#!/usr/bin/python3

import unittest

import atxsimulator.glo as glo
import atxsimulator.simulator as simulator
import atxsimulator.utils


class SimulatorTestCase(unittest.TestCase):
    def setUp(self):
        self.mem = {}
        atxsimulator.utils.mem_init(self.mem)

        stru = simulator.read_structure_helper(None, "test/data/base.ini", "test/data/parameters.ini", "test/data/settings.ini")
        self.objs = simulator.make_objs(stru)
        glo.objs = self.objs  # TODO: ugly hack

    # TODO
    def test_test(self):
        t = 1
        dt = 0.1
        for v in self.objs.values():
            v.tick(self.objs, t, dt, self.mem)

    def test_get_overrides(self):
        for v in self.objs.values():
            v.get_overrides()

    def test_get_info(self):
        for v in self.objs.values():
            v.get_info()


if __name__ == "__main__":
    unittest.main()
