var onkej = function(url, name, e) {
	if (e.which != 13) return;
	val = e.target.value;
	m.request({
		url: url + '/override/' + name + '/' + val,
		timeout: 5000,
	});
}

var onklik = function(url, name) {
	m.request({
		url: url + '/action/' + name,
		timeout: 5000,
	});
}

var onmesydz = function(url, name, ans) {
	m.request({
		url: url + '/message/' + name + '/' + ans,
		timeout: 5000,
	});
}

var items = function(o) {
	ret = [];
	for (var k in o) {
		ret.push([k, o[k]]);
	}
	return ret;
};

var d_to_color = function(d) {
	if (d['_type'] == 'Mixer') {
		return '.w3-flat-nephritis';
	}
	color = {
		'Aggregate': '.w3-flat-sun-flower',
		'Admixture': '.w3-flat-pomegranate',
		'Cement': '.w3-flat-concrete',
		'Water': '.w3-flat-peter-river',
	}[d['_material_type']];
	if (color) return color;
	return '.w3-flat-wisteria';
}

var Main = {
	view: vnode => {
		var keys = Object.keys(vnode.attrs.nodes).sort();
		var nodes = [];
		for (var k of keys) {
			var v = vnode.attrs.nodes[k];
			_data = {url: '/' + k, key: k, data: v};
			if (v['_type'] == 'Silo') {
				nodes.push(m(Silo, _data));
			} else {
				nodes.push(m(Unknown, _data));
			}
		}
		return m('.w3-container.w3-row-padding', nodes);
	}
};

var Unknown = {
	view: vnode => {
		d = vnode.attrs.data;
		_img = m('a[href=#]', {onclick: e => {vnode.state.godmode = vnode.state.godmode ? 0 : 1; return false;}}, m('img', {src: '/static/godmode.png', height: 30}))
		return m('.nodexxx.w3-col.w3-card-2', [
			m('h2.w3-container' + d_to_color(d), [vnode.attrs.url, _img]),
			vnode.state.godmode ? m(Node, vnode.attrs) : null,
		]);
	}
}

var Node = {
	view: vnode => {
		d = vnode.attrs.data;
		_overrides = d['overrides'] || {};
		_actions = d['actions'] || [];
		_messages = d['messages'] || {};
		//_messages = {'ahoj': {'k': 'ahoj', 'text': 'ahoj vole', 'options': ['ok', 'nene']}}
		delete d['overrides'];
		delete d['actions'];
		delete d['messages'];
		var info_str = JSON.stringify(d, null, 2);
		overrides = items(_overrides).map(([k, v]) => {
			var inp = m('input', {onkeydown: e => onkej(vnode.attrs.url, k, e), size: "1"});
			return m('div', [k + ":" + JSON.stringify(v, null, 2), inp]);
		});
		actions = _actions.map(k => m('button', {onclick: e => onklik(vnode.attrs.url, k)}, k));
		messages = items(_messages).map(([k, v]) => {
			buts = v['options'].map(x => m('button', {onclick: e => onmesydz(vnode.attrs.url, k, x)}, x));
			return m('div', [v['text'], buts]);
		});
		return [
			m('pre', info_str),
			m('.w3-container', overrides),
			m('.w3-container', actions),
			m('.w3-container', messages),
		];
	},
};

var togl = function(vnode, k) {
	vnode.state[k] = vnode.state[k] ? 0 : 1;
	return false;
}

var Silo = {
	view: vnode => {
		d = vnode.attrs.data
		_img = m('a[href=#]', {onclick: e => togl(vnode, 'godmode')}, m('img', {src: '/static/godmode.png', height: 30}))
		return m('.nodexxx.w3-col.w3-card-2', [
			m('.w3-container' + d_to_color(d),
			  m('h2', [vnode.attrs.url, _img])),
			m('img', {src: '/static/arrow.gif', class: (d['open'] ? "" : "hidden")}),
			vnode.state['godmode'] ? m(Node, vnode.attrs) : null,
		]);
	}
}

var source = new EventSource('/stream');
source.addEventListener('message', function(e) {
	var data = JSON.parse(e.data);
	m.render(document.getElementById('content'), m(Main, {nodes: data}));
});
