const byKeyToByLang = d => {
  const ret = {}
  for (const [k, v] of Object.entries(d)) {
    for (const [kk, vv] of Object.entries(v)) {
      if (!(kk in ret)) {
        ret[kk] = {}
      }
      ret[kk][k] = vv
    }
  }
  return ret
}

// TODO: it would be better to use set type for recursion protection but it only provides in-place operations afaik
const _fmt = (s, vals, recurProtection = []) => {
  if (typeof s !== 'string') {
    return s
  }
  return s.replace(/{(.*?)}/g, (_, k) => ((recurProtection.indexOf(k) === -1) && vals[k] !== undefined && vals[k] !== null ? _fmt(vals[k], vals, recurProtection.concat(k)) : '!' + k + '!'))
}

// given a language and captions dictionary grouped by language, returns a translating function
const makeFmt = (lang, byLangDict) => {
  const langD = byLangDict ? byLangDict[lang] : {}
  return (s, moreVals = {}) => _fmt(s, { ...langD, ...moreVals })
}

// given a language and captions dictionary, returns a translating function
/* const makeFmt = (lang, captionsDict) => {
  const byLangDict = byKeyToByLang(captionsDict)
  const langDict = byLangDict ? byLangDict[lang] : {}
  return (s, moreVals = {}) => _fmt(s, { ...langDict, ...moreVals })
} */

export { byKeyToByLang, makeFmt }
