/* global m */
/* global _ */

let theData = []
const windowHeight = (window.innerHeight - 1) + 'px'

const QueueItem = {
  view: vnode => {
    const d = vnode.attrs.data
    let color = d.color
    let correction = d.water_correction >= 0 ? '+' + d.water_correction : d.water_correction
    const correctionSetted = correction
    if (_.get(vnode.state, ['last_correction']) != null) {
      correction = _.get(vnode.state, ['last_correction'])
    }
    const vehicleIdentificationNumber = d.vehicle_identification_number
    const recipeId = d.recipe_number
    const recipeName = d.recipe_name
    const recipeIdAndName = recipeId + ' ( ' + recipeName + ' )'
    if (!_.get(vnode, ['state', 'display'])) {
      vnode.state.display = 'none'
    }
    const volume = d.order_volume_str
    const comment = d.order_comment
    const displayState = color === '#aaffaa' ? 'flex' : vnode.state.display
    const border = displayState === 'flex' ? '1px solid #0000FF' : 'none'
    if (document.getElementById(d.id)) {
      if ((vnode.state.display === 'flex') && (color === null)) {
        color = '#F5F5F5'
      }
    }
    return m('.queue-item#itemNumber-' + d.id, {
      style: { backgroundColor: color, border },
      onmouseover: _e => { vnode.state.display = 'flex' },
      onmouseleave: _e => { if (color !== '#aaffaa') { vnode.state.display = 'none' } }
    }, [
      // m('a.queue-name #n-'+d.id, {href: '#!/orders/'+d.id}, d.text),
      // m('.queue-name#n-'+d.id, {onclick: e => {document.title = 'orders/'+d.id; document.title = ''}}, d.text),
      m('.queue-spz-row #' + d.id, {
        style: { backgroundColor: color },
        onclick: _e => { document.title = 'orders/' + d.id; document.title = '' }
      }, [
        m('.queue-spz', vehicleIdentificationNumber),
        m('.queue-spz-volumeAndCorreciton', [
          m('.queue-spz-correction', correctionSetted),
          m('.queue-spz-volume', { title: 'm³' }, volume)
        ])
      ]),
      comment
        ? m('.queue-detail-recipeId' + d.id, { style: { display: displayState } }, [
          m('.queue-detail-recipeId-text', { title: comment }, comment)
        ])
        : null,
      m('.queue-detail#' + d.id, { style: { display: displayState } }, [
        m('.queue-detail-button', {
          onclick: _e => m.request('/orders/' + d.id + '/dec_ten_water_correction')
        }, [
          m('i.fa.fa-minus.detail-space'),
          m('i.fa.fa-minus.detail-space')
        ]),
        m('.queue-detail-button', {
          onclick: _e => m.request('/orders/' + d.id + '/dec_water_correction')
        }, m('i.fa fa-minus')),
        m('input.correction #c-' + d.id, {
          value: correction,
          oninput: e => { correctionPreventRedraw(vnode, d.id, e); e.redraw = false },
          onkeyup: e => { correctionChange(d.id, e); e.redraw = false },
          onmouseleave: _e => { vnode.state.last_correction = null }
        }),
        m('.queue-detail-button', {
          onclick: _e => m.request('/orders/' + d.id + '/inc_water_correction')
        }, m('i.fa.fa-plus')),
        m('.queue-detail-button', { onclick: e => m.request('/orders/' + d.id + '/inc_ten_water_correction') }, [m('i.fa.fa-plus.detail-space'), m('i.fa.fa-plus.detail-space')])
      ]),
      m('.queue-detail-recipeId#recipe-' + d.id, { style: { display: displayState } }, [
        m('.queue-detail-recipeId-text', { title: recipeIdAndName }, recipeIdAndName)
      ])
    ])
  }
}

function correctionChange (id_, e) {
  if (e.keyCode === 13) {
    const correction = e.target.value.replace('+', '')
    m.request('/orders/' + id_ + '/manual_water_correction/' + correction)
  }
}

function correctionPreventRedraw (node, id_, e) {
  if (e.keyCode !== 13) {
    const correction = document.getElementById('c-' + id_).value
    node.state.last_correction = correction
  }
}

const Queue = {
  view: _vnode => {
    return m('.container',
      m('.queue.scroller', { style: { height: windowHeight } }, theData.map(x => m(QueueItem, { key: x.id, data: x }))))
  }
}

const Order = {
  view: _vnode => {
    return m('h1', '')
  }
}

m.route(document.body, '/queue', {
  '/queue': Queue,
  '/orders/:id': Order
})

// m.mount(document.body, Queue)

const source = new window.EventSource('/stream')
source.addEventListener('message', e => {
  const data = JSON.parse(e.data)
  // m.render(document.getElementById('content'), m(Main, {nodes: data}))
  theData = data.data
  // theData = [{}].concat(data.data);  // TODO: fucking skanska chodov hack
  m.redraw()
})
