// TODO: this is basically a trimmed-down version of script400.js for read-only front-end variant - unite!

/* global m */
/* global _ */

import { byKeyToByLang, makeFmt } from './translate.js'

let theData = null
const atx300 = window.location.href.indexOf('/300') !== -1

const urlParams = new URLSearchParams(window.location.search)

// taken from https://stackoverflow.com/questions/879152/how-do-i-make-javascript-beep
// if you have another AudioContext class use that one, as some browsers have a limit
const audioCtx = new (window.AudioContext || window.webkitAudioContext || window.audioContext)()

// All arguments are optional:

// duration of the tone in milliseconds. Default is 500
// frequency of the tone in hertz. default is 440
// volume of the tone. Default is 1, off is 0.
// type of tone. Possible values are sine, square, sawtooth, triangle, and custom. Default is sine.
// callback to use on end of tone
function beep (duration, frequency, volume, type, callback) {
  const oscillator = audioCtx.createOscillator()
  const gainNode = audioCtx.createGain()

  oscillator.connect(gainNode)
  gainNode.connect(audioCtx.destination)

  if (volume) { gainNode.gain.value = volume }
  if (frequency) { oscillator.frequency.value = frequency }
  if (type) { oscillator.type = type }
  if (callback) { oscillator.onended = callback }

  oscillator.start(audioCtx.currentTime)
  oscillator.stop(audioCtx.currentTime + ((duration || 500) / 1000))
}

function soundAlert () {
  beep(200, 659) // E5 note
  console.log('play tone')
}

// TODO: cut-n-pasted from pycontrol
// Disable right click on page
document.addEventListener('contextmenu', event => event.preventDefault())

const QueueItem = {
  view: vnode => {
    const d = vnode.attrs.data
    const fmt = vnode.attrs.fmt
    const recipeNumber = d.recipe_number
    const recipeName = d.recipe_name
    const volume = d.order_volume_str
    const comment = d.order_comment
    const place = d.order_place
    const consistencyTargetStr = d.consistency_target_str
    const consistencyHistory = (d.consistency_history && d.consistency_history.length > 0) ? d.consistency_history.slice() : null
    const consistencyHistoryStr = consistencyHistory ? ((consistencyHistory.length > 5 ? '...' : '') + consistencyHistory.slice(-5).map(x => x.toFixed()).join(', ')) : null // TODO: hard-coded shit (5)
    const color = d.color
    const problems = _.get(d, ['problems'])
    let displayStateProblemsAndWarnings = 'none'
    const problemsAndWarningsArray = []
    if (Array.isArray(problems) && problems.length) {
      displayStateProblemsAndWarnings = 'flex'
      for (const pr in problems) {
        problemsAndWarningsArray.push(m('.queue-problem-or-warning-item.problem', fmt(problems[pr])))
      }
    }

    return m('.queue-item #itemNumber-' + d.id, { key: d.id, style: { backgroundColor: color } }, [
      m('.queue-spz-row #' + d.id, {}, [
        m('.queue-spz', d.vehicle_identification_number),
        place ? m('.queue-detail-item-place', { title: fmt('{place}: ' + place) }, place) : null,
        m('a.queue-spz-volume', volume)
      ]),
      m('.queue-detail-item', {}, [
        m('.queue-detail-item-name', recipeNumber + ' ( ' + recipeName + ' )')
      ]),
      comment
        ? m('.queue-detail-item', {}, [
          m('.queue-detail-item-comment', { title: fmt('{comment}: ' + comment) }, comment)
        ])
        : null,
      (consistencyHistory || consistencyTargetStr)
        ? m('.queue-detail-item', { style: { display: 'flex' } }, [
          m('.queue-detail-item-consistency-target', { title: fmt('{ConsistencyTarget}') }, consistencyTargetStr),
          m('.queue-detail-item-consistency', { title: fmt('{ConsistencyHistory}') }, consistencyHistoryStr)
        ])
        : null,
      m('.queue-problems-and-warnings', { style: { display: displayStateProblemsAndWarnings } }, problemsAndWarningsArray)
    ])
  }
}

const Queue = {
  view: vnode => {
    const fmt = vnode.attrs.fmt
    return m('.container', [
      m('.queue', [
        theData === null
          ? m('.firstMessage', fmt('...{connecting}...'))
          : theData.length === 0
            ? m('.firstMessage', fmt('...{order_queue_is_empty}...'))
            : null,
        theData !== null
          ? theData.map(x => m(QueueItem, { ...vnode.attrs, key: x.id, data: x }))
          : null
      ])
    ])
  }
}

// TODO: finish this and get rid of order_dialog.js?
const Order = {
  view: _vnode => {
    return m('h1', '')
  }
}

const LanguageQueue = {
  oninit: vnode => {
    vnode.state.lang = urlParams.get('lang') || 'cs'
    console.log('lang is', vnode.state.lang)
    vnode.state.byLangDict = {}
    vnode.state.fmt = x => x // TODO: hacky way to avoid undefined later on
    m.request('./captions').then(data => {
      console.log('got lang', data)
      vnode.state.byLangDict = byKeyToByLang(data)
      vnode.state.fmt = makeFmt(vnode.state.lang, vnode.state.byLangDict)
    })
  },
  view: vnode => {
    return m(Queue, { fmt: vnode.state.fmt })
  }
}

m.route(document.getElementById('content'), '/queue', {
  '/queue': LanguageQueue,
  '/orders/:id': Order
})

let lastCountOfOrders = 0

const onSseMessage = e => {
  const data = JSON.parse(e.data)
  theData = data.data
  console.log('theData:', theData)
  // TODO: don't depend on count but do full identity check
  const countOfOrders = theData.length
  if (!atx300 && (countOfOrders > lastCountOfOrders)) {
    soundAlert()
  }
  lastCountOfOrders = countOfOrders
  m.redraw() // TODO: ugly
}

const onSseError = e => {
  console.log('sse error', e)
  theData = null
  m.redraw() // TODO: ugly
  source.close()
  setTimeout(() => {
    console.log('sse reconnect')
    source = new window.EventSource('stream')
    source.addEventListener('message', onSseMessage)
    source.addEventListener('error', onSseError)
  }, 1000)
}

let source = new window.EventSource('stream')
source.addEventListener('message', onSseMessage)
source.addEventListener('error', onSseError)
