/* global m */
/* global _ */

console.log('loading order_dialog.js')
const orderId = document.title
console.debug('order_id', orderId)

const urlParams = new URLSearchParams(window.location.search)

// TODO: cut-n-pasted from pycontrol
const byKeyToByLang = d => {
  const ret = {}
  for (const [k, v] of Object.entries(d)) {
    for (const [kk, vv] of Object.entries(v)) {
      if (!(kk in ret)) {
        ret[kk] = {}
      }
      ret[kk][k] = vv
    }
  }
  return ret
}

// TODO: cut-n-pasted from pycontrol
const _fmt = (s, vals) => {
  return s.replace(/{(.*?)}/g, (_match, k) => (vals[k] !== undefined ? _fmt(vals[k], vals) : '!' + k + '!'))
}

// TODO: i've seen lots of calls to this function with two arguments - wtf!?
function sendAndGetData (vnode) {
  // console.log("sending and getting data", vnode.state.post)
  m.request({
    method: 'POST',
    url: '../orders/' + orderId + '/get_fill_data',
    body: vnode.state.post ? vnode.state.post : {}
  })
    .then(data => {
      vnode.state.data = data
      // console.debug("got data", data)
    })
}

// TODO: i don't like this - get rid of it
function nonFocusedValue (id, val) {
  const el = document.getElementById(id)
  return el && document.activeElement === el ? el.value : val
}

const Language = {
  oninit: vnode => {
    vnode.state.lang = urlParams.get('lang') || 'cs'
    console.log('lang is', vnode.state.lang)
    vnode.state.lang_d = {}
    m.request('../captions').then(data => {
      console.log('got lang', data)
      vnode.state.lang_d = byKeyToByLang(data)[vnode.state.lang] || {}
    })
  },
  view: vnode => {
    return m(OrderDialog, { fmt: s => _fmt(s, vnode.state.lang_d) })
  }
}

const OrderDialog = {
  oninit: vnode => {
    vnode.state.data = {}
    vnode.state.post = {}
    sendAndGetData(vnode)
    document.addEventListener('dialog_closing', e => {
      console.debug('dialog_closing', e)
      sendResult('0', vnode.state.data)
    })
  },
  view: vnode => {
    const d = vnode.state.data
    const fmt = vnode.attrs.fmt
    const rawCorrection = _.get(d, ['water_correction'])
    const correction = nonFocusedValue('water_correction', rawCorrection)
    const correctionStr = correction
    const correctionInt = correction == null ? 0 : correction
    // const solidsCorrection = nonFocusedValue('solids_correction', _.get(d, ['solids_correction']))
    // const solidsCorrectionStr = solidsCorrection
    const waterTemperature = nonFocusedValue('water_temperature', _.get(d, ['water_temperature']))
    const batchVolumeLimit = nonFocusedValue('batch_volume_limit_override', _.get(d, ['batch_volume_limit_override']))
    const batchCorrection = _.get(d, ['batch_correction'])
    const batchesFixed = _.get(d, ['_batches_fixed'])
    const batchUnequalSplit = _.get(d, ['uneven_batches'])
    const continuousMode = _.get(d, ['continuous_mode'])
    const continuousModeEnabled = _.get(d, ['continuous_mode_enabled'])
    const radioBatchCorrectionNone = batchCorrection === 'none'
      ? m('i.far fa-dot-circle.green')
      : m('i.far fa-circle.gray')
    const radioBatchCorrectionNext = batchCorrection === 'next'
      ? m('i.far fa-dot-circle.green')
      : m('i.far fa-circle.gray')
    const radioBatchCorrectionRemaining = batchCorrection === 'remaining'
      ? m('i.far fa-dot-circle.green')
      : m('i.far fa-circle.gray')

    const displayMode = _.get(d, ['display_mode'])
    const radioDisplayModeRecipe = (displayMode === null || displayMode === 'recipe')
      ? m('i.far.fa-dot-circle.green')
      : m('i.far.fa-circle.gray')
    const radioDisplayModeBatch = displayMode === 'batch'
      ? m('i.far.fa-dot-circle.green')
      : m('i.far.fa-circle.gray')
    const radioDisplayModeOrder = displayMode === 'order'
      ? m('i.far.fa-dot-circle.green')
      : m('i.far.fa-circle.gray')
    const radioBatchUnequalSplit = m('i.far' + ((batchUnequalSplit === null || batchUnequalSplit === 0)
      ? '.fa-square'
      : '.fa-check-square') + (batchesFixed ? '.gray' : '.green'))
    const radioContinousMode = m('i.far' + ((continuousMode === null || continuousMode === 0)
      ? '.fa-square'
      : '.fa-check-square') + (batchesFixed ? '.gray' : '.green'))

    // ORDER
    const Number = _.get(d, ['order', 'Number'])
    const User = _.get(d, ['order', 'User'])
    const ConstructionSite = _.get(d, ['order', 'ConstructionSite'])
    const VehicleIdentificationNumber = _.get(d, ['order', 'VehicleIdentificationNumber'])
    const Place = _.get(d, ['order', 'Place'])
    const Time = _.get(d, ['order', 'Time'])
    const Date = _.get(d, ['order', 'Date'])
    const Comment = _.get(d, ['order', 'Comment'])
    // BATCH
    const Volume = _.get(d, ['order', 'Volume']) ? parseFloat(_.get(d, ['order', 'Volume'])).toFixed(2) : null // TODO: get rid of toFixed - calc string on backend
    const BatchVolume = _.get(d, ['batch_volume']) ? parseFloat(_.get(d, ['batch_volume'])).toFixed(2) : null // TODO: dtto
    const BatchCount = _.get(d, ['batch_count'])
    const BatchNext = _.get(d, ['batch_next'])
    const BatchMoisture = _.get(d, ['batch_moisture'])
    // RECIPE
    const RecipeNumber = _.get(d, ['recipe', 'Number'])
    const RecipeName = _.get(d, ['recipe', 'Name'])
    // const RecipeDescription = _.get(d, ['recipe', 'Description'])
    const RecipeVariant = _.get(d, ['recipe', 'Variant'])
    const RecipeConsistencyClass = _.get(d, ['recipe', 'Consistency_Class'])
    const RecipeClass = _.get(d, ['recipe', 'Class'])
    const RecipeVolumeWeight = parseFloat(_.get(d, ['volume_weight'])).toFixed(2) // TODO: get rid of toFixed everywhere...!
    const RecipeVC = _.get(d, ['more_data_water_to_cement_ratio']) ? parseFloat(_.get(d, ['more_data_water_to_cement_ratio'])).toFixed(2) : null
    const KRatio = _.get(d, ['recipe', 'K_ratio']) ? parseFloat(_.get(d, ['recipe', 'K_ratio'])).toFixed(2) : null
    // WATER
    const WaterInAggregates = _.get(d, ['more_data_water_in_aggregates_mult']) ? parseFloat(_.get(d, ['more_data_water_in_aggregates_mult'])).toFixed(2) : null
    const WaterInAdmixtures = _.get(d, ['more_data_water_in_admixtures_mult']) ? parseFloat(_.get(d, ['more_data_water_in_admixtures_mult'])).toFixed(2) : null
    const WaterInRecipe = _.get(d, ['more_data_batch_water_mult']) ? parseFloat(_.get(d, ['more_data_batch_water_mult'])).toFixed(2) : null
    // const WaterCorrection = _.get(d, ['more_data_batch_water_corr_mult']) ? parseFloat(_.get(d, ['more_data_batch_water_corr_mult'])).toFixed(2) : null
    // const WaterWeight = _.get(d, ['more_data_batch_water_reduced_mult']) ? parseFloat(_.get(d, ['more_data_batch_water_reduced_mult'])).toFixed(2) : null
    const WaterFlushAdmixtures = _.get(d, ['flush_water_disp']) ? parseFloat(_.get(d, ['flush_water_disp'])).toFixed(2) : null
    // (recycled) water solids
    const SolidsCorrectedMult = _.get(d, ['more_data_solids_corrected_mult']) ? parseFloat(_.get(d, ['more_data_solids_corrected_mult'])).toFixed(2) : null
    const WaterFinalSolids = _.get(d, ['more_data', 'water_final_solids']) ? parseFloat(_.get(d, ['more_data', 'water_final_solids'])).toFixed(2) : null

    // OTHER
    // const UnevenBatches = _.get(d, ['uneven_batches'])

    const Problems = _.get(d, ['problems'])
    const Warnings = _.get(d, ['warnings'])
    const problemsAndWarningsArray = []
    if (Array.isArray(Problems) && Problems.length) {
      for (const pr in Problems) {
        problemsAndWarningsArray.push(m('.queue-problem-or-warning-item.problem', fmt(Problems[pr])))
      }
    }
    if (Array.isArray(Warnings) && Warnings.length) {
      for (const wa in Warnings) {
        problemsAndWarningsArray.push(m('.queue-problem-or-warning-item.warning', fmt(Warnings[wa])))
      }
    }
    // BUTTONS
    const enabledButtons = _.get(d, ['enabled_buttons'])
    // TODO: put proper parenthesis to the ternary operators below
    const buttonProduce = enabledButtons ? enabledButtons.includes('produce') ? '.button-produce' : '.button-produce disable' : '.button-produce disable'
    const buttonReturn = enabledButtons ? enabledButtons.includes('return') ? '.button-return' : '.button-return disable' : '.button-return disable'
    const buttonDelete = enabledButtons ? enabledButtons.includes('delete') ? '.button-delete' : '.button-delete disable' : '.button-delete disable'
    if (!_.get(vnode, ['state', 'openProduce'])) {
      vnode.state.openProduce = false
    }
    if (!_.get(vnode, ['state', 'openReturn'])) {
      vnode.state.openReturn = false
    }
    if (!_.get(vnode, ['state', 'openDelete'])) {
      vnode.state.openDelete = false
    }
    if (!_.get(vnode, ['state', 'openButtons'])) {
      vnode.state.openButtons = false
    }
    const openProduce = vnode.state.openProduce
    const openReturn = vnode.state.openReturn
    const openDelete = vnode.state.openDelete
    const openButtons = !(openProduce || openReturn || openDelete)
    // const displayStateProduce = openProduce ? "flex" : "none"
    const displayStateReturn = openReturn ? 'flex' : 'none'
    const displayStateDelete = openDelete ? 'flex' : 'none'
    const displayStateButtons = openButtons ? 'flex' : 'none'

    const materialsTable = []
    materialsTable.push(
      m('tr', [
        m('th', fmt('{MaterialsType}')),
        m('th', fmt('{silo}')),
        m('th', fmt('{delay}')),
        m('th', fmt('{MaterialsName}')),
        m('th', { title: fmt('{MaterialsRecipeWeight}') }, fmt('{MaterialsRecipeWeight_abbrev}')),
        m('th', fmt('{moisture}')),
        m('th', fmt('{MaterialsWeight}'))
      ])
    )
    for (const idx in _.get(d, ['table_rows'])) {
      const row = d.table_rows[idx]
      const moisture = row.moisture != null ? parseFloat(row.moisture).toFixed(2) : null
      materialsTable.push(
        m('tr.' + row._type, [
          m('td', row.letter),
          m('td', row.silo),
          m('td', row.delay),
          m('td.left', row.name),
          m('td.right', parseFloat(row.weight_dry).toFixed(2)),
          m('td.right', moisture),
          m('td.right.bold', parseFloat(row.weight).toFixed(2))
        ])
      )
    }

    const watersTable = []
    watersTable.push(
      m('tr', [
        m('th'),
        m('th', fmt('{silo}')),
        m('th', fmt('{delay}')),
        m('th', fmt('{MaterialsName}')),
        m('th', { title: fmt('{MaterialsRecipeWeight}') }, fmt('{MaterialsRecipeWeight_abbrev}')),
        m('th', fmt('{density}')),
        m('th', fmt('{temperature}')),
        m('th', fmt('{MaterialsWeight}'))
      ])
    )
    vnode.state.post.banned_waters = _.get(d, ['banned_waters'], []) // TODO: ugly
    for (const idxW in _.get(d, ['table_rows_waters'])) {
      const rowW = d.table_rows_waters[idxW]
      if (rowW._type) {
        watersTable.push(
          m('tr.' + rowW._type, [
            m('td.pointer' + (rowW.is_banned ? '.banned' : ''), {
              onclick: _e => {
                const bw = new Set(vnode.state.post.banned_waters)
                if (rowW.is_banned) {
                  bw.delete(rowW.name)
                } else {
                  bw.add(rowW.name)
                }
                vnode.state.post.banned_waters = [...bw]
                sendAndGetData(vnode, orderId)
              }
            }, [
              m('i.far' + (rowW.is_banned ? '.fa-square' : '.fa-check-square') + '.black')
            ]),
            m('td', rowW.silo ? rowW.silo : null),
            m('td', rowW.delay),
            m('td.left', rowW.name),
            m('td.right', rowW.weight_orig ? parseFloat(rowW.weight_orig).toFixed(2) : null),
            m('td.right', rowW.density_cur ? parseFloat(rowW.density_cur).toFixed(2) : null),
            m('td.right', rowW.temp ? parseFloat(rowW.temp).toFixed(2) : null),
            m('td.right.bold', parseFloat(rowW.weight).toFixed(2))
          ])
        )
      } else {
        watersTable.push(
          m('tr', [
            m('td.noborder.spacer', { colspan: '8' })
          ]),
          m('tr', [
            m('td.right.noborder', { colspan: '6' }, fmt('{to_dose}')),
            m('td.right.bold.Water', parseFloat(rowW.temp).toFixed(2)),
            m('td.right.bold.Water', parseFloat(rowW.weight).toFixed(2))
          ])
        )
      }
    }

    return m('.content', [
      m('.top-content', [
        m('fieldset', [
          m('legend', fmt('{order}')),
          m('.order-info', [
            m('.padded-area', [
              m('table.manager-order', [
                m('tr', [
                  m('th.right', fmt('{number}')),
                  m('td', { colspan: '3' }, Number)
                ]),
                m('tr', [
                  m('th.right', fmt('{User}')),
                  m('td', { colspan: '3' }, User)
                ]),
                m('tr', [
                  m('th.right', fmt('{ConstructionSite}')),
                  m('td', { colspan: '3' }, ConstructionSite)
                ]),
                m('tr', [
                  m('th.right', fmt('{VehicleIdentificationNumber}')),
                  m('td', VehicleIdentificationNumber),
                  m('th.right', fmt('{place}')),
                  m('td', Place)
                ]),
                m('tr', [
                  m('th.right', fmt('{time}')),
                  m('td', Time),
                  m('th.right', fmt('{date}')),
                  m('td', Date)
                ]),
                m('tr', [
                  m('th.right', fmt('{comment}')),
                  m('td', { colspan: '3' }, Comment)
                ])
              ])
            ])
          ])
        ]),
        m('fieldset', [
          m('legend', fmt('{batches}')),
          m('.batch-info', [
            m('.padded-area2', [
              m('table.manager-order', [
                m('tr', [
                  m('th.right', fmt('{total_volume}')),
                  m('td.right', Volume),
                  continuousModeEnabled
                    ? m('td.noborder.right.pointer', {
                      style: { paddingLeft: '0.5vw' },
                      onclick: batchesFixed
                        ? null
                        : _e => {
                          vnode.state.post.continuous_mode = continuousMode ? 0 : 1
                          sendAndGetData(vnode, orderId)
                        }
                    }, radioContinousMode)
                    : null,
                  continuousModeEnabled ? m('th.left', fmt('{mix_continuously}')) : null
                ]),
                m('tr', [
                  m('th.right', fmt('{batch_volume}')),
                  m('td.right', BatchVolume)
                ]),
                m('tr', [
                  m('th.right', fmt('{batch_volume_limit}')),
                  m('td.noborder', {
                    style: { width: '20%' }
                  }, m('input.batchLimit #batch_volume_limit_override', {
                    disabled: batchesFixed ? 1 : 0,
                    value: batchVolumeLimit,
                    onkeyup: e => { inputChange(vnode, orderId, e, 'batch_volume_limit_override', true) }
                  })),
                  m('td.noborder.right.pointer', {
                    style: { paddingLeft: '0.5vw' },
                    onclick: batchesFixed
                      ? null
                      : _e => {
                        vnode.state.post.uneven_batches = batchUnequalSplit ? 0 : 1
                        sendAndGetData(vnode, orderId)
                      }
                  }, radioBatchUnequalSplit),
                  m('th.left', fmt('{BatchUnequalSplit}'))
                ]),
                m('tr', [
                  m('th.right', fmt('{batch_count}')),
                  m('td.right', BatchCount)
                ]),
                m('tr', [
                  m('th.right', fmt('{next}')),
                  m('td.right', BatchNext)
                ])
              ])
            ])
          ])
        ]),
        m('fieldset', [
          m('legend', fmt('{BatchCorrection}')),
          m('.batch-info2', [
            m('.padded-area3', [
              m('table.manager-order', [
                m('tr', [
                  m('th.noborder.right.pointer', {
                    onclick: _e => {
                      vnode.state.post.batch_correction = 'none'
                      sendAndGetData(vnode, orderId)
                    }
                  }, radioBatchCorrectionNone),
                  m('td.noborder', fmt('{none}'))
                ]),
                m('tr', [
                  m('th.noborder.right.pointer', {
                    onclick: _e => {
                      vnode.state.post.batch_correction = 'next'
                      sendAndGetData(vnode, orderId)
                    }
                  }, radioBatchCorrectionNext),
                  m('td.noborder', fmt('{next}'))
                ]),
                m('tr', [
                  m('th.noborder.right.pointer', {
                    onclick: _e => {
                      vnode.state.post.batch_correction = 'remaining'
                      sendAndGetData(vnode, orderId)
                    }
                  }, radioBatchCorrectionRemaining),
                  m('td.noborder', fmt('{remaining}'))
                ])
              ])
            ])
          ])
        ]),
        m('fieldset', [
          m('legend', fmt('{Show}')),
          m('.show-info', [
            m('.padded-area3', [
              m('table.manager-order', [
                m('tr', [
                  m('th.noborder.right.pointer', {
                    onclick: _e => {
                      vnode.state.post.display_mode = 'recipe'
                      sendAndGetData(vnode, orderId)
                    }
                  }, radioDisplayModeRecipe),
                  m('td.noborder', fmt('{recipe}'))
                ]),
                m('tr', [
                  m('th.noborder.right.pointer', {
                    onclick: _e => {
                      vnode.state.post.display_mode = 'batch'
                      sendAndGetData(vnode, orderId)
                    }
                  }, radioDisplayModeBatch),
                  m('td.noborder', fmt('{batch}'))
                ]),
                m('tr', [
                  m('th.noborder.right.pointer', {
                    onclick: _e => {
                      vnode.state.post.display_mode = 'order'
                      sendAndGetData(vnode, orderId)
                    }
                  }, radioDisplayModeOrder),
                  m('td.noborder', fmt('{order}'))
                ])
              ])
            ])
          ])
        ])
      ]),
      m('.middle-content', [
        m('fieldset', [
          m('legend', fmt('{recipe}')),
          m('.recipe-info', [
            m('.padded-area', [
              m('table.manager-order', [
                m('tr', [
                  m('th.right', fmt('{number}')),
                  m('td', { colspan: '3' }, RecipeNumber)
                ]),
                m('tr', [
                  m('th.right', fmt('{RecipeName}')),
                  m('td', { colspan: '3' }, RecipeName)
                ]),
                m('tr', [
                  m('th.right', fmt('{variant}')),
                  m('td', { colspan: '3' }, RecipeVariant)
                ]),
                m('tr', [
                  m('th.right', { title: fmt('{RecipeConsistencyClass}') }, fmt('{RecipeConsistencyClass_abbrev}')),
                  m('td', { colspan: '3' }, RecipeConsistencyClass)
                ]),
                m('tr', [
                  m('th.right', fmt('{RecipeClass}')),
                  m('td', { colspan: '3' }, RecipeClass)
                ]),
                m('tr', [
                  m('th', ''),
                  m('th.right', { colspan: '2' }, fmt('{k_value}')),
                  m('td.right', KRatio)
                ]),
                m('tr', [
                  m('th', ''),
                  m('th.right', { colspan: '2' }, fmt('{water_to_cement_abbrev}')),
                  m('td.right', RecipeVC)
                ]),
                m('tr', [
                  m('th', ''),
                  m('th.right', { colspan: '2' }, fmt('{volume_weight_abbrev}')),
                  m('td.right', RecipeVolumeWeight)
                ]),
                m('tr', [
                  m('th', ''),
                  m('th.right', { colspan: '2', title: fmt('{RecipeMoistureValue}') }, fmt('{RecipeMoistureValue_abbrev}')),
                  m('td.noborder', { style: { width: '50%' } },
                    m('input.temperatureCorrection#batch_moisture', {
                      value: BatchMoisture,
                      onkeyup: e => { inputChange(vnode, orderId, e, 'batch_moisture', true) }
                    }))
                ])
              ])
            ])
          ])
        ]),
        m('fieldset', [
          m('legend', fmt('{Materials}')),
          m('.materials-info', [
            m('.padded-area', [
              m('table.manager-order-materials', materialsTable)
            ])
          ])
        ]),
        m('fieldset', [
          m('legend', fmt('{problems_and_warnings}')),
          m('.problems-and-warnings-info', [
            m('.padded-area', [
              m('.problems-and-warnings', problemsAndWarningsArray)
            ])
          ])
        ])
      ]),
      m('.bottom-content', [
        m('fieldset', [
          m('legend', fmt('{WaterSetting}')),
          m('.correction-water-info', [
            m('.padded-area', [
              m('table.manager-order', [
                m('tr', [
                  m('th.right', fmt('{Correction}')),
                  m('td.noborder', { style: { width: '50%' } }, [
                    m('.correction-button-area', [
                      m('.correction-water-button', {
                        onclick: _e => {
                          vnode.state.post.water_correction = (correctionInt - 10)
                          sendAndGetData(vnode, orderId)
                        }
                      }, [
                        m('i.fa.fa-minus.correction-water-button-space'),
                        m('i.fa.fa-minus.correction-water-button-space')
                      ]),
                      m('.correction-water-button', {
                        onclick: _e => {
                          vnode.state.post.water_correction = (correctionInt - 1)
                          sendAndGetData(vnode, orderId)
                        }
                      }, [
                        m('i.fa.fa-minus.correction-water-button-space')
                      ]),
                      m('input.correction#water_correction', {
                        value: correctionStr,
                        placeholder: rawCorrection,
                        onkeyup: e => { inputChange(vnode, orderId, e, 'water_correction', false) }
                      }),
                      m('.correction-water-button', {
                        onclick: _e => {
                          vnode.state.post.water_correction = (correctionInt + 1)
                          sendAndGetData(vnode, orderId)
                        }
                      }, [
                        m('i.fa.fa-plus.correction-water-button-space')
                      ]),
                      m('.correction-water-button', {
                        onclick: _e => {
                          vnode.state.post.water_correction = (correctionInt + 10)
                          sendAndGetData(vnode, orderId)
                        }
                      }, [
                        m('i.fa.fa-plus.correction-water-button-space'),
                        m('i.fa.fa-plus.correction-water-button-space')
                      ])
                    ])
                  ])
                ]),
                m('tr', [
                  m('td.noborder.spacer', { colspan: '2' })
                ]),
                m('tr', [
                  m('th.right', { title: fmt('{CorrectionWaterTemperature}') }, fmt('{CorrectionWaterTemperature_abbrev}')),
                  m('td.noborder', m('input.temperatureCorrection#water_temperature', {
                    value: waterTemperature,
                    onkeyup: e => { inputChange(vnode, orderId, e, 'water_temperature', true) }
                  }))
                ]),
                m('tr', [
                  m('td.noborder.spacer', { colspan: '2' })
                ])
                // disabled for now because operators mistake this for water correction and fuck up the batch because too much recycled water is dosed if they fill in some big number
                /* m('tr', [
                  m('th.right', {
                    title: fmt('{DensitySolidsCorrectionValue}')
                  }, fmt('{DensitySolidsCorrectionValue_abbrev}')),
                  m('td.noborder',
                    m('input.temperatureCorrection#solids_correction', {
                      value: solidsCorrectionStr,
                      onkeyup: e => { inputChange(vnode, orderId, e, 'solids_correction', false) }
                    }))
                ]) */
              ])
            ])
          ])
        ]),
        m('fieldset', [
          m('legend', fmt('{water}')),
          m('.water-info', [
            m('.padded-area', [
              m('table.manager-order', [
                m('tr', [
                  m('th.right', fmt('{in_aggregates}')),
                  m('td.right', WaterInAggregates),
                  m('th.right', fmt('{in_admixtures}')),
                  m('td.right', WaterInAdmixtures),
                  m('th.right', fmt('{in_flush}')),
                  m('td.right', WaterFlushAdmixtures)
                ]),
                m('tr', [
                  m('th.right', fmt('{batch_water_volume}')),
                  m('td.right', WaterInRecipe),
                  m('th.right', { title: fmt('{DensitySolidsAllowMax}') }, fmt('{DensitySolidsAllowMax_abbrev}')),
                  m('td.right', SolidsCorrectedMult),
                  m('th.right', { title: fmt('{DensitySolidsWeightSum}') }, fmt('{DensitySolidsWeightSum_abbrev}')),
                  m('td.right', WaterFinalSolids)
                ])
              ]),
              m('br'),
              m('table.manager-order-materials', watersTable)
            ])
          ])
        ]),
        m('fieldset', [
          m('legend', fmt('{Actions}')),
          m('.production-buttons-area', [
            m('.padded-area-buttons', [
              m('.produce-sentence-area', { style: { display: displayStateReturn } }, [
                m('.produce-sentence.yellow', fmt('{do_you_really_want_to_return_this_order}')),
                m('.buttons2', [
                  m('.button-no', {
                    onclick: openReturn
                      ? _e => { vnode.state.openReturn = false }
                      : null
                  }, fmt('{no}')),
                  m('.button-yes', { onclick: _e => { sendResult('2', d) } }, fmt('{yes}'))
                ])
              ]),
              m('.produce-sentence-area', { style: { display: displayStateDelete } }, [
                m('.produce-sentence.red', fmt('{do_you_really_want_to_delete_this_order}')),
                m('.buttons2', [
                  m('.button-no', {
                    onclick: openDelete
                      ? _e => { vnode.state.openDelete = false }
                      : null
                  }, fmt('{no}')),
                  m('.button-yes', { onclick: _e => { sendResult('3', d) } }, fmt('{yes}'))
                ])
              ]),
              m('.buttons', { style: { display: displayStateButtons } }, [
                m(buttonProduce, { onclick: _e => { sendResult('1', d) } }, fmt('{produce}')),
                m(buttonReturn, {
                  onclick: openReturn
                    ? null
                    : _e => { vnode.state.openReturn = true }
                }, fmt('{return}')),
                m(buttonDelete, {
                  onclick: openDelete
                    ? null
                    : _e => { vnode.state.openDelete = true }
                }, fmt('{delete}'))
              ])
            ])
          ])
        ])
      ])
    ])
  }
}

function sendResult (res, data) {
  document.title = res
  m.request({
    method: 'POST',
    url: '/manager/orders/' + orderId + '/process_order_dialog_result/' + res,
    body: data // TODO: send only require data in the future
  })
  // TODO: when "correcting" this, it seems to fuck up things - solve
  // eslint-disable-next-line eqeqeq
  if (res != '0') {
    const inputValue = document.getElementById('orderDialogEventContent')
    inputValue.value = res
    inputValue.dispatchEvent(new Event('input'))
  }
}

function inputChange (vnode, id_, e, k, floatVal) {
  let v = e.target.value
  v = v.replace('+', '')
  v = v.replace(',', '.')
  v = floatVal ? parseFloat(v) : parseInt(v)
  v = isNaN(v) ? null : v
  if (v !== vnode.state.post[k]) {
    vnode.state.post[k] = v
    sendAndGetData(vnode, id_)
  }
}

m.mount(document.getElementById('content'), Language)
