import unittest

import atxmanager as manager
import atxmanager.utils as utils
import atxpylib.comm as atxcomm
import atxpylib.structure as structure
import atxpylib.utils as atxutils


# import logging
# logging.basicConfig(level="DEBUG")


# TODO
class WaterRecalcTestCase(unittest.TestCase):
    def test_racalc_pavel(self):
        waters = ["c", "k", "t"]
        temps = {"c": 20, "k": 4, "t": 40}
        densities = {"c": 1, "k": 1.12, "t": 1}
        solids = 12
        temp = 35
        res = utils.recalc_water(100, solids, temp, waters, densities, temps)
        # print(solids, temp, res, calc_batch_solids(res, densities), calc_batch_temp(res, temps))

        waters = ["c", "k", "t"]
        temps = {"c": 20, "k": 4, "t": 40}
        densities = {"c": 1, "k": 1.12, "t": 1}
        solids = 12
        temp = 0
        res = utils.recalc_water(100, solids, temp, waters, densities, temps)
        # print(solids, temp, res, calc_batch_solids(res, densities), calc_batch_temp(res, temps))

        temps = {"c": 20, "k": 4, "t": 40}
        densities = {"c": 1, "k": 1, "t": 1}
        solids = 12
        temp = 35
        res = utils.recalc_water(100, solids, temp, waters, densities, temps)
        # print(solids, temp, res, calc_batch_solids(res, densities), calc_batch_temp(res, temps))

        temps = {"c": 20, "k": 4, "t": 100}
        densities = {"c": 1.0, "k": 1.12, "t": 1.0}
        solids = 12
        temp = 35
        res = utils.recalc_water(100, solids, temp, waters, densities, temps)
        # print(solids, temp, res, calc_batch_solids(res, densities), calc_batch_temp(res, temps))
        assert res


# TODO: rename to something better
class MyTestCase(unittest.TestCase):
    def test_gen_next_batch_request(self):
        base_ini_fn = "tests/data/base.ini"
        parameters_ini_fn = "tests/data/parameters.ini"
        placement_ini_fn = "tests/ata/placemnt.ini"
        settings_ini_fn = "tests/data/settings.ini"
        o = atxcomm.order_from_ini_f("tests/data/order1.ord")
        r = atxcomm.recipe_from_ini_f("tests/data/order1.ord")
        batch_volume = 1
        stru = structure.structure_from_base_ini_pre(base_ini_fn, parameters_ini_fn, settings_ini_fn)
        # mixer_volume = utils.get_mixer_volume(stru)
        # batch_volume_limit_override = None
        # batch_volume_limit = utils.calc_batch_volume_limit(r, mixer_volume, batch_volume_limit_override)
        # op = {
        # 'batch_count': utils.calc_batch_count(o['Volume'], batch_volume_limit),
        # }
        water_correction = 10
        solids_correction = 0
        water_temperature = 30
        mem = {
            "MEMSH_MA_RecycledWater_disabled": 0,
        }
        silo_to_bin = atxutils.load_silo_to_bin_mapping(base_ini_fn) if base_ini_fn else None  # TODO: this is legacy - get the mapping from stru
        placements = atxcomm.placements_from_ini_f(placement_ini_fn, silo_to_bin)
        moistures = {f"AggregateSilo{i}": i for i in range(1, 7)}
        legacy_water = False
        temperatures = utils.get_temperatures(stru, mem)
        densities = utils.get_densities(stru, mem)
        recycled_water_disabled = mem["MEMSH_MA_RecycledWater_disabled"]
        banned_waters = None

        br_mats, _ = utils.gen_next_batch_request_materials(
            o,
            r,
            batch_volume,
            water_correction,
            solids_correction,
            water_temperature,
            recycled_water_disabled,
            banned_waters,
            temperatures,
            placements,
            moistures,
            densities,
            legacy_water,
            stru,
            False,
            False,
            silo_to_bin,
        )
        assert br_mats

    def test_gen_next_batch_request_legacy_water(self):
        base_ini_fn = "tests/data/base.ini"
        parameters_ini_fn = "tests/data/parameters.ini"
        placement_ini_fn = "tests/data/placemnt.ini"
        settings_ini_fn = "tests/data/settings.ini"
        o = atxcomm.order_from_ini_f("tests/data/order1.ord")
        r = atxcomm.recipe_from_ini_f("tests/data/order1.ord")
        batch_volume = 1
        stru = structure.structure_from_base_ini_pre(base_ini_fn, parameters_ini_fn, settings_ini_fn)
        # mixer_volume = utils.get_mixer_volume(stru)
        # batch_volume_limit_override = None
        # batch_volume_limit = utils.calc_batch_volume_limit(r, mixer_volume, batch_volume_limit_override)
        # op = {
        # 'batch_count': utils.calc_batch_count(o['Volume'], batch_volume_limit),
        # }
        water_correction = 10
        solids_correction = 0
        water_temperature = 30
        mem = {
            "MEMSH_MA_RecycledWater_disabled": 0,
        }
        silo_to_bin = atxutils.load_silo_to_bin_mapping(base_ini_fn) if base_ini_fn else None  # TODO: this is legacy - get the mapping from stru
        placements = atxcomm.placements_from_ini_f(placement_ini_fn, silo_to_bin)
        moistures = {f"AggregateSilo{i}": i for i in range(1, 7)}
        legacy_water = True
        stru = structure.structure_from_base_ini_pre(base_ini_fn, parameters_ini_fn, settings_ini_fn)
        temperatures = utils.get_temperatures(stru, mem)
        densities = utils.get_densities(stru, mem)
        recycled_water_disabled = mem["MEMSH_MA_RecycledWater_disabled"]
        banned_waters = None

        br_mats, _ = utils.gen_next_batch_request_materials(
            o,
            r,
            batch_volume,
            water_correction,
            solids_correction,
            water_temperature,
            recycled_water_disabled,
            banned_waters,
            temperatures,
            placements,
            moistures,
            densities,
            legacy_water,
            stru,
            False,
            False,
            silo_to_bin,
        )
        assert br_mats


def test_gen_waters():
    recipe = {
        "materials": [
            {"_type": "Water", "Name": "KALOVA", "Weight": 120, "_k_orig": "Water1"},
            # {'_type': 'Water', 'Name': 'CISTA', 'Weight': 100, '_k_orig': 'Water2'},
        ],
    }
    placements = {
        "WaterSilo1": {
            "name": "CISTA",
            "type": "Water",
            "subtype": "CleanWater",
        },
        "WaterSilo2": {
            "name": "KALOVA",
            "type": "Water",
            "subtype": "RecycledWater",
        },
    }
    legacy_water = 0
    recycled_water_disabled = 1
    waters = utils.get_available_waters(recipe, placements, legacy_water, recycled_water_disabled)
    base_ini_fn = "tests/data/base.ini"
    silo_to_bin = atxutils.load_silo_to_bin_mapping(base_ini_fn)  # TODO: this is legacy - get the mapping from stru
    batch_water_reduced = 220
    solids_corrected = 0
    water_temperature = 14
    denss = {
        "CISTA": 1.0,
        "KALOVA": 1.01,
    }
    temps = {
        "CISTA": 20,
        "KALOVA": 20,
    }
    new_waters_corr = utils.recalc_water(batch_water_reduced, solids_corrected, water_temperature, waters, denss, temps)
    batch_volume = 2.5

    # TODO: this is all cut-n-pasted, clean this shit

    used_k_origs = set()  # TODO: this is ugly
    for name in waters:
        w = atxutils.find_by(recipe["materials"], "Name", name)
        if w:
            used_k_origs.add(w["_k_orig"])
    used_k_origs = {i["_k_orig"] for i in recipe["materials"]}

    ret = {
        "materials": [],
    }
    for name in waters:
        silo_ = utils.material_name_to_silo(name, placements)
        bin_num = silo_to_bin[(placements[silo_]["type"], atxcomm.get_index(silo_))]
        silo_major = atxcomm.get_index(silo_)
        silo_minor = placements[silo_].get("silo_minor")
        d = {"Bin": bin_num, "Silo_Major": silo_major, "Silo_Minor": silo_minor, "Weight": new_waters_corr[name] * batch_volume}
        w = atxutils.find_by(recipe["materials"], "Name", name)
        if w:
            d["_k_orig"] = w["_k_orig"]
        else:
            # TODO: uglyyyy
            for i in range(1, 20):  # TODO: hard-coded shit
                if f"Water{i}" not in used_k_origs:
                    # logging.debug(f"created new _k_orig of Water{i} for {name}")
                    d["_k_orig"] = f"Water{i}"
                    used_k_origs.add(f"Water{i}")
                    break
        ret["materials"].append(d)
    assert ret
    # TODO: actually assert something meaningful


def test_reorder_queue():
    q = ["aa", "bb", "cc"]
    ops = {
        "aa": {"state": None},
        "bb": {"state": "ready"},
    }
    q = manager.reordered_queue(q, ops)
    assert q == ["bb", "aa", "cc"]


def test_gen_next_batch_request_all_sent():
    base_ini_fn = "tests/data/base.ini"
    parameters_ini_fn = "tests/data/parameters.ini"
    settings_ini_fn = "tests/data/settings.ini"
    placement_ini_fn = "tests/data/placemnt.ini"
    o = atxcomm.order_from_ini_f("tests/data/order1.ord")
    r = atxcomm.recipe_from_ini_f("tests/data/order1.ord")
    batch_volume = 1
    # op = {
    # 'batch_count': 4,
    # 'batches_sent': [1, 2, 3, 4],
    # }
    water_correction = 10
    solids_correction = 0
    water_temperature = 30
    mem = {
        "MEMSH_MA_RecycledWater_disabled": 0,
    }
    silo_to_bin = atxutils.load_silo_to_bin_mapping(base_ini_fn) if base_ini_fn else None  # TODO: this is legacy - get the mapping from stru
    placements = atxcomm.placements_from_ini_f(placement_ini_fn, silo_to_bin)
    moistures = {f"AggregateSilo{i}": i for i in range(1, 7)}
    legacy_water = False
    stru = structure.structure_from_base_ini_pre(base_ini_fn, parameters_ini_fn, settings_ini_fn)
    temperatures = utils.get_temperatures(stru, mem)
    densities = utils.get_densities(stru, mem)
    recycled_water_disabled = mem["MEMSH_MA_RecycledWater_disabled"]
    banned_waters = None
    br_mats, _ = utils.gen_next_batch_request_materials(
        o,
        r,
        batch_volume,
        water_correction,
        solids_correction,
        water_temperature,
        recycled_water_disabled,
        banned_waters,
        temperatures,
        placements,
        moistures,
        densities,
        legacy_water,
        stru,
        False,
        False,
        silo_to_bin,
    )
    assert br_mats


def test_get_flush_water():
    recipe = {
        "materials": [{"Name": "aaa", "Weight": 1}, {"Name": "bbb", "Weight": 2}],
    }
    placements = {
        "AdmixtureSilo1": {"name": "aaa", "type": "Admixture"},
        "AdmixtureSilo2": {"name": "bbb", "type": "Admixture"},
    }
    stru = {
        "AdmixtureSilo1": {"_type": "Silo", "sink": "AdmixtureBin1"},
        "AdmixtureSilo2": {"_type": "Silo", "sink": "AdmixtureBin1"},
        "AdmixtureBin1": {"_type": "Bin", "flush_weight": 11},
    }
    x = utils.get_flush_water(recipe, placements, stru)
    assert x == 11
    stru = {
        "AdmixtureSilo1": {"_type": "Silo", "sink": "AdmixtureBin1"},
        "AdmixtureSilo2": {"_type": "Silo", "sink": "AdmixtureBin2"},
        "AdmixtureBin1": {"_type": "Bin", "flush_weight": 11},
        "AdmixtureBin2": {"_type": "Bin", "flush_weight": 22},
    }
    x = utils.get_flush_water(recipe, placements, stru)
    assert x == 33


def test_fix_water_delays():
    recipe = {
        "materials": [
            {"_k_orig": "Water1", "Delay": 13, "_type": "Water"},
            {"_k_orig": "Water2", "Delay": 55, "_type": "Water"},
        ]
    }
    br_mats = [{"_k_orig": "Water3", "Silo_Major": 3, "_type": "Water"}]
    res = utils.fix_water_delays(br_mats, recipe)
    assert res == [{"_k_orig": "Water3", "Silo_Major": 3, "_type": "Water", "Delay": 55}]


def test_calc_batch_volume_etc():
    assert utils.calc_batch_volume_etc(1, False, False, 3) == {
        "batch_count": 1,
        "batch_volume": 1,
        "batch_volume_last": None,
    }
    assert utils.calc_batch_volume_etc(2, False, False, 3) == {
        "batch_count": 1,
        "batch_volume": 2,
        "batch_volume_last": None,
    }
    assert utils.calc_batch_volume_etc(5, False, True, 3) == {
        "batch_count": 2,
        "batch_volume": 3,
        "batch_volume_last": 2,
    }
    assert utils.calc_batch_volume_etc(2, False, True, 3) == {
        "batch_count": 1,
        "batch_volume": 2,
        "batch_volume_last": None,
    }
    assert utils.calc_batch_volume_etc(3, False, True, 3) == {
        "batch_count": 1,
        "batch_volume": 3,
        "batch_volume_last": None,
    }
    assert utils.calc_batch_volume_etc(6, False, True, 3) == {
        "batch_count": 2,
        "batch_volume": 3,
        "batch_volume_last": None,
    }
    assert utils.calc_batch_volume_etc(22, True, False, 3) == {
        "batch_count": 1,
        "batch_volume": 22,
        "batch_volume_last": None,
    }
    assert utils.calc_batch_volume_etc(22, True, True, 3) == {
        "batch_count": 1,
        "batch_volume": 22,
        "batch_volume_last": None,
    }
    assert utils.calc_batch_volume_etc(22, False, False, 3) == {
        "batch_count": 8,
        "batch_volume": 2.75,
        "batch_volume_last": None,
    }
