class Main extends React.Component {
	render() {
		const keys = Object.keys(this.props.nodes).sort();
		let nodes = [];
		for (let k of keys) {
			const v = this.props.nodes[k];
			//console.log(v);
			if (v._type == 'Blind') {
				nodes.push(React.createElement(Blind, {url: '/' + k, key: k, data: v}));
			} else if (v._type == 'Bulb') {
				nodes.push(React.createElement(Bulb, {url: '/' + k, key: k, data: v}));
			} else {
				nodes.push(React.createElement(Node, {url: '/' + k, key: k, data: v}));
			}
		}
		return (<div className="main">{nodes}</div>);
	}
};

/*var Message = React.createClass({
});*/

class Node extends React.Component {
	//getInitialState: function() { return {}; },
	//componentDidMount: common_componentDidMount,

	on_key_down(e) {
		if (e.which != 13) return;
		const name = e.target.getAttribute('data-override-name');
		const val = e.target.value;
		console.log('on_key_down', this.props.url, name, val);
		$.ajax({
			url: this.props.url + '/set_override/' + name + '/' + val,
			//dataType: 'json',
			//cache: false,
			success: function(data) {
				console.log(this.props.url, 'ok');
			}.bind(this),
			error: function(xhr, status, err) {
				console.error(this.props.url, status, err.toString());
			}.bind(this),
			timeout: 5000,
		});
	}

	on_click(e) {
		const name = e.target.getAttribute('data-override-name');
		console.log('on_click', this.props.url, name);
		$.ajax({
			url: this.props.url + '/' + name,
			//dataType: 'json',
			//cache: false,
			success: function(data) {
				console.log(this.props.url, 'ok');
			}.bind(this),
			error: function(xhr, status, err) {
				console.error(this.props.url, status, err.toString());
			}.bind(this),
			timeout: 5000,
		});
	}

	on_message_click(e) {
		const name = e.target.getAttribute('data-override-name');
		const ans = e.target.getAttribute('data-override-ans');
		console.log('on_message_click', this.props.url, name, ans);
		$.ajax({
			url: this.props.url + '/set_message_answer/' + name + '/' + ans,
			//dataType: 'json',
			//cache: false,
			success: function(data) {
				console.log(this.props.url, 'ok');
			}.bind(this),
			error: function(xhr, status, err) {
				console.error(this.props.url, status, err.toString());
			}.bind(this),
			timeout: 5000,
		});
	}

	render() {
		const info_str = JSON.stringify(this.props.data, null, 2);
		let overrides = [];
		for (let k in this.props.data['_overrides']) {
			const v = this.props.data['_overrides'][k];
			overrides.push(<div key={this.props.url + '/override/' + k}>{k}: {JSON.stringify(v, null, 2)} <input data-override-name={k} onKeyDown={this.on_key_down.bind(this)} size="1" /></div>);
		}
		let actions = [];
		for (let k in this.props.data['_actions']) {
			const v = this.props.data['_actions'][k];
			actions.push(<button key={this.props.url + '/action/' + v} data-override-name={v} onClick={this.on_click.bind(this)}>{v}</button>);
		}
		/*const messages_str = JSON.stringify(this.props.data['messages'], null, 2);*/
		let messages = [];
		for (let k in this.props.data['_messages']) {
			const v = this.props.data['_messages'][k];
			let buts = [];
			for (let i in v['options']) {
				const ii = v['options'][i];
				buts.push(<button data-override-name={k} data-override-ans={ii} onClick={this.on_message_click.bind(this)}>{ii}</button>);
			}
			messages.push(<div>{k}: {buts}</div>);
		}
		return (
			<div className="node">
				{this.props.url}: <pre>{info_str}</pre>
				<div className='overrides'>{overrides}</div>
				<div className='actions'>{actions}</div>
				<div className='messages'>{messages}</div>
			</div>
		)
	}
};

class Blind extends React.Component {
	on_click(e) {
		console.log('on_click', this.props.url);
		const name = e.target.getAttribute('data-action-name');
		$.ajax({
			url: this.props.url + '/' + name,
			//dataType: 'json',
			//cache: false,
			success: function(data) {
				console.log(this.props.url, 'ok');
			}.bind(this),
			error: function(xhr, status, err) {
				console.error(this.props.url, status, err.toString());
			}.bind(this),
			timeout: 5000,
		});
	}

	render() {
		const info_str = JSON.stringify(this.props.data, null, 2);
		return (
			<div className="node">
				{this.props.url}: <br /> <pre style={{display: "none"}}>{info_str}</pre>
				<img src="/static/blind_open.png" width="64" data-action-name="go_up" onClick={this.on_click.bind(this)} />
				<img src="/static/blind_semi.png" width="64" data-action-name="go_down_and_open" onClick={this.on_click.bind(this)} />
				<img src="/static/blind_closed.png" width="64" data-action-name="go_down" onClick={this.on_click.bind(this)} />
				<img src="/static/stop.png" width="48" data-action-name="stop" onClick={this.on_click.bind(this)} />
			</div>
		)
	}
};

class Bulb extends React.Component {
	on_click(e) {
		console.log('on_click', this.props.url);
		const name = e.target.getAttribute('data-action-name');
		$.ajax({
			url: this.props.url + '/' + name,
			//dataType: 'json',
			//cache: false,
			success: function(data) {
				console.log(this.props.url, 'ok');
			}.bind(this),
			error: function(xhr, status, err) {
				console.error(this.props.url, status, err.toString());
			}.bind(this),
			timeout: 5000,
		});
	}

	render() {
		const info_str = JSON.stringify(this.props.data, null, 2);
		const on_off = this.props.data['is_on'];
		const img_src = "/static/bulb_" + (on_off ? "on" : "off") + ".png";
		return (
			<div className="node">
				{this.props.url}: <br /> <pre style={{display: "none"}}>{info_str}</pre>
				<img src={img_src} width="64" data-action-name="toggle" onClick={this.on_click.bind(this)} />
			</div>
		)
	}
};

//ReactDOM.render(<Main />, document.getElementById('content'));

var source = new EventSource('/stream');
source.onmessage = e => {
	const data = JSON.parse(e.data);
	ReactDOM.render(<Main nodes={data}/>, document.getElementById('content'));
};
/*
source.onerror = e => {
	console.log('sse error');
	ReactDOM.render(<div>sse error</div>, document.getElementById('content'));
};
*/
