"""Peewee migrations -- 113_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    @migrator.create_model
    class LockedTable(pw.Model):
        id = pw.AutoField()
        user = pw.ForeignKeyField(backref='locked_tables', column_name='user_id', field='id', model=migrator.orm['user'], on_delete='CASCADE')
        table_name = pw.TextField()

        class Meta:
            table_name = "lockedtable"
            indexes = [(('user', 'table_name'), True)]


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('lockedtable')
