"""Peewee migrations -- 131_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator


def migrate(migrator: Migrator, database: pw.Database, *, fake: bool = False) -> None:
    """Write your migrations here."""

    migrator.remove_fields('order',  'transport_zone_modified')


def rollback(migrator: Migrator, database: pw.Database, *, fake: bool = False) -> None:
    """Write your rollback migrations here."""

    migrator.add_fields(
        'order',

        transport_zone_modified=pw.ForeignKeyField(column_name='transport_zone_modified_id', field='id', model=migrator.orm['transportzone'], null=True, on_delete='RESTRICT'))

    migrator.sql("""
        UPDATE "order"
        SET transport_zone_modified_id = "delivery".transport_zone_modified_id
        FROM (SELECT id, transport_zone_modified_id FROM "delivery") AS "delivery"
        WHERE "delivery".id = "order".delivery_id;
    """)
