"""Peewee migrations -- 057_MAIN.py."""

import datetime as dt
import peewee as pw
from peewee_migrate import Migrator
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    @migrator.create_model
    class Pump(pw.Model):
        id = pw.AutoField()
        hidden = pw.BooleanField(constraints=[SQL("DEFAULT False")], default=False)
        registration_number = pw.TextField(unique=True)
        driver = pw.ForeignKeyField(backref='pump_set', column_name='driver_id', field='id', model=migrator.orm['driver'], null=True, on_delete='SET NULL')
        comment = pw.TextField(null=True)
        pump_type = pw.TextField(null=True)
        price_per_km = pw.DoubleField(null=True)
        price_per_hour = pw.DoubleField(null=True)

        class Meta:
            table_name = "pump"


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('pump')
