"""Peewee migrations -- 096_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):

    @migrator.create_model
    class TransportType(pw.Model):
        id = pw.AutoField()
        hidden = pw.BooleanField(constraints=[SQL("DEFAULT False")], default=False)
        name = pw.TextField(unique=True)

        class Meta:
            table_name = "transporttype"


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('transporttype')
