import logging
from typing import Callable

from peewee_migrate.cli import get_router
from pathlib import Path
from importlib import import_module
from peewee_migrate.router import void, Router

from atxdispatch import settings


def read(self, name: str) -> tuple[Callable, Callable]:
    """The original method reads the file and then uses exec() on it (wtf :D?) so a debugger does not work there.
    Import the file normally to enable migration debugging.
    """
    module = import_module(name)

    return getattr(module, "migrate", void), getattr(module, "rollback", void)


if __name__ == '__main__':
    logging.basicConfig(level=logging.DEBUG)

    Router.read = read

    router = get_router(
        directory=str(Path(__file__).absolute().parent),
        database=f"sqlite:///{settings.DEFAULT_DB_FILE}",
        verbose=1,
    )
    router.run()
