"""Peewee migrations -- 149_MAIN.py.

Some examples (model - class or model name)::

    > Model = migrator.orm['table_name']            # Return model in current state by name
    > Model = migrator.ModelClass                   # Return model in current state by name

    > migrator.sql(sql)                             # Run custom SQL
    > migrator.run(func, *args, **kwargs)           # Run python function with the given args
    > migrator.create_model(Model)                  # Create a model (could be used as decorator)
    > migrator.remove_model(model, cascade=True)    # Remove a model
    > migrator.add_fields(model, **fields)          # Add fields to a model
    > migrator.change_fields(model, **fields)       # Change fields
    > migrator.remove_fields(model, *field_names, cascade=True)
    > migrator.rename_field(model, old_field_name, new_field_name)
    > migrator.rename_table(model, new_table_name)
    > migrator.add_index(model, *col_names, unique=False)
    > migrator.add_not_null(model, *field_names)
    > migrator.add_default(model, field_name, default)
    > migrator.add_constraint(model, name, sql)
    > migrator.drop_index(model, *col_names)
    > migrator.drop_not_null(model, *field_names)
    > migrator.drop_constraints(model, *constraints)

"""

from contextlib import suppress

import peewee as pw
from peewee_migrate import Migrator


with suppress(ImportError):
    import playhouse.postgres_ext as pw_pext


def migrate(migrator: Migrator, database: pw.Database, *, fake=False):
    """Write your migrations here."""

    migrator.rename_field('order', 'audit_changed_by', 'audit_created_by')
    migrator.rename_field('order', 'audit_changed_at', 'audit_created_at')

    migrator.add_fields(
        'order',
        audit_changed_at=pw.IntegerField(default=0),
        audit_changed_by=pw.TextField(null=True))

    migrator.rename_field('sample', 'audit_changed_by', 'audit_created_by')
    migrator.rename_field('sample', 'audit_changed_at', 'audit_created_at')

    migrator.add_fields(
        'sample',
        audit_changed_at=pw.IntegerField(default=0),
        audit_changed_by=pw.TextField(null=True))


def rollback(migrator: Migrator, database: pw.Database, *, fake=False):
    """Write your rollback migrations here."""
    migrator.remove_fields('sample', 'audit_changed_at', 'audit_changed_by')

    migrator.rename_field('sample', 'audit_created_by', 'audit_changed_by')
    migrator.rename_field('sample', 'audit_created_at', 'audit_changed_at')

    migrator.remove_fields('order', 'audit_changed_at', 'audit_changed_by')

    migrator.rename_field('order', 'audit_created_by', 'audit_changed_by')
    migrator.rename_field('order', 'audit_created_at', 'audit_changed_at')
