"""Peewee migrations -- 080_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):

    @migrator.create_model
    class Price(pw.Model):
        id = pw.AutoField()
        recipe = pw.ForeignKeyField(backref='prices', column_name='recipe_id', field='id', model=migrator.orm['recipe'], on_delete='CASCADE')
        customer = pw.ForeignKeyField(backref='prices', column_name='customer_id', field='id', model=migrator.orm['customer'], on_delete='CASCADE')
        amount = pw.DoubleField()
        type = pw.IntegerField(constraints=[SQL("DEFAULT 1")], default=1)

        class Meta:
            table_name = "price"


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('price')
