"""Peewee migrations -- 066_MAIN.py."""

import datetime as dt
import peewee as pw
from peewee_migrate import Migrator
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields('recipe', price=pw.DoubleField(null=True))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('recipe', 'price')

