"""Peewee migrations -- 144_MAIN.py.

Some examples (model - class or model name)::

    > Model = migrator.orm['table_name']            # Return model in current state by name
    > Model = migrator.ModelClass                   # Return model in current state by name

    > migrator.sql(sql)                             # Run custom SQL
    > migrator.run(func, *args, **kwargs)           # Run python function with the given args
    > migrator.create_model(Model)                  # Create a model (could be used as decorator)
    > migrator.remove_model(model, cascade=True)    # Remove a model
    > migrator.add_fields(model, **fields)          # Add fields to a model
    > migrator.change_fields(model, **fields)       # Change fields
    > migrator.remove_fields(model, *field_names, cascade=True)
    > migrator.rename_field(model, old_field_name, new_field_name)
    > migrator.rename_table(model, new_table_name)
    > migrator.add_index(model, *col_names, unique=False)
    > migrator.add_not_null(model, *field_names)
    > migrator.add_default(model, field_name, default)
    > migrator.add_constraint(model, name, sql)
    > migrator.drop_index(model, *col_names)
    > migrator.drop_not_null(model, *field_names)
    > migrator.drop_constraints(model, *constraints)

"""

from contextlib import suppress

import peewee as pw
from peewee_migrate import Migrator

from atxdispatch import settings, func

with suppress(ImportError):
    import playhouse.postgres_ext as pw_pext


def migrate_state_up() -> None:
    state = func.state_load(settings.STATE_FILE)
    if temperature_air := state.pop("temperature_by_user", None):
        state["temperature_air_by_user"] = temperature_air
        func.state_save(state, settings.STATE_FILE)


def migrate_state_down() -> None:
    state = func.state_load(settings.STATE_FILE)
    if temperature_air := state.pop("temperature_air_by_user", None):
        state["temperature_by_user"] = temperature_air
        func.state_save(state, settings.STATE_FILE)


def migrate(migrator: Migrator, database: pw.Database, *, fake=False):
    """Write your migrations here."""

    migrator.add_fields(
        'order',

        temperature_concrete=pw.DoubleField(null=True))

    migrator.rename_field('order', 'temperature', 'temperature_air')

    migrator.run(migrate_state_up)


def rollback(migrator: Migrator, database: pw.Database, *, fake=False):
    """Write your rollback migrations here."""

    migrator.rename_field('order', 'temperature_air', 'temperature')

    migrator.remove_fields('order', 'temperature_concrete')

    migrator.run(migrate_state_down)
