"""Peewee migrations -- 038_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.rename_field('batchmaterial', 'consumption_rq', 'amount_rq')


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.rename_field('batchmaterial', 'amount_rq', 'consumption_rq')
