"""Peewee migrations -- 034_MAIN.py."""
import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.drop_index('customer', 'name', 'company_id')
    migrator.rename_field('customer', 'company_id', 'company_idnum')
    migrator.add_index('customer', 'name', 'company_idnum', unique=True)


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.drop_index('customer', 'name', 'company_idnum')
    migrator.rename_field('customer', 'company_idnum', 'company_id')
    migrator.add_index('customer', 'name', 'company_id', unique=True)
