"""Peewee migrations -- 089_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields(
        'order',
        price_surcharges_modified=pw.DoubleField(null=True),
        price_shipping_modified=pw.DoubleField(null=True),
        price_concrete_modified=pw.DoubleField(null=True))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('order', 'price_surcharges_modified', 'price_shipping_modified', 'price_concrete_modified')
