"""Peewee migrations -- 075_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):

    @migrator.create_model
    class CompanySurcharge(pw.Model):
        id = pw.AutoField()
        name = pw.TextField(unique=True)
        price = pw.DoubleField(null=True)
        price_type = pw.IntegerField(constraints=[SQL("DEFAULT 0")], default=0)
        unit_name = pw.TextField(null=True)

        class Meta:
            table_name = "companysurcharge"


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('companysurcharge')

