"""Peewee migrations -- 072_MAIN.py.
"""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields('pumpordersurcharge', export_name=pw.TextField(null=True))
    migrator.add_fields('pumpsurcharge', export_name=pw.TextField(null=True))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('pumpsurcharge', 'export_name')
    migrator.remove_fields('pumpordersurcharge', 'export_name')

