"""Peewee migrations -- 062_MAIN.py."""

import datetime as dt
import peewee as pw
from peewee_migrate import Migrator
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):

    @migrator.create_model
    class PumpOrderSurcharge(pw.Model):
        id = pw.AutoField()
        type = pw.IntegerField()
        order = pw.ForeignKeyField(backref='surcharges', column_name='order_id', field='id', model=migrator.orm['pumporder'], on_delete='CASCADE')
        price_unit = pw.DoubleField(null=True)
        amount = pw.IntegerField(null=True)

        class Meta:
            table_name = "pumpordersurcharge"
            indexes = [(('type', 'order'), True)]


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('pumpordersurcharge')

