"""Peewee migrations -- 104_MAIN.py."""

import datetime as dt
import peewee as pw
from peewee_migrate import Migrator
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields(
        'order',
        contract_record=pw.ForeignKeyField(backref='orders', column_name='contract_record_id', field='id', model=migrator.orm['contract'], null=True, on_delete='SET NULL'),
        recipe_record=pw.ForeignKeyField(backref='orders', column_name='recipe_record_id', field='id', model=migrator.orm['recipe'], null=True, on_delete='SET NULL'))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('order', 'contract_record', 'recipe_record')
