"""Peewee migrations -- 087_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.rename_field('transportzone', 'distance_km', 'distance_km_max')


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.rename_field('transportzone', 'distance_km_max', 'distance_km')
