""" Workability time for Recipe """

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields('order', r_workability_time=pw.IntegerField(null=True))
    migrator.add_fields('defaults', workability_time=pw.IntegerField(null=True))
    migrator.add_fields('recipe', workability_time=pw.IntegerField(null=True))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('recipe', 'workability_time')
    migrator.remove_fields('defaults', 'workability_time')
    migrator.remove_fields('order', 'r_workability_time')
