"""Peewee migrations -- 088_MAIN.py.
"""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields(
        'transportzone',
        distance_km_min=pw.IntegerField(constraints=[SQL("DEFAULT 0")], default=0),
        distance_max_inclusive=pw.BooleanField(constraints=[SQL("DEFAULT False")], default=False),
        distance_min_inclusive=pw.BooleanField(constraints=[SQL("DEFAULT False")], default=False))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('transportzone', 'distance_km_min', 'distance_max_inclusive', 'distance_min_inclusive')

