"""Peewee migrations -- 105_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):

    migrator.add_fields(
        'delivery',
        car_record=pw.ForeignKeyField(backref='deliveries', column_name='car_record_id', field='id', model=migrator.orm['car'], null=True, on_delete='SET NULL'))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('delivery', 'car_record')
