"""Peewee migrations -- 083_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields('order', r_price_note=pw.TextField(null=True))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('order', 'r_price_note')
