"""Peewee migrations -- 059_MAIN.py."""

import datetime as dt
import peewee as pw
from peewee_migrate import Migrator
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.drop_not_null('pumporder', 'construction_site_name')
    migrator.drop_index('pumporder', 'construction_site_name')


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_not_null('pumporder', 'construction_site_name')
    migrator.add_index('pumporder', 'construction_site_name', unique=True)

