"""Peewee migrations -- 101_MAIN.py.

Some examples (model - class or model name)::

    > Model = migrator.orm['model_name']            # Return model in current state by name

    > migrator.sql(sql)                             # Run custom SQL
    > migrator.python(func, *args, **kwargs)        # Run python code
    > migrator.create_model(Model)                  # Create a model (could be used as decorator)
    > migrator.remove_model(model, cascade=True)    # Remove a model
    > migrator.add_fields(model, **fields)          # Add fields to a model
    > migrator.change_fields(model, **fields)       # Change fields
    > migrator.remove_fields(model, *field_names, cascade=True)
    > migrator.rename_field(model, old_field_name, new_field_name)
    > migrator.rename_table(model, new_table_name)
    > migrator.add_index(model, *col_names, unique=False)
    > migrator.drop_index(model, *col_names)
    > migrator.add_not_null(model, *field_names)
    > migrator.drop_not_null(model, *field_names)
    > migrator.add_default(model, field_name, default)

"""

import peewee as pw
from peewee_migrate import Migrator
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database: pw.Database, fake=False, **kwargs):
    """Write your migrations here."""
    
    migrator.add_fields(
        'setup',

        facility_code=pw.TextField(null=True))

    @migrator.create_model
    class _Surcharge(pw.Model):
        id = pw.AutoField()
        name = pw.TextField(unique=True)
        price = pw.DoubleField(null=True)

        class Meta:
            table_name = "_surcharge"

    @migrator.create_model
    class _Vehicle(pw.Model):
        id = pw.AutoField()
        registration_number = pw.TextField(unique=True)
        driver = pw.ForeignKeyField(column_name='driver_id', field='id', model=migrator.orm['driver'], null=True, on_delete='SET NULL')
        comment = pw.TextField(null=True)
        price_per_km = pw.DoubleField(null=True)

        class Meta:
            table_name = "_vehicle"



def rollback(migrator: Migrator, database: pw.Database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    
    migrator.remove_fields('setup', 'facility_code')

    migrator.remove_model('_vehicle')

    migrator.remove_model('_surcharge')
