"""Peewee migrations -- 073_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):

    @migrator.create_model
    class TransportZone(pw.Model):
        id = pw.AutoField()
        distance_km = pw.IntegerField()
        price_per_m3 = pw.DoubleField()

        class Meta:
            table_name = "transportzone"


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('transportzone')

