"""Peewee migrations -- 121_MAIN.py.

Some examples (model - class or model name)::

    > Model = migrator.orm['table_name']            # Return model in current state by name
    > Model = migrator.ModelClass                   # Return model in current state by name

    > migrator.sql(sql)                             # Run custom SQL
    > migrator.run(func, *args, **kwargs)           # Run python function with the given args
    > migrator.create_model(Model)                  # Create a model (could be used as decorator)
    > migrator.remove_model(model, cascade=True)    # Remove a model
    > migrator.add_fields(model, **fields)          # Add fields to a model
    > migrator.change_fields(model, **fields)       # Change fields
    > migrator.remove_fields(model, *field_names, cascade=True)
    > migrator.rename_field(model, old_field_name, new_field_name)
    > migrator.rename_table(model, new_table_name)
    > migrator.add_index(model, *col_names, unique=False)
    > migrator.add_not_null(model, *field_names)
    > migrator.add_default(model, field_name, default)
    > migrator.add_constraint(model, name, sql)
    > migrator.drop_index(model, *col_names)
    > migrator.drop_not_null(model, *field_names)
    > migrator.drop_constraints(model, *constraints)

"""

from contextlib import suppress

import peewee as pw
from peewee_migrate import Migrator


with suppress(ImportError):
    import playhouse.postgres_ext as pw_pext


def migrate(migrator: Migrator, database: pw.Database, *, fake=False):
    """Write your migrations here."""
    
    migrator.add_fields(
        'customer',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'constructionsite',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'defaults',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'recipe',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'transporttype',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'driver',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'car',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'contract',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'transportzone',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'order',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'batch',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'material',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'companysurcharge',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'user',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'lockedtable',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'price',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'pump',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'pumporder',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'pumpsurcharge',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'sample',

        _search_string=pw.TextField(null=True))

    migrator.add_fields(
        'stockmovement',

        _search_string=pw.TextField(null=True))

    @migrator.create_model
    class SearchableModel(pw.Model):
        id = pw.AutoField()
        _search_string = pw.TextField(null=True)

        class Meta:
            table_name = "searchablemodel"


def rollback(migrator: Migrator, database: pw.Database, *, fake=False):
    """Write your rollback migrations here."""
    
    migrator.remove_fields('stockmovement', '_search_string')

    migrator.remove_fields('sample', '_search_string')

    migrator.remove_fields('pumpsurcharge', '_search_string')

    migrator.remove_fields('pumporder', '_search_string')

    migrator.remove_fields('pump', '_search_string')

    migrator.remove_fields('price', '_search_string')

    migrator.remove_fields('lockedtable', '_search_string')

    migrator.remove_fields('user', '_search_string')

    migrator.remove_fields('companysurcharge', '_search_string')

    migrator.remove_fields('material', '_search_string')

    migrator.remove_fields('batch', '_search_string')

    migrator.remove_fields('order', '_search_string')

    migrator.remove_fields('contract', '_search_string')

    migrator.remove_fields('car', '_search_string')

    migrator.remove_fields('driver', '_search_string')

    migrator.remove_fields('recipe', '_search_string')

    migrator.remove_fields('defaults', '_search_string')

    migrator.remove_fields('transportzone', '_search_string')

    migrator.remove_fields('transporttype', '_search_string')

    migrator.remove_fields('customer', '_search_string')

    migrator.remove_fields('constructionsite', '_search_string')

    migrator.remove_model('searchablemodel')
