"""Peewee migrations -- 076_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):

    @migrator.create_model
    class OrderSurcharge(pw.Model):
        id = pw.AutoField()
        order = pw.ForeignKeyField(backref='surcharges', column_name='order_id', field='id', model=migrator.orm['order'], on_delete='CASCADE')
        name = pw.TextField()
        price = pw.DoubleField(null=True)
        price_type = pw.IntegerField()
        unit_name = pw.TextField(null=True)
        amount = pw.IntegerField(null=True)

        class Meta:
            table_name = "ordersurcharge"
            indexes = [(('name', 'order'), True)]


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('ordersurcharge')
