"""Peewee migrations -- 058_MAIN.py. Add PumpOrder """

import datetime as dt
import peewee as pw
from peewee_migrate import Migrator
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    @migrator.create_model
    class PumpOrder(pw.Model):
        id = pw.AutoField()
        hidden = pw.BooleanField(constraints=[SQL("DEFAULT False")], default=False)
        t = pw.IntegerField()
        kms = pw.DoubleField(null=True)
        hours = pw.DoubleField(null=True)
        pump_registration_number = pw.TextField(null=True)
        pump_driver = pw.TextField(null=True)
        pump_driver_contact = pw.TextField(null=True)
        pump_pump_type = pw.TextField(null=True)
        pump_price_per_km = pw.DoubleField(null=True)
        pump_price_per_hour = pw.DoubleField(null=True)
        pump_record = pw.ForeignKeyField(backref='pump_orders', column_name='pump_record_id', field='id', model=migrator.orm['pump'], null=True, on_delete='SET NULL')
        construction_site_name = pw.TextField(unique=True)
        construction_site_address = pw.TextField(null=True)
        construction_site_city = pw.TextField(null=True)
        construction_site_zip = pw.TextField(null=True)
        construction_site_record = pw.ForeignKeyField(backref='pump_orders', column_name='construction_site_record_id', field='id', model=migrator.orm['constructionsite'], null=True, on_delete='SET NULL')
        customer_name = pw.TextField()
        customer_address = pw.TextField(null=True)
        customer_city = pw.TextField(null=True)
        customer_zip = pw.TextField(null=True)
        customer_company_idnum = pw.TextField(null=True)
        customer_vat_idnum = pw.TextField(null=True)
        customer_record = pw.ForeignKeyField(backref='pump_orders', column_name='customer_record_id', field='id', model=migrator.orm['customer'], null=True, on_delete='SET NULL')

        class Meta:
            table_name = "pumporder"


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    migrator.remove_model('pumporder')
