"""Peewee migrations -- 138_MAIN.py and 139_MAIN.py

Split into two due to field removal being stupid
"""

from contextlib import suppress

import peewee as pw
from peewee_migrate import Migrator


with suppress(ImportError):
    import playhouse.postgres_ext as pw_pext


def migrate(migrator: Migrator, database: pw.Database, *, fake=False):
    """Write your migrations here."""

    migrator.remove_fields("order", "price_concrete_modified")


def rollback(migrator: Migrator, database: pw.Database, *, fake=False):
    """Write your rollback migrations here."""

    migrator.add_fields('order',

                        price_concrete_modified=pw.DoubleField(null=True))
