"""Peewee migrations -- 090_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.rename_field('order', 'price_shipping_modified', 'price_transport_modified')


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.rename_field('order', 'price_transport_modified', 'price_shipping_modified')
