"""Peewee migrations -- 094_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields(
        'order',
        transport_zone_modified=pw.ForeignKeyField(backref='orders', column_name='transport_zone_modified_id', field='id', model=migrator.orm['transportzone'], null=True, on_delete='RESTRICT'))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('order', 'transport_zone_modified')
