from typing import Callable, Any

from playhouse.migrate import SqliteMigrator


def force_kwargs(method: Callable, **forced_kwargs) -> Callable:
    def inner(*args, **kwargs) -> Any:
        merged_kwargs = kwargs | forced_kwargs
        return method(*args, **merged_kwargs)
    return inner


def drop_fk_column_fix() -> None:
    """Peewee is unable to drop a fk field. Call this in your migration to fix it
    https://github.com/coleifer/peewee/issues/2439#issuecomment-2259328570
    """
    SqliteMigrator.drop_column = force_kwargs(SqliteMigrator.drop_column, legacy=True)
