"""Peewee migrations -- 111_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields(
        'pumpordersurcharge',
        price_type=pw.IntegerField(constraints=[SQL("DEFAULT 0")], default=0),
        unit_name=pw.TextField(null=True))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('pumpordersurcharge', 'price_type', 'unit_name')
