# Welcome to the migrations for this project!

## General information
* To make a new migration after a change in the database model, please use `make migs`
  * Check the generated migration to be sure that it does what you want it to do
  * There are db changes that require manual migrations, mainly to migrate data
* The database is migrated when `atxdispatch.model.mount_and_migrate_db` in the `atxdispatch.dispatch.main` runs
* Place all abstract models that should not be included in the actual DB in the migration [config file](conf.py)

## Anti-patterns
* Never import from `atxdispatch.model`. This will import the live version of the model instead of the version that was there when the migration was made. Use `migrator.orm['modelclass']` (lowercase) instead.
* Do not execute any code or SQL directly in the `migrate` or `rollback` function. Use the `migrator.run()` or `migrator.sql()`

## Tips
* Instead of using `print()`, use the [debug runner](debug_migrations.py) to debug migrations in a debugger

## Gotchas
* If you add a nullable field, and then use `migrator.add_not_null` on it, Peewee will rewrite the bound Field you passed to `migrator.add_fields` resulting in an error. Split your migration in two and call `migrator.add_not_null` in the second migration
* Peewee is unable to drop a fk field. Call `migrations.utils.drop_fk_column_fix` in your migration to fix it
