"""Peewee migrations -- 099_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields('order', without_transport=pw.BooleanField(constraints=[SQL("DEFAULT False")], default=False))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('order', 'without_transport')
