"""Peewee migrations -- 063_MAIN.py."""

import datetime as dt
import peewee as pw
from peewee_migrate import Migrator
from decimal import ROUND_HALF_EVEN

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields(
        'pumporder',
        auto_number=pw.IntegerField(constraints=[SQL("DEFAULT 0")], default=0))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('pumporder', 'auto_number')

