"""Peewee migrations -- 040_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.rename_field('user', 'password', 'password_hash_sha256')


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.rename_field('user', 'password_hash_sha256', 'password')
