"""Peewee migrations -- 098_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    migrator.add_fields(
        'transportzone',
        transport_type=pw.ForeignKeyField(backref='zones', column_name='transport_type_id', field='id', model=migrator.orm['transporttype'], null=True, on_delete='SET NULL'))


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_fields('transportzone', 'transport_type')
