"""Peewee migrations -- 069_MAIN.py."""

import peewee as pw
from peewee_migrate import Migrator

try:
    import playhouse.postgres_ext as pw_pext
except ImportError:
    pass

SQL = pw.SQL


def migrate(migrator: Migrator, database, fake=False, **kwargs):
    @migrator.create_model
    class PumpSurcharge(pw.Model):
        id = pw.AutoField()
        name = pw.TextField(unique=True)
        price = pw.DoubleField(null=True)

        class Meta:
            table_name = "pumpsurcharge"


def rollback(migrator: Migrator, database, fake=False, **kwargs):
    migrator.remove_model('pumpsurcharge')
