// Copyright (C) 2025  Niels Martignène <niels.martignene@protonmail.com>

// Permission is hereby granted, free of charge, to any person obtaining a copy of
// this software and associated documentation files (the “Software”), to deal in
// the Software without restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
// Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.

// This file is autogenerated by crc_gen.py

namespace K {

static const uint32_t Crc32Table[256] = {
    0x00000000u, 0x77073096u, 0xEE0E612Cu, 0x990951BAu, 0x076DC419u, 0x706AF48Fu,
    0xE963A535u, 0x9E6495A3u, 0x0EDB8832u, 0x79DCB8A4u, 0xE0D5E91Eu, 0x97D2D988u,
    0x09B64C2Bu, 0x7EB17CBDu, 0xE7B82D07u, 0x90BF1D91u, 0x1DB71064u, 0x6AB020F2u,
    0xF3B97148u, 0x84BE41DEu, 0x1ADAD47Du, 0x6DDDE4EBu, 0xF4D4B551u, 0x83D385C7u,
    0x136C9856u, 0x646BA8C0u, 0xFD62F97Au, 0x8A65C9ECu, 0x14015C4Fu, 0x63066CD9u,
    0xFA0F3D63u, 0x8D080DF5u, 0x3B6E20C8u, 0x4C69105Eu, 0xD56041E4u, 0xA2677172u,
    0x3C03E4D1u, 0x4B04D447u, 0xD20D85FDu, 0xA50AB56Bu, 0x35B5A8FAu, 0x42B2986Cu,
    0xDBBBC9D6u, 0xACBCF940u, 0x32D86CE3u, 0x45DF5C75u, 0xDCD60DCFu, 0xABD13D59u,
    0x26D930ACu, 0x51DE003Au, 0xC8D75180u, 0xBFD06116u, 0x21B4F4B5u, 0x56B3C423u,
    0xCFBA9599u, 0xB8BDA50Fu, 0x2802B89Eu, 0x5F058808u, 0xC60CD9B2u, 0xB10BE924u,
    0x2F6F7C87u, 0x58684C11u, 0xC1611DABu, 0xB6662D3Du, 0x76DC4190u, 0x01DB7106u,
    0x98D220BCu, 0xEFD5102Au, 0x71B18589u, 0x06B6B51Fu, 0x9FBFE4A5u, 0xE8B8D433u,
    0x7807C9A2u, 0x0F00F934u, 0x9609A88Eu, 0xE10E9818u, 0x7F6A0DBBu, 0x086D3D2Du,
    0x91646C97u, 0xE6635C01u, 0x6B6B51F4u, 0x1C6C6162u, 0x856530D8u, 0xF262004Eu,
    0x6C0695EDu, 0x1B01A57Bu, 0x8208F4C1u, 0xF50FC457u, 0x65B0D9C6u, 0x12B7E950u,
    0x8BBEB8EAu, 0xFCB9887Cu, 0x62DD1DDFu, 0x15DA2D49u, 0x8CD37CF3u, 0xFBD44C65u,
    0x4DB26158u, 0x3AB551CEu, 0xA3BC0074u, 0xD4BB30E2u, 0x4ADFA541u, 0x3DD895D7u,
    0xA4D1C46Du, 0xD3D6F4FBu, 0x4369E96Au, 0x346ED9FCu, 0xAD678846u, 0xDA60B8D0u,
    0x44042D73u, 0x33031DE5u, 0xAA0A4C5Fu, 0xDD0D7CC9u, 0x5005713Cu, 0x270241AAu,
    0xBE0B1010u, 0xC90C2086u, 0x5768B525u, 0x206F85B3u, 0xB966D409u, 0xCE61E49Fu,
    0x5EDEF90Eu, 0x29D9C998u, 0xB0D09822u, 0xC7D7A8B4u, 0x59B33D17u, 0x2EB40D81u,
    0xB7BD5C3Bu, 0xC0BA6CADu, 0xEDB88320u, 0x9ABFB3B6u, 0x03B6E20Cu, 0x74B1D29Au,
    0xEAD54739u, 0x9DD277AFu, 0x04DB2615u, 0x73DC1683u, 0xE3630B12u, 0x94643B84u,
    0x0D6D6A3Eu, 0x7A6A5AA8u, 0xE40ECF0Bu, 0x9309FF9Du, 0x0A00AE27u, 0x7D079EB1u,
    0xF00F9344u, 0x8708A3D2u, 0x1E01F268u, 0x6906C2FEu, 0xF762575Du, 0x806567CBu,
    0x196C3671u, 0x6E6B06E7u, 0xFED41B76u, 0x89D32BE0u, 0x10DA7A5Au, 0x67DD4ACCu,
    0xF9B9DF6Fu, 0x8EBEEFF9u, 0x17B7BE43u, 0x60B08ED5u, 0xD6D6A3E8u, 0xA1D1937Eu,
    0x38D8C2C4u, 0x4FDFF252u, 0xD1BB67F1u, 0xA6BC5767u, 0x3FB506DDu, 0x48B2364Bu,
    0xD80D2BDAu, 0xAF0A1B4Cu, 0x36034AF6u, 0x41047A60u, 0xDF60EFC3u, 0xA867DF55u,
    0x316E8EEFu, 0x4669BE79u, 0xCB61B38Cu, 0xBC66831Au, 0x256FD2A0u, 0x5268E236u,
    0xCC0C7795u, 0xBB0B4703u, 0x220216B9u, 0x5505262Fu, 0xC5BA3BBEu, 0xB2BD0B28u,
    0x2BB45A92u, 0x5CB36A04u, 0xC2D7FFA7u, 0xB5D0CF31u, 0x2CD99E8Bu, 0x5BDEAE1Du,
    0x9B64C2B0u, 0xEC63F226u, 0x756AA39Cu, 0x026D930Au, 0x9C0906A9u, 0xEB0E363Fu,
    0x72076785u, 0x05005713u, 0x95BF4A82u, 0xE2B87A14u, 0x7BB12BAEu, 0x0CB61B38u,
    0x92D28E9Bu, 0xE5D5BE0Du, 0x7CDCEFB7u, 0x0BDBDF21u, 0x86D3D2D4u, 0xF1D4E242u,
    0x68DDB3F8u, 0x1FDA836Eu, 0x81BE16CDu, 0xF6B9265Bu, 0x6FB077E1u, 0x18B74777u,
    0x88085AE6u, 0xFF0F6A70u, 0x66063BCAu, 0x11010B5Cu, 0x8F659EFFu, 0xF862AE69u,
    0x616BFFD3u, 0x166CCF45u, 0xA00AE278u, 0xD70DD2EEu, 0x4E048354u, 0x3903B3C2u,
    0xA7672661u, 0xD06016F7u, 0x4969474Du, 0x3E6E77DBu, 0xAED16A4Au, 0xD9D65ADCu,
    0x40DF0B66u, 0x37D83BF0u, 0xA9BCAE53u, 0xDEBB9EC5u, 0x47B2CF7Fu, 0x30B5FFE9u,
    0xBDBDF21Cu, 0xCABAC28Au, 0x53B39330u, 0x24B4A3A6u, 0xBAD03605u, 0xCDD70693u,
    0x54DE5729u, 0x23D967BFu, 0xB3667A2Eu, 0xC4614AB8u, 0x5D681B02u, 0x2A6F2B94u,
    0xB40BBE37u, 0xC30C8EA1u, 0x5A05DF1Bu, 0x2D02EF8Du,
};

static const uint32_t Crc32CTable[256] = {
    0x00000000u, 0xF26B8303u, 0xE13B70F7u, 0x1350F3F4u, 0xC79A971Fu, 0x35F1141Cu,
    0x26A1E7E8u, 0xD4CA64EBu, 0x8AD958CFu, 0x78B2DBCCu, 0x6BE22838u, 0x9989AB3Bu,
    0x4D43CFD0u, 0xBF284CD3u, 0xAC78BF27u, 0x5E133C24u, 0x105EC76Fu, 0xE235446Cu,
    0xF165B798u, 0x030E349Bu, 0xD7C45070u, 0x25AFD373u, 0x36FF2087u, 0xC494A384u,
    0x9A879FA0u, 0x68EC1CA3u, 0x7BBCEF57u, 0x89D76C54u, 0x5D1D08BFu, 0xAF768BBCu,
    0xBC267848u, 0x4E4DFB4Bu, 0x20BD8EDEu, 0xD2D60DDDu, 0xC186FE29u, 0x33ED7D2Au,
    0xE72719C1u, 0x154C9AC2u, 0x061C6936u, 0xF477EA35u, 0xAA64D611u, 0x580F5512u,
    0x4B5FA6E6u, 0xB93425E5u, 0x6DFE410Eu, 0x9F95C20Du, 0x8CC531F9u, 0x7EAEB2FAu,
    0x30E349B1u, 0xC288CAB2u, 0xD1D83946u, 0x23B3BA45u, 0xF779DEAEu, 0x05125DADu,
    0x1642AE59u, 0xE4292D5Au, 0xBA3A117Eu, 0x4851927Du, 0x5B016189u, 0xA96AE28Au,
    0x7DA08661u, 0x8FCB0562u, 0x9C9BF696u, 0x6EF07595u, 0x417B1DBCu, 0xB3109EBFu,
    0xA0406D4Bu, 0x522BEE48u, 0x86E18AA3u, 0x748A09A0u, 0x67DAFA54u, 0x95B17957u,
    0xCBA24573u, 0x39C9C670u, 0x2A993584u, 0xD8F2B687u, 0x0C38D26Cu, 0xFE53516Fu,
    0xED03A29Bu, 0x1F682198u, 0x5125DAD3u, 0xA34E59D0u, 0xB01EAA24u, 0x42752927u,
    0x96BF4DCCu, 0x64D4CECFu, 0x77843D3Bu, 0x85EFBE38u, 0xDBFC821Cu, 0x2997011Fu,
    0x3AC7F2EBu, 0xC8AC71E8u, 0x1C661503u, 0xEE0D9600u, 0xFD5D65F4u, 0x0F36E6F7u,
    0x61C69362u, 0x93AD1061u, 0x80FDE395u, 0x72966096u, 0xA65C047Du, 0x5437877Eu,
    0x4767748Au, 0xB50CF789u, 0xEB1FCBADu, 0x197448AEu, 0x0A24BB5Au, 0xF84F3859u,
    0x2C855CB2u, 0xDEEEDFB1u, 0xCDBE2C45u, 0x3FD5AF46u, 0x7198540Du, 0x83F3D70Eu,
    0x90A324FAu, 0x62C8A7F9u, 0xB602C312u, 0x44694011u, 0x5739B3E5u, 0xA55230E6u,
    0xFB410CC2u, 0x092A8FC1u, 0x1A7A7C35u, 0xE811FF36u, 0x3CDB9BDDu, 0xCEB018DEu,
    0xDDE0EB2Au, 0x2F8B6829u, 0x82F63B78u, 0x709DB87Bu, 0x63CD4B8Fu, 0x91A6C88Cu,
    0x456CAC67u, 0xB7072F64u, 0xA457DC90u, 0x563C5F93u, 0x082F63B7u, 0xFA44E0B4u,
    0xE9141340u, 0x1B7F9043u, 0xCFB5F4A8u, 0x3DDE77ABu, 0x2E8E845Fu, 0xDCE5075Cu,
    0x92A8FC17u, 0x60C37F14u, 0x73938CE0u, 0x81F80FE3u, 0x55326B08u, 0xA759E80Bu,
    0xB4091BFFu, 0x466298FCu, 0x1871A4D8u, 0xEA1A27DBu, 0xF94AD42Fu, 0x0B21572Cu,
    0xDFEB33C7u, 0x2D80B0C4u, 0x3ED04330u, 0xCCBBC033u, 0xA24BB5A6u, 0x502036A5u,
    0x4370C551u, 0xB11B4652u, 0x65D122B9u, 0x97BAA1BAu, 0x84EA524Eu, 0x7681D14Du,
    0x2892ED69u, 0xDAF96E6Au, 0xC9A99D9Eu, 0x3BC21E9Du, 0xEF087A76u, 0x1D63F975u,
    0x0E330A81u, 0xFC588982u, 0xB21572C9u, 0x407EF1CAu, 0x532E023Eu, 0xA145813Du,
    0x758FE5D6u, 0x87E466D5u, 0x94B49521u, 0x66DF1622u, 0x38CC2A06u, 0xCAA7A905u,
    0xD9F75AF1u, 0x2B9CD9F2u, 0xFF56BD19u, 0x0D3D3E1Au, 0x1E6DCDEEu, 0xEC064EEDu,
    0xC38D26C4u, 0x31E6A5C7u, 0x22B65633u, 0xD0DDD530u, 0x0417B1DBu, 0xF67C32D8u,
    0xE52CC12Cu, 0x1747422Fu, 0x49547E0Bu, 0xBB3FFD08u, 0xA86F0EFCu, 0x5A048DFFu,
    0x8ECEE914u, 0x7CA56A17u, 0x6FF599E3u, 0x9D9E1AE0u, 0xD3D3E1ABu, 0x21B862A8u,
    0x32E8915Cu, 0xC083125Fu, 0x144976B4u, 0xE622F5B7u, 0xF5720643u, 0x07198540u,
    0x590AB964u, 0xAB613A67u, 0xB831C993u, 0x4A5A4A90u, 0x9E902E7Bu, 0x6CFBAD78u,
    0x7FAB5E8Cu, 0x8DC0DD8Fu, 0xE330A81Au, 0x115B2B19u, 0x020BD8EDu, 0xF0605BEEu,
    0x24AA3F05u, 0xD6C1BC06u, 0xC5914FF2u, 0x37FACCF1u, 0x69E9F0D5u, 0x9B8273D6u,
    0x88D28022u, 0x7AB90321u, 0xAE7367CAu, 0x5C18E4C9u, 0x4F48173Du, 0xBD23943Eu,
    0xF36E6F75u, 0x0105EC76u, 0x12551F82u, 0xE03E9C81u, 0x34F4F86Au, 0xC69F7B69u,
    0xD5CF889Du, 0x27A40B9Eu, 0x79B737BAu, 0x8BDCB4B9u, 0x988C474Du, 0x6AE7C44Eu,
    0xBE2DA0A5u, 0x4C4623A6u, 0x5F16D052u, 0xAD7D5351u,
};

static const uint64_t Crc64XzTable0[256] = {
    0x0000000000000000ull, 0xB32E4CBE03A75F6Full, 0xF4843657A840A05Bull, 0x47AA7AE9ABE7FF34ull,
    0x7BD0C384FF8F5E33ull, 0xC8FE8F3AFC28015Cull, 0x8F54F5D357CFFE68ull, 0x3C7AB96D5468A107ull,
    0xF7A18709FF1EBC66ull, 0x448FCBB7FCB9E309ull, 0x0325B15E575E1C3Dull, 0xB00BFDE054F94352ull,
    0x8C71448D0091E255ull, 0x3F5F08330336BD3Aull, 0x78F572DAA8D1420Eull, 0xCBDB3E64AB761D61ull,
    0x7D9BA13851336649ull, 0xCEB5ED8652943926ull, 0x891F976FF973C612ull, 0x3A31DBD1FAD4997Dull,
    0x064B62BCAEBC387Aull, 0xB5652E02AD1B6715ull, 0xF2CF54EB06FC9821ull, 0x41E11855055BC74Eull,
    0x8A3A2631AE2DDA2Full, 0x39146A8FAD8A8540ull, 0x7EBE1066066D7A74ull, 0xCD905CD805CA251Bull,
    0xF1EAE5B551A2841Cull, 0x42C4A90B5205DB73ull, 0x056ED3E2F9E22447ull, 0xB6409F5CFA457B28ull,
    0xFB374270A266CC92ull, 0x48190ECEA1C193FDull, 0x0FB374270A266CC9ull, 0xBC9D3899098133A6ull,
    0x80E781F45DE992A1ull, 0x33C9CD4A5E4ECDCEull, 0x7463B7A3F5A932FAull, 0xC74DFB1DF60E6D95ull,
    0x0C96C5795D7870F4ull, 0xBFB889C75EDF2F9Bull, 0xF812F32EF538D0AFull, 0x4B3CBF90F69F8FC0ull,
    0x774606FDA2F72EC7ull, 0xC4684A43A15071A8ull, 0x83C230AA0AB78E9Cull, 0x30EC7C140910D1F3ull,
    0x86ACE348F355AADBull, 0x3582AFF6F0F2F5B4ull, 0x7228D51F5B150A80ull, 0xC10699A158B255EFull,
    0xFD7C20CC0CDAF4E8ull, 0x4E526C720F7DAB87ull, 0x09F8169BA49A54B3ull, 0xBAD65A25A73D0BDCull,
    0x710D64410C4B16BDull, 0xC22328FF0FEC49D2ull, 0x85895216A40BB6E6ull, 0x36A71EA8A7ACE989ull,
    0x0ADDA7C5F3C4488Eull, 0xB9F3EB7BF06317E1ull, 0xFE5991925B84E8D5ull, 0x4D77DD2C5823B7BAull,
    0x64B62BCAEBC387A1ull, 0xD7986774E864D8CEull, 0x90321D9D438327FAull, 0x231C512340247895ull,
    0x1F66E84E144CD992ull, 0xAC48A4F017EB86FDull, 0xEBE2DE19BC0C79C9ull, 0x58CC92A7BFAB26A6ull,
    0x9317ACC314DD3BC7ull, 0x2039E07D177A64A8ull, 0x67939A94BC9D9B9Cull, 0xD4BDD62ABF3AC4F3ull,
    0xE8C76F47EB5265F4ull, 0x5BE923F9E8F53A9Bull, 0x1C4359104312C5AFull, 0xAF6D15AE40B59AC0ull,
    0x192D8AF2BAF0E1E8ull, 0xAA03C64CB957BE87ull, 0xEDA9BCA512B041B3ull, 0x5E87F01B11171EDCull,
    0x62FD4976457FBFDBull, 0xD1D305C846D8E0B4ull, 0x96797F21ED3F1F80ull, 0x2557339FEE9840EFull,
    0xEE8C0DFB45EE5D8Eull, 0x5DA24145464902E1ull, 0x1A083BACEDAEFDD5ull, 0xA9267712EE09A2BAull,
    0x955CCE7FBA6103BDull, 0x267282C1B9C65CD2ull, 0x61D8F8281221A3E6ull, 0xD2F6B4961186FC89ull,
    0x9F8169BA49A54B33ull, 0x2CAF25044A02145Cull, 0x6B055FEDE1E5EB68ull, 0xD82B1353E242B407ull,
    0xE451AA3EB62A1500ull, 0x577FE680B58D4A6Full, 0x10D59C691E6AB55Bull, 0xA3FBD0D71DCDEA34ull,
    0x6820EEB3B6BBF755ull, 0xDB0EA20DB51CA83Aull, 0x9CA4D8E41EFB570Eull, 0x2F8A945A1D5C0861ull,
    0x13F02D374934A966ull, 0xA0DE61894A93F609ull, 0xE7741B60E174093Dull, 0x545A57DEE2D35652ull,
    0xE21AC88218962D7Aull, 0x5134843C1B317215ull, 0x169EFED5B0D68D21ull, 0xA5B0B26BB371D24Eull,
    0x99CA0B06E7197349ull, 0x2AE447B8E4BE2C26ull, 0x6D4E3D514F59D312ull, 0xDE6071EF4CFE8C7Dull,
    0x15BB4F8BE788911Cull, 0xA6950335E42FCE73ull, 0xE13F79DC4FC83147ull, 0x521135624C6F6E28ull,
    0x6E6B8C0F1807CF2Full, 0xDD45C0B11BA09040ull, 0x9AEFBA58B0476F74ull, 0x29C1F6E6B3E0301Bull,
    0xC96C5795D7870F42ull, 0x7A421B2BD420502Dull, 0x3DE861C27FC7AF19ull, 0x8EC62D7C7C60F076ull,
    0xB2BC941128085171ull, 0x0192D8AF2BAF0E1Eull, 0x4638A2468048F12Aull, 0xF516EEF883EFAE45ull,
    0x3ECDD09C2899B324ull, 0x8DE39C222B3EEC4Bull, 0xCA49E6CB80D9137Full, 0x7967AA75837E4C10ull,
    0x451D1318D716ED17ull, 0xF6335FA6D4B1B278ull, 0xB199254F7F564D4Cull, 0x02B769F17CF11223ull,
    0xB4F7F6AD86B4690Bull, 0x07D9BA1385133664ull, 0x4073C0FA2EF4C950ull, 0xF35D8C442D53963Full,
    0xCF273529793B3738ull, 0x7C0979977A9C6857ull, 0x3BA3037ED17B9763ull, 0x888D4FC0D2DCC80Cull,
    0x435671A479AAD56Dull, 0xF0783D1A7A0D8A02ull, 0xB7D247F3D1EA7536ull, 0x04FC0B4DD24D2A59ull,
    0x3886B22086258B5Eull, 0x8BA8FE9E8582D431ull, 0xCC0284772E652B05ull, 0x7F2CC8C92DC2746Aull,
    0x325B15E575E1C3D0ull, 0x8175595B76469CBFull, 0xC6DF23B2DDA1638Bull, 0x75F16F0CDE063CE4ull,
    0x498BD6618A6E9DE3ull, 0xFAA59ADF89C9C28Cull, 0xBD0FE036222E3DB8ull, 0x0E21AC88218962D7ull,
    0xC5FA92EC8AFF7FB6ull, 0x76D4DE52895820D9ull, 0x317EA4BB22BFDFEDull, 0x8250E80521188082ull,
    0xBE2A516875702185ull, 0x0D041DD676D77EEAull, 0x4AAE673FDD3081DEull, 0xF9802B81DE97DEB1ull,
    0x4FC0B4DD24D2A599ull, 0xFCEEF8632775FAF6ull, 0xBB44828A8C9205C2ull, 0x086ACE348F355AADull,
    0x34107759DB5DFBAAull, 0x873E3BE7D8FAA4C5ull, 0xC094410E731D5BF1ull, 0x73BA0DB070BA049Eull,
    0xB86133D4DBCC19FFull, 0x0B4F7F6AD86B4690ull, 0x4CE50583738CB9A4ull, 0xFFCB493D702BE6CBull,
    0xC3B1F050244347CCull, 0x709FBCEE27E418A3ull, 0x3735C6078C03E797ull, 0x841B8AB98FA4B8F8ull,
    0xADDA7C5F3C4488E3ull, 0x1EF430E13FE3D78Cull, 0x595E4A08940428B8ull, 0xEA7006B697A377D7ull,
    0xD60ABFDBC3CBD6D0ull, 0x6524F365C06C89BFull, 0x228E898C6B8B768Bull, 0x91A0C532682C29E4ull,
    0x5A7BFB56C35A3485ull, 0xE955B7E8C0FD6BEAull, 0xAEFFCD016B1A94DEull, 0x1DD181BF68BDCBB1ull,
    0x21AB38D23CD56AB6ull, 0x9285746C3F7235D9ull, 0xD52F0E859495CAEDull, 0x6601423B97329582ull,
    0xD041DD676D77EEAAull, 0x636F91D96ED0B1C5ull, 0x24C5EB30C5374EF1ull, 0x97EBA78EC690119Eull,
    0xAB911EE392F8B099ull, 0x18BF525D915FEFF6ull, 0x5F1528B43AB810C2ull, 0xEC3B640A391F4FADull,
    0x27E05A6E926952CCull, 0x94CE16D091CE0DA3ull, 0xD3646C393A29F297ull, 0x604A2087398EADF8ull,
    0x5C3099EA6DE60CFFull, 0xEF1ED5546E415390ull, 0xA8B4AFBDC5A6ACA4ull, 0x1B9AE303C601F3CBull,
    0x56ED3E2F9E224471ull, 0xE5C372919D851B1Eull, 0xA26908783662E42Aull, 0x114744C635C5BB45ull,
    0x2D3DFDAB61AD1A42ull, 0x9E13B115620A452Dull, 0xD9B9CBFCC9EDBA19ull, 0x6A978742CA4AE576ull,
    0xA14CB926613CF817ull, 0x1262F598629BA778ull, 0x55C88F71C97C584Cull, 0xE6E6C3CFCADB0723ull,
    0xDA9C7AA29EB3A624ull, 0x69B2361C9D14F94Bull, 0x2E184CF536F3067Full, 0x9D36004B35545910ull,
    0x2B769F17CF112238ull, 0x9858D3A9CCB67D57ull, 0xDFF2A94067518263ull, 0x6CDCE5FE64F6DD0Cull,
    0x50A65C93309E7C0Bull, 0xE388102D33392364ull, 0xA4226AC498DEDC50ull, 0x170C267A9B79833Full,
    0xDCD7181E300F9E5Eull, 0x6FF954A033A8C131ull, 0x28532E49984F3E05ull, 0x9B7D62F79BE8616Aull,
    0xA707DB9ACF80C06Dull, 0x14299724CC279F02ull, 0x5383EDCD67C06036ull, 0xE0ADA17364673F59ull,
};
static const uint64_t Crc64XzTable1[256] = {
    0x0000000000000000ull, 0x54E979925CD0F10Dull, 0xA9D2F324B9A1E21Aull, 0xFD3B8AB6E5711317ull,
    0xC17D4962DC4DDAB1ull, 0x959430F0809D2BBCull, 0x68AFBA4665EC38ABull, 0x3C46C3D4393CC9A6ull,
    0x10223DEE1795ABE7ull, 0x44CB447C4B455AEAull, 0xB9F0CECAAE3449FDull, 0xED19B758F2E4B8F0ull,
    0xD15F748CCBD87156ull, 0x85B60D1E9708805Bull, 0x788D87A87279934Cull, 0x2C64FE3A2EA96241ull,
    0x20447BDC2F2B57CEull, 0x74AD024E73FBA6C3ull, 0x899688F8968AB5D4ull, 0xDD7FF16ACA5A44D9ull,
    0xE13932BEF3668D7Full, 0xB5D04B2CAFB67C72ull, 0x48EBC19A4AC76F65ull, 0x1C02B80816179E68ull,
    0x3066463238BEFC29ull, 0x648F3FA0646E0D24ull, 0x99B4B516811F1E33ull, 0xCD5DCC84DDCFEF3Eull,
    0xF11B0F50E4F32698ull, 0xA5F276C2B823D795ull, 0x58C9FC745D52C482ull, 0x0C2085E60182358Full,
    0x4088F7B85E56AF9Cull, 0x14618E2A02865E91ull, 0xE95A049CE7F74D86ull, 0xBDB37D0EBB27BC8Bull,
    0x81F5BEDA821B752Dull, 0xD51CC748DECB8420ull, 0x28274DFE3BBA9737ull, 0x7CCE346C676A663Aull,
    0x50AACA5649C3047Bull, 0x0443B3C41513F576ull, 0xF9783972F062E661ull, 0xAD9140E0ACB2176Cull,
    0x91D78334958EDECAull, 0xC53EFAA6C95E2FC7ull, 0x380570102C2F3CD0ull, 0x6CEC098270FFCDDDull,
    0x60CC8C64717DF852ull, 0x3425F5F62DAD095Full, 0xC91E7F40C8DC1A48ull, 0x9DF706D2940CEB45ull,
    0xA1B1C506AD3022E3ull, 0xF558BC94F1E0D3EEull, 0x086336221491C0F9ull, 0x5C8A4FB0484131F4ull,
    0x70EEB18A66E853B5ull, 0x2407C8183A38A2B8ull, 0xD93C42AEDF49B1AFull, 0x8DD53B3C839940A2ull,
    0xB193F8E8BAA58904ull, 0xE57A817AE6757809ull, 0x18410BCC03046B1Eull, 0x4CA8725E5FD49A13ull,
    0x8111EF70BCAD5F38ull, 0xD5F896E2E07DAE35ull, 0x28C31C54050CBD22ull, 0x7C2A65C659DC4C2Full,
    0x406CA61260E08589ull, 0x1485DF803C307484ull, 0xE9BE5536D9416793ull, 0xBD572CA48591969Eull,
    0x9133D29EAB38F4DFull, 0xC5DAAB0CF7E805D2ull, 0x38E121BA129916C5ull, 0x6C0858284E49E7C8ull,
    0x504E9BFC77752E6Eull, 0x04A7E26E2BA5DF63ull, 0xF99C68D8CED4CC74ull, 0xAD75114A92043D79ull,
    0xA15594AC938608F6ull, 0xF5BCED3ECF56F9FBull, 0x088767882A27EAECull, 0x5C6E1E1A76F71BE1ull,
    0x6028DDCE4FCBD247ull, 0x34C1A45C131B234Aull, 0xC9FA2EEAF66A305Dull, 0x9D135778AABAC150ull,
    0xB177A9428413A311ull, 0xE59ED0D0D8C3521Cull, 0x18A55A663DB2410Bull, 0x4C4C23F46162B006ull,
    0x700AE020585E79A0ull, 0x24E399B2048E88ADull, 0xD9D81304E1FF9BBAull, 0x8D316A96BD2F6AB7ull,
    0xC19918C8E2FBF0A4ull, 0x9570615ABE2B01A9ull, 0x684BEBEC5B5A12BEull, 0x3CA2927E078AE3B3ull,
    0x00E451AA3EB62A15ull, 0x540D28386266DB18ull, 0xA936A28E8717C80Full, 0xFDDFDB1CDBC73902ull,
    0xD1BB2526F56E5B43ull, 0x85525CB4A9BEAA4Eull, 0x7869D6024CCFB959ull, 0x2C80AF90101F4854ull,
    0x10C66C44292381F2ull, 0x442F15D675F370FFull, 0xB9149F60908263E8ull, 0xEDFDE6F2CC5292E5ull,
    0xE1DD6314CDD0A76Aull, 0xB5341A8691005667ull, 0x480F903074714570ull, 0x1CE6E9A228A1B47Dull,
    0x20A02A76119D7DDBull, 0x744953E44D4D8CD6ull, 0x8972D952A83C9FC1ull, 0xDD9BA0C0F4EC6ECCull,
    0xF1FF5EFADA450C8Dull, 0xA51627688695FD80ull, 0x582DADDE63E4EE97ull, 0x0CC4D44C3F341F9Aull,
    0x308217980608D63Cull, 0x646B6E0A5AD82731ull, 0x9950E4BCBFA93426ull, 0xCDB99D2EE379C52Bull,
    0x90FB71CAD654A0F5ull, 0xC41208588A8451F8ull, 0x392982EE6FF542EFull, 0x6DC0FB7C3325B3E2ull,
    0x518638A80A197A44ull, 0x056F413A56C98B49ull, 0xF854CB8CB3B8985Eull, 0xACBDB21EEF686953ull,
    0x80D94C24C1C10B12ull, 0xD43035B69D11FA1Full, 0x290BBF007860E908ull, 0x7DE2C69224B01805ull,
    0x41A405461D8CD1A3ull, 0x154D7CD4415C20AEull, 0xE876F662A42D33B9ull, 0xBC9F8FF0F8FDC2B4ull,
    0xB0BF0A16F97FF73Bull, 0xE4567384A5AF0636ull, 0x196DF93240DE1521ull, 0x4D8480A01C0EE42Cull,
    0x71C2437425322D8Aull, 0x252B3AE679E2DC87ull, 0xD810B0509C93CF90ull, 0x8CF9C9C2C0433E9Dull,
    0xA09D37F8EEEA5CDCull, 0xF4744E6AB23AADD1ull, 0x094FC4DC574BBEC6ull, 0x5DA6BD4E0B9B4FCBull,
    0x61E07E9A32A7866Dull, 0x350907086E777760ull, 0xC8328DBE8B066477ull, 0x9CDBF42CD7D6957Aull,
    0xD073867288020F69ull, 0x849AFFE0D4D2FE64ull, 0x79A1755631A3ED73ull, 0x2D480CC46D731C7Eull,
    0x110ECF10544FD5D8ull, 0x45E7B682089F24D5ull, 0xB8DC3C34EDEE37C2ull, 0xEC3545A6B13EC6CFull,
    0xC051BB9C9F97A48Eull, 0x94B8C20EC3475583ull, 0x698348B826364694ull, 0x3D6A312A7AE6B799ull,
    0x012CF2FE43DA7E3Full, 0x55C58B6C1F0A8F32ull, 0xA8FE01DAFA7B9C25ull, 0xFC177848A6AB6D28ull,
    0xF037FDAEA72958A7ull, 0xA4DE843CFBF9A9AAull, 0x59E50E8A1E88BABDull, 0x0D0C771842584BB0ull,
    0x314AB4CC7B648216ull, 0x65A3CD5E27B4731Bull, 0x989847E8C2C5600Cull, 0xCC713E7A9E159101ull,
    0xE015C040B0BCF340ull, 0xB4FCB9D2EC6C024Dull, 0x49C73364091D115Aull, 0x1D2E4AF655CDE057ull,
    0x216889226CF129F1ull, 0x7581F0B03021D8FCull, 0x88BA7A06D550CBEBull, 0xDC53039489803AE6ull,
    0x11EA9EBA6AF9FFCDull, 0x4503E72836290EC0ull, 0xB8386D9ED3581DD7ull, 0xECD1140C8F88ECDAull,
    0xD097D7D8B6B4257Cull, 0x847EAE4AEA64D471ull, 0x794524FC0F15C766ull, 0x2DAC5D6E53C5366Bull,
    0x01C8A3547D6C542Aull, 0x5521DAC621BCA527ull, 0xA81A5070C4CDB630ull, 0xFCF329E2981D473Dull,
    0xC0B5EA36A1218E9Bull, 0x945C93A4FDF17F96ull, 0x6967191218806C81ull, 0x3D8E608044509D8Cull,
    0x31AEE56645D2A803ull, 0x65479CF41902590Eull, 0x987C1642FC734A19ull, 0xCC956FD0A0A3BB14ull,
    0xF0D3AC04999F72B2ull, 0xA43AD596C54F83BFull, 0x59015F20203E90A8ull, 0x0DE826B27CEE61A5ull,
    0x218CD888524703E4ull, 0x7565A11A0E97F2E9ull, 0x885E2BACEBE6E1FEull, 0xDCB7523EB73610F3ull,
    0xE0F191EA8E0AD955ull, 0xB418E878D2DA2858ull, 0x492362CE37AB3B4Full, 0x1DCA1B5C6B7BCA42ull,
    0x5162690234AF5051ull, 0x058B1090687FA15Cull, 0xF8B09A268D0EB24Bull, 0xAC59E3B4D1DE4346ull,
    0x901F2060E8E28AE0ull, 0xC4F659F2B4327BEDull, 0x39CDD344514368FAull, 0x6D24AAD60D9399F7ull,
    0x414054EC233AFBB6ull, 0x15A92D7E7FEA0ABBull, 0xE892A7C89A9B19ACull, 0xBC7BDE5AC64BE8A1ull,
    0x803D1D8EFF772107ull, 0xD4D4641CA3A7D00Aull, 0x29EFEEAA46D6C31Dull, 0x7D0697381A063210ull,
    0x712612DE1B84079Full, 0x25CF6B4C4754F692ull, 0xD8F4E1FAA225E585ull, 0x8C1D9868FEF51488ull,
    0xB05B5BBCC7C9DD2Eull, 0xE4B2222E9B192C23ull, 0x1989A8987E683F34ull, 0x4D60D10A22B8CE39ull,
    0x61042F300C11AC78ull, 0x35ED56A250C15D75ull, 0xC8D6DC14B5B04E62ull, 0x9C3FA586E960BF6Full,
    0xA0796652D05C76C9ull, 0xF4901FC08C8C87C4ull, 0x09AB957669FD94D3ull, 0x5D42ECE4352D65DEull,
};
static const uint64_t Crc64XzTable2[256] = {
    0x0000000000000000ull, 0x3F0BE14A916A6DCBull, 0x7E17C29522D4DB96ull, 0x411C23DFB3BEB65Dull,
    0xFC2F852A45A9B72Cull, 0xC3246460D4C3DAE7ull, 0x823847BF677D6CBAull, 0xBD33A6F5F6170171ull,
    0x6A87A57F245D70DDull, 0x558C4435B5371D16ull, 0x149067EA0689AB4Bull, 0x2B9B86A097E3C680ull,
    0x96A8205561F4C7F1ull, 0xA9A3C11FF09EAA3Aull, 0xE8BFE2C043201C67ull, 0xD7B4038AD24A71ACull,
    0xD50F4AFE48BAE1BAull, 0xEA04ABB4D9D08C71ull, 0xAB18886B6A6E3A2Cull, 0x94136921FB0457E7ull,
    0x2920CFD40D135696ull, 0x162B2E9E9C793B5Dull, 0x57370D412FC78D00ull, 0x683CEC0BBEADE0CBull,
    0xBF88EF816CE79167ull, 0x80830ECBFD8DFCACull, 0xC19F2D144E334AF1ull, 0xFE94CC5EDF59273Aull,
    0x43A76AAB294E264Bull, 0x7CAC8BE1B8244B80ull, 0x3DB0A83E0B9AFDDDull, 0x02BB49749AF09016ull,
    0x38C63AD73E7BDDF1ull, 0x07CDDB9DAF11B03Aull, 0x46D1F8421CAF0667ull, 0x79DA19088DC56BACull,
    0xC4E9BFFD7BD26ADDull, 0xFBE25EB7EAB80716ull, 0xBAFE7D685906B14Bull, 0x85F59C22C86CDC80ull,
    0x52419FA81A26AD2Cull, 0x6D4A7EE28B4CC0E7ull, 0x2C565D3D38F276BAull, 0x135DBC77A9981B71ull,
    0xAE6E1A825F8F1A00ull, 0x9165FBC8CEE577CBull, 0xD079D8177D5BC196ull, 0xEF72395DEC31AC5Dull,
    0xEDC9702976C13C4Bull, 0xD2C29163E7AB5180ull, 0x93DEB2BC5415E7DDull, 0xACD553F6C57F8A16ull,
    0x11E6F50333688B67ull, 0x2EED1449A202E6ACull, 0x6FF1379611BC50F1ull, 0x50FAD6DC80D63D3Aull,
    0x874ED556529C4C96ull, 0xB845341CC3F6215Dull, 0xF95917C370489700ull, 0xC652F689E122FACBull,
    0x7B61507C1735FBBAull, 0x446AB136865F9671ull, 0x057692E935E1202Cull, 0x3A7D73A3A48B4DE7ull,
    0x718C75AE7CF7BBE2ull, 0x4E8794E4ED9DD629ull, 0x0F9BB73B5E236074ull, 0x30905671CF490DBFull,
    0x8DA3F084395E0CCEull, 0xB2A811CEA8346105ull, 0xF3B432111B8AD758ull, 0xCCBFD35B8AE0BA93ull,
    0x1B0BD0D158AACB3Full, 0x2400319BC9C0A6F4ull, 0x651C12447A7E10A9ull, 0x5A17F30EEB147D62ull,
    0xE72455FB1D037C13ull, 0xD82FB4B18C6911D8ull, 0x9933976E3FD7A785ull, 0xA6387624AEBDCA4Eull,
    0xA4833F50344D5A58ull, 0x9B88DE1AA5273793ull, 0xDA94FDC5169981CEull, 0xE59F1C8F87F3EC05ull,
    0x58ACBA7A71E4ED74ull, 0x67A75B30E08E80BFull, 0x26BB78EF533036E2ull, 0x19B099A5C25A5B29ull,
    0xCE049A2F10102A85ull, 0xF10F7B65817A474Eull, 0xB01358BA32C4F113ull, 0x8F18B9F0A3AE9CD8ull,
    0x322B1F0555B99DA9ull, 0x0D20FE4FC4D3F062ull, 0x4C3CDD90776D463Full, 0x73373CDAE6072BF4ull,
    0x494A4F79428C6613ull, 0x7641AE33D3E60BD8ull, 0x375D8DEC6058BD85ull, 0x08566CA6F132D04Eull,
    0xB565CA530725D13Full, 0x8A6E2B19964FBCF4ull, 0xCB7208C625F10AA9ull, 0xF479E98CB49B6762ull,
    0x23CDEA0666D116CEull, 0x1CC60B4CF7BB7B05ull, 0x5DDA28934405CD58ull, 0x62D1C9D9D56FA093ull,
    0xDFE26F2C2378A1E2ull, 0xE0E98E66B212CC29ull, 0xA1F5ADB901AC7A74ull, 0x9EFE4CF390C617BFull,
    0x9C4505870A3687A9ull, 0xA34EE4CD9B5CEA62ull, 0xE252C71228E25C3Full, 0xDD592658B98831F4ull,
    0x606A80AD4F9F3085ull, 0x5F6161E7DEF55D4Eull, 0x1E7D42386D4BEB13ull, 0x2176A372FC2186D8ull,
    0xF6C2A0F82E6BF774ull, 0xC9C941B2BF019ABFull, 0x88D5626D0CBF2CE2ull, 0xB7DE83279DD54129ull,
    0x0AED25D26BC24058ull, 0x35E6C498FAA82D93ull, 0x74FAE74749169BCEull, 0x4BF1060DD87CF605ull,
    0xE318EB5CF9EF77C4ull, 0xDC130A1668851A0Full, 0x9D0F29C9DB3BAC52ull, 0xA204C8834A51C199ull,
    0x1F376E76BC46C0E8ull, 0x203C8F3C2D2CAD23ull, 0x6120ACE39E921B7Eull, 0x5E2B4DA90FF876B5ull,
    0x899F4E23DDB20719ull, 0xB694AF694CD86AD2ull, 0xF7888CB6FF66DC8Full, 0xC8836DFC6E0CB144ull,
    0x75B0CB09981BB035ull, 0x4ABB2A430971DDFEull, 0x0BA7099CBACF6BA3ull, 0x34ACE8D62BA50668ull,
    0x3617A1A2B155967Eull, 0x091C40E8203FFBB5ull, 0x4800633793814DE8ull, 0x770B827D02EB2023ull,
    0xCA382488F4FC2152ull, 0xF533C5C265964C99ull, 0xB42FE61DD628FAC4ull, 0x8B2407574742970Full,
    0x5C9004DD9508E6A3ull, 0x639BE59704628B68ull, 0x2287C648B7DC3D35ull, 0x1D8C270226B650FEull,
    0xA0BF81F7D0A1518Full, 0x9FB460BD41CB3C44ull, 0xDEA84362F2758A19ull, 0xE1A3A228631FE7D2ull,
    0xDBDED18BC794AA35ull, 0xE4D530C156FEC7FEull, 0xA5C9131EE54071A3ull, 0x9AC2F254742A1C68ull,
    0x27F154A1823D1D19ull, 0x18FAB5EB135770D2ull, 0x59E69634A0E9C68Full, 0x66ED777E3183AB44ull,
    0xB15974F4E3C9DAE8ull, 0x8E5295BE72A3B723ull, 0xCF4EB661C11D017Eull, 0xF045572B50776CB5ull,
    0x4D76F1DEA6606DC4ull, 0x727D1094370A000Full, 0x3361334B84B4B652ull, 0x0C6AD20115DEDB99ull,
    0x0ED19B758F2E4B8Full, 0x31DA7A3F1E442644ull, 0x70C659E0ADFA9019ull, 0x4FCDB8AA3C90FDD2ull,
    0xF2FE1E5FCA87FCA3ull, 0xCDF5FF155BED9168ull, 0x8CE9DCCAE8532735ull, 0xB3E23D8079394AFEull,
    0x64563E0AAB733B52ull, 0x5B5DDF403A195699ull, 0x1A41FC9F89A7E0C4ull, 0x254A1DD518CD8D0Full,
    0x9879BB20EEDA8C7Eull, 0xA7725A6A7FB0E1B5ull, 0xE66E79B5CC0E57E8ull, 0xD96598FF5D643A23ull,
    0x92949EF28518CC26ull, 0xAD9F7FB81472A1EDull, 0xEC835C67A7CC17B0ull, 0xD388BD2D36A67A7Bull,
    0x6EBB1BD8C0B17B0Aull, 0x51B0FA9251DB16C1ull, 0x10ACD94DE265A09Cull, 0x2FA73807730FCD57ull,
    0xF8133B8DA145BCFBull, 0xC718DAC7302FD130ull, 0x8604F9188391676Dull, 0xB90F185212FB0AA6ull,
    0x043CBEA7E4EC0BD7ull, 0x3B375FED7586661Cull, 0x7A2B7C32C638D041ull, 0x45209D785752BD8Aull,
    0x479BD40CCDA22D9Cull, 0x789035465CC84057ull, 0x398C1699EF76F60Aull, 0x0687F7D37E1C9BC1ull,
    0xBBB45126880B9AB0ull, 0x84BFB06C1961F77Bull, 0xC5A393B3AADF4126ull, 0xFAA872F93BB52CEDull,
    0x2D1C7173E9FF5D41ull, 0x121790397895308Aull, 0x530BB3E6CB2B86D7ull, 0x6C0052AC5A41EB1Cull,
    0xD133F459AC56EA6Dull, 0xEE3815133D3C87A6ull, 0xAF2436CC8E8231FBull, 0x902FD7861FE85C30ull,
    0xAA52A425BB6311D7ull, 0x9559456F2A097C1Cull, 0xD44566B099B7CA41ull, 0xEB4E87FA08DDA78Aull,
    0x567D210FFECAA6FBull, 0x6976C0456FA0CB30ull, 0x286AE39ADC1E7D6Dull, 0x176102D04D7410A6ull,
    0xC0D5015A9F3E610Aull, 0xFFDEE0100E540CC1ull, 0xBEC2C3CFBDEABA9Cull, 0x81C922852C80D757ull,
    0x3CFA8470DA97D626ull, 0x03F1653A4BFDBBEDull, 0x42ED46E5F8430DB0ull, 0x7DE6A7AF6929607Bull,
    0x7F5DEEDBF3D9F06Dull, 0x40560F9162B39DA6ull, 0x014A2C4ED10D2BFBull, 0x3E41CD0440674630ull,
    0x83726BF1B6704741ull, 0xBC798ABB271A2A8Aull, 0xFD65A96494A49CD7ull, 0xC26E482E05CEF11Cull,
    0x15DA4BA4D78480B0ull, 0x2AD1AAEE46EEED7Bull, 0x6BCD8931F5505B26ull, 0x54C6687B643A36EDull,
    0xE9F5CE8E922D379Cull, 0xD6FE2FC403475A57ull, 0x97E20C1BB0F9EC0Aull, 0xA8E9ED51219381C1ull,
};
static const uint64_t Crc64XzTable3[256] = {
    0x0000000000000000ull, 0x1DEE8A5E222CA1DCull, 0x3BDD14BC445943B8ull, 0x26339EE26675E264ull,
    0x77BA297888B28770ull, 0x6A54A326AA9E26ACull, 0x4C673DC4CCEBC4C8ull, 0x5189B79AEEC76514ull,
    0xEF7452F111650EE0ull, 0xF29AD8AF3349AF3Cull, 0xD4A9464D553C4D58ull, 0xC947CC137710EC84ull,
    0x98CE7B8999D78990ull, 0x8520F1D7BBFB284Cull, 0xA3136F35DD8ECA28ull, 0xBEFDE56BFFA26BF4ull,
    0x4C300AC98DC40345ull, 0x51DE8097AFE8A299ull, 0x77ED1E75C99D40FDull, 0x6A03942BEBB1E121ull,
    0x3B8A23B105768435ull, 0x2664A9EF275A25E9ull, 0x0057370D412FC78Dull, 0x1DB9BD5363036651ull,
    0xA34458389CA10DA5ull, 0xBEAAD266BE8DAC79ull, 0x98994C84D8F84E1Dull, 0x8577C6DAFAD4EFC1ull,
    0xD4FE714014138AD5ull, 0xC910FB1E363F2B09ull, 0xEF2365FC504AC96Dull, 0xF2CDEFA2726668B1ull,
    0x986015931B88068Aull, 0x858E9FCD39A4A756ull, 0xA3BD012F5FD14532ull, 0xBE538B717DFDE4EEull,
    0xEFDA3CEB933A81FAull, 0xF234B6B5B1162026ull, 0xD4072857D763C242ull, 0xC9E9A209F54F639Eull,
    0x771447620AED086Aull, 0x6AFACD3C28C1A9B6ull, 0x4CC953DE4EB44BD2ull, 0x5127D9806C98EA0Eull,
    0x00AE6E1A825F8F1Aull, 0x1D40E444A0732EC6ull, 0x3B737AA6C606CCA2ull, 0x269DF0F8E42A6D7Eull,
    0xD4501F5A964C05CFull, 0xC9BE9504B460A413ull, 0xEF8D0BE6D2154677ull, 0xF26381B8F039E7ABull,
    0xA3EA36221EFE82BFull, 0xBE04BC7C3CD22363ull, 0x9837229E5AA7C107ull, 0x85D9A8C0788B60DBull,
    0x3B244DAB87290B2Full, 0x26CAC7F5A505AAF3ull, 0x00F95917C3704897ull, 0x1D17D349E15CE94Bull,
    0x4C9E64D30F9B8C5Full, 0x5170EE8D2DB72D83ull, 0x7743706F4BC2CFE7ull, 0x6AADFA3169EE6E3Bull,
    0xA218840D981E1391ull, 0xBFF60E53BA32B24Dull, 0x99C590B1DC475029ull, 0x842B1AEFFE6BF1F5ull,
    0xD5A2AD7510AC94E1ull, 0xC84C272B3280353Dull, 0xEE7FB9C954F5D759ull, 0xF391339776D97685ull,
    0x4D6CD6FC897B1D71ull, 0x50825CA2AB57BCADull, 0x76B1C240CD225EC9ull, 0x6B5F481EEF0EFF15ull,
    0x3AD6FF8401C99A01ull, 0x273875DA23E53BDDull, 0x010BEB384590D9B9ull, 0x1CE5616667BC7865ull,
    0xEE288EC415DA10D4ull, 0xF3C6049A37F6B108ull, 0xD5F59A785183536Cull, 0xC81B102673AFF2B0ull,
    0x9992A7BC9D6897A4ull, 0x847C2DE2BF443678ull, 0xA24FB300D931D41Cull, 0xBFA1395EFB1D75C0ull,
    0x015CDC3504BF1E34ull, 0x1CB2566B2693BFE8ull, 0x3A81C88940E65D8Cull, 0x276F42D762CAFC50ull,
    0x76E6F54D8C0D9944ull, 0x6B087F13AE213898ull, 0x4D3BE1F1C854DAFCull, 0x50D56BAFEA787B20ull,
    0x3A78919E8396151Bull, 0x27961BC0A1BAB4C7ull, 0x01A58522C7CF56A3ull, 0x1C4B0F7CE5E3F77Full,
    0x4DC2B8E60B24926Bull, 0x502C32B8290833B7ull, 0x761FAC5A4F7DD1D3ull, 0x6BF126046D51700Full,
    0xD50CC36F92F31BFBull, 0xC8E24931B0DFBA27ull, 0xEED1D7D3D6AA5843ull, 0xF33F5D8DF486F99Full,
    0xA2B6EA171A419C8Bull, 0xBF586049386D3D57ull, 0x996BFEAB5E18DF33ull, 0x848574F57C347EEFull,
    0x76489B570E52165Eull, 0x6BA611092C7EB782ull, 0x4D958FEB4A0B55E6ull, 0x507B05B56827F43Aull,
    0x01F2B22F86E0912Eull, 0x1C1C3871A4CC30F2ull, 0x3A2FA693C2B9D296ull, 0x27C12CCDE095734Aull,
    0x993CC9A61F3718BEull, 0x84D243F83D1BB962ull, 0xA2E1DD1A5B6E5B06ull, 0xBF0F57447942FADAull,
    0xEE86E0DE97859FCEull, 0xF3686A80B5A93E12ull, 0xD55BF462D3DCDC76ull, 0xC8B57E3CF1F07DAAull,
    0xD6E9A7309F3239A7ull, 0xCB072D6EBD1E987Bull, 0xED34B38CDB6B7A1Full, 0xF0DA39D2F947DBC3ull,
    0xA1538E481780BED7ull, 0xBCBD041635AC1F0Bull, 0x9A8E9AF453D9FD6Full, 0x876010AA71F55CB3ull,
    0x399DF5C18E573747ull, 0x24737F9FAC7B969Bull, 0x0240E17DCA0E74FFull, 0x1FAE6B23E822D523ull,
    0x4E27DCB906E5B037ull, 0x53C956E724C911EBull, 0x75FAC80542BCF38Full, 0x6814425B60905253ull,
    0x9AD9ADF912F63AE2ull, 0x873727A730DA9B3Eull, 0xA104B94556AF795Aull, 0xBCEA331B7483D886ull,
    0xED6384819A44BD92ull, 0xF08D0EDFB8681C4Eull, 0xD6BE903DDE1DFE2Aull, 0xCB501A63FC315FF6ull,
    0x75ADFF0803933402ull, 0x6843755621BF95DEull, 0x4E70EBB447CA77BAull, 0x539E61EA65E6D666ull,
    0x0217D6708B21B372ull, 0x1FF95C2EA90D12AEull, 0x39CAC2CCCF78F0CAull, 0x24244892ED545116ull,
    0x4E89B2A384BA3F2Dull, 0x536738FDA6969EF1ull, 0x7554A61FC0E37C95ull, 0x68BA2C41E2CFDD49ull,
    0x39339BDB0C08B85Dull, 0x24DD11852E241981ull, 0x02EE8F674851FBE5ull, 0x1F0005396A7D5A39ull,
    0xA1FDE05295DF31CDull, 0xBC136A0CB7F39011ull, 0x9A20F4EED1867275ull, 0x87CE7EB0F3AAD3A9ull,
    0xD647C92A1D6DB6BDull, 0xCBA943743F411761ull, 0xED9ADD965934F505ull, 0xF07457C87B1854D9ull,
    0x02B9B86A097E3C68ull, 0x1F5732342B529DB4ull, 0x3964ACD64D277FD0ull, 0x248A26886F0BDE0Cull,
    0x7503911281CCBB18ull, 0x68ED1B4CA3E01AC4ull, 0x4EDE85AEC595F8A0ull, 0x53300FF0E7B9597Cull,
    0xEDCDEA9B181B3288ull, 0xF02360C53A379354ull, 0xD610FE275C427130ull, 0xCBFE74797E6ED0ECull,
    0x9A77C3E390A9B5F8ull, 0x879949BDB2851424ull, 0xA1AAD75FD4F0F640ull, 0xBC445D01F6DC579Cull,
    0x74F1233D072C2A36ull, 0x691FA96325008BEAull, 0x4F2C37814375698Eull, 0x52C2BDDF6159C852ull,
    0x034B0A458F9EAD46ull, 0x1EA5801BADB20C9Aull, 0x38961EF9CBC7EEFEull, 0x257894A7E9EB4F22ull,
    0x9B8571CC164924D6ull, 0x866BFB923465850Aull, 0xA05865705210676Eull, 0xBDB6EF2E703CC6B2ull,
    0xEC3F58B49EFBA3A6ull, 0xF1D1D2EABCD7027Aull, 0xD7E24C08DAA2E01Eull, 0xCA0CC656F88E41C2ull,
    0x38C129F48AE82973ull, 0x252FA3AAA8C488AFull, 0x031C3D48CEB16ACBull, 0x1EF2B716EC9DCB17ull,
    0x4F7B008C025AAE03ull, 0x52958AD220760FDFull, 0x74A614304603EDBBull, 0x69489E6E642F4C67ull,
    0xD7B57B059B8D2793ull, 0xCA5BF15BB9A1864Full, 0xEC686FB9DFD4642Bull, 0xF186E5E7FDF8C5F7ull,
    0xA00F527D133FA0E3ull, 0xBDE1D8233113013Full, 0x9BD246C15766E35Bull, 0x863CCC9F754A4287ull,
    0xEC9136AE1CA42CBCull, 0xF17FBCF03E888D60ull, 0xD74C221258FD6F04ull, 0xCAA2A84C7AD1CED8ull,
    0x9B2B1FD69416ABCCull, 0x86C59588B63A0A10ull, 0xA0F60B6AD04FE874ull, 0xBD188134F26349A8ull,
    0x03E5645F0DC1225Cull, 0x1E0BEE012FED8380ull, 0x383870E3499861E4ull, 0x25D6FABD6BB4C038ull,
    0x745F4D278573A52Cull, 0x69B1C779A75F04F0ull, 0x4F82599BC12AE694ull, 0x526CD3C5E3064748ull,
    0xA0A13C6791602FF9ull, 0xBD4FB639B34C8E25ull, 0x9B7C28DBD5396C41ull, 0x8692A285F715CD9Dull,
    0xD71B151F19D2A889ull, 0xCAF59F413BFE0955ull, 0xECC601A35D8BEB31ull, 0xF1288BFD7FA74AEDull,
    0x4FD56E9680052119ull, 0x523BE4C8A22980C5ull, 0x74087A2AC45C62A1ull, 0x69E6F074E670C37Dull,
    0x386F47EE08B7A669ull, 0x2581CDB02A9B07B5ull, 0x03B253524CEEE5D1ull, 0x1E5CD90C6EC2440Dull,
};
static const uint64_t Crc64XzTable4[256] = {
    0x0000000000000000ull, 0x5C2D776033C4205Eull, 0xB85AEEC0678840BCull, 0xE47799A0544C60E2ull,
    0xE26D72AB601E9FFDull, 0xBE4005CB53DABFA3ull, 0x5A379C6B0796DF41ull, 0x061AEB0B3452FF1Full,
    0x56024A7D6F33217Full, 0x0A2F3D1D5CF70121ull, 0xEE58A4BD08BB61C3ull, 0xB275D3DD3B7F419Dull,
    0xB46F38D60F2DBE82ull, 0xE8424FB63CE99EDCull, 0x0C35D61668A5FE3Eull, 0x5018A1765B61DE60ull,
    0xAC0494FADE6642FEull, 0xF029E39AEDA262A0ull, 0x145E7A3AB9EE0242ull, 0x48730D5A8A2A221Cull,
    0x4E69E651BE78DD03ull, 0x124491318DBCFD5Dull, 0xF6330891D9F09DBFull, 0xAA1E7FF1EA34BDE1ull,
    0xFA06DE87B1556381ull, 0xA62BA9E7829143DFull, 0x425C3047D6DD233Dull, 0x1E714727E5190363ull,
    0x186BAC2CD14BFC7Cull, 0x4446DB4CE28FDC22ull, 0xA03142ECB6C3BCC0ull, 0xFC1C358C85079C9Eull,
    0xCAD186DE13C29B79ull, 0x96FCF1BE2006BB27ull, 0x728B681E744ADBC5ull, 0x2EA61F7E478EFB9Bull,
    0x28BCF47573DC0484ull, 0x74918315401824DAull, 0x90E61AB514544438ull, 0xCCCB6DD527906466ull,
    0x9CD3CCA37CF1BA06ull, 0xC0FEBBC34F359A58ull, 0x248922631B79FABAull, 0x78A4550328BDDAE4ull,
    0x7EBEBE081CEF25FBull, 0x2293C9682F2B05A5ull, 0xC6E450C87B676547ull, 0x9AC927A848A34519ull,
    0x66D51224CDA4D987ull, 0x3AF86544FE60F9D9ull, 0xDE8FFCE4AA2C993Bull, 0x82A28B8499E8B965ull,
    0x84B8608FADBA467Aull, 0xD89517EF9E7E6624ull, 0x3CE28E4FCA3206C6ull, 0x60CFF92FF9F62698ull,
    0x30D75859A297F8F8ull, 0x6CFA2F399153D8A6ull, 0x888DB699C51FB844ull, 0xD4A0C1F9F6DB981Aull,
    0xD2BA2AF2C2896705ull, 0x8E975D92F14D475Bull, 0x6AE0C432A50127B9ull, 0x36CDB35296C507E7ull,
    0x077BA297888B2877ull, 0x5B56D5F7BB4F0829ull, 0xBF214C57EF0368CBull, 0xE30C3B37DCC74895ull,
    0xE516D03CE895B78Aull, 0xB93BA75CDB5197D4ull, 0x5D4C3EFC8F1DF736ull, 0x0161499CBCD9D768ull,
    0x5179E8EAE7B80908ull, 0x0D549F8AD47C2956ull, 0xE923062A803049B4ull, 0xB50E714AB3F469EAull,
    0xB3149A4187A696F5ull, 0xEF39ED21B462B6ABull, 0x0B4E7481E02ED649ull, 0x576303E1D3EAF617ull,
    0xAB7F366D56ED6A89ull, 0xF752410D65294AD7ull, 0x1325D8AD31652A35ull, 0x4F08AFCD02A10A6Bull,
    0x491244C636F3F574ull, 0x153F33A60537D52Aull, 0xF148AA06517BB5C8ull, 0xAD65DD6662BF9596ull,
    0xFD7D7C1039DE4BF6ull, 0xA1500B700A1A6BA8ull, 0x452792D05E560B4Aull, 0x190AE5B06D922B14ull,
    0x1F100EBB59C0D40Bull, 0x433D79DB6A04F455ull, 0xA74AE07B3E4894B7ull, 0xFB67971B0D8CB4E9ull,
    0xCDAA24499B49B30Eull, 0x91875329A88D9350ull, 0x75F0CA89FCC1F3B2ull, 0x29DDBDE9CF05D3ECull,
    0x2FC756E2FB572CF3ull, 0x73EA2182C8930CADull, 0x979DB8229CDF6C4Full, 0xCBB0CF42AF1B4C11ull,
    0x9BA86E34F47A9271ull, 0xC7851954C7BEB22Full, 0x23F280F493F2D2CDull, 0x7FDFF794A036F293ull,
    0x79C51C9F94640D8Cull, 0x25E86BFFA7A02DD2ull, 0xC19FF25FF3EC4D30ull, 0x9DB2853FC0286D6Eull,
    0x61AEB0B3452FF1F0ull, 0x3D83C7D376EBD1AEull, 0xD9F45E7322A7B14Cull, 0x85D9291311639112ull,
    0x83C3C21825316E0Dull, 0xDFEEB57816F54E53ull, 0x3B992CD842B92EB1ull, 0x67B45BB8717D0EEFull,
    0x37ACFACE2A1CD08Full, 0x6B818DAE19D8F0D1ull, 0x8FF6140E4D949033ull, 0xD3DB636E7E50B06Dull,
    0xD5C188654A024F72ull, 0x89ECFF0579C66F2Cull, 0x6D9B66A52D8A0FCEull, 0x31B611C51E4E2F90ull,
    0x0EF7452F111650EEull, 0x52DA324F22D270B0ull, 0xB6ADABEF769E1052ull, 0xEA80DC8F455A300Cull,
    0xEC9A37847108CF13ull, 0xB0B740E442CCEF4Dull, 0x54C0D94416808FAFull, 0x08EDAE242544AFF1ull,
    0x58F50F527E257191ull, 0x04D878324DE151CFull, 0xE0AFE19219AD312Dull, 0xBC8296F22A691173ull,
    0xBA987DF91E3BEE6Cull, 0xE6B50A992DFFCE32ull, 0x02C2933979B3AED0ull, 0x5EEFE4594A778E8Eull,
    0xA2F3D1D5CF701210ull, 0xFEDEA6B5FCB4324Eull, 0x1AA93F15A8F852ACull, 0x468448759B3C72F2ull,
    0x409EA37EAF6E8DEDull, 0x1CB3D41E9CAAADB3ull, 0xF8C44DBEC8E6CD51ull, 0xA4E93ADEFB22ED0Full,
    0xF4F19BA8A043336Full, 0xA8DCECC893871331ull, 0x4CAB7568C7CB73D3ull, 0x10860208F40F538Dull,
    0x169CE903C05DAC92ull, 0x4AB19E63F3998CCCull, 0xAEC607C3A7D5EC2Eull, 0xF2EB70A39411CC70ull,
    0xC426C3F102D4CB97ull, 0x980BB4913110EBC9ull, 0x7C7C2D31655C8B2Bull, 0x20515A515698AB75ull,
    0x264BB15A62CA546Aull, 0x7A66C63A510E7434ull, 0x9E115F9A054214D6ull, 0xC23C28FA36863488ull,
    0x9224898C6DE7EAE8ull, 0xCE09FEEC5E23CAB6ull, 0x2A7E674C0A6FAA54ull, 0x7653102C39AB8A0Aull,
    0x7049FB270DF97515ull, 0x2C648C473E3D554Bull, 0xC81315E76A7135A9ull, 0x943E628759B515F7ull,
    0x6822570BDCB28969ull, 0x340F206BEF76A937ull, 0xD078B9CBBB3AC9D5ull, 0x8C55CEAB88FEE98Bull,
    0x8A4F25A0BCAC1694ull, 0xD66252C08F6836CAull, 0x3215CB60DB245628ull, 0x6E38BC00E8E07676ull,
    0x3E201D76B381A816ull, 0x620D6A1680458848ull, 0x867AF3B6D409E8AAull, 0xDA5784D6E7CDC8F4ull,
    0xDC4D6FDDD39F37EBull, 0x806018BDE05B17B5ull, 0x6417811DB4177757ull, 0x383AF67D87D35709ull,
    0x098CE7B8999D7899ull, 0x55A190D8AA5958C7ull, 0xB1D60978FE153825ull, 0xEDFB7E18CDD1187Bull,
    0xEBE19513F983E764ull, 0xB7CCE273CA47C73Aull, 0x53BB7BD39E0BA7D8ull, 0x0F960CB3ADCF8786ull,
    0x5F8EADC5F6AE59E6ull, 0x03A3DAA5C56A79B8ull, 0xE7D443059126195Aull, 0xBBF93465A2E23904ull,
    0xBDE3DF6E96B0C61Bull, 0xE1CEA80EA574E645ull, 0x05B931AEF13886A7ull, 0x599446CEC2FCA6F9ull,
    0xA588734247FB3A67ull, 0xF9A50422743F1A39ull, 0x1DD29D8220737ADBull, 0x41FFEAE213B75A85ull,
    0x47E501E927E5A59Aull, 0x1BC87689142185C4ull, 0xFFBFEF29406DE526ull, 0xA392984973A9C578ull,
    0xF38A393F28C81B18ull, 0xAFA74E5F1B0C3B46ull, 0x4BD0D7FF4F405BA4ull, 0x17FDA09F7C847BFAull,
    0x11E74B9448D684E5ull, 0x4DCA3CF47B12A4BBull, 0xA9BDA5542F5EC459ull, 0xF590D2341C9AE407ull,
    0xC35D61668A5FE3E0ull, 0x9F701606B99BC3BEull, 0x7B078FA6EDD7A35Cull, 0x272AF8C6DE138302ull,
    0x213013CDEA417C1Dull, 0x7D1D64ADD9855C43ull, 0x996AFD0D8DC93CA1ull, 0xC5478A6DBE0D1CFFull,
    0x955F2B1BE56CC29Full, 0xC9725C7BD6A8E2C1ull, 0x2D05C5DB82E48223ull, 0x7128B2BBB120A27Dull,
    0x773259B085725D62ull, 0x2B1F2ED0B6B67D3Cull, 0xCF68B770E2FA1DDEull, 0x9345C010D13E3D80ull,
    0x6F59F59C5439A11Eull, 0x337482FC67FD8140ull, 0xD7031B5C33B1E1A2ull, 0x8B2E6C3C0075C1FCull,
    0x8D34873734273EE3ull, 0xD119F05707E31EBDull, 0x356E69F753AF7E5Full, 0x69431E97606B5E01ull,
    0x395BBFE13B0A8061ull, 0x6576C88108CEA03Full, 0x810151215C82C0DDull, 0xDD2C26416F46E083ull,
    0xDB36CD4A5B141F9Cull, 0x871BBA2A68D03FC2ull, 0x636C238A3C9C5F20ull, 0x3F4154EA0F587F7Eull,
};
static const uint64_t Crc64XzTable5[256] = {
    0x0000000000000000ull, 0x6184D55F721267C6ull, 0xC309AABEE424CF8Cull, 0xA28D7FE19636A84Aull,
    0x14CBFA566747819Dull, 0x754F2F091555E65Bull, 0xD7C250E883634E11ull, 0xB64685B7F17129D7ull,
    0x2997F4ACCE8F033Aull, 0x481321F3BC9D64FCull, 0xEA9E5E122AABCCB6ull, 0x8B1A8B4D58B9AB70ull,
    0x3D5C0EFAA9C882A7ull, 0x5CD8DBA5DBDAE561ull, 0xFE55A4444DEC4D2Bull, 0x9FD1711B3FFE2AEDull,
    0x532FE9599D1E0674ull, 0x32AB3C06EF0C61B2ull, 0x902643E7793AC9F8ull, 0xF1A296B80B28AE3Eull,
    0x47E4130FFA5987E9ull, 0x2660C650884BE02Full, 0x84EDB9B11E7D4865ull, 0xE5696CEE6C6F2FA3ull,
    0x7AB81DF55391054Eull, 0x1B3CC8AA21836288ull, 0xB9B1B74BB7B5CAC2ull, 0xD8356214C5A7AD04ull,
    0x6E73E7A334D684D3ull, 0x0FF732FC46C4E315ull, 0xAD7A4D1DD0F24B5Full, 0xCCFE9842A2E02C99ull,
    0xA65FD2B33A3C0CE8ull, 0xC7DB07EC482E6B2Eull, 0x6556780DDE18C364ull, 0x04D2AD52AC0AA4A2ull,
    0xB29428E55D7B8D75ull, 0xD310FDBA2F69EAB3ull, 0x719D825BB95F42F9ull, 0x10195704CB4D253Full,
    0x8FC8261FF4B30FD2ull, 0xEE4CF34086A16814ull, 0x4CC18CA11097C05Eull, 0x2D4559FE6285A798ull,
    0x9B03DC4993F48E4Full, 0xFA870916E1E6E989ull, 0x580A76F777D041C3ull, 0x398EA3A805C22605ull,
    0xF5703BEAA7220A9Cull, 0x94F4EEB5D5306D5Aull, 0x367991544306C510ull, 0x57FD440B3114A2D6ull,
    0xE1BBC1BCC0658B01ull, 0x803F14E3B277ECC7ull, 0x22B26B022441448Dull, 0x4336BE5D5653234Bull,
    0xDCE7CF4669AD09A6ull, 0xBD631A191BBF6E60ull, 0x1FEE65F88D89C62Aull, 0x7E6AB0A7FF9BA1ECull,
    0xC82C35100EEA883Bull, 0xA9A8E04F7CF8EFFDull, 0x0B259FAEEACE47B7ull, 0x6AA14AF198DC2071ull,
    0xDE670A4DDB760755ull, 0xBFE3DF12A9646093ull, 0x1D6EA0F33F52C8D9ull, 0x7CEA75AC4D40AF1Full,
    0xCAACF01BBC3186C8ull, 0xAB282544CE23E10Eull, 0x09A55AA558154944ull, 0x68218FFA2A072E82ull,
    0xF7F0FEE115F9046Full, 0x96742BBE67EB63A9ull, 0x34F9545FF1DDCBE3ull, 0x557D810083CFAC25ull,
    0xE33B04B772BE85F2ull, 0x82BFD1E800ACE234ull, 0x2032AE09969A4A7Eull, 0x41B67B56E4882DB8ull,
    0x8D48E31446680121ull, 0xECCC364B347A66E7ull, 0x4E4149AAA24CCEADull, 0x2FC59CF5D05EA96Bull,
    0x99831942212F80BCull, 0xF807CC1D533DE77Aull, 0x5A8AB3FCC50B4F30ull, 0x3B0E66A3B71928F6ull,
    0xA4DF17B888E7021Bull, 0xC55BC2E7FAF565DDull, 0x67D6BD066CC3CD97ull, 0x065268591ED1AA51ull,
    0xB014EDEEEFA08386ull, 0xD19038B19DB2E440ull, 0x731D47500B844C0Aull, 0x1299920F79962BCCull,
    0x7838D8FEE14A0BBDull, 0x19BC0DA193586C7Bull, 0xBB317240056EC431ull, 0xDAB5A71F777CA3F7ull,
    0x6CF322A8860D8A20ull, 0x0D77F7F7F41FEDE6ull, 0xAFFA8816622945ACull, 0xCE7E5D49103B226Aull,
    0x51AF2C522FC50887ull, 0x302BF90D5DD76F41ull, 0x92A686ECCBE1C70Bull, 0xF32253B3B9F3A0CDull,
    0x4564D6044882891Aull, 0x24E0035B3A90EEDCull, 0x866D7CBAACA64696ull, 0xE7E9A9E5DEB42150ull,
    0x2B1731A77C540DC9ull, 0x4A93E4F80E466A0Full, 0xE81E9B199870C245ull, 0x899A4E46EA62A583ull,
    0x3FDCCBF11B138C54ull, 0x5E581EAE6901EB92ull, 0xFCD5614FFF3743D8ull, 0x9D51B4108D25241Eull,
    0x0280C50BB2DB0EF3ull, 0x63041054C0C96935ull, 0xC1896FB556FFC17Full, 0xA00DBAEA24EDA6B9ull,
    0x164B3F5DD59C8F6Eull, 0x77CFEA02A78EE8A8ull, 0xD54295E331B840E2ull, 0xB4C640BC43AA2724ull,
    0x2E16BBB019E2102Full, 0x4F926EEF6BF077E9ull, 0xED1F110EFDC6DFA3ull, 0x8C9BC4518FD4B865ull,
    0x3ADD41E67EA591B2ull, 0x5B5994B90CB7F674ull, 0xF9D4EB589A815E3Eull, 0x98503E07E89339F8ull,
    0x07814F1CD76D1315ull, 0x66059A43A57F74D3ull, 0xC488E5A23349DC99ull, 0xA50C30FD415BBB5Full,
    0x134AB54AB02A9288ull, 0x72CE6015C238F54Eull, 0xD0431FF4540E5D04ull, 0xB1C7CAAB261C3AC2ull,
    0x7D3952E984FC165Bull, 0x1CBD87B6F6EE719Dull, 0xBE30F85760D8D9D7ull, 0xDFB42D0812CABE11ull,
    0x69F2A8BFE3BB97C6ull, 0x08767DE091A9F000ull, 0xAAFB0201079F584Aull, 0xCB7FD75E758D3F8Cull,
    0x54AEA6454A731561ull, 0x352A731A386172A7ull, 0x97A70CFBAE57DAEDull, 0xF623D9A4DC45BD2Bull,
    0x40655C132D3494FCull, 0x21E1894C5F26F33Aull, 0x836CF6ADC9105B70ull, 0xE2E823F2BB023CB6ull,
    0x8849690323DE1CC7ull, 0xE9CDBC5C51CC7B01ull, 0x4B40C3BDC7FAD34Bull, 0x2AC416E2B5E8B48Dull,
    0x9C82935544999D5Aull, 0xFD06460A368BFA9Cull, 0x5F8B39EBA0BD52D6ull, 0x3E0FECB4D2AF3510ull,
    0xA1DE9DAFED511FFDull, 0xC05A48F09F43783Bull, 0x62D737110975D071ull, 0x0353E24E7B67B7B7ull,
    0xB51567F98A169E60ull, 0xD491B2A6F804F9A6ull, 0x761CCD476E3251ECull, 0x179818181C20362Aull,
    0xDB66805ABEC01AB3ull, 0xBAE25505CCD27D75ull, 0x186F2AE45AE4D53Full, 0x79EBFFBB28F6B2F9ull,
    0xCFAD7A0CD9879B2Eull, 0xAE29AF53AB95FCE8ull, 0x0CA4D0B23DA354A2ull, 0x6D2005ED4FB13364ull,
    0xF2F174F6704F1989ull, 0x9375A1A9025D7E4Full, 0x31F8DE48946BD605ull, 0x507C0B17E679B1C3ull,
    0xE63A8EA017089814ull, 0x87BE5BFF651AFFD2ull, 0x2533241EF32C5798ull, 0x44B7F141813E305Eull,
    0xF071B1FDC294177Aull, 0x91F564A2B08670BCull, 0x33781B4326B0D8F6ull, 0x52FCCE1C54A2BF30ull,
    0xE4BA4BABA5D396E7ull, 0x853E9EF4D7C1F121ull, 0x27B3E11541F7596Bull, 0x4637344A33E53EADull,
    0xD9E645510C1B1440ull, 0xB862900E7E097386ull, 0x1AEFEFEFE83FDBCCull, 0x7B6B3AB09A2DBC0Aull,
    0xCD2DBF076B5C95DDull, 0xACA96A58194EF21Bull, 0x0E2415B98F785A51ull, 0x6FA0C0E6FD6A3D97ull,
    0xA35E58A45F8A110Eull, 0xC2DA8DFB2D9876C8ull, 0x6057F21ABBAEDE82ull, 0x01D32745C9BCB944ull,
    0xB795A2F238CD9093ull, 0xD61177AD4ADFF755ull, 0x749C084CDCE95F1Full, 0x1518DD13AEFB38D9ull,
    0x8AC9AC0891051234ull, 0xEB4D7957E31775F2ull, 0x49C006B67521DDB8ull, 0x2844D3E90733BA7Eull,
    0x9E02565EF64293A9ull, 0xFF8683018450F46Full, 0x5D0BFCE012665C25ull, 0x3C8F29BF60743BE3ull,
    0x562E634EF8A81B92ull, 0x37AAB6118ABA7C54ull, 0x9527C9F01C8CD41Eull, 0xF4A31CAF6E9EB3D8ull,
    0x42E599189FEF9A0Full, 0x23614C47EDFDFDC9ull, 0x81EC33A67BCB5583ull, 0xE068E6F909D93245ull,
    0x7FB997E2362718A8ull, 0x1E3D42BD44357F6Eull, 0xBCB03D5CD203D724ull, 0xDD34E803A011B0E2ull,
    0x6B726DB451609935ull, 0x0AF6B8EB2372FEF3ull, 0xA87BC70AB54456B9ull, 0xC9FF1255C756317Full,
    0x05018A1765B61DE6ull, 0x64855F4817A47A20ull, 0xC60820A98192D26Aull, 0xA78CF5F6F380B5ACull,
    0x11CA704102F19C7Bull, 0x704EA51E70E3FBBDull, 0xD2C3DAFFE6D553F7ull, 0xB3470FA094C73431ull,
    0x2C967EBBAB391EDCull, 0x4D12ABE4D92B791Aull, 0xEF9FD4054F1DD150ull, 0x8E1B015A3D0FB696ull,
    0x385D84EDCC7E9F41ull, 0x59D951B2BE6CF887ull, 0xFB542E53285A50CDull, 0x9AD0FB0C5A48370Bull,
};
static const uint64_t Crc64XzTable6[256] = {
    0x0000000000000000ull, 0x22EF0D5934F964ECull, 0x45DE1AB269F2C9D8ull, 0x673117EB5D0BAD34ull,
    0x8BBC3564D3E593B0ull, 0xA953383DE71CF75Cull, 0xCE622FD6BA175A68ull, 0xEC8D228F8EEE3E84ull,
    0x85A0C5E208C539E5ull, 0xA74FC8BB3C3C5D09ull, 0xC07EDF506137F03Dull, 0xE291D20955CE94D1ull,
    0x0E1CF086DB20AA55ull, 0x2CF3FDDFEFD9CEB9ull, 0x4BC2EA34B2D2638Dull, 0x692DE76D862B0761ull,
    0x999924EFBE846D4Full, 0xBB7629B68A7D09A3ull, 0xDC473E5DD776A497ull, 0xFEA83304E38FC07Bull,
    0x1225118B6D61FEFFull, 0x30CA1CD259989A13ull, 0x57FB0B3904933727ull, 0x75140660306A53CBull,
    0x1C39E10DB64154AAull, 0x3ED6EC5482B83046ull, 0x59E7FBBFDFB39D72ull, 0x7B08F6E6EB4AF99Eull,
    0x9785D46965A4C71Aull, 0xB56AD930515DA3F6ull, 0xD25BCEDB0C560EC2ull, 0xF0B4C38238AF6A2Eull,
    0xA1EAE6F4D206C41Bull, 0x8305EBADE6FFA0F7ull, 0xE434FC46BBF40DC3ull, 0xC6DBF11F8F0D692Full,
    0x2A56D39001E357ABull, 0x08B9DEC9351A3347ull, 0x6F88C92268119E73ull, 0x4D67C47B5CE8FA9Full,
    0x244A2316DAC3FDFEull, 0x06A52E4FEE3A9912ull, 0x619439A4B3313426ull, 0x437B34FD87C850CAull,
    0xAFF6167209266E4Eull, 0x8D191B2B3DDF0AA2ull, 0xEA280CC060D4A796ull, 0xC8C70199542DC37Aull,
    0x3873C21B6C82A954ull, 0x1A9CCF42587BCDB8ull, 0x7DADD8A90570608Cull, 0x5F42D5F031890460ull,
    0xB3CFF77FBF673AE4ull, 0x9120FA268B9E5E08ull, 0xF611EDCDD695F33Cull, 0xD4FEE094E26C97D0ull,
    0xBDD307F9644790B1ull, 0x9F3C0AA050BEF45Dull, 0xF80D1D4B0DB55969ull, 0xDAE21012394C3D85ull,
    0x366F329DB7A20301ull, 0x14803FC4835B67EDull, 0x73B1282FDE50CAD9ull, 0x515E2576EAA9AE35ull,
    0xD10D62C20B0396B3ull, 0xF3E26F9B3FFAF25Full, 0x94D3787062F15F6Bull, 0xB63C752956083B87ull,
    0x5AB157A6D8E60503ull, 0x785E5AFFEC1F61EFull, 0x1F6F4D14B114CCDBull, 0x3D80404D85EDA837ull,
    0x54ADA72003C6AF56ull, 0x7642AA79373FCBBAull, 0x1173BD926A34668Eull, 0x339CB0CB5ECD0262ull,
    0xDF119244D0233CE6ull, 0xFDFE9F1DE4DA580Aull, 0x9ACF88F6B9D1F53Eull, 0xB82085AF8D2891D2ull,
    0x4894462DB587FBFCull, 0x6A7B4B74817E9F10ull, 0x0D4A5C9FDC753224ull, 0x2FA551C6E88C56C8ull,
    0xC32873496662684Cull, 0xE1C77E10529B0CA0ull, 0x86F669FB0F90A194ull, 0xA41964A23B69C578ull,
    0xCD3483CFBD42C219ull, 0xEFDB8E9689BBA6F5ull, 0x88EA997DD4B00BC1ull, 0xAA059424E0496F2Dull,
    0x4688B6AB6EA751A9ull, 0x6467BBF25A5E3545ull, 0x0356AC1907559871ull, 0x21B9A14033ACFC9Dull,
    0x70E78436D90552A8ull, 0x5208896FEDFC3644ull, 0x35399E84B0F79B70ull, 0x17D693DD840EFF9Cull,
    0xFB5BB1520AE0C118ull, 0xD9B4BC0B3E19A5F4ull, 0xBE85ABE0631208C0ull, 0x9C6AA6B957EB6C2Cull,
    0xF54741D4D1C06B4Dull, 0xD7A84C8DE5390FA1ull, 0xB0995B66B832A295ull, 0x9276563F8CCBC679ull,
    0x7EFB74B00225F8FDull, 0x5C1479E936DC9C11ull, 0x3B256E026BD73125ull, 0x19CA635B5F2E55C9ull,
    0xE97EA0D967813FE7ull, 0xCB91AD8053785B0Bull, 0xACA0BA6B0E73F63Full, 0x8E4FB7323A8A92D3ull,
    0x62C295BDB464AC57ull, 0x402D98E4809DC8BBull, 0x271C8F0FDD96658Full, 0x05F38256E96F0163ull,
    0x6CDE653B6F440602ull, 0x4E3168625BBD62EEull, 0x29007F8906B6CFDAull, 0x0BEF72D0324FAB36ull,
    0xE762505FBCA195B2ull, 0xC58D5D068858F15Eull, 0xA2BC4AEDD5535C6Aull, 0x805347B4E1AA3886ull,
    0x30C26AAFB90933E3ull, 0x122D67F68DF0570Full, 0x751C701DD0FBFA3Bull, 0x57F37D44E4029ED7ull,
    0xBB7E5FCB6AECA053ull, 0x999152925E15C4BFull, 0xFEA04579031E698Bull, 0xDC4F482037E70D67ull,
    0xB562AF4DB1CC0A06ull, 0x978DA21485356EEAull, 0xF0BCB5FFD83EC3DEull, 0xD253B8A6ECC7A732ull,
    0x3EDE9A29622999B6ull, 0x1C31977056D0FD5Aull, 0x7B00809B0BDB506Eull, 0x59EF8DC23F223482ull,
    0xA95B4E40078D5EACull, 0x8BB4431933743A40ull, 0xEC8554F26E7F9774ull, 0xCE6A59AB5A86F398ull,
    0x22E77B24D468CD1Cull, 0x0008767DE091A9F0ull, 0x67396196BD9A04C4ull, 0x45D66CCF89636028ull,
    0x2CFB8BA20F486749ull, 0x0E1486FB3BB103A5ull, 0x6925911066BAAE91ull, 0x4BCA9C495243CA7Dull,
    0xA747BEC6DCADF4F9ull, 0x85A8B39FE8549015ull, 0xE299A474B55F3D21ull, 0xC076A92D81A659CDull,
    0x91288C5B6B0FF7F8ull, 0xB3C781025FF69314ull, 0xD4F696E902FD3E20ull, 0xF6199BB036045ACCull,
    0x1A94B93FB8EA6448ull, 0x387BB4668C1300A4ull, 0x5F4AA38DD118AD90ull, 0x7DA5AED4E5E1C97Cull,
    0x148849B963CACE1Dull, 0x366744E05733AAF1ull, 0x5156530B0A3807C5ull, 0x73B95E523EC16329ull,
    0x9F347CDDB02F5DADull, 0xBDDB718484D63941ull, 0xDAEA666FD9DD9475ull, 0xF8056B36ED24F099ull,
    0x08B1A8B4D58B9AB7ull, 0x2A5EA5EDE172FE5Bull, 0x4D6FB206BC79536Full, 0x6F80BF5F88803783ull,
    0x830D9DD0066E0907ull, 0xA1E2908932976DEBull, 0xC6D387626F9CC0DFull, 0xE43C8A3B5B65A433ull,
    0x8D116D56DD4EA352ull, 0xAFFE600FE9B7C7BEull, 0xC8CF77E4B4BC6A8Aull, 0xEA207ABD80450E66ull,
    0x06AD58320EAB30E2ull, 0x2442556B3A52540Eull, 0x437342806759F93Aull, 0x619C4FD953A09DD6ull,
    0xE1CF086DB20AA550ull, 0xC320053486F3C1BCull, 0xA41112DFDBF86C88ull, 0x86FE1F86EF010864ull,
    0x6A733D0961EF36E0ull, 0x489C30505516520Cull, 0x2FAD27BB081DFF38ull, 0x0D422AE23CE49BD4ull,
    0x646FCD8FBACF9CB5ull, 0x4680C0D68E36F859ull, 0x21B1D73DD33D556Dull, 0x035EDA64E7C43181ull,
    0xEFD3F8EB692A0F05ull, 0xCD3CF5B25DD36BE9ull, 0xAA0DE25900D8C6DDull, 0x88E2EF003421A231ull,
    0x78562C820C8EC81Full, 0x5AB921DB3877ACF3ull, 0x3D883630657C01C7ull, 0x1F673B695185652Bull,
    0xF3EA19E6DF6B5BAFull, 0xD10514BFEB923F43ull, 0xB6340354B6999277ull, 0x94DB0E0D8260F69Bull,
    0xFDF6E960044BF1FAull, 0xDF19E43930B29516ull, 0xB828F3D26DB93822ull, 0x9AC7FE8B59405CCEull,
    0x764ADC04D7AE624Aull, 0x54A5D15DE35706A6ull, 0x3394C6B6BE5CAB92ull, 0x117BCBEF8AA5CF7Eull,
    0x4025EE99600C614Bull, 0x62CAE3C054F505A7ull, 0x05FBF42B09FEA893ull, 0x2714F9723D07CC7Full,
    0xCB99DBFDB3E9F2FBull, 0xE976D6A487109617ull, 0x8E47C14FDA1B3B23ull, 0xACA8CC16EEE25FCFull,
    0xC5852B7B68C958AEull, 0xE76A26225C303C42ull, 0x805B31C9013B9176ull, 0xA2B43C9035C2F59Aull,
    0x4E391E1FBB2CCB1Eull, 0x6CD613468FD5AFF2ull, 0x0BE704ADD2DE02C6ull, 0x290809F4E627662Aull,
    0xD9BCCA76DE880C04ull, 0xFB53C72FEA7168E8ull, 0x9C62D0C4B77AC5DCull, 0xBE8DDD9D8383A130ull,
    0x5200FF120D6D9FB4ull, 0x70EFF24B3994FB58ull, 0x17DEE5A0649F566Cull, 0x3531E8F950663280ull,
    0x5C1C0F94D64D35E1ull, 0x7EF302CDE2B4510Dull, 0x19C21526BFBFFC39ull, 0x3B2D187F8B4698D5ull,
    0xD7A03AF005A8A651ull, 0xF54F37A93151C2BDull, 0x927E20426C5A6F89ull, 0xB0912D1B58A30B65ull,
};
static const uint64_t Crc64XzTable7[256] = {
    0x0000000000000000ull, 0xDABE95AFC7875F40ull, 0x27A584742000A005ull, 0xFD1B11DBE787FF45ull,
    0x4F4B08E84001400Aull, 0x95F59D4787861F4Aull, 0x68EE8C9C6001E00Full, 0xB2501933A786BF4Full,
    0x9E9611D080028014ull, 0x4428847F4785DF54ull, 0xB93395A4A0022011ull, 0x638D000B67857F51ull,
    0xD1DD1938C003C01Eull, 0x0B638C9707849F5Eull, 0xF6789D4CE003601Bull, 0x2CC608E327843F5Bull,
    0xAFF48C8AAF0B1EADull, 0x754A1925688C41EDull, 0x885108FE8F0BBEA8ull, 0x52EF9D51488CE1E8ull,
    0xE0BF8462EF0A5EA7ull, 0x3A0111CD288D01E7ull, 0xC71A0016CF0AFEA2ull, 0x1DA495B9088DA1E2ull,
    0x31629D5A2F099EB9ull, 0xEBDC08F5E88EC1F9ull, 0x16C7192E0F093EBCull, 0xCC798C81C88E61FCull,
    0x7E2995B26F08DEB3ull, 0xA497001DA88F81F3ull, 0x598C11C64F087EB6ull, 0x83328469888F21F6ull,
    0xCD31B63EF11823DFull, 0x178F2391369F7C9Full, 0xEA94324AD11883DAull, 0x302AA7E5169FDC9Aull,
    0x827ABED6B11963D5ull, 0x58C42B79769E3C95ull, 0xA5DF3AA29119C3D0ull, 0x7F61AF0D569E9C90ull,
    0x53A7A7EE711AA3CBull, 0x89193241B69DFC8Bull, 0x7402239A511A03CEull, 0xAEBCB635969D5C8Eull,
    0x1CECAF06311BE3C1ull, 0xC6523AA9F69CBC81ull, 0x3B492B72111B43C4ull, 0xE1F7BEDDD69C1C84ull,
    0x62C53AB45E133D72ull, 0xB87BAF1B99946232ull, 0x4560BEC07E139D77ull, 0x9FDE2B6FB994C237ull,
    0x2D8E325C1E127D78ull, 0xF730A7F3D9952238ull, 0x0A2BB6283E12DD7Dull, 0xD0952387F995823Dull,
    0xFC532B64DE11BD66ull, 0x26EDBECB1996E226ull, 0xDBF6AF10FE111D63ull, 0x01483ABF39964223ull,
    0xB318238C9E10FD6Cull, 0x69A6B6235997A22Cull, 0x94BDA7F8BE105D69ull, 0x4E03325779970229ull,
    0x08BBC3564D3E593Bull, 0xD20556F98AB9067Bull, 0x2F1E47226D3EF93Eull, 0xF5A0D28DAAB9A67Eull,
    0x47F0CBBE0D3F1931ull, 0x9D4E5E11CAB84671ull, 0x60554FCA2D3FB934ull, 0xBAEBDA65EAB8E674ull,
    0x962DD286CD3CD92Full, 0x4C9347290ABB866Full, 0xB18856F2ED3C792Aull, 0x6B36C35D2ABB266Aull,
    0xD966DA6E8D3D9925ull, 0x03D84FC14ABAC665ull, 0xFEC35E1AAD3D3920ull, 0x247DCBB56ABA6660ull,
    0xA74F4FDCE2354796ull, 0x7DF1DA7325B218D6ull, 0x80EACBA8C235E793ull, 0x5A545E0705B2B8D3ull,
    0xE8044734A234079Cull, 0x32BAD29B65B358DCull, 0xCFA1C3408234A799ull, 0x151F56EF45B3F8D9ull,
    0x39D95E0C6237C782ull, 0xE367CBA3A5B098C2ull, 0x1E7CDA7842376787ull, 0xC4C24FD785B038C7ull,
    0x769256E422368788ull, 0xAC2CC34BE5B1D8C8ull, 0x5137D2900236278Dull, 0x8B89473FC5B178CDull,
    0xC58A7568BC267AE4ull, 0x1F34E0C77BA125A4ull, 0xE22FF11C9C26DAE1ull, 0x389164B35BA185A1ull,
    0x8AC17D80FC273AEEull, 0x507FE82F3BA065AEull, 0xAD64F9F4DC279AEBull, 0x77DA6C5B1BA0C5ABull,
    0x5B1C64B83C24FAF0ull, 0x81A2F117FBA3A5B0ull, 0x7CB9E0CC1C245AF5ull, 0xA6077563DBA305B5ull,
    0x14576C507C25BAFAull, 0xCEE9F9FFBBA2E5BAull, 0x33F2E8245C251AFFull, 0xE94C7D8B9BA245BFull,
    0x6A7EF9E2132D6449ull, 0xB0C06C4DD4AA3B09ull, 0x4DDB7D96332DC44Cull, 0x9765E839F4AA9B0Cull,
    0x2535F10A532C2443ull, 0xFF8B64A594AB7B03ull, 0x0290757E732C8446ull, 0xD82EE0D1B4ABDB06ull,
    0xF4E8E832932FE45Dull, 0x2E567D9D54A8BB1Dull, 0xD34D6C46B32F4458ull, 0x09F3F9E974A81B18ull,
    0xBBA3E0DAD32EA457ull, 0x611D757514A9FB17ull, 0x9C0664AEF32E0452ull, 0x46B8F10134A95B12ull,
    0x117786AC9A7CB276ull, 0xCBC913035DFBED36ull, 0x36D202D8BA7C1273ull, 0xEC6C97777DFB4D33ull,
    0x5E3C8E44DA7DF27Cull, 0x84821BEB1DFAAD3Cull, 0x79990A30FA7D5279ull, 0xA3279F9F3DFA0D39ull,
    0x8FE1977C1A7E3262ull, 0x555F02D3DDF96D22ull, 0xA84413083A7E9267ull, 0x72FA86A7FDF9CD27ull,
    0xC0AA9F945A7F7268ull, 0x1A140A3B9DF82D28ull, 0xE70F1BE07A7FD26Dull, 0x3DB18E4FBDF88D2Dull,
    0xBE830A263577ACDBull, 0x643D9F89F2F0F39Bull, 0x99268E5215770CDEull, 0x43981BFDD2F0539Eull,
    0xF1C802CE7576ECD1ull, 0x2B769761B2F1B391ull, 0xD66D86BA55764CD4ull, 0x0CD3131592F11394ull,
    0x20151BF6B5752CCFull, 0xFAAB8E5972F2738Full, 0x07B09F8295758CCAull, 0xDD0E0A2D52F2D38Aull,
    0x6F5E131EF5746CC5ull, 0xB5E086B132F33385ull, 0x48FB976AD574CCC0ull, 0x924502C512F39380ull,
    0xDC4630926B6491A9ull, 0x06F8A53DACE3CEE9ull, 0xFBE3B4E64B6431ACull, 0x215D21498CE36EECull,
    0x930D387A2B65D1A3ull, 0x49B3ADD5ECE28EE3ull, 0xB4A8BC0E0B6571A6ull, 0x6E1629A1CCE22EE6ull,
    0x42D02142EB6611BDull, 0x986EB4ED2CE14EFDull, 0x6575A536CB66B1B8ull, 0xBFCB30990CE1EEF8ull,
    0x0D9B29AAAB6751B7ull, 0xD725BC056CE00EF7ull, 0x2A3EADDE8B67F1B2ull, 0xF08038714CE0AEF2ull,
    0x73B2BC18C46F8F04ull, 0xA90C29B703E8D044ull, 0x5417386CE46F2F01ull, 0x8EA9ADC323E87041ull,
    0x3CF9B4F0846ECF0Eull, 0xE647215F43E9904Eull, 0x1B5C3084A46E6F0Bull, 0xC1E2A52B63E9304Bull,
    0xED24ADC8446D0F10ull, 0x379A386783EA5050ull, 0xCA8129BC646DAF15ull, 0x103FBC13A3EAF055ull,
    0xA26FA520046C4F1Aull, 0x78D1308FC3EB105Aull, 0x85CA2154246CEF1Full, 0x5F74B4FBE3EBB05Full,
    0x19CC45FAD742EB4Dull, 0xC372D05510C5B40Dull, 0x3E69C18EF7424B48ull, 0xE4D7542130C51408ull,
    0x56874D129743AB47ull, 0x8C39D8BD50C4F407ull, 0x7122C966B7430B42ull, 0xAB9C5CC970C45402ull,
    0x875A542A57406B59ull, 0x5DE4C18590C73419ull, 0xA0FFD05E7740CB5Cull, 0x7A4145F1B0C7941Cull,
    0xC8115CC217412B53ull, 0x12AFC96DD0C67413ull, 0xEFB4D8B637418B56ull, 0x350A4D19F0C6D416ull,
    0xB638C9707849F5E0ull, 0x6C865CDFBFCEAAA0ull, 0x919D4D04584955E5ull, 0x4B23D8AB9FCE0AA5ull,
    0xF973C1983848B5EAull, 0x23CD5437FFCFEAAAull, 0xDED645EC184815EFull, 0x0468D043DFCF4AAFull,
    0x28AED8A0F84B75F4ull, 0xF2104D0F3FCC2AB4ull, 0x0F0B5CD4D84BD5F1ull, 0xD5B5C97B1FCC8AB1ull,
    0x67E5D048B84A35FEull, 0xBD5B45E77FCD6ABEull, 0x4040543C984A95FBull, 0x9AFEC1935FCDCABBull,
    0xD4FDF3C4265AC892ull, 0x0E43666BE1DD97D2ull, 0xF35877B0065A6897ull, 0x29E6E21FC1DD37D7ull,
    0x9BB6FB2C665B8898ull, 0x41086E83A1DCD7D8ull, 0xBC137F58465B289Dull, 0x66ADEAF781DC77DDull,
    0x4A6BE214A6584886ull, 0x90D577BB61DF17C6ull, 0x6DCE66608658E883ull, 0xB770F3CF41DFB7C3ull,
    0x0520EAFCE659088Cull, 0xDF9E7F5321DE57CCull, 0x22856E88C659A889ull, 0xF83BFB2701DEF7C9ull,
    0x7B097F4E8951D63Full, 0xA1B7EAE14ED6897Full, 0x5CACFB3AA951763Aull, 0x86126E956ED6297Aull,
    0x344277A6C9509635ull, 0xEEFCE2090ED7C975ull, 0x13E7F3D2E9503630ull, 0xC959667D2ED76970ull,
    0xE59F6E9E0953562Bull, 0x3F21FB31CED4096Bull, 0xC23AEAEA2953F62Eull, 0x18847F45EED4A96Eull,
    0xAAD4667649521621ull, 0x706AF3D98ED54961ull, 0x8D71E2026952B624ull, 0x57CF77ADAED5E964ull,
};
static const uint64_t Crc64XzTable8[256] = {
    0x0000000000000000ull, 0x646C955F440400FEull, 0xC8D92ABE880801FCull, 0xACB5BFE1CC0C0102ull,
    0x036AFA56BF1E1D7Dull, 0x67066F09FB1A1D83ull, 0xCBB3D0E837161C81ull, 0xAFDF45B773121C7Full,
    0x06D5F4AD7E3C3AFAull, 0x62B961F23A383A04ull, 0xCE0CDE13F6343B06ull, 0xAA604B4CB2303BF8ull,
    0x05BF0EFBC1222787ull, 0x61D39BA485262779ull, 0xCD662445492A267Bull, 0xA90AB11A0D2E2685ull,
    0x0DABE95AFC7875F4ull, 0x69C77C05B87C750Aull, 0xC572C3E474707408ull, 0xA11E56BB307474F6ull,
    0x0EC1130C43666889ull, 0x6AAD865307626877ull, 0xC61839B2CB6E6975ull, 0xA274ACED8F6A698Bull,
    0x0B7E1DF782444F0Eull, 0x6F1288A8C6404FF0ull, 0xC3A737490A4C4EF2ull, 0xA7CBA2164E484E0Cull,
    0x0814E7A13D5A5273ull, 0x6C7872FE795E528Dull, 0xC0CDCD1FB552538Full, 0xA4A15840F1565371ull,
    0x1B57D2B5F8F0EBE8ull, 0x7F3B47EABCF4EB16ull, 0xD38EF80B70F8EA14ull, 0xB7E26D5434FCEAEAull,
    0x183D28E347EEF695ull, 0x7C51BDBC03EAF66Bull, 0xD0E4025DCFE6F769ull, 0xB48897028BE2F797ull,
    0x1D82261886CCD112ull, 0x79EEB347C2C8D1ECull, 0xD55B0CA60EC4D0EEull, 0xB13799F94AC0D010ull,
    0x1EE8DC4E39D2CC6Full, 0x7A8449117DD6CC91ull, 0xD631F6F0B1DACD93ull, 0xB25D63AFF5DECD6Dull,
    0x16FC3BEF04889E1Cull, 0x7290AEB0408C9EE2ull, 0xDE2511518C809FE0ull, 0xBA49840EC8849F1Eull,
    0x1596C1B9BB968361ull, 0x71FA54E6FF92839Full, 0xDD4FEB07339E829Dull, 0xB9237E58779A8263ull,
    0x1029CF427AB4A4E6ull, 0x74455A1D3EB0A418ull, 0xD8F0E5FCF2BCA51Aull, 0xBC9C70A3B6B8A5E4ull,
    0x13433514C5AAB99Bull, 0x772FA04B81AEB965ull, 0xDB9A1FAA4DA2B867ull, 0xBFF68AF509A6B899ull,
    0x36AFA56BF1E1D7D0ull, 0x52C33034B5E5D72Eull, 0xFE768FD579E9D62Cull, 0x9A1A1A8A3DEDD6D2ull,
    0x35C55F3D4EFFCAADull, 0x51A9CA620AFBCA53ull, 0xFD1C7583C6F7CB51ull, 0x9970E0DC82F3CBAFull,
    0x307A51C68FDDED2Aull, 0x5416C499CBD9EDD4ull, 0xF8A37B7807D5ECD6ull, 0x9CCFEE2743D1EC28ull,
    0x3310AB9030C3F057ull, 0x577C3ECF74C7F0A9ull, 0xFBC9812EB8CBF1ABull, 0x9FA51471FCCFF155ull,
    0x3B044C310D99A224ull, 0x5F68D96E499DA2DAull, 0xF3DD668F8591A3D8ull, 0x97B1F3D0C195A326ull,
    0x386EB667B287BF59ull, 0x5C022338F683BFA7ull, 0xF0B79CD93A8FBEA5ull, 0x94DB09867E8BBE5Bull,
    0x3DD1B89C73A598DEull, 0x59BD2DC337A19820ull, 0xF5089222FBAD9922ull, 0x9164077DBFA999DCull,
    0x3EBB42CACCBB85A3ull, 0x5AD7D79588BF855Dull, 0xF662687444B3845Full, 0x920EFD2B00B784A1ull,
    0x2DF877DE09113C38ull, 0x4994E2814D153CC6ull, 0xE5215D6081193DC4ull, 0x814DC83FC51D3D3Aull,
    0x2E928D88B60F2145ull, 0x4AFE18D7F20B21BBull, 0xE64BA7363E0720B9ull, 0x822732697A032047ull,
    0x2B2D8373772D06C2ull, 0x4F41162C3329063Cull, 0xE3F4A9CDFF25073Eull, 0x87983C92BB2107C0ull,
    0x28477925C8331BBFull, 0x4C2BEC7A8C371B41ull, 0xE09E539B403B1A43ull, 0x84F2C6C4043F1ABDull,
    0x20539E84F56949CCull, 0x443F0BDBB16D4932ull, 0xE88AB43A7D614830ull, 0x8CE62165396548CEull,
    0x233964D24A7754B1ull, 0x4755F18D0E73544Full, 0xEBE04E6CC27F554Dull, 0x8F8CDB33867B55B3ull,
    0x26866A298B557336ull, 0x42EAFF76CF5173C8ull, 0xEE5F4097035D72CAull, 0x8A33D5C847597234ull,
    0x25EC907F344B6E4Bull, 0x41800520704F6EB5ull, 0xED35BAC1BC436FB7ull, 0x89592F9EF8476F49ull,
    0x6D5F4AD7E3C3AFA0ull, 0x0933DF88A7C7AF5Eull, 0xA58660696BCBAE5Cull, 0xC1EAF5362FCFAEA2ull,
    0x6E35B0815CDDB2DDull, 0x0A5925DE18D9B223ull, 0xA6EC9A3FD4D5B321ull, 0xC2800F6090D1B3DFull,
    0x6B8ABE7A9DFF955Aull, 0x0FE62B25D9FB95A4ull, 0xA35394C415F794A6ull, 0xC73F019B51F39458ull,
    0x68E0442C22E18827ull, 0x0C8CD17366E588D9ull, 0xA0396E92AAE989DBull, 0xC455FBCDEEED8925ull,
    0x60F4A38D1FBBDA54ull, 0x049836D25BBFDAAAull, 0xA82D893397B3DBA8ull, 0xCC411C6CD3B7DB56ull,
    0x639E59DBA0A5C729ull, 0x07F2CC84E4A1C7D7ull, 0xAB47736528ADC6D5ull, 0xCF2BE63A6CA9C62Bull,
    0x662157206187E0AEull, 0x024DC27F2583E050ull, 0xAEF87D9EE98FE152ull, 0xCA94E8C1AD8BE1ACull,
    0x654BAD76DE99FDD3ull, 0x012738299A9DFD2Dull, 0xAD9287C85691FC2Full, 0xC9FE12971295FCD1ull,
    0x760898621B334448ull, 0x12640D3D5F3744B6ull, 0xBED1B2DC933B45B4ull, 0xDABD2783D73F454Aull,
    0x75626234A42D5935ull, 0x110EF76BE02959CBull, 0xBDBB488A2C2558C9ull, 0xD9D7DDD568215837ull,
    0x70DD6CCF650F7EB2ull, 0x14B1F990210B7E4Cull, 0xB8044671ED077F4Eull, 0xDC68D32EA9037FB0ull,
    0x73B79699DA1163CFull, 0x17DB03C69E156331ull, 0xBB6EBC2752196233ull, 0xDF022978161D62CDull,
    0x7BA37138E74B31BCull, 0x1FCFE467A34F3142ull, 0xB37A5B866F433040ull, 0xD716CED92B4730BEull,
    0x78C98B6E58552CC1ull, 0x1CA51E311C512C3Full, 0xB010A1D0D05D2D3Dull, 0xD47C348F94592DC3ull,
    0x7D76859599770B46ull, 0x191A10CADD730BB8ull, 0xB5AFAF2B117F0ABAull, 0xD1C33A74557B0A44ull,
    0x7E1C7FC32669163Bull, 0x1A70EA9C626D16C5ull, 0xB6C5557DAE6117C7ull, 0xD2A9C022EA651739ull,
    0x5BF0EFBC12227870ull, 0x3F9C7AE35626788Eull, 0x9329C5029A2A798Cull, 0xF745505DDE2E7972ull,
    0x589A15EAAD3C650Dull, 0x3CF680B5E93865F3ull, 0x90433F54253464F1ull, 0xF42FAA0B6130640Full,
    0x5D251B116C1E428Aull, 0x39498E4E281A4274ull, 0x95FC31AFE4164376ull, 0xF190A4F0A0124388ull,
    0x5E4FE147D3005FF7ull, 0x3A23741897045F09ull, 0x9696CBF95B085E0Bull, 0xF2FA5EA61F0C5EF5ull,
    0x565B06E6EE5A0D84ull, 0x323793B9AA5E0D7Aull, 0x9E822C5866520C78ull, 0xFAEEB90722560C86ull,
    0x5531FCB0514410F9ull, 0x315D69EF15401007ull, 0x9DE8D60ED94C1105ull, 0xF98443519D4811FBull,
    0x508EF24B9066377Eull, 0x34E26714D4623780ull, 0x9857D8F5186E3682ull, 0xFC3B4DAA5C6A367Cull,
    0x53E4081D2F782A03ull, 0x37889D426B7C2AFDull, 0x9B3D22A3A7702BFFull, 0xFF51B7FCE3742B01ull,
    0x40A73D09EAD29398ull, 0x24CBA856AED69366ull, 0x887E17B762DA9264ull, 0xEC1282E826DE929Aull,
    0x43CDC75F55CC8EE5ull, 0x27A1520011C88E1Bull, 0x8B14EDE1DDC48F19ull, 0xEF7878BE99C08FE7ull,
    0x4672C9A494EEA962ull, 0x221E5CFBD0EAA99Cull, 0x8EABE31A1CE6A89Eull, 0xEAC7764558E2A860ull,
    0x451833F22BF0B41Full, 0x2174A6AD6FF4B4E1ull, 0x8DC1194CA3F8B5E3ull, 0xE9AD8C13E7FCB51Dull,
    0x4D0CD45316AAE66Cull, 0x2960410C52AEE692ull, 0x85D5FEED9EA2E790ull, 0xE1B96BB2DAA6E76Eull,
    0x4E662E05A9B4FB11ull, 0x2A0ABB5AEDB0FBEFull, 0x86BF04BB21BCFAEDull, 0xE2D391E465B8FA13ull,
    0x4BD920FE6896DC96ull, 0x2FB5B5A12C92DC68ull, 0x83000A40E09EDD6Aull, 0xE76C9F1FA49ADD94ull,
    0x48B3DAA8D788C1EBull, 0x2CDF4FF7938CC115ull, 0x806AF0165F80C017ull, 0xE40665491B84C0E9ull,
};
static const uint64_t Crc64XzTable9[256] = {
    0x0000000000000000ull, 0x53E7815838846436ull, 0xA7CF02B07108C86Cull, 0xF42883E8498CAC5Aull,
    0xDD46AA4B4D1F8E5Dull, 0x8EA12B13759BEA6Bull, 0x7A89A8FB3C174631ull, 0x296E29A304932207ull,
    0x2855FBBD3531023Full, 0x7BB27AE50DB56609ull, 0x8F9AF90D4439CA53ull, 0xDC7D78557CBDAE65ull,
    0xF51351F6782E8C62ull, 0xA6F4D0AE40AAE854ull, 0x52DC53460926440Eull, 0x013BD21E31A22038ull,
    0x50ABF77A6A62047Eull, 0x034C762252E66048ull, 0xF764F5CA1B6ACC12ull, 0xA483749223EEA824ull,
    0x8DED5D31277D8A23ull, 0xDE0ADC691FF9EE15ull, 0x2A225F815675424Full, 0x79C5DED96EF12679ull,
    0x78FE0CC75F530641ull, 0x2B198D9F67D76277ull, 0xDF310E772E5BCE2Dull, 0x8CD68F2F16DFAA1Bull,
    0xA5B8A68C124C881Cull, 0xF65F27D42AC8EC2Aull, 0x0277A43C63444070ull, 0x519025645BC02446ull,
    0xA157EEF4D4C408FCull, 0xF2B06FACEC406CCAull, 0x0698EC44A5CCC090ull, 0x557F6D1C9D48A4A6ull,
    0x7C1144BF99DB86A1ull, 0x2FF6C5E7A15FE297ull, 0xDBDE460FE8D34ECDull, 0x8839C757D0572AFBull,
    0x89021549E1F50AC3ull, 0xDAE59411D9716EF5ull, 0x2ECD17F990FDC2AFull, 0x7D2A96A1A879A699ull,
    0x5444BF02ACEA849Eull, 0x07A33E5A946EE0A8ull, 0xF38BBDB2DDE24CF2ull, 0xA06C3CEAE56628C4ull,
    0xF1FC198EBEA60C82ull, 0xA21B98D6862268B4ull, 0x56331B3ECFAEC4EEull, 0x05D49A66F72AA0D8ull,
    0x2CBAB3C5F3B982DFull, 0x7F5D329DCB3DE6E9ull, 0x8B75B17582B14AB3ull, 0xD892302DBA352E85ull,
    0xD9A9E2338B970EBDull, 0x8A4E636BB3136A8Bull, 0x7E66E083FA9FC6D1ull, 0x2D8161DBC21BA2E7ull,
    0x04EF4878C68880E0ull, 0x5708C920FE0CE4D6ull, 0xA3204AC8B780488Cull, 0xF0C7CB908F042CBAull,
    0xD07772C206860F7Dull, 0x8390F39A3E026B4Bull, 0x77B87072778EC711ull, 0x245FF12A4F0AA327ull,
    0x0D31D8894B998120ull, 0x5ED659D1731DE516ull, 0xAAFEDA393A91494Cull, 0xF9195B6102152D7Aull,
    0xF822897F33B70D42ull, 0xABC508270B336974ull, 0x5FED8BCF42BFC52Eull, 0x0C0A0A977A3BA118ull,
    0x256423347EA8831Full, 0x7683A26C462CE729ull, 0x82AB21840FA04B73ull, 0xD14CA0DC37242F45ull,
    0x80DC85B86CE40B03ull, 0xD33B04E054606F35ull, 0x271387081DECC36Full, 0x74F406502568A759ull,
    0x5D9A2FF321FB855Eull, 0x0E7DAEAB197FE168ull, 0xFA552D4350F34D32ull, 0xA9B2AC1B68772904ull,
    0xA8897E0559D5093Cull, 0xFB6EFF5D61516D0Aull, 0x0F467CB528DDC150ull, 0x5CA1FDED1059A566ull,
    0x75CFD44E14CA8761ull, 0x262855162C4EE357ull, 0xD200D6FE65C24F0Dull, 0x81E757A65D462B3Bull,
    0x71209C36D2420781ull, 0x22C71D6EEAC663B7ull, 0xD6EF9E86A34ACFEDull, 0x85081FDE9BCEABDBull,
    0xAC66367D9F5D89DCull, 0xFF81B725A7D9EDEAull, 0x0BA934CDEE5541B0ull, 0x584EB595D6D12586ull,
    0x5975678BE77305BEull, 0x0A92E6D3DFF76188ull, 0xFEBA653B967BCDD2ull, 0xAD5DE463AEFFA9E4ull,
    0x8433CDC0AA6C8BE3ull, 0xD7D44C9892E8EFD5ull, 0x23FCCF70DB64438Full, 0x701B4E28E3E027B9ull,
    0x218B6B4CB82003FFull, 0x726CEA1480A467C9ull, 0x864469FCC928CB93ull, 0xD5A3E8A4F1ACAFA5ull,
    0xFCCDC107F53F8DA2ull, 0xAF2A405FCDBBE994ull, 0x5B02C3B7843745CEull, 0x08E542EFBCB321F8ull,
    0x09DE90F18D1101C0ull, 0x5A3911A9B59565F6ull, 0xAE119241FC19C9ACull, 0xFDF61319C49DAD9Aull,
    0xD4983ABAC00E8F9Dull, 0x877FBBE2F88AEBABull, 0x7357380AB10647F1ull, 0x20B0B952898223C7ull,
    0x32364AAFA202007Full, 0x61D1CBF79A866449ull, 0x95F9481FD30AC813ull, 0xC61EC947EB8EAC25ull,
    0xEF70E0E4EF1D8E22ull, 0xBC9761BCD799EA14ull, 0x48BFE2549E15464Eull, 0x1B58630CA6912278ull,
    0x1A63B11297330240ull, 0x4984304AAFB76676ull, 0xBDACB3A2E63BCA2Cull, 0xEE4B32FADEBFAE1Aull,
    0xC7251B59DA2C8C1Dull, 0x94C29A01E2A8E82Bull, 0x60EA19E9AB244471ull, 0x330D98B193A02047ull,
    0x629DBDD5C8600401ull, 0x317A3C8DF0E46037ull, 0xC552BF65B968CC6Dull, 0x96B53E3D81ECA85Bull,
    0xBFDB179E857F8A5Cull, 0xEC3C96C6BDFBEE6Aull, 0x1814152EF4774230ull, 0x4BF39476CCF32606ull,
    0x4AC84668FD51063Eull, 0x192FC730C5D56208ull, 0xED0744D88C59CE52ull, 0xBEE0C580B4DDAA64ull,
    0x978EEC23B04E8863ull, 0xC4696D7B88CAEC55ull, 0x3041EE93C146400Full, 0x63A66FCBF9C22439ull,
    0x9361A45B76C60883ull, 0xC08625034E426CB5ull, 0x34AEA6EB07CEC0EFull, 0x674927B33F4AA4D9ull,
    0x4E270E103BD986DEull, 0x1DC08F48035DE2E8ull, 0xE9E80CA04AD14EB2ull, 0xBA0F8DF872552A84ull,
    0xBB345FE643F70ABCull, 0xE8D3DEBE7B736E8Aull, 0x1CFB5D5632FFC2D0ull, 0x4F1CDC0E0A7BA6E6ull,
    0x6672F5AD0EE884E1ull, 0x359574F5366CE0D7ull, 0xC1BDF71D7FE04C8Dull, 0x925A7645476428BBull,
    0xC3CA53211CA40CFDull, 0x902DD279242068CBull, 0x640551916DACC491ull, 0x37E2D0C95528A0A7ull,
    0x1E8CF96A51BB82A0ull, 0x4D6B7832693FE696ull, 0xB943FBDA20B34ACCull, 0xEAA47A8218372EFAull,
    0xEB9FA89C29950EC2ull, 0xB87829C411116AF4ull, 0x4C50AA2C589DC6AEull, 0x1FB72B746019A298ull,
    0x36D902D7648A809Full, 0x653E838F5C0EE4A9ull, 0x91160067158248F3ull, 0xC2F1813F2D062CC5ull,
    0xE241386DA4840F02ull, 0xB1A6B9359C006B34ull, 0x458E3ADDD58CC76Eull, 0x1669BB85ED08A358ull,
    0x3F079226E99B815Full, 0x6CE0137ED11FE569ull, 0x98C8909698934933ull, 0xCB2F11CEA0172D05ull,
    0xCA14C3D091B50D3Dull, 0x99F34288A931690Bull, 0x6DDBC160E0BDC551ull, 0x3E3C4038D839A167ull,
    0x1752699BDCAA8360ull, 0x44B5E8C3E42EE756ull, 0xB09D6B2BADA24B0Cull, 0xE37AEA7395262F3Aull,
    0xB2EACF17CEE60B7Cull, 0xE10D4E4FF6626F4Aull, 0x1525CDA7BFEEC310ull, 0x46C24CFF876AA726ull,
    0x6FAC655C83F98521ull, 0x3C4BE404BB7DE117ull, 0xC86367ECF2F14D4Dull, 0x9B84E6B4CA75297Bull,
    0x9ABF34AAFBD70943ull, 0xC958B5F2C3536D75ull, 0x3D70361A8ADFC12Full, 0x6E97B742B25BA519ull,
    0x47F99EE1B6C8871Eull, 0x141E1FB98E4CE328ull, 0xE0369C51C7C04F72ull, 0xB3D11D09FF442B44ull,
    0x4316D699704007FEull, 0x10F157C148C463C8ull, 0xE4D9D4290148CF92ull, 0xB73E557139CCABA4ull,
    0x9E507CD23D5F89A3ull, 0xCDB7FD8A05DBED95ull, 0x399F7E624C5741CFull, 0x6A78FF3A74D325F9ull,
    0x6B432D24457105C1ull, 0x38A4AC7C7DF561F7ull, 0xCC8C2F943479CDADull, 0x9F6BAECC0CFDA99Bull,
    0xB605876F086E8B9Cull, 0xE5E2063730EAEFAAull, 0x11CA85DF796643F0ull, 0x422D048741E227C6ull,
    0x13BD21E31A220380ull, 0x405AA0BB22A667B6ull, 0xB47223536B2ACBECull, 0xE795A20B53AEAFDAull,
    0xCEFB8BA8573D8DDDull, 0x9D1C0AF06FB9E9EBull, 0x69348918263545B1ull, 0x3AD308401EB12187ull,
    0x3BE8DA5E2F1301BFull, 0x680F5B0617976589ull, 0x9C27D8EE5E1BC9D3ull, 0xCFC059B6669FADE5ull,
    0xE6AE7015620C8FE2ull, 0xB549F14D5A88EBD4ull, 0x416172A51304478Eull, 0x1286F3FD2B8023B8ull,
};
static const uint64_t Crc64XzTable10[256] = {
    0x0000000000000000ull, 0x09ABF11AFCA2D0D7ull, 0x1357E235F945A1AEull, 0x1AFC132F05E77179ull,
    0x26AFC46BF28B435Cull, 0x2F0435710E29938Bull, 0x35F8265E0BCEE2F2ull, 0x3C53D744F76C3225ull,
    0x4D5F88D7E51686B8ull, 0x44F479CD19B4566Full, 0x5E086AE21C532716ull, 0x57A39BF8E0F1F7C1ull,
    0x6BF04CBC179DC5E4ull, 0x625BBDA6EB3F1533ull, 0x78A7AE89EED8644Aull, 0x710C5F93127AB49Dull,
    0x9ABF11AFCA2D0D70ull, 0x9314E0B5368FDDA7ull, 0x89E8F39A3368ACDEull, 0x80430280CFCA7C09ull,
    0xBC10D5C438A64E2Cull, 0xB5BB24DEC4049EFBull, 0xAF4737F1C1E3EF82ull, 0xA6ECC6EB3D413F55ull,
    0xD7E099782F3B8BC8ull, 0xDE4B6862D3995B1Full, 0xC4B77B4DD67E2A66ull, 0xCD1C8A572ADCFAB1ull,
    0xF14F5D13DDB0C894ull, 0xF8E4AC0921121843ull, 0xE218BF2624F5693Aull, 0xEBB34E3CD857B9EDull,
    0xA7A68C743B540465ull, 0xAE0D7D6EC7F6D4B2ull, 0xB4F16E41C211A5CBull, 0xBD5A9F5B3EB3751Cull,
    0x8109481FC9DF4739ull, 0x88A2B905357D97EEull, 0x925EAA2A309AE697ull, 0x9BF55B30CC383640ull,
    0xEAF904A3DE4282DDull, 0xE352F5B922E0520Aull, 0xF9AEE69627072373ull, 0xF005178CDBA5F3A4ull,
    0xCC56C0C82CC9C181ull, 0xC5FD31D2D06B1156ull, 0xDF0122FDD58C602Full, 0xD6AAD3E7292EB0F8ull,
    0x3D199DDBF1790915ull, 0x34B26CC10DDBD9C2ull, 0x2E4E7FEE083CA8BBull, 0x27E58EF4F49E786Cull,
    0x1BB659B003F24A49ull, 0x121DA8AAFF509A9Eull, 0x08E1BB85FAB7EBE7ull, 0x014A4A9F06153B30ull,
    0x7046150C146F8FADull, 0x79EDE416E8CD5F7Aull, 0x6311F739ED2A2E03ull, 0x6ABA06231188FED4ull,
    0x56E9D167E6E4CCF1ull, 0x5F42207D1A461C26ull, 0x45BE33521FA16D5Full, 0x4C15C248E303BD88ull,
    0xDD95B7C3D9A6164Full, 0xD43E46D92504C698ull, 0xCEC255F620E3B7E1ull, 0xC769A4ECDC416736ull,
    0xFB3A73A82B2D5513ull, 0xF29182B2D78F85C4ull, 0xE86D919DD268F4BDull, 0xE1C660872ECA246Aull,
    0x90CA3F143CB090F7ull, 0x9961CE0EC0124020ull, 0x839DDD21C5F53159ull, 0x8A362C3B3957E18Eull,
    0xB665FB7FCE3BD3ABull, 0xBFCE0A653299037Cull, 0xA532194A377E7205ull, 0xAC99E850CBDCA2D2ull,
    0x472AA66C138B1B3Full, 0x4E815776EF29CBE8ull, 0x547D4459EACEBA91ull, 0x5DD6B543166C6A46ull,
    0x61856207E1005863ull, 0x682E931D1DA288B4ull, 0x72D280321845F9CDull, 0x7B797128E4E7291Aull,
    0x0A752EBBF69D9D87ull, 0x03DEDFA10A3F4D50ull, 0x1922CC8E0FD83C29ull, 0x10893D94F37AECFEull,
    0x2CDAEAD00416DEDBull, 0x25711BCAF8B40E0Cull, 0x3F8D08E5FD537F75ull, 0x3626F9FF01F1AFA2ull,
    0x7A333BB7E2F2122Aull, 0x7398CAAD1E50C2FDull, 0x6964D9821BB7B384ull, 0x60CF2898E7156353ull,
    0x5C9CFFDC10795176ull, 0x55370EC6ECDB81A1ull, 0x4FCB1DE9E93CF0D8ull, 0x4660ECF3159E200Full,
    0x376CB36007E49492ull, 0x3EC7427AFB464445ull, 0x243B5155FEA1353Cull, 0x2D90A04F0203E5EBull,
    0x11C3770BF56FD7CEull, 0x1868861109CD0719ull, 0x0294953E0C2A7660ull, 0x0B3F6424F088A6B7ull,
    0xE08C2A1828DF1F5Aull, 0xE927DB02D47DCF8Dull, 0xF3DBC82DD19ABEF4ull, 0xFA7039372D386E23ull,
    0xC623EE73DA545C06ull, 0xCF881F6926F68CD1ull, 0xD5740C462311FDA8ull, 0xDCDFFD5CDFB32D7Full,
    0xADD3A2CFCDC999E2ull, 0xA47853D5316B4935ull, 0xBE8440FA348C384Cull, 0xB72FB1E0C82EE89Bull,
    0x8B7C66A43F42DABEull, 0x82D797BEC3E00A69ull, 0x982B8491C6077B10ull, 0x9180758B3AA5ABC7ull,
    0x29F3C0AC1C42321Bull, 0x205831B6E0E0E2CCull, 0x3AA42299E50793B5ull, 0x330FD38319A54362ull,
    0x0F5C04C7EEC97147ull, 0x06F7F5DD126BA190ull, 0x1C0BE6F2178CD0E9ull, 0x15A017E8EB2E003Eull,
    0x64AC487BF954B4A3ull, 0x6D07B96105F66474ull, 0x77FBAA4E0011150Dull, 0x7E505B54FCB3C5DAull,
    0x42038C100BDFF7FFull, 0x4BA87D0AF77D2728ull, 0x51546E25F29A5651ull, 0x58FF9F3F0E388686ull,
    0xB34CD103D66F3F6Bull, 0xBAE720192ACDEFBCull, 0xA01B33362F2A9EC5ull, 0xA9B0C22CD3884E12ull,
    0x95E3156824E47C37ull, 0x9C48E472D846ACE0ull, 0x86B4F75DDDA1DD99ull, 0x8F1F064721030D4Eull,
    0xFE1359D43379B9D3ull, 0xF7B8A8CECFDB6904ull, 0xED44BBE1CA3C187Dull, 0xE4EF4AFB369EC8AAull,
    0xD8BC9DBFC1F2FA8Full, 0xD1176CA53D502A58ull, 0xCBEB7F8A38B75B21ull, 0xC2408E90C4158BF6ull,
    0x8E554CD82716367Eull, 0x87FEBDC2DBB4E6A9ull, 0x9D02AEEDDE5397D0ull, 0x94A95FF722F14707ull,
    0xA8FA88B3D59D7522ull, 0xA15179A9293FA5F5ull, 0xBBAD6A862CD8D48Cull, 0xB2069B9CD07A045Bull,
    0xC30AC40FC200B0C6ull, 0xCAA135153EA26011ull, 0xD05D263A3B451168ull, 0xD9F6D720C7E7C1BFull,
    0xE5A50064308BF39Aull, 0xEC0EF17ECC29234Dull, 0xF6F2E251C9CE5234ull, 0xFF59134B356C82E3ull,
    0x14EA5D77ED3B3B0Eull, 0x1D41AC6D1199EBD9ull, 0x07BDBF42147E9AA0ull, 0x0E164E58E8DC4A77ull,
    0x3245991C1FB07852ull, 0x3BEE6806E312A885ull, 0x21127B29E6F5D9FCull, 0x28B98A331A57092Bull,
    0x59B5D5A0082DBDB6ull, 0x501E24BAF48F6D61ull, 0x4AE23795F1681C18ull, 0x4349C68F0DCACCCFull,
    0x7F1A11CBFAA6FEEAull, 0x76B1E0D106042E3Dull, 0x6C4DF3FE03E35F44ull, 0x65E602E4FF418F93ull,
    0xF466776FC5E42454ull, 0xFDCD86753946F483ull, 0xE731955A3CA185FAull, 0xEE9A6440C003552Dull,
    0xD2C9B304376F6708ull, 0xDB62421ECBCDB7DFull, 0xC19E5131CE2AC6A6ull, 0xC835A02B32881671ull,
    0xB939FFB820F2A2ECull, 0xB0920EA2DC50723Bull, 0xAA6E1D8DD9B70342ull, 0xA3C5EC972515D395ull,
    0x9F963BD3D279E1B0ull, 0x963DCAC92EDB3167ull, 0x8CC1D9E62B3C401Eull, 0x856A28FCD79E90C9ull,
    0x6ED966C00FC92924ull, 0x677297DAF36BF9F3ull, 0x7D8E84F5F68C888Aull, 0x742575EF0A2E585Dull,
    0x4876A2ABFD426A78ull, 0x41DD53B101E0BAAFull, 0x5B21409E0407CBD6ull, 0x528AB184F8A51B01ull,
    0x2386EE17EADFAF9Cull, 0x2A2D1F0D167D7F4Bull, 0x30D10C22139A0E32ull, 0x397AFD38EF38DEE5ull,
    0x05292A7C1854ECC0ull, 0x0C82DB66E4F63C17ull, 0x167EC849E1114D6Eull, 0x1FD539531DB39DB9ull,
    0x53C0FB1BFEB02031ull, 0x5A6B0A010212F0E6ull, 0x4097192E07F5819Full, 0x493CE834FB575148ull,
    0x756F3F700C3B636Dull, 0x7CC4CE6AF099B3BAull, 0x6638DD45F57EC2C3ull, 0x6F932C5F09DC1214ull,
    0x1E9F73CC1BA6A689ull, 0x173482D6E704765Eull, 0x0DC891F9E2E30727ull, 0x046360E31E41D7F0ull,
    0x3830B7A7E92DE5D5ull, 0x319B46BD158F3502ull, 0x2B6755921068447Bull, 0x22CCA488ECCA94ACull,
    0xC97FEAB4349D2D41ull, 0xC0D41BAEC83FFD96ull, 0xDA280881CDD88CEFull, 0xD383F99B317A5C38ull,
    0xEFD02EDFC6166E1Dull, 0xE67BDFC53AB4BECAull, 0xFC87CCEA3F53CFB3ull, 0xF52C3DF0C3F11F64ull,
    0x84206263D18BABF9ull, 0x8D8B93792D297B2Eull, 0x9777805628CE0A57ull, 0x9EDC714CD46CDA80ull,
    0xA28FA6082300E8A5ull, 0xAB245712DFA23872ull, 0xB1D8443DDA45490Bull, 0xB873B52726E799DCull,
};
static const uint64_t Crc64XzTable11[256] = {
    0x0000000000000000ull, 0xEC32CFFB23E3ED7Dull, 0x4ABD30DDE8C9C47Full, 0xA68FFF26CB2A2902ull,
    0x957A61BBD19388FEull, 0x7948AE40F2706583ull, 0xDFC75166395A4C81ull, 0x33F59E9D1AB9A1FCull,
    0xB82C6C5C0C290F79ull, 0x541EA3A72FCAE204ull, 0xF2915C81E4E0CB06ull, 0x1EA3937AC703267Bull,
    0x2D560DE7DDBA8787ull, 0xC164C21CFE596AFAull, 0x67EB3D3A357343F8ull, 0x8BD9F2C11690AE85ull,
    0xE2807793B75C0077ull, 0x0EB2B86894BFED0Aull, 0xA83D474E5F95C408ull, 0x440F88B57C762975ull,
    0x77FA162866CF8889ull, 0x9BC8D9D3452C65F4ull, 0x3D4726F58E064CF6ull, 0xD175E90EADE5A18Bull,
    0x5AAC1BCFBB750F0Eull, 0xB69ED4349896E273ull, 0x10112B1253BCCB71ull, 0xFC23E4E9705F260Cull,
    0xCFD67A746AE687F0ull, 0x23E4B58F49056A8Dull, 0x856B4AA9822F438Full, 0x69598552A1CCAEF2ull,
    0x57D8400CC1B61E6Bull, 0xBBEA8FF7E255F316ull, 0x1D6570D1297FDA14ull, 0xF157BF2A0A9C3769ull,
    0xC2A221B710259695ull, 0x2E90EE4C33C67BE8ull, 0x881F116AF8EC52EAull, 0x642DDE91DB0FBF97ull,
    0xEFF42C50CD9F1112ull, 0x03C6E3ABEE7CFC6Full, 0xA5491C8D2556D56Dull, 0x497BD37606B53810ull,
    0x7A8E4DEB1C0C99ECull, 0x96BC82103FEF7491ull, 0x30337D36F4C55D93ull, 0xDC01B2CDD726B0EEull,
    0xB558379F76EA1E1Cull, 0x596AF8645509F361ull, 0xFFE507429E23DA63ull, 0x13D7C8B9BDC0371Eull,
    0x20225624A77996E2ull, 0xCC1099DF849A7B9Full, 0x6A9F66F94FB0529Dull, 0x86ADA9026C53BFE0ull,
    0x0D745BC37AC31165ull, 0xE14694385920FC18ull, 0x47C96B1E920AD51Aull, 0xABFBA4E5B1E93867ull,
    0x980E3A78AB50999Bull, 0x743CF58388B374E6ull, 0xD2B30AA543995DE4ull, 0x3E81C55E607AB099ull,
    0xAFB08019836C3CD6ull, 0x43824FE2A08FD1ABull, 0xE50DB0C46BA5F8A9ull, 0x093F7F3F484615D4ull,
    0x3ACAE1A252FFB428ull, 0xD6F82E59711C5955ull, 0x7077D17FBA367057ull, 0x9C451E8499D59D2Aull,
    0x179CEC458F4533AFull, 0xFBAE23BEACA6DED2ull, 0x5D21DC98678CF7D0ull, 0xB1131363446F1AADull,
    0x82E68DFE5ED6BB51ull, 0x6ED442057D35562Cull, 0xC85BBD23B61F7F2Eull, 0x246972D895FC9253ull,
    0x4D30F78A34303CA1ull, 0xA102387117D3D1DCull, 0x078DC757DCF9F8DEull, 0xEBBF08ACFF1A15A3ull,
    0xD84A9631E5A3B45Full, 0x347859CAC6405922ull, 0x92F7A6EC0D6A7020ull, 0x7EC569172E899D5Dull,
    0xF51C9BD6381933D8ull, 0x192E542D1BFADEA5ull, 0xBFA1AB0BD0D0F7A7ull, 0x539364F0F3331ADAull,
    0x6066FA6DE98ABB26ull, 0x8C543596CA69565Bull, 0x2ADBCAB001437F59ull, 0xC6E9054B22A09224ull,
    0xF868C01542DA22BDull, 0x145A0FEE6139CFC0ull, 0xB2D5F0C8AA13E6C2ull, 0x5EE73F3389F00BBFull,
    0x6D12A1AE9349AA43ull, 0x81206E55B0AA473Eull, 0x27AF91737B806E3Cull, 0xCB9D5E8858638341ull,
    0x4044AC494EF32DC4ull, 0xAC7663B26D10C0B9ull, 0x0AF99C94A63AE9BBull, 0xE6CB536F85D904C6ull,
    0xD53ECDF29F60A53Aull, 0x390C0209BC834847ull, 0x9F83FD2F77A96145ull, 0x73B132D4544A8C38ull,
    0x1AE8B786F58622CAull, 0xF6DA787DD665CFB7ull, 0x5055875B1D4FE6B5ull, 0xBC6748A03EAC0BC8ull,
    0x8F92D63D2415AA34ull, 0x63A019C607F64749ull, 0xC52FE6E0CCDC6E4Bull, 0x291D291BEF3F8336ull,
    0xA2C4DBDAF9AF2DB3ull, 0x4EF61421DA4CC0CEull, 0xE879EB071166E9CCull, 0x044B24FC328504B1ull,
    0x37BEBA61283CA54Dull, 0xDB8C759A0BDF4830ull, 0x7D038ABCC0F56132ull, 0x91314547E3168C4Full,
    0xCDB9AF18A9D66729ull, 0x218B60E38A358A54ull, 0x87049FC5411FA356ull, 0x6B36503E62FC4E2Bull,
    0x58C3CEA37845EFD7ull, 0xB4F101585BA602AAull, 0x127EFE7E908C2BA8ull, 0xFE4C3185B36FC6D5ull,
    0x7595C344A5FF6850ull, 0x99A70CBF861C852Dull, 0x3F28F3994D36AC2Full, 0xD31A3C626ED54152ull,
    0xE0EFA2FF746CE0AEull, 0x0CDD6D04578F0DD3ull, 0xAA5292229CA524D1ull, 0x46605DD9BF46C9ACull,
    0x2F39D88B1E8A675Eull, 0xC30B17703D698A23ull, 0x6584E856F643A321ull, 0x89B627ADD5A04E5Cull,
    0xBA43B930CF19EFA0ull, 0x567176CBECFA02DDull, 0xF0FE89ED27D02BDFull, 0x1CCC46160433C6A2ull,
    0x9715B4D712A36827ull, 0x7B277B2C3140855Aull, 0xDDA8840AFA6AAC58ull, 0x319A4BF1D9894125ull,
    0x026FD56CC330E0D9ull, 0xEE5D1A97E0D30DA4ull, 0x48D2E5B12BF924A6ull, 0xA4E02A4A081AC9DBull,
    0x9A61EF1468607942ull, 0x765320EF4B83943Full, 0xD0DCDFC980A9BD3Dull, 0x3CEE1032A34A5040ull,
    0x0F1B8EAFB9F3F1BCull, 0xE32941549A101CC1ull, 0x45A6BE72513A35C3ull, 0xA994718972D9D8BEull,
    0x224D83486449763Bull, 0xCE7F4CB347AA9B46ull, 0x68F0B3958C80B244ull, 0x84C27C6EAF635F39ull,
    0xB737E2F3B5DAFEC5ull, 0x5B052D08963913B8ull, 0xFD8AD22E5D133ABAull, 0x11B81DD57EF0D7C7ull,
    0x78E19887DF3C7935ull, 0x94D3577CFCDF9448ull, 0x325CA85A37F5BD4Aull, 0xDE6E67A114165037ull,
    0xED9BF93C0EAFF1CBull, 0x01A936C72D4C1CB6ull, 0xA726C9E1E66635B4ull, 0x4B14061AC585D8C9ull,
    0xC0CDF4DBD315764Cull, 0x2CFF3B20F0F69B31ull, 0x8A70C4063BDCB233ull, 0x66420BFD183F5F4Eull,
    0x55B795600286FEB2ull, 0xB9855A9B216513CFull, 0x1F0AA5BDEA4F3ACDull, 0xF3386A46C9ACD7B0ull,
    0x62092F012ABA5BFFull, 0x8E3BE0FA0959B682ull, 0x28B41FDCC2739F80ull, 0xC486D027E19072FDull,
    0xF7734EBAFB29D301ull, 0x1B418141D8CA3E7Cull, 0xBDCE7E6713E0177Eull, 0x51FCB19C3003FA03ull,
    0xDA25435D26935486ull, 0x36178CA60570B9FBull, 0x90987380CE5A90F9ull, 0x7CAABC7BEDB97D84ull,
    0x4F5F22E6F700DC78ull, 0xA36DED1DD4E33105ull, 0x05E2123B1FC91807ull, 0xE9D0DDC03C2AF57Aull,
    0x808958929DE65B88ull, 0x6CBB9769BE05B6F5ull, 0xCA34684F752F9FF7ull, 0x2606A7B456CC728Aull,
    0x15F339294C75D376ull, 0xF9C1F6D26F963E0Bull, 0x5F4E09F4A4BC1709ull, 0xB37CC60F875FFA74ull,
    0x38A534CE91CF54F1ull, 0xD497FB35B22CB98Cull, 0x721804137906908Eull, 0x9E2ACBE85AE57DF3ull,
    0xADDF5575405CDC0Full, 0x41ED9A8E63BF3172ull, 0xE76265A8A8951870ull, 0x0B50AA538B76F50Dull,
    0x35D16F0DEB0C4594ull, 0xD9E3A0F6C8EFA8E9ull, 0x7F6C5FD003C581EBull, 0x935E902B20266C96ull,
    0xA0AB0EB63A9FCD6Aull, 0x4C99C14D197C2017ull, 0xEA163E6BD2560915ull, 0x0624F190F1B5E468ull,
    0x8DFD0351E7254AEDull, 0x61CFCCAAC4C6A790ull, 0xC740338C0FEC8E92ull, 0x2B72FC772C0F63EFull,
    0x188762EA36B6C213ull, 0xF4B5AD1115552F6Eull, 0x523A5237DE7F066Cull, 0xBE089DCCFD9CEB11ull,
    0xD751189E5C5045E3ull, 0x3B63D7657FB3A89Eull, 0x9DEC2843B499819Cull, 0x71DEE7B8977A6CE1ull,
    0x422B79258DC3CD1Dull, 0xAE19B6DEAE202060ull, 0x089649F8650A0962ull, 0xE4A4860346E9E41Full,
    0x6F7D74C250794A9Aull, 0x834FBB39739AA7E7ull, 0x25C0441FB8B08EE5ull, 0xC9F28BE49B536398ull,
    0xFA07157981EAC264ull, 0x1635DA82A2092F19ull, 0xB0BA25A46923061Bull, 0x5C88EA5F4AC0EB66ull,
};
static const uint64_t Crc64XzTable12[256] = {
    0x0000000000000000ull, 0xDDA9F27EE08373ADull, 0x298B4BD66E08F9DFull, 0xF422B9A88E8B8A72ull,
    0x531697ACDC11F3BEull, 0x8EBF65D23C928013ull, 0x7A9DDC7AB2190A61ull, 0xA7342E04529A79CCull,
    0xA62D2F59B823E77Cull, 0x7B84DD2758A094D1ull, 0x8FA6648FD62B1EA3ull, 0x520F96F136A86D0Eull,
    0xF53BB8F5643214C2ull, 0x28924A8B84B1676Full, 0xDCB0F3230A3AED1Dull, 0x0119015DEAB99EB0ull,
    0xDE82F198DF49D07Dull, 0x032B03E63FCAA3D0ull, 0xF709BA4EB14129A2ull, 0x2AA0483051C25A0Full,
    0x8D946634035823C3ull, 0x503D944AE3DB506Eull, 0xA41F2DE26D50DA1Cull, 0x79B6DF9C8DD3A9B1ull,
    0x78AFDEC1676A3701ull, 0xA5062CBF87E944ACull, 0x512495170962CEDEull, 0x8C8D6769E9E1BD73ull,
    0x2BB9496DBB7BC4BFull, 0xF610BB135BF8B712ull, 0x023202BBD5733D60ull, 0xDF9BF0C535F04ECDull,
    0x2FDD4C1A119DBE7Full, 0xF274BE64F11ECDD2ull, 0x065607CC7F9547A0ull, 0xDBFFF5B29F16340Dull,
    0x7CCBDBB6CD8C4DC1ull, 0xA16229C82D0F3E6Cull, 0x55409060A384B41Eull, 0x88E9621E4307C7B3ull,
    0x89F06343A9BE5903ull, 0x5459913D493D2AAEull, 0xA07B2895C7B6A0DCull, 0x7DD2DAEB2735D371ull,
    0xDAE6F4EF75AFAABDull, 0x074F0691952CD910ull, 0xF36DBF391BA75362ull, 0x2EC44D47FB2420CFull,
    0xF15FBD82CED46E02ull, 0x2CF64FFC2E571DAFull, 0xD8D4F654A0DC97DDull, 0x057D042A405FE470ull,
    0xA2492A2E12C59DBCull, 0x7FE0D850F246EE11ull, 0x8BC261F87CCD6463ull, 0x566B93869C4E17CEull,
    0x577292DB76F7897Eull, 0x8ADB60A59674FAD3ull, 0x7EF9D90D18FF70A1ull, 0xA3502B73F87C030Cull,
    0x04640577AAE67AC0ull, 0xD9CDF7094A65096Dull, 0x2DEF4EA1C4EE831Full, 0xF046BCDF246DF0B2ull,
    0x5FBA9834233B7CFEull, 0x82136A4AC3B80F53ull, 0x7631D3E24D338521ull, 0xAB98219CADB0F68Cull,
    0x0CAC0F98FF2A8F40ull, 0xD105FDE61FA9FCEDull, 0x2527444E9122769Full, 0xF88EB63071A10532ull,
    0xF997B76D9B189B82ull, 0x243E45137B9BE82Full, 0xD01CFCBBF510625Dull, 0x0DB50EC5159311F0ull,
    0xAA8120C14709683Cull, 0x7728D2BFA78A1B91ull, 0x830A6B17290191E3ull, 0x5EA39969C982E24Eull,
    0x813869ACFC72AC83ull, 0x5C919BD21CF1DF2Eull, 0xA8B3227A927A555Cull, 0x751AD00472F926F1ull,
    0xD22EFE0020635F3Dull, 0x0F870C7EC0E02C90ull, 0xFBA5B5D64E6BA6E2ull, 0x260C47A8AEE8D54Full,
    0x271546F544514BFFull, 0xFABCB48BA4D23852ull, 0x0E9E0D232A59B220ull, 0xD337FF5DCADAC18Dull,
    0x7403D1599840B841ull, 0xA9AA232778C3CBECull, 0x5D889A8FF648419Eull, 0x802168F116CB3233ull,
    0x7067D42E32A6C281ull, 0xADCE2650D225B12Cull, 0x59EC9FF85CAE3B5Eull, 0x84456D86BC2D48F3ull,
    0x23714382EEB7313Full, 0xFED8B1FC0E344292ull, 0x0AFA085480BFC8E0ull, 0xD753FA2A603CBB4Dull,
    0xD64AFB778A8525FDull, 0x0BE309096A065650ull, 0xFFC1B0A1E48DDC22ull, 0x226842DF040EAF8Full,
    0x855C6CDB5694D643ull, 0x58F59EA5B617A5EEull, 0xACD7270D389C2F9Cull, 0x717ED573D81F5C31ull,
    0xAEE525B6EDEF12FCull, 0x734CD7C80D6C6151ull, 0x876E6E6083E7EB23ull, 0x5AC79C1E6364988Eull,
    0xFDF3B21A31FEE142ull, 0x205A4064D17D92EFull, 0xD478F9CC5FF6189Dull, 0x09D10BB2BF756B30ull,
    0x08C80AEF55CCF580ull, 0xD561F891B54F862Dull, 0x214341393BC40C5Full, 0xFCEAB347DB477FF2ull,
    0x5BDE9D4389DD063Eull, 0x86776F3D695E7593ull, 0x7255D695E7D5FFE1ull, 0xAFFC24EB07568C4Cull,
    0xBF7530684676F9FCull, 0x62DCC216A6F58A51ull, 0x96FE7BBE287E0023ull, 0x4B5789C0C8FD738Eull,
    0xEC63A7C49A670A42ull, 0x31CA55BA7AE479EFull, 0xC5E8EC12F46FF39Dull, 0x18411E6C14EC8030ull,
    0x19581F31FE551E80ull, 0xC4F1ED4F1ED66D2Dull, 0x30D354E7905DE75Full, 0xED7AA69970DE94F2ull,
    0x4A4E889D2244ED3Eull, 0x97E77AE3C2C79E93ull, 0x63C5C34B4C4C14E1ull, 0xBE6C3135ACCF674Cull,
    0x61F7C1F0993F2981ull, 0xBC5E338E79BC5A2Cull, 0x487C8A26F737D05Eull, 0x95D5785817B4A3F3ull,
    0x32E1565C452EDA3Full, 0xEF48A422A5ADA992ull, 0x1B6A1D8A2B2623E0ull, 0xC6C3EFF4CBA5504Dull,
    0xC7DAEEA9211CCEFDull, 0x1A731CD7C19FBD50ull, 0xEE51A57F4F143722ull, 0x33F85701AF97448Full,
    0x94CC7905FD0D3D43ull, 0x49658B7B1D8E4EEEull, 0xBD4732D39305C49Cull, 0x60EEC0AD7386B731ull,
    0x90A87C7257EB4783ull, 0x4D018E0CB768342Eull, 0xB92337A439E3BE5Cull, 0x648AC5DAD960CDF1ull,
    0xC3BEEBDE8BFAB43Dull, 0x1E1719A06B79C790ull, 0xEA35A008E5F24DE2ull, 0x379C527605713E4Full,
    0x3685532BEFC8A0FFull, 0xEB2CA1550F4BD352ull, 0x1F0E18FD81C05920ull, 0xC2A7EA8361432A8Dull,
    0x6593C48733D95341ull, 0xB83A36F9D35A20ECull, 0x4C188F515DD1AA9Eull, 0x91B17D2FBD52D933ull,
    0x4E2A8DEA88A297FEull, 0x93837F946821E453ull, 0x67A1C63CE6AA6E21ull, 0xBA08344206291D8Cull,
    0x1D3C1A4654B36440ull, 0xC095E838B43017EDull, 0x34B751903ABB9D9Full, 0xE91EA3EEDA38EE32ull,
    0xE807A2B330817082ull, 0x35AE50CDD002032Full, 0xC18CE9655E89895Dull, 0x1C251B1BBE0AFAF0ull,
    0xBB11351FEC90833Cull, 0x66B8C7610C13F091ull, 0x929A7EC982987AE3ull, 0x4F338CB7621B094Eull,
    0xE0CFA85C654D8502ull, 0x3D665A2285CEF6AFull, 0xC944E38A0B457CDDull, 0x14ED11F4EBC60F70ull,
    0xB3D93FF0B95C76BCull, 0x6E70CD8E59DF0511ull, 0x9A527426D7548F63ull, 0x47FB865837D7FCCEull,
    0x46E28705DD6E627Eull, 0x9B4B757B3DED11D3ull, 0x6F69CCD3B3669BA1ull, 0xB2C03EAD53E5E80Cull,
    0x15F410A9017F91C0ull, 0xC85DE2D7E1FCE26Dull, 0x3C7F5B7F6F77681Full, 0xE1D6A9018FF41BB2ull,
    0x3E4D59C4BA04557Full, 0xE3E4ABBA5A8726D2ull, 0x17C61212D40CACA0ull, 0xCA6FE06C348FDF0Dull,
    0x6D5BCE686615A6C1ull, 0xB0F23C168696D56Cull, 0x44D085BE081D5F1Eull, 0x997977C0E89E2CB3ull,
    0x9860769D0227B203ull, 0x45C984E3E2A4C1AEull, 0xB1EB3D4B6C2F4BDCull, 0x6C42CF358CAC3871ull,
    0xCB76E131DE3641BDull, 0x16DF134F3EB53210ull, 0xE2FDAAE7B03EB862ull, 0x3F54589950BDCBCFull,
    0xCF12E44674D03B7Dull, 0x12BB1638945348D0ull, 0xE699AF901AD8C2A2ull, 0x3B305DEEFA5BB10Full,
    0x9C0473EAA8C1C8C3ull, 0x41AD81944842BB6Eull, 0xB58F383CC6C9311Cull, 0x6826CA42264A42B1ull,
    0x693FCB1FCCF3DC01ull, 0xB49639612C70AFACull, 0x40B480C9A2FB25DEull, 0x9D1D72B742785673ull,
    0x3A295CB310E22FBFull, 0xE780AECDF0615C12ull, 0x13A217657EEAD660ull, 0xCE0BE51B9E69A5CDull,
    0x119015DEAB99EB00ull, 0xCC39E7A04B1A98ADull, 0x381B5E08C59112DFull, 0xE5B2AC7625126172ull,
    0x42868272778818BEull, 0x9F2F700C970B6B13ull, 0x6B0DC9A41980E161ull, 0xB6A43BDAF90392CCull,
    0xB7BD3A8713BA0C7Cull, 0x6A14C8F9F3397FD1ull, 0x9E3671517DB2F5A3ull, 0x439F832F9D31860Eull,
    0xE4ABAD2BCFABFFC2ull, 0x39025F552F288C6Full, 0xCD20E6FDA1A3061Dull, 0x10891483412075B0ull,
};
static const uint64_t Crc64XzTable13[256] = {
    0x0000000000000000ull, 0x0DD9B4240837FD99ull, 0x1BB36848106FFB32ull, 0x166ADC6C185806ABull,
    0x3766D09020DFF664ull, 0x3ABF64B428E80BFDull, 0x2CD5B8D830B00D56ull, 0x210C0CFC3887F0CFull,
    0x6ECDA12041BFECC8ull, 0x6314150449881151ull, 0x757EC96851D017FAull, 0x78A77D4C59E7EA63ull,
    0x59AB71B061601AACull, 0x5472C5946957E735ull, 0x421819F8710FE19Eull, 0x4FC1ADDC79381C07ull,
    0xDD9B4240837FD990ull, 0xD042F6648B482409ull, 0xC6282A08931022A2ull, 0xCBF19E2C9B27DF3Bull,
    0xEAFD92D0A3A02FF4ull, 0xE72426F4AB97D26Dull, 0xF14EFA98B3CFD4C6ull, 0xFC974EBCBBF8295Full,
    0xB356E360C2C03558ull, 0xBE8F5744CAF7C8C1ull, 0xA8E58B28D2AFCE6Aull, 0xA53C3F0CDA9833F3ull,
    0x843033F0E21FC33Cull, 0x89E987D4EA283EA5ull, 0x9F835BB8F270380Eull, 0x925AEF9CFA47C597ull,
    0x29EE2BAAA9F1ADA5ull, 0x24379F8EA1C6503Cull, 0x325D43E2B99E5697ull, 0x3F84F7C6B1A9AB0Eull,
    0x1E88FB3A892E5BC1ull, 0x13514F1E8119A658ull, 0x053B93729941A0F3ull, 0x08E2275691765D6Aull,
    0x47238A8AE84E416Dull, 0x4AFA3EAEE079BCF4ull, 0x5C90E2C2F821BA5Full, 0x514956E6F01647C6ull,
    0x70455A1AC891B709ull, 0x7D9CEE3EC0A64A90ull, 0x6BF63252D8FE4C3Bull, 0x662F8676D0C9B1A2ull,
    0xF47569EA2A8E7435ull, 0xF9ACDDCE22B989ACull, 0xEFC601A23AE18F07ull, 0xE21FB58632D6729Eull,
    0xC313B97A0A518251ull, 0xCECA0D5E02667FC8ull, 0xD8A0D1321A3E7963ull, 0xD5796516120984FAull,
    0x9AB8C8CA6B3198FDull, 0x97617CEE63066564ull, 0x810BA0827B5E63CFull, 0x8CD214A673699E56ull,
    0xADDE185A4BEE6E99ull, 0xA007AC7E43D99300ull, 0xB66D70125B8195ABull, 0xBBB4C43653B66832ull,
    0x53DC575553E35B4Aull, 0x5E05E3715BD4A6D3ull, 0x486F3F1D438CA078ull, 0x45B68B394BBB5DE1ull,
    0x64BA87C5733CAD2Eull, 0x696333E17B0B50B7ull, 0x7F09EF8D6353561Cull, 0x72D05BA96B64AB85ull,
    0x3D11F675125CB782ull, 0x30C842511A6B4A1Bull, 0x26A29E3D02334CB0ull, 0x2B7B2A190A04B129ull,
    0x0A7726E5328341E6ull, 0x07AE92C13AB4BC7Full, 0x11C44EAD22ECBAD4ull, 0x1C1DFA892ADB474Dull,
    0x8E471515D09C82DAull, 0x839EA131D8AB7F43ull, 0x95F47D5DC0F379E8ull, 0x982DC979C8C48471ull,
    0xB921C585F04374BEull, 0xB4F871A1F8748927ull, 0xA292ADCDE02C8F8Cull, 0xAF4B19E9E81B7215ull,
    0xE08AB43591236E12ull, 0xED5300119914938Bull, 0xFB39DC7D814C9520ull, 0xF6E06859897B68B9ull,
    0xD7EC64A5B1FC9876ull, 0xDA35D081B9CB65EFull, 0xCC5F0CEDA1936344ull, 0xC186B8C9A9A49EDDull,
    0x7A327CFFFA12F6EFull, 0x77EBC8DBF2250B76ull, 0x618114B7EA7D0DDDull, 0x6C58A093E24AF044ull,
    0x4D54AC6FDACD008Bull, 0x408D184BD2FAFD12ull, 0x56E7C427CAA2FBB9ull, 0x5B3E7003C2950620ull,
    0x14FFDDDFBBAD1A27ull, 0x192669FBB39AE7BEull, 0x0F4CB597ABC2E115ull, 0x029501B3A3F51C8Cull,
    0x23990D4F9B72EC43ull, 0x2E40B96B934511DAull, 0x382A65078B1D1771ull, 0x35F3D123832AEAE8ull,
    0xA7A93EBF796D2F7Full, 0xAA708A9B715AD2E6ull, 0xBC1A56F76902D44Dull, 0xB1C3E2D3613529D4ull,
    0x90CFEE2F59B2D91Bull, 0x9D165A0B51852482ull, 0x8B7C866749DD2229ull, 0x86A5324341EADFB0ull,
    0xC9649F9F38D2C3B7ull, 0xC4BD2BBB30E53E2Eull, 0xD2D7F7D728BD3885ull, 0xDF0E43F3208AC51Cull,
    0xFE024F0F180D35D3ull, 0xF3DBFB2B103AC84Aull, 0xE5B127470862CEE1ull, 0xE868936300553378ull,
    0xA7B8AEAAA7C6B694ull, 0xAA611A8EAFF14B0Dull, 0xBC0BC6E2B7A94DA6ull, 0xB1D272C6BF9EB03Full,
    0x90DE7E3A871940F0ull, 0x9D07CA1E8F2EBD69ull, 0x8B6D16729776BBC2ull, 0x86B4A2569F41465Bull,
    0xC9750F8AE6795A5Cull, 0xC4ACBBAEEE4EA7C5ull, 0xD2C667C2F616A16Eull, 0xDF1FD3E6FE215CF7ull,
    0xFE13DF1AC6A6AC38ull, 0xF3CA6B3ECE9151A1ull, 0xE5A0B752D6C9570Aull, 0xE8790376DEFEAA93ull,
    0x7A23ECEA24B96F04ull, 0x77FA58CE2C8E929Dull, 0x619084A234D69436ull, 0x6C4930863CE169AFull,
    0x4D453C7A04669960ull, 0x409C885E0C5164F9ull, 0x56F6543214096252ull, 0x5B2FE0161C3E9FCBull,
    0x14EE4DCA650683CCull, 0x1937F9EE6D317E55ull, 0x0F5D2582756978FEull, 0x028491A67D5E8567ull,
    0x23889D5A45D975A8ull, 0x2E51297E4DEE8831ull, 0x383BF51255B68E9Aull, 0x35E241365D817303ull,
    0x8E5685000E371B31ull, 0x838F31240600E6A8ull, 0x95E5ED481E58E003ull, 0x983C596C166F1D9Aull,
    0xB93055902EE8ED55ull, 0xB4E9E1B426DF10CCull, 0xA2833DD83E871667ull, 0xAF5A89FC36B0EBFEull,
    0xE09B24204F88F7F9ull, 0xED42900447BF0A60ull, 0xFB284C685FE70CCBull, 0xF6F1F84C57D0F152ull,
    0xD7FDF4B06F57019Dull, 0xDA2440946760FC04ull, 0xCC4E9CF87F38FAAFull, 0xC19728DC770F0736ull,
    0x53CDC7408D48C2A1ull, 0x5E147364857F3F38ull, 0x487EAF089D273993ull, 0x45A71B2C9510C40Aull,
    0x64AB17D0AD9734C5ull, 0x6972A3F4A5A0C95Cull, 0x7F187F98BDF8CFF7ull, 0x72C1CBBCB5CF326Eull,
    0x3D006660CCF72E69ull, 0x30D9D244C4C0D3F0ull, 0x26B30E28DC98D55Bull, 0x2B6ABA0CD4AF28C2ull,
    0x0A66B6F0EC28D80Dull, 0x07BF02D4E41F2594ull, 0x11D5DEB8FC47233Full, 0x1C0C6A9CF470DEA6ull,
    0xF464F9FFF425EDDEull, 0xF9BD4DDBFC121047ull, 0xEFD791B7E44A16ECull, 0xE20E2593EC7DEB75ull,
    0xC302296FD4FA1BBAull, 0xCEDB9D4BDCCDE623ull, 0xD8B14127C495E088ull, 0xD568F503CCA21D11ull,
    0x9AA958DFB59A0116ull, 0x9770ECFBBDADFC8Full, 0x811A3097A5F5FA24ull, 0x8CC384B3ADC207BDull,
    0xADCF884F9545F772ull, 0xA0163C6B9D720AEBull, 0xB67CE007852A0C40ull, 0xBBA554238D1DF1D9ull,
    0x29FFBBBF775A344Eull, 0x24260F9B7F6DC9D7ull, 0x324CD3F76735CF7Cull, 0x3F9567D36F0232E5ull,
    0x1E996B2F5785C22Aull, 0x1340DF0B5FB23FB3ull, 0x052A036747EA3918ull, 0x08F3B7434FDDC481ull,
    0x47321A9F36E5D886ull, 0x4AEBAEBB3ED2251Full, 0x5C8172D7268A23B4ull, 0x5158C6F32EBDDE2Dull,
    0x7054CA0F163A2EE2ull, 0x7D8D7E2B1E0DD37Bull, 0x6BE7A2470655D5D0ull, 0x663E16630E622849ull,
    0xDD8AD2555DD4407Bull, 0xD053667155E3BDE2ull, 0xC639BA1D4DBBBB49ull, 0xCBE00E39458C46D0ull,
    0xEAEC02C57D0BB61Full, 0xE735B6E1753C4B86ull, 0xF15F6A8D6D644D2Dull, 0xFC86DEA96553B0B4ull,
    0xB34773751C6BACB3ull, 0xBE9EC751145C512Aull, 0xA8F41B3D0C045781ull, 0xA52DAF190433AA18ull,
    0x8421A3E53CB45AD7ull, 0x89F817C13483A74Eull, 0x9F92CBAD2CDBA1E5ull, 0x924B7F8924EC5C7Cull,
    0x00119015DEAB99EBull, 0x0DC82431D69C6472ull, 0x1BA2F85DCEC462D9ull, 0x167B4C79C6F39F40ull,
    0x37774085FE746F8Full, 0x3AAEF4A1F6439216ull, 0x2CC428CDEE1B94BDull, 0x211D9CE9E62C6924ull,
    0x6EDC31359F147523ull, 0x63058511972388BAull, 0x756F597D8F7B8E11ull, 0x78B6ED59874C7388ull,
    0x59BAE1A5BFCB8347ull, 0x54635581B7FC7EDEull, 0x420989EDAFA47875ull, 0x4FD03DC9A79385ECull,
};
static const uint64_t Crc64XzTable14[256] = {
    0x0000000000000000ull, 0xF075E4AE5E05BDFFull, 0x723366771305657Bull, 0x824682D94D00D884ull,
    0xE466CCEE260ACAF6ull, 0x14132840780F7709ull, 0x9655AA99350FAF8Dull, 0x66204E376B0A1272ull,
    0x5A1536F7E31B8B69ull, 0xAA60D259BD1E3696ull, 0x28265080F01EEE12ull, 0xD853B42EAE1B53EDull,
    0xBE73FA19C511419Full, 0x4E061EB79B14FC60ull, 0xCC409C6ED61424E4ull, 0x3C3578C08811991Bull,
    0xB42A6DEFC63716D2ull, 0x445F89419832AB2Dull, 0xC6190B98D53273A9ull, 0x366CEF368B37CE56ull,
    0x504CA101E03DDC24ull, 0xA03945AFBE3861DBull, 0x227FC776F338B95Full, 0xD20A23D8AD3D04A0ull,
    0xEE3F5B18252C9DBBull, 0x1E4ABFB67B292044ull, 0x9C0C3D6F3629F8C0ull, 0x6C79D9C1682C453Full,
    0x0A5997F60326574Dull, 0xFA2C73585D23EAB2ull, 0x786AF18110233236ull, 0x881F152F4E268FC9ull,
    0xFA8C74F423603321ull, 0x0AF9905A7D658EDEull, 0x88BF12833065565Aull, 0x78CAF62D6E60EBA5ull,
    0x1EEAB81A056AF9D7ull, 0xEE9F5CB45B6F4428ull, 0x6CD9DE6D166F9CACull, 0x9CAC3AC3486A2153ull,
    0xA0994203C07BB848ull, 0x50ECA6AD9E7E05B7ull, 0xD2AA2474D37EDD33ull, 0x22DFC0DA8D7B60CCull,
    0x44FF8EEDE67172BEull, 0xB48A6A43B874CF41ull, 0x36CCE89AF57417C5ull, 0xC6B90C34AB71AA3Aull,
    0x4EA6191BE55725F3ull, 0xBED3FDB5BB52980Cull, 0x3C957F6CF6524088ull, 0xCCE09BC2A857FD77ull,
    0xAAC0D5F5C35DEF05ull, 0x5AB5315B9D5852FAull, 0xD8F3B382D0588A7Eull, 0x2886572C8E5D3781ull,
    0x14B32FEC064CAE9Aull, 0xE4C6CB4258491365ull, 0x6680499B1549CBE1ull, 0x96F5AD354B4C761Eull,
    0xF0D5E3022046646Cull, 0x00A007AC7E43D993ull, 0x82E6857533430117ull, 0x729361DB6D46BCE8ull,
    0x67C046C3E9CE78C7ull, 0x97B5A26DB7CBC538ull, 0x15F320B4FACB1DBCull, 0xE586C41AA4CEA043ull,
    0x83A68A2DCFC4B231ull, 0x73D36E8391C10FCEull, 0xF195EC5ADCC1D74Aull, 0x01E008F482C46AB5ull,
    0x3DD570340AD5F3AEull, 0xCDA0949A54D04E51ull, 0x4FE6164319D096D5ull, 0xBF93F2ED47D52B2Aull,
    0xD9B3BCDA2CDF3958ull, 0x29C6587472DA84A7ull, 0xAB80DAAD3FDA5C23ull, 0x5BF53E0361DFE1DCull,
    0xD3EA2B2C2FF96E15ull, 0x239FCF8271FCD3EAull, 0xA1D94D5B3CFC0B6Eull, 0x51ACA9F562F9B691ull,
    0x378CE7C209F3A4E3ull, 0xC7F9036C57F6191Cull, 0x45BF81B51AF6C198ull, 0xB5CA651B44F37C67ull,
    0x89FF1DDBCCE2E57Cull, 0x798AF97592E75883ull, 0xFBCC7BACDFE78007ull, 0x0BB99F0281E23DF8ull,
    0x6D99D135EAE82F8Aull, 0x9DEC359BB4ED9275ull, 0x1FAAB742F9ED4AF1ull, 0xEFDF53ECA7E8F70Eull,
    0x9D4C3237CAAE4BE6ull, 0x6D39D69994ABF619ull, 0xEF7F5440D9AB2E9Dull, 0x1F0AB0EE87AE9362ull,
    0x792AFED9ECA48110ull, 0x895F1A77B2A13CEFull, 0x0B1998AEFFA1E46Bull, 0xFB6C7C00A1A45994ull,
    0xC75904C029B5C08Full, 0x372CE06E77B07D70ull, 0xB56A62B73AB0A5F4ull, 0x451F861964B5180Bull,
    0x233FC82E0FBF0A79ull, 0xD34A2C8051BAB786ull, 0x510CAE591CBA6F02ull, 0xA1794AF742BFD2FDull,
    0x29665FD80C995D34ull, 0xD913BB76529CE0CBull, 0x5B5539AF1F9C384Full, 0xAB20DD01419985B0ull,
    0xCD0093362A9397C2ull, 0x3D75779874962A3Dull, 0xBF33F5413996F2B9ull, 0x4F4611EF67934F46ull,
    0x7373692FEF82D65Dull, 0x83068D81B1876BA2ull, 0x01400F58FC87B326ull, 0xF135EBF6A2820ED9ull,
    0x9715A5C1C9881CABull, 0x6760416F978DA154ull, 0xE526C3B6DA8D79D0ull, 0x155327188488C42Full,
    0xCF808D87D39CF18Eull, 0x3FF569298D994C71ull, 0xBDB3EBF0C09994F5ull, 0x4DC60F5E9E9C290Aull,
    0x2BE64169F5963B78ull, 0xDB93A5C7AB938687ull, 0x59D5271EE6935E03ull, 0xA9A0C3B0B896E3FCull,
    0x9595BB7030877AE7ull, 0x65E05FDE6E82C718ull, 0xE7A6DD0723821F9Cull, 0x17D339A97D87A263ull,
    0x71F3779E168DB011ull, 0x8186933048880DEEull, 0x03C011E90588D56Aull, 0xF3B5F5475B8D6895ull,
    0x7BAAE06815ABE75Cull, 0x8BDF04C64BAE5AA3ull, 0x0999861F06AE8227ull, 0xF9EC62B158AB3FD8ull,
    0x9FCC2C8633A12DAAull, 0x6FB9C8286DA49055ull, 0xEDFF4AF120A448D1ull, 0x1D8AAE5F7EA1F52Eull,
    0x21BFD69FF6B06C35ull, 0xD1CA3231A8B5D1CAull, 0x538CB0E8E5B5094Eull, 0xA3F95446BBB0B4B1ull,
    0xC5D91A71D0BAA6C3ull, 0x35ACFEDF8EBF1B3Cull, 0xB7EA7C06C3BFC3B8ull, 0x479F98A89DBA7E47ull,
    0x350CF973F0FCC2AFull, 0xC5791DDDAEF97F50ull, 0x473F9F04E3F9A7D4ull, 0xB74A7BAABDFC1A2Bull,
    0xD16A359DD6F60859ull, 0x211FD13388F3B5A6ull, 0xA35953EAC5F36D22ull, 0x532CB7449BF6D0DDull,
    0x6F19CF8413E749C6ull, 0x9F6C2B2A4DE2F439ull, 0x1D2AA9F300E22CBDull, 0xED5F4D5D5EE79142ull,
    0x8B7F036A35ED8330ull, 0x7B0AE7C46BE83ECFull, 0xF94C651D26E8E64Bull, 0x093981B378ED5BB4ull,
    0x8126949C36CBD47Dull, 0x7153703268CE6982ull, 0xF315F2EB25CEB106ull, 0x036016457BCB0CF9ull,
    0x6540587210C11E8Bull, 0x9535BCDC4EC4A374ull, 0x17733E0503C47BF0ull, 0xE706DAAB5DC1C60Full,
    0xDB33A26BD5D05F14ull, 0x2B4646C58BD5E2EBull, 0xA900C41CC6D53A6Full, 0x597520B298D08790ull,
    0x3F556E85F3DA95E2ull, 0xCF208A2BADDF281Dull, 0x4D6608F2E0DFF099ull, 0xBD13EC5CBEDA4D66ull,
    0xA840CB443A528949ull, 0x58352FEA645734B6ull, 0xDA73AD332957EC32ull, 0x2A06499D775251CDull,
    0x4C2607AA1C5843BFull, 0xBC53E304425DFE40ull, 0x3E1561DD0F5D26C4ull, 0xCE60857351589B3Bull,
    0xF255FDB3D9490220ull, 0x0220191D874CBFDFull, 0x80669BC4CA4C675Bull, 0x70137F6A9449DAA4ull,
    0x1633315DFF43C8D6ull, 0xE646D5F3A1467529ull, 0x6400572AEC46ADADull, 0x9475B384B2431052ull,
    0x1C6AA6ABFC659F9Bull, 0xEC1F4205A2602264ull, 0x6E59C0DCEF60FAE0ull, 0x9E2C2472B165471Full,
    0xF80C6A45DA6F556Dull, 0x08798EEB846AE892ull, 0x8A3F0C32C96A3016ull, 0x7A4AE89C976F8DE9ull,
    0x467F905C1F7E14F2ull, 0xB60A74F2417BA90Dull, 0x344CF62B0C7B7189ull, 0xC4391285527ECC76ull,
    0xA2195CB23974DE04ull, 0x526CB81C677163FBull, 0xD02A3AC52A71BB7Full, 0x205FDE6B74740680ull,
    0x52CCBFB01932BA68ull, 0xA2B95B1E47370797ull, 0x20FFD9C70A37DF13ull, 0xD08A3D69543262ECull,
    0xB6AA735E3F38709Eull, 0x46DF97F0613DCD61ull, 0xC49915292C3D15E5ull, 0x34ECF1877238A81Aull,
    0x08D98947FA293101ull, 0xF8AC6DE9A42C8CFEull, 0x7AEAEF30E92C547Aull, 0x8A9F0B9EB729E985ull,
    0xECBF45A9DC23FBF7ull, 0x1CCAA10782264608ull, 0x9E8C23DECF269E8Cull, 0x6EF9C77091232373ull,
    0xE6E6D25FDF05ACBAull, 0x169336F181001145ull, 0x94D5B428CC00C9C1ull, 0x64A050869205743Eull,
    0x02801EB1F90F664Cull, 0xF2F5FA1FA70ADBB3ull, 0x70B378C6EA0A0337ull, 0x80C69C68B40FBEC8ull,
    0xBCF3E4A83C1E27D3ull, 0x4C860006621B9A2Cull, 0xCEC082DF2F1B42A8ull, 0x3EB56671711EFF57ull,
    0x589528461A14ED25ull, 0xA8E0CCE8441150DAull, 0x2AA64E310911885Eull, 0xDAD3AA9F571435A1ull,
};
static const uint64_t Crc64XzTable15[256] = {
    0x0000000000000000ull, 0xE05DD497CA393AE4ull, 0x526306043B7C6B4Dull, 0xB23ED293F14551A9ull,
    0xA4C60C0876F8D69Aull, 0x449BD89FBCC1EC7Eull, 0xF6A50A0C4D84BDD7ull, 0x16F8DE9B87BD8733ull,
    0xDB54B73B42FFB3B1ull, 0x3B0963AC88C68955ull, 0x8937B13F7983D8FCull, 0x696A65A8B3BAE218ull,
    0x7F92BB333407652Bull, 0x9FCF6FA4FE3E5FCFull, 0x2DF1BD370F7B0E66ull, 0xCDAC69A0C5423482ull,
    0x2471C15D2AF179E7ull, 0xC42C15CAE0C84303ull, 0x7612C759118D12AAull, 0x964F13CEDBB4284Eull,
    0x80B7CD555C09AF7Dull, 0x60EA19C296309599ull, 0xD2D4CB516775C430ull, 0x32891FC6AD4CFED4ull,
    0xFF257666680ECA56ull, 0x1F78A2F1A237F0B2ull, 0xAD4670625372A11Bull, 0x4D1BA4F5994B9BFFull,
    0x5BE37A6E1EF61CCCull, 0xBBBEAEF9D4CF2628ull, 0x09807C6A258A7781ull, 0xE9DDA8FDEFB34D65ull,
    0x48E382BA55E2F3CEull, 0xA8BE562D9FDBC92Aull, 0x1A8084BE6E9E9883ull, 0xFADD5029A4A7A267ull,
    0xEC258EB2231A2554ull, 0x0C785A25E9231FB0ull, 0xBE4688B618664E19ull, 0x5E1B5C21D25F74FDull,
    0x93B73581171D407Full, 0x73EAE116DD247A9Bull, 0xC1D433852C612B32ull, 0x2189E712E65811D6ull,
    0x3771398961E596E5ull, 0xD72CED1EABDCAC01ull, 0x65123F8D5A99FDA8ull, 0x854FEB1A90A0C74Cull,
    0x6C9243E77F138A29ull, 0x8CCF9770B52AB0CDull, 0x3EF145E3446FE164ull, 0xDEAC91748E56DB80ull,
    0xC8544FEF09EB5CB3ull, 0x28099B78C3D26657ull, 0x9A3749EB329737FEull, 0x7A6A9D7CF8AE0D1Aull,
    0xB7C6F4DC3DEC3998ull, 0x579B204BF7D5037Cull, 0xE5A5F2D8069052D5ull, 0x05F8264FCCA96831ull,
    0x1300F8D44B14EF02ull, 0xF35D2C43812DD5E6ull, 0x4163FED07068844Full, 0xA13E2A47BA51BEABull,
    0x91C70574ABC5E79Cull, 0x719AD1E361FCDD78ull, 0xC3A4037090B98CD1ull, 0x23F9D7E75A80B635ull,
    0x3501097CDD3D3106ull, 0xD55CDDEB17040BE2ull, 0x67620F78E6415A4Bull, 0x873FDBEF2C7860AFull,
    0x4A93B24FE93A542Dull, 0xAACE66D823036EC9ull, 0x18F0B44BD2463F60ull, 0xF8AD60DC187F0584ull,
    0xEE55BE479FC282B7ull, 0x0E086AD055FBB853ull, 0xBC36B843A4BEE9FAull, 0x5C6B6CD46E87D31Eull,
    0xB5B6C42981349E7Bull, 0x55EB10BE4B0DA49Full, 0xE7D5C22DBA48F536ull, 0x078816BA7071CFD2ull,
    0x1170C821F7CC48E1ull, 0xF12D1CB63DF57205ull, 0x4313CE25CCB023ACull, 0xA34E1AB206891948ull,
    0x6EE27312C3CB2DCAull, 0x8EBFA78509F2172Eull, 0x3C817516F8B74687ull, 0xDCDCA181328E7C63ull,
    0xCA247F1AB533FB50ull, 0x2A79AB8D7F0AC1B4ull, 0x9847791E8E4F901Dull, 0x781AAD894476AAF9ull,
    0xD92487CEFE271452ull, 0x39795359341E2EB6ull, 0x8B4781CAC55B7F1Full, 0x6B1A555D0F6245FBull,
    0x7DE28BC688DFC2C8ull, 0x9DBF5F5142E6F82Cull, 0x2F818DC2B3A3A985ull, 0xCFDC5955799A9361ull,
    0x027030F5BCD8A7E3ull, 0xE22DE46276E19D07ull, 0x501336F187A4CCAEull, 0xB04EE2664D9DF64Aull,
    0xA6B63CFDCA207179ull, 0x46EBE86A00194B9Dull, 0xF4D53AF9F15C1A34ull, 0x1488EE6E3B6520D0ull,
    0xFD554693D4D66DB5ull, 0x1D0892041EEF5751ull, 0xAF364097EFAA06F8ull, 0x4F6B940025933C1Cull,
    0x59934A9BA22EBB2Full, 0xB9CE9E0C681781CBull, 0x0BF04C9F9952D062ull, 0xEBAD9808536BEA86ull,
    0x2601F1A89629DE04ull, 0xC65C253F5C10E4E0ull, 0x7462F7ACAD55B549ull, 0x943F233B676C8FADull,
    0x82C7FDA0E0D1089Eull, 0x629A29372AE8327Aull, 0xD0A4FBA4DBAD63D3ull, 0x30F92F3311945937ull,
    0xB156A5C2F885D1BDull, 0x510B715532BCEB59ull, 0xE335A3C6C3F9BAF0ull, 0x0368775109C08014ull,
    0x1590A9CA8E7D0727ull, 0xF5CD7D5D44443DC3ull, 0x47F3AFCEB5016C6Aull, 0xA7AE7B597F38568Eull,
    0x6A0212F9BA7A620Cull, 0x8A5FC66E704358E8ull, 0x386114FD81060941ull, 0xD83CC06A4B3F33A5ull,
    0xCEC41EF1CC82B496ull, 0x2E99CA6606BB8E72ull, 0x9CA718F5F7FEDFDBull, 0x7CFACC623DC7E53Full,
    0x9527649FD274A85Aull, 0x757AB008184D92BEull, 0xC744629BE908C317ull, 0x2719B60C2331F9F3ull,
    0x31E16897A48C7EC0ull, 0xD1BCBC006EB54424ull, 0x63826E939FF0158Dull, 0x83DFBA0455C92F69ull,
    0x4E73D3A4908B1BEBull, 0xAE2E07335AB2210Full, 0x1C10D5A0ABF770A6ull, 0xFC4D013761CE4A42ull,
    0xEAB5DFACE673CD71ull, 0x0AE80B3B2C4AF795ull, 0xB8D6D9A8DD0FA63Cull, 0x588B0D3F17369CD8ull,
    0xF9B52778AD672273ull, 0x19E8F3EF675E1897ull, 0xABD6217C961B493Eull, 0x4B8BF5EB5C2273DAull,
    0x5D732B70DB9FF4E9ull, 0xBD2EFFE711A6CE0Dull, 0x0F102D74E0E39FA4ull, 0xEF4DF9E32ADAA540ull,
    0x22E19043EF9891C2ull, 0xC2BC44D425A1AB26ull, 0x70829647D4E4FA8Full, 0x90DF42D01EDDC06Bull,
    0x86279C4B99604758ull, 0x667A48DC53597DBCull, 0xD4449A4FA21C2C15ull, 0x34194ED8682516F1ull,
    0xDDC4E62587965B94ull, 0x3D9932B24DAF6170ull, 0x8FA7E021BCEA30D9ull, 0x6FFA34B676D30A3Dull,
    0x7902EA2DF16E8D0Eull, 0x995F3EBA3B57B7EAull, 0x2B61EC29CA12E643ull, 0xCB3C38BE002BDCA7ull,
    0x0690511EC569E825ull, 0xE6CD85890F50D2C1ull, 0x54F3571AFE158368ull, 0xB4AE838D342CB98Cull,
    0xA2565D16B3913EBFull, 0x420B898179A8045Bull, 0xF0355B1288ED55F2ull, 0x10688F8542D46F16ull,
    0x2091A0B653403621ull, 0xC0CC742199790CC5ull, 0x72F2A6B2683C5D6Cull, 0x92AF7225A2056788ull,
    0x8457ACBE25B8E0BBull, 0x640A7829EF81DA5Full, 0xD634AABA1EC48BF6ull, 0x36697E2DD4FDB112ull,
    0xFBC5178D11BF8590ull, 0x1B98C31ADB86BF74ull, 0xA9A611892AC3EEDDull, 0x49FBC51EE0FAD439ull,
    0x5F031B856747530Aull, 0xBF5ECF12AD7E69EEull, 0x0D601D815C3B3847ull, 0xED3DC916960202A3ull,
    0x04E061EB79B14FC6ull, 0xE4BDB57CB3887522ull, 0x568367EF42CD248Bull, 0xB6DEB37888F41E6Full,
    0xA0266DE30F49995Cull, 0x407BB974C570A3B8ull, 0xF2456BE73435F211ull, 0x1218BF70FE0CC8F5ull,
    0xDFB4D6D03B4EFC77ull, 0x3FE90247F177C693ull, 0x8DD7D0D40032973Aull, 0x6D8A0443CA0BADDEull,
    0x7B72DAD84DB62AEDull, 0x9B2F0E4F878F1009ull, 0x2911DCDC76CA41A0ull, 0xC94C084BBCF37B44ull,
    0x6872220C06A2C5EFull, 0x882FF69BCC9BFF0Bull, 0x3A1124083DDEAEA2ull, 0xDA4CF09FF7E79446ull,
    0xCCB42E04705A1375ull, 0x2CE9FA93BA632991ull, 0x9ED728004B267838ull, 0x7E8AFC97811F42DCull,
    0xB3269537445D765Eull, 0x537B41A08E644CBAull, 0xE14593337F211D13ull, 0x011847A4B51827F7ull,
    0x17E0993F32A5A0C4ull, 0xF7BD4DA8F89C9A20ull, 0x45839F3B09D9CB89ull, 0xA5DE4BACC3E0F16Dull,
    0x4C03E3512C53BC08ull, 0xAC5E37C6E66A86ECull, 0x1E60E555172FD745ull, 0xFE3D31C2DD16EDA1ull,
    0xE8C5EF595AAB6A92ull, 0x08983BCE90925076ull, 0xBAA6E95D61D701DFull, 0x5AFB3DCAABEE3B3Bull,
    0x9757546A6EAC0FB9ull, 0x770A80FDA495355Dull, 0xC534526E55D064F4ull, 0x256986F99FE95E10ull,
    0x339158621854D923ull, 0xD3CC8CF5D26DE3C7ull, 0x61F25E662328B26Eull, 0x81AF8AF1E911888Aull,
};

static const uint64_t Crc64NvmeTable0[256] = {
    0x0000000000000000ull, 0x7F6EF0C830358979ull, 0xFEDDE190606B12F2ull, 0x81B31158505E9B8Bull,
    0xC962E5739841B68Full, 0xB60C15BBA8743FF6ull, 0x37BF04E3F82AA47Dull, 0x48D1F42BC81F2D04ull,
    0xA61CECB46814FE75ull, 0xD9721C7C5821770Cull, 0x58C10D24087FEC87ull, 0x27AFFDEC384A65FEull,
    0x6F7E09C7F05548FAull, 0x1010F90FC060C183ull, 0x91A3E857903E5A08ull, 0xEECD189FA00BD371ull,
    0x78E0FF3B88BE6F81ull, 0x078E0FF3B88BE6F8ull, 0x863D1EABE8D57D73ull, 0xF953EE63D8E0F40Aull,
    0xB1821A4810FFD90Eull, 0xCEECEA8020CA5077ull, 0x4F5FFBD87094CBFCull, 0x30310B1040A14285ull,
    0xDEFC138FE0AA91F4ull, 0xA192E347D09F188Dull, 0x2021F21F80C18306ull, 0x5F4F02D7B0F40A7Full,
    0x179EF6FC78EB277Bull, 0x68F0063448DEAE02ull, 0xE943176C18803589ull, 0x962DE7A428B5BCF0ull,
    0xF1C1FE77117CDF02ull, 0x8EAF0EBF2149567Bull, 0x0F1C1FE77117CDF0ull, 0x7072EF2F41224489ull,
    0x38A31B04893D698Dull, 0x47CDEBCCB908E0F4ull, 0xC67EFA94E9567B7Full, 0xB9100A5CD963F206ull,
    0x57DD12C379682177ull, 0x28B3E20B495DA80Eull, 0xA900F35319033385ull, 0xD66E039B2936BAFCull,
    0x9EBFF7B0E12997F8ull, 0xE1D10778D11C1E81ull, 0x606216208142850Aull, 0x1F0CE6E8B1770C73ull,
    0x8921014C99C2B083ull, 0xF64FF184A9F739FAull, 0x77FCE0DCF9A9A271ull, 0x08921014C99C2B08ull,
    0x4043E43F0183060Cull, 0x3F2D14F731B68F75ull, 0xBE9E05AF61E814FEull, 0xC1F0F56751DD9D87ull,
    0x2F3DEDF8F1D64EF6ull, 0x50531D30C1E3C78Full, 0xD1E00C6891BD5C04ull, 0xAE8EFCA0A188D57Dull,
    0xE65F088B6997F879ull, 0x9931F84359A27100ull, 0x1882E91B09FCEA8Bull, 0x67EC19D339C963F2ull,
    0xD75ADABD7A6E2D6Full, 0xA8342A754A5BA416ull, 0x29873B2D1A053F9Dull, 0x56E9CBE52A30B6E4ull,
    0x1E383FCEE22F9BE0ull, 0x6156CF06D21A1299ull, 0xE0E5DE5E82448912ull, 0x9F8B2E96B271006Bull,
    0x71463609127AD31Aull, 0x0E28C6C1224F5A63ull, 0x8F9BD7997211C1E8ull, 0xF0F5275142244891ull,
    0xB824D37A8A3B6595ull, 0xC74A23B2BA0EECECull, 0x46F932EAEA507767ull, 0x3997C222DA65FE1Eull,
    0xAFBA2586F2D042EEull, 0xD0D4D54EC2E5CB97ull, 0x5167C41692BB501Cull, 0x2E0934DEA28ED965ull,
    0x66D8C0F56A91F461ull, 0x19B6303D5AA47D18ull, 0x980521650AFAE693ull, 0xE76BD1AD3ACF6FEAull,
    0x09A6C9329AC4BC9Bull, 0x76C839FAAAF135E2ull, 0xF77B28A2FAAFAE69ull, 0x8815D86ACA9A2710ull,
    0xC0C42C4102850A14ull, 0xBFAADC8932B0836Dull, 0x3E19CDD162EE18E6ull, 0x41773D1952DB919Full,
    0x269B24CA6B12F26Dull, 0x59F5D4025B277B14ull, 0xD846C55A0B79E09Full, 0xA72835923B4C69E6ull,
    0xEFF9C1B9F35344E2ull, 0x90973171C366CD9Bull, 0x1124202993385610ull, 0x6E4AD0E1A30DDF69ull,
    0x8087C87E03060C18ull, 0xFFE938B633338561ull, 0x7E5A29EE636D1EEAull, 0x0134D92653589793ull,
    0x49E52D0D9B47BA97ull, 0x368BDDC5AB7233EEull, 0xB738CC9DFB2CA865ull, 0xC8563C55CB19211Cull,
    0x5E7BDBF1E3AC9DECull, 0x21152B39D3991495ull, 0xA0A63A6183C78F1Eull, 0xDFC8CAA9B3F20667ull,
    0x97193E827BED2B63ull, 0xE877CE4A4BD8A21Aull, 0x69C4DF121B863991ull, 0x16AA2FDA2BB3B0E8ull,
    0xF86737458BB86399ull, 0x8709C78DBB8DEAE0ull, 0x06BAD6D5EBD3716Bull, 0x79D4261DDBE6F812ull,
    0x3105D23613F9D516ull, 0x4E6B22FE23CC5C6Full, 0xCFD833A67392C7E4ull, 0xB0B6C36E43A74E9Dull,
    0x9A6C9329AC4BC9B5ull, 0xE50263E19C7E40CCull, 0x64B172B9CC20DB47ull, 0x1BDF8271FC15523Eull,
    0x530E765A340A7F3Aull, 0x2C608692043FF643ull, 0xADD397CA54616DC8ull, 0xD2BD67026454E4B1ull,
    0x3C707F9DC45F37C0ull, 0x431E8F55F46ABEB9ull, 0xC2AD9E0DA4342532ull, 0xBDC36EC59401AC4Bull,
    0xF5129AEE5C1E814Full, 0x8A7C6A266C2B0836ull, 0x0BCF7B7E3C7593BDull, 0x74A18BB60C401AC4ull,
    0xE28C6C1224F5A634ull, 0x9DE29CDA14C02F4Dull, 0x1C518D82449EB4C6ull, 0x633F7D4A74AB3DBFull,
    0x2BEE8961BCB410BBull, 0x548079A98C8199C2ull, 0xD53368F1DCDF0249ull, 0xAA5D9839ECEA8B30ull,
    0x449080A64CE15841ull, 0x3BFE706E7CD4D138ull, 0xBA4D61362C8A4AB3ull, 0xC52391FE1CBFC3CAull,
    0x8DF265D5D4A0EECEull, 0xF29C951DE49567B7ull, 0x732F8445B4CBFC3Cull, 0x0C41748D84FE7545ull,
    0x6BAD6D5EBD3716B7ull, 0x14C39D968D029FCEull, 0x95708CCEDD5C0445ull, 0xEA1E7C06ED698D3Cull,
    0xA2CF882D2576A038ull, 0xDDA178E515432941ull, 0x5C1269BD451DB2CAull, 0x237C997575283BB3ull,
    0xCDB181EAD523E8C2ull, 0xB2DF7122E51661BBull, 0x336C607AB548FA30ull, 0x4C0290B2857D7349ull,
    0x04D364994D625E4Dull, 0x7BBD94517D57D734ull, 0xFA0E85092D094CBFull, 0x856075C11D3CC5C6ull,
    0x134D926535897936ull, 0x6C2362AD05BCF04Full, 0xED9073F555E26BC4ull, 0x92FE833D65D7E2BDull,
    0xDA2F7716ADC8CFB9ull, 0xA54187DE9DFD46C0ull, 0x24F29686CDA3DD4Bull, 0x5B9C664EFD965432ull,
    0xB5517ED15D9D8743ull, 0xCA3F8E196DA80E3Aull, 0x4B8C9F413DF695B1ull, 0x34E26F890DC31CC8ull,
    0x7C339BA2C5DC31CCull, 0x035D6B6AF5E9B8B5ull, 0x82EE7A32A5B7233Eull, 0xFD808AFA9582AA47ull,
    0x4D364994D625E4DAull, 0x3258B95CE6106DA3ull, 0xB3EBA804B64EF628ull, 0xCC8558CC867B7F51ull,
    0x8454ACE74E645255ull, 0xFB3A5C2F7E51DB2Cull, 0x7A894D772E0F40A7ull, 0x05E7BDBF1E3AC9DEull,
    0xEB2AA520BE311AAFull, 0x944455E88E0493D6ull, 0x15F744B0DE5A085Dull, 0x6A99B478EE6F8124ull,
    0x224840532670AC20ull, 0x5D26B09B16452559ull, 0xDC95A1C3461BBED2ull, 0xA3FB510B762E37ABull,
    0x35D6B6AF5E9B8B5Bull, 0x4AB846676EAE0222ull, 0xCB0B573F3EF099A9ull, 0xB465A7F70EC510D0ull,
    0xFCB453DCC6DA3DD4ull, 0x83DAA314F6EFB4ADull, 0x0269B24CA6B12F26ull, 0x7D0742849684A65Full,
    0x93CA5A1B368F752Eull, 0xECA4AAD306BAFC57ull, 0x6D17BB8B56E467DCull, 0x12794B4366D1EEA5ull,
    0x5AA8BF68AECEC3A1ull, 0x25C64FA09EFB4AD8ull, 0xA4755EF8CEA5D153ull, 0xDB1BAE30FE90582Aull,
    0xBCF7B7E3C7593BD8ull, 0xC399472BF76CB2A1ull, 0x422A5673A732292Aull, 0x3D44A6BB9707A053ull,
    0x759552905F188D57ull, 0x0AFBA2586F2D042Eull, 0x8B48B3003F739FA5ull, 0xF42643C80F4616DCull,
    0x1AEB5B57AF4DC5ADull, 0x6585AB9F9F784CD4ull, 0xE436BAC7CF26D75Full, 0x9B584A0FFF135E26ull,
    0xD389BE24370C7322ull, 0xACE74EEC0739FA5Bull, 0x2D545FB4576761D0ull, 0x523AAF7C6752E8A9ull,
    0xC41748D84FE75459ull, 0xBB79B8107FD2DD20ull, 0x3ACAA9482F8C46ABull, 0x45A459801FB9CFD2ull,
    0x0D75ADABD7A6E2D6ull, 0x721B5D63E7936BAFull, 0xF3A84C3BB7CDF024ull, 0x8CC6BCF387F8795Dull,
    0x620BA46C27F3AA2Cull, 0x1D6554A417C62355ull, 0x9CD645FC4798B8DEull, 0xE3B8B53477AD31A7ull,
    0xAB69411FBFB21CA3ull, 0xD407B1D78F8795DAull, 0x55B4A08FDFD90E51ull, 0x2ADA5047EFEC8728ull,
};
static const uint64_t Crc64NvmeTable1[256] = {
    0x0000000000000000ull, 0x8776A97D73BDDF69ull, 0x3A3474A9BFEC2DB9ull, 0xBD42DDD4CC51F2D0ull,
    0x7468E9537FD85B72ull, 0xF31E402E0C65841Bull, 0x4E5C9DFAC03476CBull, 0xC92A3487B389A9A2ull,
    0xE8D1D2A6FFB0B6E4ull, 0x6FA77BDB8C0D698Dull, 0xD2E5A60F405C9B5Dull, 0x55930F7233E14434ull,
    0x9CB93BF58068ED96ull, 0x1BCF9288F3D532FFull, 0xA68D4F5C3F84C02Full, 0x21FBE6214C391F46ull,
    0xE57A831EA7F6FEA3ull, 0x620C2A63D44B21CAull, 0xDF4EF7B7181AD31Aull, 0x58385ECA6BA70C73ull,
    0x91126A4DD82EA5D1ull, 0x1664C330AB937AB8ull, 0xAB261EE467C28868ull, 0x2C50B799147F5701ull,
    0x0DAB51B858464847ull, 0x8ADDF8C52BFB972Eull, 0x379F2511E7AA65FEull, 0xB0E98C6C9417BA97ull,
    0x79C3B8EB279E1335ull, 0xFEB511965423CC5Cull, 0x43F7CC4298723E8Cull, 0xC481653FEBCFE1E5ull,
    0xFE2C206E177A6E2Dull, 0x795A891364C7B144ull, 0xC41854C7A8964394ull, 0x436EFDBADB2B9CFDull,
    0x8A44C93D68A2355Full, 0x0D3260401B1FEA36ull, 0xB070BD94D74E18E6ull, 0x370614E9A4F3C78Full,
    0x16FDF2C8E8CAD8C9ull, 0x918B5BB59B7707A0ull, 0x2CC986615726F570ull, 0xABBF2F1C249B2A19ull,
    0x62951B9B971283BBull, 0xE5E3B2E6E4AF5CD2ull, 0x58A16F3228FEAE02ull, 0xDFD7C64F5B43716Bull,
    0x1B56A370B08C908Eull, 0x9C200A0DC3314FE7ull, 0x2162D7D90F60BD37ull, 0xA6147EA47CDD625Eull,
    0x6F3E4A23CF54CBFCull, 0xE848E35EBCE91495ull, 0x550A3E8A70B8E645ull, 0xD27C97F70305392Cull,
    0xF38771D64F3C266Aull, 0x74F1D8AB3C81F903ull, 0xC9B3057FF0D00BD3ull, 0x4EC5AC02836DD4BAull,
    0x87EF988530E47D18ull, 0x009931F84359A271ull, 0xBDDBEC2C8F0850A1ull, 0x3AAD4551FCB58FC8ull,
    0xC881668F76634F31ull, 0x4FF7CFF205DE9058ull, 0xF2B51226C98F6288ull, 0x75C3BB5BBA32BDE1ull,
    0xBCE98FDC09BB1443ull, 0x3B9F26A17A06CB2Aull, 0x86DDFB75B65739FAull, 0x01AB5208C5EAE693ull,
    0x2050B42989D3F9D5ull, 0xA7261D54FA6E26BCull, 0x1A64C080363FD46Cull, 0x9D1269FD45820B05ull,
    0x54385D7AF60BA2A7ull, 0xD34EF40785B67DCEull, 0x6E0C29D349E78F1Eull, 0xE97A80AE3A5A5077ull,
    0x2DFBE591D195B192ull, 0xAA8D4CECA2286EFBull, 0x17CF91386E799C2Bull, 0x90B938451DC44342ull,
    0x59930CC2AE4DEAE0ull, 0xDEE5A5BFDDF03589ull, 0x63A7786B11A1C759ull, 0xE4D1D116621C1830ull,
    0xC52A37372E250776ull, 0x425C9E4A5D98D81Full, 0xFF1E439E91C92ACFull, 0x7868EAE3E274F5A6ull,
    0xB142DE6451FD5C04ull, 0x363477192240836Dull, 0x8B76AACDEE1171BDull, 0x0C0003B09DACAED4ull,
    0x36AD46E16119211Cull, 0xB1DBEF9C12A4FE75ull, 0x0C993248DEF50CA5ull, 0x8BEF9B35AD48D3CCull,
    0x42C5AFB21EC17A6Eull, 0xC5B306CF6D7CA507ull, 0x78F1DB1BA12D57D7ull, 0xFF877266D29088BEull,
    0xDE7C94479EA997F8ull, 0x590A3D3AED144891ull, 0xE448E0EE2145BA41ull, 0x633E499352F86528ull,
    0xAA147D14E171CC8Aull, 0x2D62D46992CC13E3ull, 0x902009BD5E9DE133ull, 0x1756A0C02D203E5Aull,
    0xD3D7C5FFC6EFDFBFull, 0x54A16C82B55200D6ull, 0xE9E3B1567903F206ull, 0x6E95182B0ABE2D6Full,
    0xA7BF2CACB93784CDull, 0x20C985D1CA8A5BA4ull, 0x9D8B580506DBA974ull, 0x1AFDF1787566761Dull,
    0x3B061759395F695Bull, 0xBC70BE244AE2B632ull, 0x013263F086B344E2ull, 0x8644CA8DF50E9B8Bull,
    0x4F6EFE0A46873229ull, 0xC8185777353AED40ull, 0x755A8AA3F96B1F90ull, 0xF22C23DE8AD6C0F9ull,
    0xA5DBEB4DB4510D09ull, 0x22AD4230C7ECD260ull, 0x9FEF9FE40BBD20B0ull, 0x189936997800FFD9ull,
    0xD1B3021ECB89567Bull, 0x56C5AB63B8348912ull, 0xEB8776B774657BC2ull, 0x6CF1DFCA07D8A4ABull,
    0x4D0A39EB4BE1BBEDull, 0xCA7C9096385C6484ull, 0x773E4D42F40D9654ull, 0xF048E43F87B0493Dull,
    0x3962D0B83439E09Full, 0xBE1479C547843FF6ull, 0x0356A4118BD5CD26ull, 0x84200D6CF868124Full,
    0x40A1685313A7F3AAull, 0xC7D7C12E601A2CC3ull, 0x7A951CFAAC4BDE13ull, 0xFDE3B587DFF6017Aull,
    0x34C981006C7FA8D8ull, 0xB3BF287D1FC277B1ull, 0x0EFDF5A9D3938561ull, 0x898B5CD4A02E5A08ull,
    0xA870BAF5EC17454Eull, 0x2F0613889FAA9A27ull, 0x9244CE5C53FB68F7ull, 0x153267212046B79Eull,
    0xDC1853A693CF1E3Cull, 0x5B6EFADBE072C155ull, 0xE62C270F2C233385ull, 0x615A8E725F9EECECull,
    0x5BF7CB23A32B6324ull, 0xDC81625ED096BC4Dull, 0x61C3BF8A1CC74E9Dull, 0xE6B516F76F7A91F4ull,
    0x2F9F2270DCF33856ull, 0xA8E98B0DAF4EE73Full, 0x15AB56D9631F15EFull, 0x92DDFFA410A2CA86ull,
    0xB32619855C9BD5C0ull, 0x3450B0F82F260AA9ull, 0x89126D2CE377F879ull, 0x0E64C45190CA2710ull,
    0xC74EF0D623438EB2ull, 0x403859AB50FE51DBull, 0xFD7A847F9CAFA30Bull, 0x7A0C2D02EF127C62ull,
    0xBE8D483D04DD9D87ull, 0x39FBE140776042EEull, 0x84B93C94BB31B03Eull, 0x03CF95E9C88C6F57ull,
    0xCAE5A16E7B05C6F5ull, 0x4D93081308B8199Cull, 0xF0D1D5C7C4E9EB4Cull, 0x77A77CBAB7543425ull,
    0x565C9A9BFB6D2B63ull, 0xD12A33E688D0F40Aull, 0x6C68EE32448106DAull, 0xEB1E474F373CD9B3ull,
    0x223473C884B57011ull, 0xA542DAB5F708AF78ull, 0x180007613B595DA8ull, 0x9F76AE1C48E482C1ull,
    0x6D5A8DC2C2324238ull, 0xEA2C24BFB18F9D51ull, 0x576EF96B7DDE6F81ull, 0xD01850160E63B0E8ull,
    0x19326491BDEA194Aull, 0x9E44CDECCE57C623ull, 0x23061038020634F3ull, 0xA470B94571BBEB9Aull,
    0x858B5F643D82F4DCull, 0x02FDF6194E3F2BB5ull, 0xBFBF2BCD826ED965ull, 0x38C982B0F1D3060Cull,
    0xF1E3B637425AAFAEull, 0x76951F4A31E770C7ull, 0xCBD7C29EFDB68217ull, 0x4CA16BE38E0B5D7Eull,
    0x88200EDC65C4BC9Bull, 0x0F56A7A1167963F2ull, 0xB2147A75DA289122ull, 0x3562D308A9954E4Bull,
    0xFC48E78F1A1CE7E9ull, 0x7B3E4EF269A13880ull, 0xC67C9326A5F0CA50ull, 0x410A3A5BD64D1539ull,
    0x60F1DC7A9A740A7Full, 0xE7877507E9C9D516ull, 0x5AC5A8D3259827C6ull, 0xDDB301AE5625F8AFull,
    0x14993529E5AC510Dull, 0x93EF9C5496118E64ull, 0x2EAD41805A407CB4ull, 0xA9DBE8FD29FDA3DDull,
    0x9376ADACD5482C15ull, 0x140004D1A6F5F37Cull, 0xA942D9056AA401ACull, 0x2E3470781919DEC5ull,
    0xE71E44FFAA907767ull, 0x6068ED82D92DA80Eull, 0xDD2A3056157C5ADEull, 0x5A5C992B66C185B7ull,
    0x7BA77F0A2AF89AF1ull, 0xFCD1D67759454598ull, 0x41930BA39514B748ull, 0xC6E5A2DEE6A96821ull,
    0x0FCF96595520C183ull, 0x88B93F24269D1EEAull, 0x35FBE2F0EACCEC3Aull, 0xB28D4B8D99713353ull,
    0x760C2EB272BED2B6ull, 0xF17A87CF01030DDFull, 0x4C385A1BCD52FF0Full, 0xCB4EF366BEEF2066ull,
    0x0264C7E10D6689C4ull, 0x85126E9C7EDB56ADull, 0x3850B348B28AA47Dull, 0xBF261A35C1377B14ull,
    0x9EDDFC148D0E6452ull, 0x19AB5569FEB3BB3Bull, 0xA4E988BD32E249EBull, 0x239F21C0415F9682ull,
    0xEAB51547F2D63F20ull, 0x6DC3BC3A816BE049ull, 0xD08161EE4D3A1299ull, 0x57F7C8933E87CDF0ull,
};
static const uint64_t Crc64NvmeTable2[256] = {
    0x0000000000000000ull, 0xFF6E4E1F4E4038BEull, 0xCA05BA6DC417E217ull, 0x356BF4728A57DAA9ull,
    0xA0D25288D0B85745ull, 0x5FBC1C979EF86FFBull, 0x6AD7E8E514AFB552ull, 0x95B9A6FA5AEF8DECull,
    0x757D8342F9E73DE1ull, 0x8A13CD5DB7A7055Full, 0xBF78392F3DF0DFF6ull, 0x4016773073B0E748ull,
    0xD5AFD1CA295F6AA4ull, 0x2AC19FD5671F521Aull, 0x1FAA6BA7ED4888B3ull, 0xE0C425B8A308B00Dull,
    0xEAFB0685F3CE7BC2ull, 0x1595489ABD8E437Cull, 0x20FEBCE837D999D5ull, 0xDF90F2F77999A16Bull,
    0x4A29540D23762C87ull, 0xB5471A126D361439ull, 0x802CEE60E761CE90ull, 0x7F42A07FA921F62Eull,
    0x9F8685C70A294623ull, 0x60E8CBD844697E9Dull, 0x55833FAACE3EA434ull, 0xAAED71B5807E9C8Aull,
    0x3F54D74FDA911166ull, 0xC03A995094D129D8ull, 0xF5516D221E86F371ull, 0x0A3F233D50C6CBCFull,
    0xE12F2B58BF0B64EFull, 0x1E416547F14B5C51ull, 0x2B2A91357B1C86F8ull, 0xD444DF2A355CBE46ull,
    0x41FD79D06FB333AAull, 0xBE9337CF21F30B14ull, 0x8BF8C3BDABA4D1BDull, 0x74968DA2E5E4E903ull,
    0x9452A81A46EC590Eull, 0x6B3CE60508AC61B0ull, 0x5E57127782FBBB19ull, 0xA1395C68CCBB83A7ull,
    0x3480FA9296540E4Bull, 0xCBEEB48DD81436F5ull, 0xFE8540FF5243EC5Cull, 0x01EB0EE01C03D4E2ull,
    0x0BD42DDD4CC51F2Dull, 0xF4BA63C202852793ull, 0xC1D197B088D2FD3Aull, 0x3EBFD9AFC692C584ull,
    0xAB067F559C7D4868ull, 0x5468314AD23D70D6ull, 0x6103C538586AAA7Full, 0x9E6D8B27162A92C1ull,
    0x7EA9AE9FB52222CCull, 0x81C7E080FB621A72ull, 0xB4AC14F27135C0DBull, 0x4BC25AED3F75F865ull,
    0xDE7BFC17659A7589ull, 0x2115B2082BDA4D37ull, 0x147E467AA18D979Eull, 0xEB100865EFCDAF20ull,
    0xF68770E226815AB5ull, 0x09E93EFD68C1620Bull, 0x3C82CA8FE296B8A2ull, 0xC3EC8490ACD6801Cull,
    0x5655226AF6390DF0ull, 0xA93B6C75B879354Eull, 0x9C509807322EEFE7ull, 0x633ED6187C6ED759ull,
    0x83FAF3A0DF666754ull, 0x7C94BDBF91265FEAull, 0x49FF49CD1B718543ull, 0xB69107D25531BDFDull,
    0x2328A1280FDE3011ull, 0xDC46EF37419E08AFull, 0xE92D1B45CBC9D206ull, 0x1643555A8589EAB8ull,
    0x1C7C7667D54F2177ull, 0xE31238789B0F19C9ull, 0xD679CC0A1158C360ull, 0x291782155F18FBDEull,
    0xBCAE24EF05F77632ull, 0x43C06AF04BB74E8Cull, 0x76AB9E82C1E09425ull, 0x89C5D09D8FA0AC9Bull,
    0x6901F5252CA81C96ull, 0x966FBB3A62E82428ull, 0xA3044F48E8BFFE81ull, 0x5C6A0157A6FFC63Full,
    0xC9D3A7ADFC104BD3ull, 0x36BDE9B2B250736Dull, 0x03D61DC03807A9C4ull, 0xFCB853DF7647917Aull,
    0x17A85BBA998A3E5Aull, 0xE8C615A5D7CA06E4ull, 0xDDADE1D75D9DDC4Dull, 0x22C3AFC813DDE4F3ull,
    0xB77A09324932691Full, 0x4814472D077251A1ull, 0x7D7FB35F8D258B08ull, 0x8211FD40C365B3B6ull,
    0x62D5D8F8606D03BBull, 0x9DBB96E72E2D3B05ull, 0xA8D06295A47AE1ACull, 0x57BE2C8AEA3AD912ull,
    0xC2078A70B0D554FEull, 0x3D69C46FFE956C40ull, 0x0802301D74C2B6E9ull, 0xF76C7E023A828E57ull,
    0xFD535D3F6A444598ull, 0x023D132024047D26ull, 0x3756E752AE53A78Full, 0xC838A94DE0139F31ull,
    0x5D810FB7BAFC12DDull, 0xA2EF41A8F4BC2A63ull, 0x9784B5DA7EEBF0CAull, 0x68EAFBC530ABC874ull,
    0x882EDE7D93A37879ull, 0x77409062DDE340C7ull, 0x422B641057B49A6Eull, 0xBD452A0F19F4A2D0ull,
    0x28FC8CF5431B2F3Cull, 0xD792C2EA0D5B1782ull, 0xE2F93698870CCD2Bull, 0x1D977887C94CF595ull,
    0xD9D7C79715952601ull, 0x26B989885BD51EBFull, 0x13D27DFAD182C416ull, 0xECBC33E59FC2FCA8ull,
    0x7905951FC52D7144ull, 0x866BDB008B6D49FAull, 0xB3002F72013A9353ull, 0x4C6E616D4F7AABEDull,
    0xACAA44D5EC721BE0ull, 0x53C40ACAA232235Eull, 0x66AFFEB82865F9F7ull, 0x99C1B0A76625C149ull,
    0x0C78165D3CCA4CA5ull, 0xF3165842728A741Bull, 0xC67DAC30F8DDAEB2ull, 0x3913E22FB69D960Cull,
    0x332CC112E65B5DC3ull, 0xCC428F0DA81B657Dull, 0xF9297B7F224CBFD4ull, 0x064735606C0C876Aull,
    0x93FE939A36E30A86ull, 0x6C90DD8578A33238ull, 0x59FB29F7F2F4E891ull, 0xA69567E8BCB4D02Full,
    0x465142501FBC6022ull, 0xB93F0C4F51FC589Cull, 0x8C54F83DDBAB8235ull, 0x733AB62295EBBA8Bull,
    0xE68310D8CF043767ull, 0x19ED5EC781440FD9ull, 0x2C86AAB50B13D570ull, 0xD3E8E4AA4553EDCEull,
    0x38F8ECCFAA9E42EEull, 0xC796A2D0E4DE7A50ull, 0xF2FD56A26E89A0F9ull, 0x0D9318BD20C99847ull,
    0x982ABE477A2615ABull, 0x6744F05834662D15ull, 0x522F042ABE31F7BCull, 0xAD414A35F071CF02ull,
    0x4D856F8D53797F0Full, 0xB2EB21921D3947B1ull, 0x8780D5E0976E9D18ull, 0x78EE9BFFD92EA5A6ull,
    0xED573D0583C1284Aull, 0x1239731ACD8110F4ull, 0x2752876847D6CA5Dull, 0xD83CC9770996F2E3ull,
    0xD203EA4A5950392Cull, 0x2D6DA45517100192ull, 0x180650279D47DB3Bull, 0xE7681E38D307E385ull,
    0x72D1B8C289E86E69ull, 0x8DBFF6DDC7A856D7ull, 0xB8D402AF4DFF8C7Eull, 0x47BA4CB003BFB4C0ull,
    0xA77E6908A0B704CDull, 0x58102717EEF73C73ull, 0x6D7BD36564A0E6DAull, 0x92159D7A2AE0DE64ull,
    0x07AC3B80700F5388ull, 0xF8C2759F3E4F6B36ull, 0xCDA981EDB418B19Full, 0x32C7CFF2FA588921ull,
    0x2F50B77533147CB4ull, 0xD03EF96A7D54440Aull, 0xE5550D18F7039EA3ull, 0x1A3B4307B943A61Dull,
    0x8F82E5FDE3AC2BF1ull, 0x70ECABE2ADEC134Full, 0x45875F9027BBC9E6ull, 0xBAE9118F69FBF158ull,
    0x5A2D3437CAF34155ull, 0xA5437A2884B379EBull, 0x90288E5A0EE4A342ull, 0x6F46C04540A49BFCull,
    0xFAFF66BF1A4B1610ull, 0x059128A0540B2EAEull, 0x30FADCD2DE5CF407ull, 0xCF9492CD901CCCB9ull,
    0xC5ABB1F0C0DA0776ull, 0x3AC5FFEF8E9A3FC8ull, 0x0FAE0B9D04CDE561ull, 0xF0C045824A8DDDDFull,
    0x6579E37810625033ull, 0x9A17AD675E22688Dull, 0xAF7C5915D475B224ull, 0x5012170A9A358A9Aull,
    0xB0D632B2393D3A97ull, 0x4FB87CAD777D0229ull, 0x7AD388DFFD2AD880ull, 0x85BDC6C0B36AE03Eull,
    0x1004603AE9856DD2ull, 0xEF6A2E25A7C5556Cull, 0xDA01DA572D928FC5ull, 0x256F944863D2B77Bull,
    0xCE7F9C2D8C1F185Bull, 0x3111D232C25F20E5ull, 0x047A26404808FA4Cull, 0xFB14685F0648C2F2ull,
    0x6EADCEA55CA74F1Eull, 0x91C380BA12E777A0ull, 0xA4A874C898B0AD09ull, 0x5BC63AD7D6F095B7ull,
    0xBB021F6F75F825BAull, 0x446C51703BB81D04ull, 0x7107A502B1EFC7ADull, 0x8E69EB1DFFAFFF13ull,
    0x1BD04DE7A54072FFull, 0xE4BE03F8EB004A41ull, 0xD1D5F78A615790E8ull, 0x2EBBB9952F17A856ull,
    0x24849AA87FD16399ull, 0xDBEAD4B731915B27ull, 0xEE8120C5BBC6818Eull, 0x11EF6EDAF586B930ull,
    0x8456C820AF6934DCull, 0x7B38863FE1290C62ull, 0x4E53724D6B7ED6CBull, 0xB13D3C52253EEE75ull,
    0x51F919EA86365E78ull, 0xAE9757F5C87666C6ull, 0x9BFCA3874221BC6Full, 0x6492ED980C6184D1ull,
    0xF12B4B62568E093Dull, 0x0E45057D18CE3183ull, 0x3B2EF10F9299EB2Aull, 0xC440BF10DCD9D394ull,
};
static const uint64_t Crc64NvmeTable3[256] = {
    0x0000000000000000ull, 0x8211147CBAF96306ull, 0x30FB0EAA2D655567ull, 0xB2EA1AD6979C3661ull,
    0x61F61D545ACAAACEull, 0xE3E70928E033C9C8ull, 0x510D13FE77AFFFA9ull, 0xD31C0782CD569CAFull,
    0xC3EC3AA8B595559Cull, 0x41FD2ED40F6C369Aull, 0xF317340298F000FBull, 0x7106207E220963FDull,
    0xA21A27FCEF5FFF52ull, 0x200B338055A69C54ull, 0x92E12956C23AAA35ull, 0x10F03D2A78C3C933ull,
    0xB301530233BD3853ull, 0x3110477E89445B55ull, 0x83FA5DA81ED86D34ull, 0x01EB49D4A4210E32ull,
    0xD2F74E566977929Dull, 0x50E65A2AD38EF19Bull, 0xE20C40FC4412C7FAull, 0x601D5480FEEBA4FCull,
    0x70ED69AA86286DCFull, 0xF2FC7DD63CD10EC9ull, 0x40166700AB4D38A8ull, 0xC207737C11B45BAEull,
    0x111B74FEDCE2C701ull, 0x930A6082661BA407ull, 0x21E07A54F1879266ull, 0xA3F16E284B7EF160ull,
    0x52DB80573FEDE3CDull, 0xD0CA942B851480CBull, 0x62208EFD1288B6AAull, 0xE0319A81A871D5ACull,
    0x332D9D0365274903ull, 0xB13C897FDFDE2A05ull, 0x03D693A948421C64ull, 0x81C787D5F2BB7F62ull,
    0x9137BAFF8A78B651ull, 0x1326AE833081D557ull, 0xA1CCB455A71DE336ull, 0x23DDA0291DE48030ull,
    0xF0C1A7ABD0B21C9Full, 0x72D0B3D76A4B7F99ull, 0xC03AA901FDD749F8ull, 0x422BBD7D472E2AFEull,
    0xE1DAD3550C50DB9Eull, 0x63CBC729B6A9B898ull, 0xD121DDFF21358EF9ull, 0x5330C9839BCCEDFFull,
    0x802CCE01569A7150ull, 0x023DDA7DEC631256ull, 0xB0D7C0AB7BFF2437ull, 0x32C6D4D7C1064731ull,
    0x2236E9FDB9C58E02ull, 0xA027FD81033CED04ull, 0x12CDE75794A0DB65ull, 0x90DCF32B2E59B863ull,
    0x43C0F4A9E30F24CCull, 0xC1D1E0D559F647CAull, 0x733BFA03CE6A71ABull, 0xF12AEE7F749312ADull,
    0xA5B700AE7FDBC79Aull, 0x27A614D2C522A49Cull, 0x954C0E0452BE92FDull, 0x175D1A78E847F1FBull,
    0xC4411DFA25116D54ull, 0x465009869FE80E52ull, 0xF4BA135008743833ull, 0x76AB072CB28D5B35ull,
    0x665B3A06CA4E9206ull, 0xE44A2E7A70B7F100ull, 0x56A034ACE72BC761ull, 0xD4B120D05DD2A467ull,
    0x07AD2752908438C8ull, 0x85BC332E2A7D5BCEull, 0x375629F8BDE16DAFull, 0xB5473D8407180EA9ull,
    0x16B653AC4C66FFC9ull, 0x94A747D0F69F9CCFull, 0x264D5D066103AAAEull, 0xA45C497ADBFAC9A8ull,
    0x77404EF816AC5507ull, 0xF5515A84AC553601ull, 0x47BB40523BC90060ull, 0xC5AA542E81306366ull,
    0xD55A6904F9F3AA55ull, 0x574B7D78430AC953ull, 0xE5A167AED496FF32ull, 0x67B073D26E6F9C34ull,
    0xB4AC7450A339009Bull, 0x36BD602C19C0639Dull, 0x84577AFA8E5C55FCull, 0x06466E8634A536FAull,
    0xF76C80F940362457ull, 0x757D9485FACF4751ull, 0xC7978E536D537130ull, 0x45869A2FD7AA1236ull,
    0x969A9DAD1AFC8E99ull, 0x148B89D1A005ED9Full, 0xA66193073799DBFEull, 0x2470877B8D60B8F8ull,
    0x3480BA51F5A371CBull, 0xB691AE2D4F5A12CDull, 0x047BB4FBD8C624ACull, 0x866AA087623F47AAull,
    0x5576A705AF69DB05ull, 0xD767B3791590B803ull, 0x658DA9AF820C8E62ull, 0xE79CBDD338F5ED64ull,
    0x446DD3FB738B1C04ull, 0xC67CC787C9727F02ull, 0x7496DD515EEE4963ull, 0xF687C92DE4172A65ull,
    0x259BCEAF2941B6CAull, 0xA78ADAD393B8D5CCull, 0x1560C0050424E3ADull, 0x9771D479BEDD80ABull,
    0x8781E953C61E4998ull, 0x0590FD2F7CE72A9Eull, 0xB77AE7F9EB7B1CFFull, 0x356BF38551827FF9ull,
    0xE677F4079CD4E356ull, 0x6466E07B262D8050ull, 0xD68CFAADB1B1B631ull, 0x549DEED10B48D537ull,
    0x7FB7270FA7201C5Full, 0xFDA633731DD97F59ull, 0x4F4C29A58A454938ull, 0xCD5D3DD930BC2A3Eull,
    0x1E413A5BFDEAB691ull, 0x9C502E274713D597ull, 0x2EBA34F1D08FE3F6ull, 0xACAB208D6A7680F0ull,
    0xBC5B1DA712B549C3ull, 0x3E4A09DBA84C2AC5ull, 0x8CA0130D3FD01CA4ull, 0x0EB1077185297FA2ull,
    0xDDAD00F3487FE30Dull, 0x5FBC148FF286800Bull, 0xED560E59651AB66Aull, 0x6F471A25DFE3D56Cull,
    0xCCB6740D949D240Cull, 0x4EA760712E64470Aull, 0xFC4D7AA7B9F8716Bull, 0x7E5C6EDB0301126Dull,
    0xAD406959CE578EC2ull, 0x2F517D2574AEEDC4ull, 0x9DBB67F3E332DBA5ull, 0x1FAA738F59CBB8A3ull,
    0x0F5A4EA521087190ull, 0x8D4B5AD99BF11296ull, 0x3FA1400F0C6D24F7ull, 0xBDB05473B69447F1ull,
    0x6EAC53F17BC2DB5Eull, 0xECBD478DC13BB858ull, 0x5E575D5B56A78E39ull, 0xDC464927EC5EED3Full,
    0x2D6CA75898CDFF92ull, 0xAF7DB32422349C94ull, 0x1D97A9F2B5A8AAF5ull, 0x9F86BD8E0F51C9F3ull,
    0x4C9ABA0CC207555Cull, 0xCE8BAE7078FE365Aull, 0x7C61B4A6EF62003Bull, 0xFE70A0DA559B633Dull,
    0xEE809DF02D58AA0Eull, 0x6C91898C97A1C908ull, 0xDE7B935A003DFF69ull, 0x5C6A8726BAC49C6Full,
    0x8F7680A4779200C0ull, 0x0D6794D8CD6B63C6ull, 0xBF8D8E0E5AF755A7ull, 0x3D9C9A72E00E36A1ull,
    0x9E6DF45AAB70C7C1ull, 0x1C7CE0261189A4C7ull, 0xAE96FAF0861592A6ull, 0x2C87EE8C3CECF1A0ull,
    0xFF9BE90EF1BA6D0Full, 0x7D8AFD724B430E09ull, 0xCF60E7A4DCDF3868ull, 0x4D71F3D866265B6Eull,
    0x5D81CEF21EE5925Dull, 0xDF90DA8EA41CF15Bull, 0x6D7AC0583380C73Aull, 0xEF6BD4248979A43Cull,
    0x3C77D3A6442F3893ull, 0xBE66C7DAFED65B95ull, 0x0C8CDD0C694A6DF4ull, 0x8E9DC970D3B30EF2ull,
    0xDA0027A1D8FBDBC5ull, 0x581133DD6202B8C3ull, 0xEAFB290BF59E8EA2ull, 0x68EA3D774F67EDA4ull,
    0xBBF63AF58231710Bull, 0x39E72E8938C8120Dull, 0x8B0D345FAF54246Cull, 0x091C202315AD476Aull,
    0x19EC1D096D6E8E59ull, 0x9BFD0975D797ED5Full, 0x291713A3400BDB3Eull, 0xAB0607DFFAF2B838ull,
    0x781A005D37A42497ull, 0xFA0B14218D5D4791ull, 0x48E10EF71AC171F0ull, 0xCAF01A8BA03812F6ull,
    0x690174A3EB46E396ull, 0xEB1060DF51BF8090ull, 0x59FA7A09C623B6F1ull, 0xDBEB6E757CDAD5F7ull,
    0x08F769F7B18C4958ull, 0x8AE67D8B0B752A5Eull, 0x380C675D9CE91C3Full, 0xBA1D732126107F39ull,
    0xAAED4E0B5ED3B60Aull, 0x28FC5A77E42AD50Cull, 0x9A1640A173B6E36Dull, 0x180754DDC94F806Bull,
    0xCB1B535F04191CC4ull, 0x490A4723BEE07FC2ull, 0xFBE05DF5297C49A3ull, 0x79F1498993852AA5ull,
    0x88DBA7F6E7163808ull, 0x0ACAB38A5DEF5B0Eull, 0xB820A95CCA736D6Full, 0x3A31BD20708A0E69ull,
    0xE92DBAA2BDDC92C6ull, 0x6B3CAEDE0725F1C0ull, 0xD9D6B40890B9C7A1ull, 0x5BC7A0742A40A4A7ull,
    0x4B379D5E52836D94ull, 0xC9268922E87A0E92ull, 0x7BCC93F47FE638F3ull, 0xF9DD8788C51F5BF5ull,
    0x2AC1800A0849C75Aull, 0xA8D09476B2B0A45Cull, 0x1A3A8EA0252C923Dull, 0x982B9ADC9FD5F13Bull,
    0x3BDAF4F4D4AB005Bull, 0xB9CBE0886E52635Dull, 0x0B21FA5EF9CE553Cull, 0x8930EE224337363Aull,
    0x5A2CE9A08E61AA95ull, 0xD83DFDDC3498C993ull, 0x6AD7E70AA304FFF2ull, 0xE8C6F37619FD9CF4ull,
    0xF836CE5C613E55C7ull, 0x7A27DA20DBC736C1ull, 0xC8CDC0F64C5B00A0ull, 0x4ADCD48AF6A263A6ull,
    0x99C0D3083BF4FF09ull, 0x1BD1C774810D9C0Full, 0xA93BDDA21691AA6Eull, 0x2B2AC9DEAC68C968ull,
};
static const uint64_t Crc64NvmeTable4[256] = {
    0x0000000000000000ull, 0x373D15F784905D1Eull, 0x6E7A2BEF0920BA3Cull, 0x59473E188DB0E722ull,
    0xDCF457DE12417478ull, 0xEBC9422996D12966ull, 0xB28E7C311B61CE44ull, 0x85B369C69FF1935Aull,
    0x8D3189EF7C157B9Bull, 0xBA0C9C18F8852685ull, 0xE34BA2007535C1A7ull, 0xD476B7F7F1A59CB9ull,
    0x51C5DE316E540FE3ull, 0x66F8CBC6EAC452FDull, 0x3FBFF5DE6774B5DFull, 0x0882E029E3E4E8C1ull,
    0x2EBA358DA0BD645Dull, 0x1987207A242D3943ull, 0x40C01E62A99DDE61ull, 0x77FD0B952D0D837Full,
    0xF24E6253B2FC1025ull, 0xC57377A4366C4D3Bull, 0x9C3449BCBBDCAA19ull, 0xAB095C4B3F4CF707ull,
    0xA38BBC62DCA81FC6ull, 0x94B6A995583842D8ull, 0xCDF1978DD588A5FAull, 0xFACC827A5118F8E4ull,
    0x7F7FEBBCCEE96BBEull, 0x4842FE4B4A7936A0ull, 0x1105C053C7C9D182ull, 0x2638D5A443598C9Cull,
    0x5D746B1B417AC8BAull, 0x6A497EECC5EA95A4ull, 0x330E40F4485A7286ull, 0x04335503CCCA2F98ull,
    0x81803CC5533BBCC2ull, 0xB6BD2932D7ABE1DCull, 0xEFFA172A5A1B06FEull, 0xD8C702DDDE8B5BE0ull,
    0xD045E2F43D6FB321ull, 0xE778F703B9FFEE3Full, 0xBE3FC91B344F091Dull, 0x8902DCECB0DF5403ull,
    0x0CB1B52A2F2EC759ull, 0x3B8CA0DDABBE9A47ull, 0x62CB9EC5260E7D65ull, 0x55F68B32A29E207Bull,
    0x73CE5E96E1C7ACE7ull, 0x44F34B616557F1F9ull, 0x1DB47579E8E716DBull, 0x2A89608E6C774BC5ull,
    0xAF3A0948F386D89Full, 0x98071CBF77168581ull, 0xC14022A7FAA662A3ull, 0xF67D37507E363FBDull,
    0xFEFFD7799DD2D77Cull, 0xC9C2C28E19428A62ull, 0x9085FC9694F26D40ull, 0xA7B8E9611062305Eull,
    0x220B80A78F93A304ull, 0x153695500B03FE1Aull, 0x4C71AB4886B31938ull, 0x7B4CBEBF02234426ull,
    0xBAE8D63682F59174ull, 0x8DD5C3C10665CC6Aull, 0xD492FDD98BD52B48ull, 0xE3AFE82E0F457656ull,
    0x661C81E890B4E50Cull, 0x5121941F1424B812ull, 0x0866AA0799945F30ull, 0x3F5BBFF01D04022Eull,
    0x37D95FD9FEE0EAEFull, 0x00E44A2E7A70B7F1ull, 0x59A37436F7C050D3ull, 0x6E9E61C173500DCDull,
    0xEB2D0807ECA19E97ull, 0xDC101DF06831C389ull, 0x855723E8E58124ABull, 0xB26A361F611179B5ull,
    0x9452E3BB2248F529ull, 0xA36FF64CA6D8A837ull, 0xFA28C8542B684F15ull, 0xCD15DDA3AFF8120Bull,
    0x48A6B46530098151ull, 0x7F9BA192B499DC4Full, 0x26DC9F8A39293B6Dull, 0x11E18A7DBDB96673ull,
    0x19636A545E5D8EB2ull, 0x2E5E7FA3DACDD3ACull, 0x771941BB577D348Eull, 0x4024544CD3ED6990ull,
    0xC5973D8A4C1CFACAull, 0xF2AA287DC88CA7D4ull, 0xABED1665453C40F6ull, 0x9CD00392C1AC1DE8ull,
    0xE79CBD2DC38F59CEull, 0xD0A1A8DA471F04D0ull, 0x89E696C2CAAFE3F2ull, 0xBEDB83354E3FBEECull,
    0x3B68EAF3D1CE2DB6ull, 0x0C55FF04555E70A8ull, 0x5512C11CD8EE978Aull, 0x622FD4EB5C7ECA94ull,
    0x6AAD34C2BF9A2255ull, 0x5D9021353B0A7F4Bull, 0x04D71F2DB6BA9869ull, 0x33EA0ADA322AC577ull,
    0xB659631CADDB562Dull, 0x816476EB294B0B33ull, 0xD82348F3A4FBEC11ull, 0xEF1E5D04206BB10Full,
    0xC92688A063323D93ull, 0xFE1B9D57E7A2608Dull, 0xA75CA34F6A1287AFull, 0x9061B6B8EE82DAB1ull,
    0x15D2DF7E717349EBull, 0x22EFCA89F5E314F5ull, 0x7BA8F4917853F3D7ull, 0x4C95E166FCC3AEC9ull,
    0x4417014F1F274608ull, 0x732A14B89BB71B16ull, 0x2A6D2AA01607FC34ull, 0x1D503F579297A12Aull,
    0x98E356910D663270ull, 0xAFDE436689F66F6Eull, 0xF6997D7E0446884Cull, 0xC1A4688980D6D552ull,
    0x41088A3E5D7CB183ull, 0x76359FC9D9ECEC9Dull, 0x2F72A1D1545C0BBFull, 0x184FB426D0CC56A1ull,
    0x9DFCDDE04F3DC5FBull, 0xAAC1C817CBAD98E5ull, 0xF386F60F461D7FC7ull, 0xC4BBE3F8C28D22D9ull,
    0xCC3903D12169CA18ull, 0xFB041626A5F99706ull, 0xA243283E28497024ull, 0x957E3DC9ACD92D3Aull,
    0x10CD540F3328BE60ull, 0x27F041F8B7B8E37Eull, 0x7EB77FE03A08045Cull, 0x498A6A17BE985942ull,
    0x6FB2BFB3FDC1D5DEull, 0x588FAA44795188C0ull, 0x01C8945CF4E16FE2ull, 0x36F581AB707132FCull,
    0xB346E86DEF80A1A6ull, 0x847BFD9A6B10FCB8ull, 0xDD3CC382E6A01B9Aull, 0xEA01D67562304684ull,
    0xE283365C81D4AE45ull, 0xD5BE23AB0544F35Bull, 0x8CF91DB388F41479ull, 0xBBC408440C644967ull,
    0x3E7761829395DA3Dull, 0x094A747517058723ull, 0x500D4A6D9AB56001ull, 0x67305F9A1E253D1Full,
    0x1C7CE1251C067939ull, 0x2B41F4D298962427ull, 0x7206CACA1526C305ull, 0x453BDF3D91B69E1Bull,
    0xC088B6FB0E470D41ull, 0xF7B5A30C8AD7505Full, 0xAEF29D140767B77Dull, 0x99CF88E383F7EA63ull,
    0x914D68CA601302A2ull, 0xA6707D3DE4835FBCull, 0xFF3743256933B89Eull, 0xC80A56D2EDA3E580ull,
    0x4DB93F14725276DAull, 0x7A842AE3F6C22BC4ull, 0x23C314FB7B72CCE6ull, 0x14FE010CFFE291F8ull,
    0x32C6D4A8BCBB1D64ull, 0x05FBC15F382B407Aull, 0x5CBCFF47B59BA758ull, 0x6B81EAB0310BFA46ull,
    0xEE328376AEFA691Cull, 0xD90F96812A6A3402ull, 0x8048A899A7DAD320ull, 0xB775BD6E234A8E3Eull,
    0xBFF75D47C0AE66FFull, 0x88CA48B0443E3BE1ull, 0xD18D76A8C98EDCC3ull, 0xE6B0635F4D1E81DDull,
    0x63030A99D2EF1287ull, 0x543E1F6E567F4F99ull, 0x0D792176DBCFA8BBull, 0x3A4434815F5FF5A5ull,
    0xFBE05C08DF8920F7ull, 0xCCDD49FF5B197DE9ull, 0x959A77E7D6A99ACBull, 0xA2A762105239C7D5ull,
    0x27140BD6CDC8548Full, 0x10291E2149580991ull, 0x496E2039C4E8EEB3ull, 0x7E5335CE4078B3ADull,
    0x76D1D5E7A39C5B6Cull, 0x41ECC010270C0672ull, 0x18ABFE08AABCE150ull, 0x2F96EBFF2E2CBC4Eull,
    0xAA258239B1DD2F14ull, 0x9D1897CE354D720Aull, 0xC45FA9D6B8FD9528ull, 0xF362BC213C6DC836ull,
    0xD55A69857F3444AAull, 0xE2677C72FBA419B4ull, 0xBB20426A7614FE96ull, 0x8C1D579DF284A388ull,
    0x09AE3E5B6D7530D2ull, 0x3E932BACE9E56DCCull, 0x67D415B464558AEEull, 0x50E90043E0C5D7F0ull,
    0x586BE06A03213F31ull, 0x6F56F59D87B1622Full, 0x3611CB850A01850Dull, 0x012CDE728E91D813ull,
    0x849FB7B411604B49ull, 0xB3A2A24395F01657ull, 0xEAE59C5B1840F175ull, 0xDDD889AC9CD0AC6Bull,
    0xA69437139EF3E84Dull, 0x91A922E41A63B553ull, 0xC8EE1CFC97D35271ull, 0xFFD3090B13430F6Full,
    0x7A6060CD8CB29C35ull, 0x4D5D753A0822C12Bull, 0x141A4B2285922609ull, 0x23275ED501027B17ull,
    0x2BA5BEFCE2E693D6ull, 0x1C98AB0B6676CEC8ull, 0x45DF9513EBC629EAull, 0x72E280E46F5674F4ull,
    0xF751E922F0A7E7AEull, 0xC06CFCD57437BAB0ull, 0x992BC2CDF9875D92ull, 0xAE16D73A7D17008Cull,
    0x882E029E3E4E8C10ull, 0xBF131769BADED10Eull, 0xE6542971376E362Cull, 0xD1693C86B3FE6B32ull,
    0x54DA55402C0FF868ull, 0x63E740B7A89FA576ull, 0x3AA07EAF252F4254ull, 0x0D9D6B58A1BF1F4Aull,
    0x051F8B71425BF78Bull, 0x32229E86C6CBAA95ull, 0x6B65A09E4B7B4DB7ull, 0x5C58B569CFEB10A9ull,
    0xD9EBDCAF501A83F3ull, 0xEED6C958D48ADEEDull, 0xB791F740593A39CFull, 0x80ACE2B7DDAA64D1ull,
};
static const uint64_t Crc64NvmeTable5[256] = {
    0x0000000000000000ull, 0xE9742A79EF04A5D4ull, 0xE63172A0869ED8C3ull, 0x0F4558D9699A7D17ull,
    0xF8BBC31255AA22EDull, 0x11CFE96BBAAE8739ull, 0x1E8AB1B2D334FA2Eull, 0xF7FE9BCB3C305FFAull,
    0xC5AEA077F3C3D6B1ull, 0x2CDA8A0E1CC77365ull, 0x239FD2D7755D0E72ull, 0xCAEBF8AE9A59ABA6ull,
    0x3D156365A669F45Cull, 0xD461491C496D5188ull, 0xDB2411C520F72C9Full, 0x32503BBCCFF3894Bull,
    0xBF8466BCBF103E09ull, 0x56F04CC550149BDDull, 0x59B5141C398EE6CAull, 0xB0C13E65D68A431Eull,
    0x473FA5AEEABA1CE4ull, 0xAE4B8FD705BEB930ull, 0xA10ED70E6C24C427ull, 0x487AFD77832061F3ull,
    0x7A2AC6CB4CD3E8B8ull, 0x935EECB2A3D74D6Cull, 0x9C1BB46BCA4D307Bull, 0x756F9E12254995AFull,
    0x829105D91979CA55ull, 0x6BE52FA0F67D6F81ull, 0x64A077799FE71296ull, 0x8DD45D0070E3B742ull,
    0x4BD1EB2A26B7EF79ull, 0xA2A5C153C9B34AADull, 0xADE0998AA02937BAull, 0x4494B3F34F2D926Eull,
    0xB36A2838731DCD94ull, 0x5A1E02419C196840ull, 0x555B5A98F5831557ull, 0xBC2F70E11A87B083ull,
    0x8E7F4B5DD57439C8ull, 0x670B61243A709C1Cull, 0x684E39FD53EAE10Bull, 0x813A1384BCEE44DFull,
    0x76C4884F80DE1B25ull, 0x9FB0A2366FDABEF1ull, 0x90F5FAEF0640C3E6ull, 0x7981D096E9446632ull,
    0xF4558D9699A7D170ull, 0x1D21A7EF76A374A4ull, 0x1264FF361F3909B3ull, 0xFB10D54FF03DAC67ull,
    0x0CEE4E84CC0DF39Dull, 0xE59A64FD23095649ull, 0xEADF3C244A932B5Eull, 0x03AB165DA5978E8Aull,
    0x31FB2DE16A6407C1ull, 0xD88F07988560A215ull, 0xD7CA5F41ECFADF02ull, 0x3EBE753803FE7AD6ull,
    0xC940EEF33FCE252Cull, 0x2034C48AD0CA80F8ull, 0x2F719C53B950FDEFull, 0xC605B62A5654583Bull,
    0x97A3D6544D6FDEF2ull, 0x7ED7FC2DA26B7B26ull, 0x7192A4F4CBF10631ull, 0x98E68E8D24F5A3E5ull,
    0x6F18154618C5FC1Full, 0x866C3F3FF7C159CBull, 0x892967E69E5B24DCull, 0x605D4D9F715F8108ull,
    0x520D7623BEAC0843ull, 0xBB795C5A51A8AD97ull, 0xB43C04833832D080ull, 0x5D482EFAD7367554ull,
    0xAAB6B531EB062AAEull, 0x43C29F4804028F7Aull, 0x4C87C7916D98F26Dull, 0xA5F3EDE8829C57B9ull,
    0x2827B0E8F27FE0FBull, 0xC1539A911D7B452Full, 0xCE16C24874E13838ull, 0x2762E8319BE59DECull,
    0xD09C73FAA7D5C216ull, 0x39E8598348D167C2ull, 0x36AD015A214B1AD5ull, 0xDFD92B23CE4FBF01ull,
    0xED89109F01BC364Aull, 0x04FD3AE6EEB8939Eull, 0x0BB8623F8722EE89ull, 0xE2CC484668264B5Dull,
    0x1532D38D541614A7ull, 0xFC46F9F4BB12B173ull, 0xF303A12DD288CC64ull, 0x1A778B543D8C69B0ull,
    0xDC723D7E6BD8318Bull, 0x3506170784DC945Full, 0x3A434FDEED46E948ull, 0xD33765A702424C9Cull,
    0x24C9FE6C3E721366ull, 0xCDBDD415D176B6B2ull, 0xC2F88CCCB8ECCBA5ull, 0x2B8CA6B557E86E71ull,
    0x19DC9D09981BE73Aull, 0xF0A8B770771F42EEull, 0xFFEDEFA91E853FF9ull, 0x1699C5D0F1819A2Dull,
    0xE1675E1BCDB1C5D7ull, 0x0813746222B56003ull, 0x07562CBB4B2F1D14ull, 0xEE2206C2A42BB8C0ull,
    0x63F65BC2D4C80F82ull, 0x8A8271BB3BCCAA56ull, 0x85C729625256D741ull, 0x6CB3031BBD527295ull,
    0x9B4D98D081622D6Full, 0x7239B2A96E6688BBull, 0x7D7CEA7007FCF5ACull, 0x9408C009E8F85078ull,
    0xA658FBB5270BD933ull, 0x4F2CD1CCC80F7CE7ull, 0x40698915A19501F0ull, 0xA91DA36C4E91A424ull,
    0x5EE338A772A1FBDEull, 0xB79712DE9DA55E0Aull, 0xB8D24A07F43F231Dull, 0x51A6607E1B3B86C9ull,
    0x1B9E8AFBC2482E8Full, 0xF2EAA0822D4C8B5Bull, 0xFDAFF85B44D6F64Cull, 0x14DBD222ABD25398ull,
    0xE32549E997E20C62ull, 0x0A51639078E6A9B6ull, 0x05143B49117CD4A1ull, 0xEC601130FE787175ull,
    0xDE302A8C318BF83Eull, 0x374400F5DE8F5DEAull, 0x3801582CB71520FDull, 0xD175725558118529ull,
    0x268BE99E6421DAD3ull, 0xCFFFC3E78B257F07ull, 0xC0BA9B3EE2BF0210ull, 0x29CEB1470DBBA7C4ull,
    0xA41AEC477D581086ull, 0x4D6EC63E925CB552ull, 0x422B9EE7FBC6C845ull, 0xAB5FB49E14C26D91ull,
    0x5CA12F5528F2326Bull, 0xB5D5052CC7F697BFull, 0xBA905DF5AE6CEAA8ull, 0x53E4778C41684F7Cull,
    0x61B44C308E9BC637ull, 0x88C06649619F63E3ull, 0x87853E9008051EF4ull, 0x6EF114E9E701BB20ull,
    0x990F8F22DB31E4DAull, 0x707BA55B3435410Eull, 0x7F3EFD825DAF3C19ull, 0x964AD7FBB2AB99CDull,
    0x504F61D1E4FFC1F6ull, 0xB93B4BA80BFB6422ull, 0xB67E137162611935ull, 0x5F0A39088D65BCE1ull,
    0xA8F4A2C3B155E31Bull, 0x418088BA5E5146CFull, 0x4EC5D06337CB3BD8ull, 0xA7B1FA1AD8CF9E0Cull,
    0x95E1C1A6173C1747ull, 0x7C95EBDFF838B293ull, 0x73D0B30691A2CF84ull, 0x9AA4997F7EA66A50ull,
    0x6D5A02B4429635AAull, 0x842E28CDAD92907Eull, 0x8B6B7014C408ED69ull, 0x621F5A6D2B0C48BDull,
    0xEFCB076D5BEFFFFFull, 0x06BF2D14B4EB5A2Bull, 0x09FA75CDDD71273Cull, 0xE08E5FB4327582E8ull,
    0x1770C47F0E45DD12ull, 0xFE04EE06E14178C6ull, 0xF141B6DF88DB05D1ull, 0x18359CA667DFA005ull,
    0x2A65A71AA82C294Eull, 0xC3118D6347288C9Aull, 0xCC54D5BA2EB2F18Dull, 0x2520FFC3C1B65459ull,
    0xD2DE6408FD860BA3ull, 0x3BAA4E711282AE77ull, 0x34EF16A87B18D360ull, 0xDD9B3CD1941C76B4ull,
    0x8C3D5CAF8F27F07Dull, 0x654976D6602355A9ull, 0x6A0C2E0F09B928BEull, 0x83780476E6BD8D6Aull,
    0x74869FBDDA8DD290ull, 0x9DF2B5C435897744ull, 0x92B7ED1D5C130A53ull, 0x7BC3C764B317AF87ull,
    0x4993FCD87CE426CCull, 0xA0E7D6A193E08318ull, 0xAFA28E78FA7AFE0Full, 0x46D6A401157E5BDBull,
    0xB1283FCA294E0421ull, 0x585C15B3C64AA1F5ull, 0x57194D6AAFD0DCE2ull, 0xBE6D671340D47936ull,
    0x33B93A133037CE74ull, 0xDACD106ADF336BA0ull, 0xD58848B3B6A916B7ull, 0x3CFC62CA59ADB363ull,
    0xCB02F901659DEC99ull, 0x2276D3788A99494Dull, 0x2D338BA1E303345Aull, 0xC447A1D80C07918Eull,
    0xF6179A64C3F418C5ull, 0x1F63B01D2CF0BD11ull, 0x1026E8C4456AC006ull, 0xF952C2BDAA6E65D2ull,
    0x0EAC5976965E3A28ull, 0xE7D8730F795A9FFCull, 0xE89D2BD610C0E2EBull, 0x01E901AFFFC4473Full,
    0xC7ECB785A9901F04ull, 0x2E989DFC4694BAD0ull, 0x21DDC5252F0EC7C7ull, 0xC8A9EF5CC00A6213ull,
    0x3F577497FC3A3DE9ull, 0xD6235EEE133E983Dull, 0xD96606377AA4E52Aull, 0x30122C4E95A040FEull,
    0x024217F25A53C9B5ull, 0xEB363D8BB5576C61ull, 0xE4736552DCCD1176ull, 0x0D074F2B33C9B4A2ull,
    0xFAF9D4E00FF9EB58ull, 0x138DFE99E0FD4E8Cull, 0x1CC8A6408967339Bull, 0xF5BC8C396663964Full,
    0x7868D1391680210Dull, 0x911CFB40F98484D9ull, 0x9E59A399901EF9CEull, 0x772D89E07F1A5C1Aull,
    0x80D3122B432A03E0ull, 0x69A73852AC2EA634ull, 0x66E2608BC5B4DB23ull, 0x8F964AF22AB07EF7ull,
    0xBDC6714EE543F7BCull, 0x54B25B370A475268ull, 0x5BF703EE63DD2F7Full, 0xB28329978CD98AABull,
    0x457DB25CB0E9D551ull, 0xAC0998255FED7085ull, 0xA34CC0FC36770D92ull, 0x4A38EA85D973A846ull,
};
static const uint64_t Crc64NvmeTable6[256] = {
    0x0000000000000000ull, 0xFC5D27F6BF353971ull, 0xCC6369BE26FDE189ull, 0x303E4E4899C8D8F8ull,
    0xAC1FF52F156C5079ull, 0x5042D2D9AA596908ull, 0x607C9C913391B1F0ull, 0x9C21BB678CA48881ull,
    0x6CE6CC0D724F3399ull, 0x90BBEBFBCD7A0AE8ull, 0xA085A5B354B2D210ull, 0x5CD88245EB87EB61ull,
    0xC0F93922672363E0ull, 0x3CA41ED4D8165A91ull, 0x0C9A509C41DE8269ull, 0xF0C7776AFEEBBB18ull,
    0xD9CD981AE49E6732ull, 0x2590BFEC5BAB5E43ull, 0x15AEF1A4C26386BBull, 0xE9F3D6527D56BFCAull,
    0x75D26D35F1F2374Bull, 0x898F4AC34EC70E3Aull, 0xB9B1048BD70FD6C2ull, 0x45EC237D683AEFB3ull,
    0xB52B541796D154ABull, 0x497673E129E46DDAull, 0x79483DA9B02CB522ull, 0x85151A5F0F198C53ull,
    0x1934A13883BD04D2ull, 0xE56986CE3C883DA3ull, 0xD557C886A540E55Bull, 0x290AEF701A75DC2Aull,
    0x8742166691AB5D0Full, 0x7B1F31902E9E647Eull, 0x4B217FD8B756BC86ull, 0xB77C582E086385F7ull,
    0x2B5DE34984C70D76ull, 0xD700C4BF3BF23407ull, 0xE73E8AF7A23AECFFull, 0x1B63AD011D0FD58Eull,
    0xEBA4DA6BE3E46E96ull, 0x17F9FD9D5CD157E7ull, 0x27C7B3D5C5198F1Full, 0xDB9A94237A2CB66Eull,
    0x47BB2F44F6883EEFull, 0xBBE608B249BD079Eull, 0x8BD846FAD075DF66ull, 0x7785610C6F40E617ull,
    0x5E8F8E7C75353A3Dull, 0xA2D2A98ACA00034Cull, 0x92ECE7C253C8DBB4ull, 0x6EB1C034ECFDE2C5ull,
    0xF2907B5360596A44ull, 0x0ECD5CA5DF6C5335ull, 0x3EF312ED46A48BCDull, 0xC2AE351BF991B2BCull,
    0x32694271077A09A4ull, 0xCE346587B84F30D5ull, 0xFE0A2BCF2187E82Dull, 0x02570C399EB2D15Cull,
    0x9E76B75E121659DDull, 0x622B90A8AD2360ACull, 0x5215DEE034EBB854ull, 0xAE48F9168BDE8125ull,
    0x3A5D0A9E7BC12975ull, 0xC6002D68C4F41004ull, 0xF63E63205D3CC8FCull, 0x0A6344D6E209F18Dull,
    0x9642FFB16EAD790Cull, 0x6A1FD847D198407Dull, 0x5A21960F48509885ull, 0xA67CB1F9F765A1F4ull,
    0x56BBC693098E1AECull, 0xAAE6E165B6BB239Dull, 0x9AD8AF2D2F73FB65ull, 0x668588DB9046C214ull,
    0xFAA433BC1CE24A95ull, 0x06F9144AA3D773E4ull, 0x36C75A023A1FAB1Cull, 0xCA9A7DF4852A926Dull,
    0xE39092849F5F4E47ull, 0x1FCDB572206A7736ull, 0x2FF3FB3AB9A2AFCEull, 0xD3AEDCCC069796BFull,
    0x4F8F67AB8A331E3Eull, 0xB3D2405D3506274Full, 0x83EC0E15ACCEFFB7ull, 0x7FB129E313FBC6C6ull,
    0x8F765E89ED107DDEull, 0x732B797F522544AFull, 0x43153737CBED9C57ull, 0xBF4810C174D8A526ull,
    0x2369ABA6F87C2DA7ull, 0xDF348C50474914D6ull, 0xEF0AC218DE81CC2Eull, 0x1357E5EE61B4F55Full,
    0xBD1F1CF8EA6A747Aull, 0x41423B0E555F4D0Bull, 0x717C7546CC9795F3ull, 0x8D2152B073A2AC82ull,
    0x1100E9D7FF062403ull, 0xED5DCE2140331D72ull, 0xDD638069D9FBC58Aull, 0x213EA79F66CEFCFBull,
    0xD1F9D0F5982547E3ull, 0x2DA4F70327107E92ull, 0x1D9AB94BBED8A66Aull, 0xE1C79EBD01ED9F1Bull,
    0x7DE625DA8D49179Aull, 0x81BB022C327C2EEBull, 0xB1854C64ABB4F613ull, 0x4DD86B921481CF62ull,
    0x64D284E20EF41348ull, 0x988FA314B1C12A39ull, 0xA8B1ED5C2809F2C1ull, 0x54ECCAAA973CCBB0ull,
    0xC8CD71CD1B984331ull, 0x3490563BA4AD7A40ull, 0x04AE18733D65A2B8ull, 0xF8F33F8582509BC9ull,
    0x083448EF7CBB20D1ull, 0xF4696F19C38E19A0ull, 0xC45721515A46C158ull, 0x380A06A7E573F829ull,
    0xA42BBDC069D770A8ull, 0x58769A36D6E249D9ull, 0x6848D47E4F2A9121ull, 0x9415F388F01FA850ull,
    0x74BA153CF78252EAull, 0x88E732CA48B76B9Bull, 0xB8D97C82D17FB363ull, 0x44845B746E4A8A12ull,
    0xD8A5E013E2EE0293ull, 0x24F8C7E55DDB3BE2ull, 0x14C689ADC413E31Aull, 0xE89BAE5B7B26DA6Bull,
    0x185CD93185CD6173ull, 0xE401FEC73AF85802ull, 0xD43FB08FA33080FAull, 0x286297791C05B98Bull,
    0xB4432C1E90A1310Aull, 0x481E0BE82F94087Bull, 0x782045A0B65CD083ull, 0x847D62560969E9F2ull,
    0xAD778D26131C35D8ull, 0x512AAAD0AC290CA9ull, 0x6114E49835E1D451ull, 0x9D49C36E8AD4ED20ull,
    0x01687809067065A1ull, 0xFD355FFFB9455CD0ull, 0xCD0B11B7208D8428ull, 0x315636419FB8BD59ull,
    0xC191412B61530641ull, 0x3DCC66DDDE663F30ull, 0x0DF2289547AEE7C8ull, 0xF1AF0F63F89BDEB9ull,
    0x6D8EB404743F5638ull, 0x91D393F2CB0A6F49ull, 0xA1EDDDBA52C2B7B1ull, 0x5DB0FA4CEDF78EC0ull,
    0xF3F8035A66290FE5ull, 0x0FA524ACD91C3694ull, 0x3F9B6AE440D4EE6Cull, 0xC3C64D12FFE1D71Dull,
    0x5FE7F67573455F9Cull, 0xA3BAD183CC7066EDull, 0x93849FCB55B8BE15ull, 0x6FD9B83DEA8D8764ull,
    0x9F1ECF5714663C7Cull, 0x6343E8A1AB53050Dull, 0x537DA6E9329BDDF5ull, 0xAF20811F8DAEE484ull,
    0x33013A78010A6C05ull, 0xCF5C1D8EBE3F5574ull, 0xFF6253C627F78D8Cull, 0x033F743098C2B4FDull,
    0x2A359B4082B768D7ull, 0xD668BCB63D8251A6ull, 0xE656F2FEA44A895Eull, 0x1A0BD5081B7FB02Full,
    0x862A6E6F97DB38AEull, 0x7A77499928EE01DFull, 0x4A4907D1B126D927ull, 0xB61420270E13E056ull,
    0x46D3574DF0F85B4Eull, 0xBA8E70BB4FCD623Full, 0x8AB03EF3D605BAC7ull, 0x76ED1905693083B6ull,
    0xEACCA262E5940B37ull, 0x169185945AA13246ull, 0x26AFCBDCC369EABEull, 0xDAF2EC2A7C5CD3CFull,
    0x4EE71FA28C437B9Full, 0xB2BA3854337642EEull, 0x8284761CAABE9A16ull, 0x7ED951EA158BA367ull,
    0xE2F8EA8D992F2BE6ull, 0x1EA5CD7B261A1297ull, 0x2E9B8333BFD2CA6Full, 0xD2C6A4C500E7F31Eull,
    0x2201D3AFFE0C4806ull, 0xDE5CF45941397177ull, 0xEE62BA11D8F1A98Full, 0x123F9DE767C490FEull,
    0x8E1E2680EB60187Full, 0x724301765455210Eull, 0x427D4F3ECD9DF9F6ull, 0xBE2068C872A8C087ull,
    0x972A87B868DD1CADull, 0x6B77A04ED7E825DCull, 0x5B49EE064E20FD24ull, 0xA714C9F0F115C455ull,
    0x3B3572977DB14CD4ull, 0xC7685561C28475A5ull, 0xF7561B295B4CAD5Dull, 0x0B0B3CDFE479942Cull,
    0xFBCC4BB51A922F34ull, 0x07916C43A5A71645ull, 0x37AF220B3C6FCEBDull, 0xCBF205FD835AF7CCull,
    0x57D3BE9A0FFE7F4Dull, 0xAB8E996CB0CB463Cull, 0x9BB0D72429039EC4ull, 0x67EDF0D29636A7B5ull,
    0xC9A509C41DE82690ull, 0x35F82E32A2DD1FE1ull, 0x05C6607A3B15C719ull, 0xF99B478C8420FE68ull,
    0x65BAFCEB088476E9ull, 0x99E7DB1DB7B14F98ull, 0xA9D995552E799760ull, 0x5584B2A3914CAE11ull,
    0xA543C5C96FA71509ull, 0x591EE23FD0922C78ull, 0x6920AC77495AF480ull, 0x957D8B81F66FCDF1ull,
    0x095C30E67ACB4570ull, 0xF5011710C5FE7C01ull, 0xC53F59585C36A4F9ull, 0x39627EAEE3039D88ull,
    0x106891DEF97641A2ull, 0xEC35B628464378D3ull, 0xDC0BF860DF8BA02Bull, 0x2056DF9660BE995Aull,
    0xBC7764F1EC1A11DBull, 0x402A4307532F28AAull, 0x70140D4FCAE7F052ull, 0x8C492AB975D2C923ull,
    0x7C8E5DD38B39723Bull, 0x80D37A25340C4B4Aull, 0xB0ED346DADC493B2ull, 0x4CB0139B12F1AAC3ull,
    0xD091A8FC9E552242ull, 0x2CCC8F0A21601B33ull, 0x1CF2C142B8A8C3CBull, 0xE0AFE6B4079DFABAull,
};
static const uint64_t Crc64NvmeTable7[256] = {
    0x0000000000000000ull, 0x21E9761E252621ACull, 0x43D2EC3C4A4C4358ull, 0x623B9A226F6A62F4ull,
    0x87A5D878949886B0ull, 0xA64CAE66B1BEA71Cull, 0xC4773444DED4C5E8ull, 0xE59E425AFBF2E444ull,
    0x3B9296A271A69E0Bull, 0x1A7BE0BC5480BFA7ull, 0x78407A9E3BEADD53ull, 0x59A90C801ECCFCFFull,
    0xBC374EDAE53E18BBull, 0x9DDE38C4C0183917ull, 0xFFE5A2E6AF725BE3ull, 0xDE0CD4F88A547A4Full,
    0x77252D44E34D3C16ull, 0x56CC5B5AC66B1DBAull, 0x34F7C178A9017F4Eull, 0x151EB7668C275EE2ull,
    0xF080F53C77D5BAA6ull, 0xD169832252F39B0Aull, 0xB35219003D99F9FEull, 0x92BB6F1E18BFD852ull,
    0x4CB7BBE692EBA21Dull, 0x6D5ECDF8B7CD83B1ull, 0x0F6557DAD8A7E145ull, 0x2E8C21C4FD81C0E9ull,
    0xCB12639E067324ADull, 0xEAFB158023550501ull, 0x88C08FA24C3F67F5ull, 0xA929F9BC69194659ull,
    0xEE4A5A89C69A782Cull, 0xCFA32C97E3BC5980ull, 0xAD98B6B58CD63B74ull, 0x8C71C0ABA9F01AD8ull,
    0x69EF82F15202FE9Cull, 0x4806F4EF7724DF30ull, 0x2A3D6ECD184EBDC4ull, 0x0BD418D33D689C68ull,
    0xD5D8CC2BB73CE627ull, 0xF431BA35921AC78Bull, 0x960A2017FD70A57Full, 0xB7E35609D85684D3ull,
    0x527D145323A46097ull, 0x7394624D0682413Bull, 0x11AFF86F69E823CFull, 0x30468E714CCE0263ull,
    0x996F77CD25D7443Aull, 0xB88601D300F16596ull, 0xDABD9BF16F9B0762ull, 0xFB54EDEF4ABD26CEull,
    0x1ECAAFB5B14FC28Aull, 0x3F23D9AB9469E326ull, 0x5D184389FB0381D2ull, 0x7CF13597DE25A07Eull,
    0xA2FDE16F5471DA31ull, 0x831497717157FB9Dull, 0xE12F0D531E3D9969ull, 0xC0C67B4D3B1BB8C5ull,
    0x25583917C0E95C81ull, 0x04B14F09E5CF7D2Dull, 0x668AD52B8AA51FD9ull, 0x4763A335AF833E75ull,
    0xE84D9340D5A36333ull, 0xC9A4E55EF085429Full, 0xAB9F7F7C9FEF206Bull, 0x8A760962BAC901C7ull,
    0x6FE84B38413BE583ull, 0x4E013D26641DC42Full, 0x2C3AA7040B77A6DBull, 0x0DD3D11A2E518777ull,
    0xD3DF05E2A405FD38ull, 0xF23673FC8123DC94ull, 0x900DE9DEEE49BE60ull, 0xB1E49FC0CB6F9FCCull,
    0x547ADD9A309D7B88ull, 0x7593AB8415BB5A24ull, 0x17A831A67AD138D0ull, 0x364147B85FF7197Cull,
    0x9F68BE0436EE5F25ull, 0xBE81C81A13C87E89ull, 0xDCBA52387CA21C7Dull, 0xFD53242659843DD1ull,
    0x18CD667CA276D995ull, 0x392410628750F839ull, 0x5B1F8A40E83A9ACDull, 0x7AF6FC5ECD1CBB61ull,
    0xA4FA28A64748C12Eull, 0x85135EB8626EE082ull, 0xE728C49A0D048276ull, 0xC6C1B2842822A3DAull,
    0x235FF0DED3D0479Eull, 0x02B686C0F6F66632ull, 0x608D1CE2999C04C6ull, 0x41646AFCBCBA256Aull,
    0x0607C9C913391B1Full, 0x27EEBFD7361F3AB3ull, 0x45D525F559755847ull, 0x643C53EB7C5379EBull,
    0x81A211B187A19DAFull, 0xA04B67AFA287BC03ull, 0xC270FD8DCDEDDEF7ull, 0xE3998B93E8CBFF5Bull,
    0x3D955F6B629F8514ull, 0x1C7C297547B9A4B8ull, 0x7E47B35728D3C64Cull, 0x5FAEC5490DF5E7E0ull,
    0xBA308713F60703A4ull, 0x9BD9F10DD3212208ull, 0xF9E26B2FBC4B40FCull, 0xD80B1D31996D6150ull,
    0x7122E48DF0742709ull, 0x50CB9293D55206A5ull, 0x32F008B1BA386451ull, 0x13197EAF9F1E45FDull,
    0xF6873CF564ECA1B9ull, 0xD76E4AEB41CA8015ull, 0xB555D0C92EA0E2E1ull, 0x94BCA6D70B86C34Dull,
    0x4AB0722F81D2B902ull, 0x6B590431A4F498AEull, 0x09629E13CB9EFA5Aull, 0x288BE80DEEB8DBF6ull,
    0xCD15AA57154A3FB2ull, 0xECFCDC49306C1E1Eull, 0x8EC7466B5F067CEAull, 0xAF2E30757A205D46ull,
    0xE44200D2F3D1550Dull, 0xC5AB76CCD6F774A1ull, 0xA790ECEEB99D1655ull, 0x86799AF09CBB37F9ull,
    0x63E7D8AA6749D3BDull, 0x420EAEB4426FF211ull, 0x203534962D0590E5ull, 0x01DC42880823B149ull,
    0xDFD096708277CB06ull, 0xFE39E06EA751EAAAull, 0x9C027A4CC83B885Eull, 0xBDEB0C52ED1DA9F2ull,
    0x58754E0816EF4DB6ull, 0x799C381633C96C1Aull, 0x1BA7A2345CA30EEEull, 0x3A4ED42A79852F42ull,
    0x93672D96109C691Bull, 0xB28E5B8835BA48B7ull, 0xD0B5C1AA5AD02A43ull, 0xF15CB7B47FF60BEFull,
    0x14C2F5EE8404EFABull, 0x352B83F0A122CE07ull, 0x571019D2CE48ACF3ull, 0x76F96FCCEB6E8D5Full,
    0xA8F5BB34613AF710ull, 0x891CCD2A441CD6BCull, 0xEB2757082B76B448ull, 0xCACE21160E5095E4ull,
    0x2F50634CF5A271A0ull, 0x0EB91552D084500Cull, 0x6C828F70BFEE32F8ull, 0x4D6BF96E9AC81354ull,
    0x0A085A5B354B2D21ull, 0x2BE12C45106D0C8Dull, 0x49DAB6677F076E79ull, 0x6833C0795A214FD5ull,
    0x8DAD8223A1D3AB91ull, 0xAC44F43D84F58A3Dull, 0xCE7F6E1FEB9FE8C9ull, 0xEF961801CEB9C965ull,
    0x319ACCF944EDB32Aull, 0x1073BAE761CB9286ull, 0x724820C50EA1F072ull, 0x53A156DB2B87D1DEull,
    0xB63F1481D075359Aull, 0x97D6629FF5531436ull, 0xF5EDF8BD9A3976C2ull, 0xD4048EA3BF1F576Eull,
    0x7D2D771FD6061137ull, 0x5CC40101F320309Bull, 0x3EFF9B239C4A526Full, 0x1F16ED3DB96C73C3ull,
    0xFA88AF67429E9787ull, 0xDB61D97967B8B62Bull, 0xB95A435B08D2D4DFull, 0x98B335452DF4F573ull,
    0x46BFE1BDA7A08F3Cull, 0x675697A38286AE90ull, 0x056D0D81EDECCC64ull, 0x24847B9FC8CAEDC8ull,
    0xC11A39C53338098Cull, 0xE0F34FDB161E2820ull, 0x82C8D5F979744AD4ull, 0xA321A3E75C526B78ull,
    0x0C0F93922672363Eull, 0x2DE6E58C03541792ull, 0x4FDD7FAE6C3E7566ull, 0x6E3409B0491854CAull,
    0x8BAA4BEAB2EAB08Eull, 0xAA433DF497CC9122ull, 0xC878A7D6F8A6F3D6ull, 0xE991D1C8DD80D27Aull,
    0x379D053057D4A835ull, 0x1674732E72F28999ull, 0x744FE90C1D98EB6Dull, 0x55A69F1238BECAC1ull,
    0xB038DD48C34C2E85ull, 0x91D1AB56E66A0F29ull, 0xF3EA317489006DDDull, 0xD203476AAC264C71ull,
    0x7B2ABED6C53F0A28ull, 0x5AC3C8C8E0192B84ull, 0x38F852EA8F734970ull, 0x191124F4AA5568DCull,
    0xFC8F66AE51A78C98ull, 0xDD6610B07481AD34ull, 0xBF5D8A921BEBCFC0ull, 0x9EB4FC8C3ECDEE6Cull,
    0x40B82874B4999423ull, 0x61515E6A91BFB58Full, 0x036AC448FED5D77Bull, 0x2283B256DBF3F6D7ull,
    0xC71DF00C20011293ull, 0xE6F486120527333Full, 0x84CF1C306A4D51CBull, 0xA5266A2E4F6B7067ull,
    0xE245C91BE0E84E12ull, 0xC3ACBF05C5CE6FBEull, 0xA1972527AAA40D4Aull, 0x807E53398F822CE6ull,
    0x65E011637470C8A2ull, 0x4409677D5156E90Eull, 0x2632FD5F3E3C8BFAull, 0x07DB8B411B1AAA56ull,
    0xD9D75FB9914ED019ull, 0xF83E29A7B468F1B5ull, 0x9A05B385DB029341ull, 0xBBECC59BFE24B2EDull,
    0x5E7287C105D656A9ull, 0x7F9BF1DF20F07705ull, 0x1DA06BFD4F9A15F1ull, 0x3C491DE36ABC345Dull,
    0x9560E45F03A57204ull, 0xB4899241268353A8ull, 0xD6B2086349E9315Cull, 0xF75B7E7D6CCF10F0ull,
    0x12C53C27973DF4B4ull, 0x332C4A39B21BD518ull, 0x5117D01BDD71B7ECull, 0x70FEA605F8579640ull,
    0xAEF272FD7203EC0Full, 0x8F1B04E35725CDA3ull, 0xED209EC1384FAF57ull, 0xCCC9E8DF1D698EFBull,
    0x2957AA85E69B6ABFull, 0x08BEDC9BC3BD4B13ull, 0x6A8546B9ACD729E7ull, 0x4B6C30A789F1084Bull,
};
static const uint64_t Crc64NvmeTable8[256] = {
    0x0000000000000000ull, 0x04F28DEF5347786Cull, 0x09E51BDEA68EF0D8ull, 0x0D179631F5C988B4ull,
    0x13CA37BD4D1DE1B0ull, 0x1738BA521E5A99DCull, 0x1A2F2C63EB931168ull, 0x1EDDA18CB8D46904ull,
    0x27946F7A9A3BC360ull, 0x2366E295C97CBB0Cull, 0x2E7174A43CB533B8ull, 0x2A83F94B6FF24BD4ull,
    0x345E58C7D72622D0ull, 0x30ACD52884615ABCull, 0x3DBB431971A8D208ull, 0x3949CEF622EFAA64ull,
    0x4F28DEF5347786C0ull, 0x4BDA531A6730FEACull, 0x46CDC52B92F97618ull, 0x423F48C4C1BE0E74ull,
    0x5CE2E948796A6770ull, 0x581064A72A2D1F1Cull, 0x5507F296DFE497A8ull, 0x51F57F798CA3EFC4ull,
    0x68BCB18FAE4C45A0ull, 0x6C4E3C60FD0B3DCCull, 0x6159AA5108C2B578ull, 0x65AB27BE5B85CD14ull,
    0x7B768632E351A410ull, 0x7F840BDDB016DC7Cull, 0x72939DEC45DF54C8ull, 0x7661100316982CA4ull,
    0x9E51BDEA68EF0D80ull, 0x9AA330053BA875ECull, 0x97B4A634CE61FD58ull, 0x93462BDB9D268534ull,
    0x8D9B8A5725F2EC30ull, 0x896907B876B5945Cull, 0x847E9189837C1CE8ull, 0x808C1C66D03B6484ull,
    0xB9C5D290F2D4CEE0ull, 0xBD375F7FA193B68Cull, 0xB020C94E545A3E38ull, 0xB4D244A1071D4654ull,
    0xAA0FE52DBFC92F50ull, 0xAEFD68C2EC8E573Cull, 0xA3EAFEF31947DF88ull, 0xA718731C4A00A7E4ull,
    0xD179631F5C988B40ull, 0xD58BEEF00FDFF32Cull, 0xD89C78C1FA167B98ull, 0xDC6EF52EA95103F4ull,
    0xC2B354A211856AF0ull, 0xC641D94D42C2129Cull, 0xCB564F7CB70B9A28ull, 0xCFA4C293E44CE244ull,
    0xF6ED0C65C6A34820ull, 0xF21F818A95E4304Cull, 0xFF0817BB602DB8F8ull, 0xFBFA9A54336AC094ull,
    0xE5273BD88BBEA990ull, 0xE1D5B637D8F9D1FCull, 0xECC220062D305948ull, 0xE830ADE97E772124ull,
    0x087A5D878949886Bull, 0x0C88D068DA0EF007ull, 0x019F46592FC778B3ull, 0x056DCBB67C8000DFull,
    0x1BB06A3AC45469DBull, 0x1F42E7D5971311B7ull, 0x125571E462DA9903ull, 0x16A7FC0B319DE16Full,
    0x2FEE32FD13724B0Bull, 0x2B1CBF1240353367ull, 0x260B2923B5FCBBD3ull, 0x22F9A4CCE6BBC3BFull,
    0x3C2405405E6FAABBull, 0x38D688AF0D28D2D7ull, 0x35C11E9EF8E15A63ull, 0x31339371ABA6220Full,
    0x47528372BD3E0EABull, 0x43A00E9DEE7976C7ull, 0x4EB798AC1BB0FE73ull, 0x4A45154348F7861Full,
    0x5498B4CFF023EF1Bull, 0x506A3920A3649777ull, 0x5D7DAF1156AD1FC3ull, 0x598F22FE05EA67AFull,
    0x60C6EC082705CDCBull, 0x643461E77442B5A7ull, 0x6923F7D6818B3D13ull, 0x6DD17A39D2CC457Full,
    0x730CDBB56A182C7Bull, 0x77FE565A395F5417ull, 0x7AE9C06BCC96DCA3ull, 0x7E1B4D849FD1A4CFull,
    0x962BE06DE1A685EBull, 0x92D96D82B2E1FD87ull, 0x9FCEFBB347287533ull, 0x9B3C765C146F0D5Full,
    0x85E1D7D0ACBB645Bull, 0x81135A3FFFFC1C37ull, 0x8C04CC0E0A359483ull, 0x88F641E15972ECEFull,
    0xB1BF8F177B9D468Bull, 0xB54D02F828DA3EE7ull, 0xB85A94C9DD13B653ull, 0xBCA819268E54CE3Full,
    0xA275B8AA3680A73Bull, 0xA687354565C7DF57ull, 0xAB90A374900E57E3ull, 0xAF622E9BC3492F8Full,
    0xD9033E98D5D1032Bull, 0xDDF1B37786967B47ull, 0xD0E62546735FF3F3ull, 0xD414A8A920188B9Full,
    0xCAC9092598CCE29Bull, 0xCE3B84CACB8B9AF7ull, 0xC32C12FB3E421243ull, 0xC7DE9F146D056A2Full,
    0xFE9751E24FEAC04Bull, 0xFA65DC0D1CADB827ull, 0xF7724A3CE9643093ull, 0xF380C7D3BA2348FFull,
    0xED5D665F02F721FBull, 0xE9AFEBB051B05997ull, 0xE4B87D81A479D123ull, 0xE04AF06EF73EA94Full,
    0x10F4BB0F129310D6ull, 0x140636E041D468BAull, 0x1911A0D1B41DE00Eull, 0x1DE32D3EE75A9862ull,
    0x033E8CB25F8EF166ull, 0x07CC015D0CC9890Aull, 0x0ADB976CF90001BEull, 0x0E291A83AA4779D2ull,
    0x3760D47588A8D3B6ull, 0x3392599ADBEFABDAull, 0x3E85CFAB2E26236Eull, 0x3A7742447D615B02ull,
    0x24AAE3C8C5B53206ull, 0x20586E2796F24A6Aull, 0x2D4FF816633BC2DEull, 0x29BD75F9307CBAB2ull,
    0x5FDC65FA26E49616ull, 0x5B2EE81575A3EE7Aull, 0x56397E24806A66CEull, 0x52CBF3CBD32D1EA2ull,
    0x4C1652476BF977A6ull, 0x48E4DFA838BE0FCAull, 0x45F34999CD77877Eull, 0x4101C4769E30FF12ull,
    0x78480A80BCDF5576ull, 0x7CBA876FEF982D1Aull, 0x71AD115E1A51A5AEull, 0x755F9CB14916DDC2ull,
    0x6B823D3DF1C2B4C6ull, 0x6F70B0D2A285CCAAull, 0x626726E3574C441Eull, 0x6695AB0C040B3C72ull,
    0x8EA506E57A7C1D56ull, 0x8A578B0A293B653Aull, 0x87401D3BDCF2ED8Eull, 0x83B290D48FB595E2ull,
    0x9D6F31583761FCE6ull, 0x999DBCB76426848Aull, 0x948A2A8691EF0C3Eull, 0x9078A769C2A87452ull,
    0xA931699FE047DE36ull, 0xADC3E470B300A65Aull, 0xA0D4724146C92EEEull, 0xA426FFAE158E5682ull,
    0xBAFB5E22AD5A3F86ull, 0xBE09D3CDFE1D47EAull, 0xB31E45FC0BD4CF5Eull, 0xB7ECC8135893B732ull,
    0xC18DD8104E0B9B96ull, 0xC57F55FF1D4CE3FAull, 0xC868C3CEE8856B4Eull, 0xCC9A4E21BBC21322ull,
    0xD247EFAD03167A26ull, 0xD6B562425051024Aull, 0xDBA2F473A5988AFEull, 0xDF50799CF6DFF292ull,
    0xE619B76AD43058F6ull, 0xE2EB3A858777209Aull, 0xEFFCACB472BEA82Eull, 0xEB0E215B21F9D042ull,
    0xF5D380D7992DB946ull, 0xF1210D38CA6AC12Aull, 0xFC369B093FA3499Eull, 0xF8C416E66CE431F2ull,
    0x188EE6889BDA98BDull, 0x1C7C6B67C89DE0D1ull, 0x116BFD563D546865ull, 0x159970B96E131009ull,
    0x0B44D135D6C7790Dull, 0x0FB65CDA85800161ull, 0x02A1CAEB704989D5ull, 0x06534704230EF1B9ull,
    0x3F1A89F201E15BDDull, 0x3BE8041D52A623B1ull, 0x36FF922CA76FAB05ull, 0x320D1FC3F428D369ull,
    0x2CD0BE4F4CFCBA6Dull, 0x282233A01FBBC201ull, 0x2535A591EA724AB5ull, 0x21C7287EB93532D9ull,
    0x57A6387DAFAD1E7Dull, 0x5354B592FCEA6611ull, 0x5E4323A30923EEA5ull, 0x5AB1AE4C5A6496C9ull,
    0x446C0FC0E2B0FFCDull, 0x409E822FB1F787A1ull, 0x4D89141E443E0F15ull, 0x497B99F117797779ull,
    0x703257073596DD1Dull, 0x74C0DAE866D1A571ull, 0x79D74CD993182DC5ull, 0x7D25C136C05F55A9ull,
    0x63F860BA788B3CADull, 0x670AED552BCC44C1ull, 0x6A1D7B64DE05CC75ull, 0x6EEFF68B8D42B419ull,
    0x86DF5B62F335953Dull, 0x822DD68DA072ED51ull, 0x8F3A40BC55BB65E5ull, 0x8BC8CD5306FC1D89ull,
    0x95156CDFBE28748Dull, 0x91E7E130ED6F0CE1ull, 0x9CF0770118A68455ull, 0x9802FAEE4BE1FC39ull,
    0xA14B3418690E565Dull, 0xA5B9B9F73A492E31ull, 0xA8AE2FC6CF80A685ull, 0xAC5CA2299CC7DEE9ull,
    0xB28103A52413B7EDull, 0xB6738E4A7754CF81ull, 0xBB64187B829D4735ull, 0xBF969594D1DA3F59ull,
    0xC9F78597C74213FDull, 0xCD05087894056B91ull, 0xC0129E4961CCE325ull, 0xC4E013A6328B9B49ull,
    0xDA3DB22A8A5FF24Dull, 0xDECF3FC5D9188A21ull, 0xD3D8A9F42CD10295ull, 0xD72A241B7F967AF9ull,
    0xEE63EAED5D79D09Dull, 0xEA9167020E3EA8F1ull, 0xE786F133FBF72045ull, 0xE3747CDCA8B05829ull,
    0xFDA9DD501064312Dull, 0xF95B50BF43234941ull, 0xF44CC68EB6EAC1F5ull, 0xF0BE4B61E5ADB999ull,
};
static const uint64_t Crc64NvmeTable9[256] = {
    0x0000000000000000ull, 0x49E1DF807414FDEFull, 0x93C3BF00E829FBDEull, 0xDA2260809C3D0631ull,
    0x135E585288C464D7ull, 0x5ABF87D2FCD09938ull, 0x809DE75260ED9F09ull, 0xC97C38D214F962E6ull,
    0x26BCB0A51188C9AEull, 0x6F5D6F25659C3441ull, 0xB57F0FA5F9A13270ull, 0xFC9ED0258DB5CF9Full,
    0x35E2E8F7994CAD79ull, 0x7C033777ED585096ull, 0xA62157F7716556A7ull, 0xEFC088770571AB48ull,
    0x4D79614A2311935Cull, 0x0498BECA57056EB3ull, 0xDEBADE4ACB386882ull, 0x975B01CABF2C956Dull,
    0x5E273918ABD5F78Bull, 0x17C6E698DFC10A64ull, 0xCDE4861843FC0C55ull, 0x8405599837E8F1BAull,
    0x6BC5D1EF32995AF2ull, 0x22240E6F468DA71Dull, 0xF8066EEFDAB0A12Cull, 0xB1E7B16FAEA45CC3ull,
    0x789B89BDBA5D3E25ull, 0x317A563DCE49C3CAull, 0xEB5836BD5274C5FBull, 0xA2B9E93D26603814ull,
    0x9AF2C294462326B8ull, 0xD3131D143237DB57ull, 0x09317D94AE0ADD66ull, 0x40D0A214DA1E2089ull,
    0x89AC9AC6CEE7426Full, 0xC04D4546BAF3BF80ull, 0x1A6F25C626CEB9B1ull, 0x538EFA4652DA445Eull,
    0xBC4E723157ABEF16ull, 0xF5AFADB123BF12F9ull, 0x2F8DCD31BF8214C8ull, 0x666C12B1CB96E927ull,
    0xAF102A63DF6F8BC1ull, 0xE6F1F5E3AB7B762Eull, 0x3CD395633746701Full, 0x75324AE343528DF0ull,
    0xD78BA3DE6532B5E4ull, 0x9E6A7C5E1126480Bull, 0x44481CDE8D1B4E3Aull, 0x0DA9C35EF90FB3D5ull,
    0xC4D5FB8CEDF6D133ull, 0x8D34240C99E22CDCull, 0x5716448C05DF2AEDull, 0x1EF79B0C71CBD702ull,
    0xF137137B74BA7C4Aull, 0xB8D6CCFB00AE81A5ull, 0x62F4AC7B9C938794ull, 0x2B1573FBE8877A7Bull,
    0xE2694B29FC7E189Dull, 0xAB8894A9886AE572ull, 0x71AAF4291457E343ull, 0x384B2BA960431EACull,
    0x013CA37BD4D1DE1Bull, 0x48DD7CFBA0C523F4ull, 0x92FF1C7B3CF825C5ull, 0xDB1EC3FB48ECD82Aull,
    0x1262FB295C15BACCull, 0x5B8324A928014723ull, 0x81A14429B43C4112ull, 0xC8409BA9C028BCFDull,
    0x278013DEC55917B5ull, 0x6E61CC5EB14DEA5Aull, 0xB443ACDE2D70EC6Bull, 0xFDA2735E59641184ull,
    0x34DE4B8C4D9D7362ull, 0x7D3F940C39898E8Dull, 0xA71DF48CA5B488BCull, 0xEEFC2B0CD1A07553ull,
    0x4C45C231F7C04D47ull, 0x05A41DB183D4B0A8ull, 0xDF867D311FE9B699ull, 0x9667A2B16BFD4B76ull,
    0x5F1B9A637F042990ull, 0x16FA45E30B10D47Full, 0xCCD82563972DD24Eull, 0x8539FAE3E3392FA1ull,
    0x6AF97294E64884E9ull, 0x2318AD14925C7906ull, 0xF93ACD940E617F37ull, 0xB0DB12147A7582D8ull,
    0x79A72AC66E8CE03Eull, 0x3046F5461A981DD1ull, 0xEA6495C686A51BE0ull, 0xA3854A46F2B1E60Full,
    0x9BCE61EF92F2F8A3ull, 0xD22FBE6FE6E6054Cull, 0x080DDEEF7ADB037Dull, 0x41EC016F0ECFFE92ull,
    0x889039BD1A369C74ull, 0xC171E63D6E22619Bull, 0x1B5386BDF21F67AAull, 0x52B2593D860B9A45ull,
    0xBD72D14A837A310Dull, 0xF4930ECAF76ECCE2ull, 0x2EB16E4A6B53CAD3ull, 0x6750B1CA1F47373Cull,
    0xAE2C89180BBE55DAull, 0xE7CD56987FAAA835ull, 0x3DEF3618E397AE04ull, 0x740EE998978353EBull,
    0xD6B700A5B1E36BFFull, 0x9F56DF25C5F79610ull, 0x4574BFA559CA9021ull, 0x0C9560252DDE6DCEull,
    0xC5E958F739270F28ull, 0x8C0887774D33F2C7ull, 0x562AE7F7D10EF4F6ull, 0x1FCB3877A51A0919ull,
    0xF00BB000A06BA251ull, 0xB9EA6F80D47F5FBEull, 0x63C80F004842598Full, 0x2A29D0803C56A460ull,
    0xE355E85228AFC686ull, 0xAAB437D25CBB3B69ull, 0x70965752C0863D58ull, 0x397788D2B492C0B7ull,
    0x027946F7A9A3BC36ull, 0x4B989977DDB741D9ull, 0x91BAF9F7418A47E8ull, 0xD85B2677359EBA07ull,
    0x11271EA52167D8E1ull, 0x58C6C1255573250Eull, 0x82E4A1A5C94E233Full, 0xCB057E25BD5ADED0ull,
    0x24C5F652B82B7598ull, 0x6D2429D2CC3F8877ull, 0xB706495250028E46ull, 0xFEE796D2241673A9ull,
    0x379BAE0030EF114Full, 0x7E7A718044FBECA0ull, 0xA4581100D8C6EA91ull, 0xEDB9CE80ACD2177Eull,
    0x4F0027BD8AB22F6Aull, 0x06E1F83DFEA6D285ull, 0xDCC398BD629BD4B4ull, 0x9522473D168F295Bull,
    0x5C5E7FEF02764BBDull, 0x15BFA06F7662B652ull, 0xCF9DC0EFEA5FB063ull, 0x867C1F6F9E4B4D8Cull,
    0x69BC97189B3AE6C4ull, 0x205D4898EF2E1B2Bull, 0xFA7F281873131D1Aull, 0xB39EF7980707E0F5ull,
    0x7AE2CF4A13FE8213ull, 0x330310CA67EA7FFCull, 0xE921704AFBD779CDull, 0xA0C0AFCA8FC38422ull,
    0x988B8463EF809A8Eull, 0xD16A5BE39B946761ull, 0x0B483B6307A96150ull, 0x42A9E4E373BD9CBFull,
    0x8BD5DC316744FE59ull, 0xC23403B1135003B6ull, 0x181663318F6D0587ull, 0x51F7BCB1FB79F868ull,
    0xBE3734C6FE085320ull, 0xF7D6EB468A1CAECFull, 0x2DF48BC61621A8FEull, 0x6415544662355511ull,
    0xAD696C9476CC37F7ull, 0xE488B31402D8CA18ull, 0x3EAAD3949EE5CC29ull, 0x774B0C14EAF131C6ull,
    0xD5F2E529CC9109D2ull, 0x9C133AA9B885F43Dull, 0x46315A2924B8F20Cull, 0x0FD085A950AC0FE3ull,
    0xC6ACBD7B44556D05ull, 0x8F4D62FB304190EAull, 0x556F027BAC7C96DBull, 0x1C8EDDFBD8686B34ull,
    0xF34E558CDD19C07Cull, 0xBAAF8A0CA90D3D93ull, 0x608DEA8C35303BA2ull, 0x296C350C4124C64Dull,
    0xE0100DDE55DDA4ABull, 0xA9F1D25E21C95944ull, 0x73D3B2DEBDF45F75ull, 0x3A326D5EC9E0A29Aull,
    0x0345E58C7D72622Dull, 0x4AA43A0C09669FC2ull, 0x90865A8C955B99F3ull, 0xD967850CE14F641Cull,
    0x101BBDDEF5B606FAull, 0x59FA625E81A2FB15ull, 0x83D802DE1D9FFD24ull, 0xCA39DD5E698B00CBull,
    0x25F955296CFAAB83ull, 0x6C188AA918EE566Cull, 0xB63AEA2984D3505Dull, 0xFFDB35A9F0C7ADB2ull,
    0x36A70D7BE43ECF54ull, 0x7F46D2FB902A32BBull, 0xA564B27B0C17348Aull, 0xEC856DFB7803C965ull,
    0x4E3C84C65E63F171ull, 0x07DD5B462A770C9Eull, 0xDDFF3BC6B64A0AAFull, 0x941EE446C25EF740ull,
    0x5D62DC94D6A795A6ull, 0x14830314A2B36849ull, 0xCEA163943E8E6E78ull, 0x8740BC144A9A9397ull,
    0x688034634FEB38DFull, 0x2161EBE33BFFC530ull, 0xFB438B63A7C2C301ull, 0xB2A254E3D3D63EEEull,
    0x7BDE6C31C72F5C08ull, 0x323FB3B1B33BA1E7ull, 0xE81DD3312F06A7D6ull, 0xA1FC0CB15B125A39ull,
    0x99B727183B514495ull, 0xD056F8984F45B97Aull, 0x0A749818D378BF4Bull, 0x43954798A76C42A4ull,
    0x8AE97F4AB3952042ull, 0xC308A0CAC781DDADull, 0x192AC04A5BBCDB9Cull, 0x50CB1FCA2FA82673ull,
    0xBF0B97BD2AD98D3Bull, 0xF6EA483D5ECD70D4ull, 0x2CC828BDC2F076E5ull, 0x6529F73DB6E48B0Aull,
    0xAC55CFEFA21DE9ECull, 0xE5B4106FD6091403ull, 0x3F9670EF4A341232ull, 0x7677AF6F3E20EFDDull,
    0xD4CE46521840D7C9ull, 0x9D2F99D26C542A26ull, 0x470DF952F0692C17ull, 0x0EEC26D2847DD1F8ull,
    0xC7901E009084B31Eull, 0x8E71C180E4904EF1ull, 0x5453A10078AD48C0ull, 0x1DB27E800CB9B52Full,
    0xF272F6F709C81E67ull, 0xBB9329777DDCE388ull, 0x61B149F7E1E1E5B9ull, 0x2850967795F51856ull,
    0xE12CAEA5810C7AB0ull, 0xA8CD7125F518875Full, 0x72EF11A56925816Eull, 0x3B0ECE251D317C81ull,
};
static const uint64_t Crc64NvmeTable10[256] = {
    0x0000000000000000ull, 0x52734EA3E726FC54ull, 0xA4E69D47CE4DF8A8ull, 0xF695D3E4296B04FCull,
    0x7D141CDCC40C623Bull, 0x2F67527F232A9E6Full, 0xD9F2819B0A419A93ull, 0x8B81CF38ED6766C7ull,
    0xFA2839B98818C476ull, 0xA85B771A6F3E3822ull, 0x5ECEA4FE46553CDEull, 0x0CBDEA5DA173C08Aull,
    0x873C25654C14A64Dull, 0xD54F6BC6AB325A19ull, 0x23DAB82282595EE5ull, 0x71A9F681657FA2B1ull,
    0xC089552048A61B87ull, 0x92FA1B83AF80E7D3ull, 0x646FC86786EBE32Full, 0x361C86C461CD1F7Bull,
    0xBD9D49FC8CAA79BCull, 0xEFEE075F6B8C85E8ull, 0x197BD4BB42E78114ull, 0x4B089A18A5C17D40ull,
    0x3AA16C99C0BEDFF1ull, 0x68D2223A279823A5ull, 0x9E47F1DE0EF32759ull, 0xCC34BF7DE9D5DB0Dull,
    0x47B5704504B2BDCAull, 0x15C63EE6E394419Eull, 0xE353ED02CAFF4562ull, 0xB120A3A12DD9B936ull,
    0xB5CB8C13C9DBA465ull, 0xE7B8C2B02EFD5831ull, 0x112D115407965CCDull, 0x435E5FF7E0B0A099ull,
    0xC8DF90CF0DD7C65Eull, 0x9AACDE6CEAF13A0Aull, 0x6C390D88C39A3EF6ull, 0x3E4A432B24BCC2A2ull,
    0x4FE3B5AA41C36013ull, 0x1D90FB09A6E59C47ull, 0xEB0528ED8F8E98BBull, 0xB976664E68A864EFull,
    0x32F7A97685CF0228ull, 0x6084E7D562E9FE7Cull, 0x961134314B82FA80ull, 0xC4627A92ACA406D4ull,
    0x7542D933817DBFE2ull, 0x27319790665B43B6ull, 0xD1A444744F30474Aull, 0x83D70AD7A816BB1Eull,
    0x0856C5EF4571DDD9ull, 0x5A258B4CA257218Dull, 0xACB058A88B3C2571ull, 0xFEC3160B6C1AD925ull,
    0x8F6AE08A09657B94ull, 0xDD19AE29EE4387C0ull, 0x2B8C7DCDC728833Cull, 0x79FF336E200E7F68ull,
    0xF27EFC56CD6919AFull, 0xA00DB2F52A4FE5FBull, 0x569861110324E107ull, 0x04EB2FB2E4021D53ull,
    0x5F4E3E74CB20DBA1ull, 0x0D3D70D72C0627F5ull, 0xFBA8A333056D2309ull, 0xA9DBED90E24BDF5Dull,
    0x225A22A80F2CB99Aull, 0x70296C0BE80A45CEull, 0x86BCBFEFC1614132ull, 0xD4CFF14C2647BD66ull,
    0xA56607CD43381FD7ull, 0xF715496EA41EE383ull, 0x01809A8A8D75E77Full, 0x53F3D4296A531B2Bull,
    0xD8721B1187347DECull, 0x8A0155B2601281B8ull, 0x7C94865649798544ull, 0x2EE7C8F5AE5F7910ull,
    0x9FC76B548386C026ull, 0xCDB425F764A03C72ull, 0x3B21F6134DCB388Eull, 0x6952B8B0AAEDC4DAull,
    0xE2D37788478AA21Dull, 0xB0A0392BA0AC5E49ull, 0x4635EACF89C75AB5ull, 0x1446A46C6EE1A6E1ull,
    0x65EF52ED0B9E0450ull, 0x379C1C4EECB8F804ull, 0xC109CFAAC5D3FCF8ull, 0x937A810922F500ACull,
    0x18FB4E31CF92666Bull, 0x4A88009228B49A3Full, 0xBC1DD37601DF9EC3ull, 0xEE6E9DD5E6F96297ull,
    0xEA85B26702FB7FC4ull, 0xB8F6FCC4E5DD8390ull, 0x4E632F20CCB6876Cull, 0x1C1061832B907B38ull,
    0x9791AEBBC6F71DFFull, 0xC5E2E01821D1E1ABull, 0x337733FC08BAE557ull, 0x61047D5FEF9C1903ull,
    0x10AD8BDE8AE3BBB2ull, 0x42DEC57D6DC547E6ull, 0xB44B169944AE431Aull, 0xE638583AA388BF4Eull,
    0x6DB997024EEFD989ull, 0x3FCAD9A1A9C925DDull, 0xC95F0A4580A22121ull, 0x9B2C44E66784DD75ull,
    0x2A0CE7474A5D6443ull, 0x787FA9E4AD7B9817ull, 0x8EEA7A0084109CEBull, 0xDC9934A3633660BFull,
    0x5718FB9B8E510678ull, 0x056BB5386977FA2Cull, 0xF3FE66DC401CFED0ull, 0xA18D287FA73A0284ull,
    0xD024DEFEC245A035ull, 0x8257905D25635C61ull, 0x74C243B90C08589Dull, 0x26B10D1AEB2EA4C9ull,
    0xAD30C2220649C20Eull, 0xFF438C81E16F3E5Aull, 0x09D65F65C8043AA6ull, 0x5BA511C62F22C6F2ull,
    0xBE9C7CE99641B742ull, 0xECEF324A71674B16ull, 0x1A7AE1AE580C4FEAull, 0x4809AF0DBF2AB3BEull,
    0xC3886035524DD579ull, 0x91FB2E96B56B292Dull, 0x676EFD729C002DD1ull, 0x351DB3D17B26D185ull,
    0x44B445501E597334ull, 0x16C70BF3F97F8F60ull, 0xE052D817D0148B9Cull, 0xB22196B4373277C8ull,
    0x39A0598CDA55110Full, 0x6BD3172F3D73ED5Bull, 0x9D46C4CB1418E9A7ull, 0xCF358A68F33E15F3ull,
    0x7E1529C9DEE7ACC5ull, 0x2C66676A39C15091ull, 0xDAF3B48E10AA546Dull, 0x8880FA2DF78CA839ull,
    0x030135151AEBCEFEull, 0x51727BB6FDCD32AAull, 0xA7E7A852D4A63656ull, 0xF594E6F13380CA02ull,
    0x843D107056FF68B3ull, 0xD64E5ED3B1D994E7ull, 0x20DB8D3798B2901Bull, 0x72A8C3947F946C4Full,
    0xF9290CAC92F30A88ull, 0xAB5A420F75D5F6DCull, 0x5DCF91EB5CBEF220ull, 0x0FBCDF48BB980E74ull,
    0x0B57F0FA5F9A1327ull, 0x5924BE59B8BCEF73ull, 0xAFB16DBD91D7EB8Full, 0xFDC2231E76F117DBull,
    0x7643EC269B96711Cull, 0x2430A2857CB08D48ull, 0xD2A5716155DB89B4ull, 0x80D63FC2B2FD75E0ull,
    0xF17FC943D782D751ull, 0xA30C87E030A42B05ull, 0x5599540419CF2FF9ull, 0x07EA1AA7FEE9D3ADull,
    0x8C6BD59F138EB56Aull, 0xDE189B3CF4A8493Eull, 0x288D48D8DDC34DC2ull, 0x7AFE067B3AE5B196ull,
    0xCBDEA5DA173C08A0ull, 0x99ADEB79F01AF4F4ull, 0x6F38389DD971F008ull, 0x3D4B763E3E570C5Cull,
    0xB6CAB906D3306A9Bull, 0xE4B9F7A5341696CFull, 0x122C24411D7D9233ull, 0x405F6AE2FA5B6E67ull,
    0x31F69C639F24CCD6ull, 0x6385D2C078023082ull, 0x951001245169347Eull, 0xC7634F87B64FC82Aull,
    0x4CE280BF5B28AEEDull, 0x1E91CE1CBC0E52B9ull, 0xE8041DF895655645ull, 0xBA77535B7243AA11ull,
    0xE1D2429D5D616CE3ull, 0xB3A10C3EBA4790B7ull, 0x4534DFDA932C944Bull, 0x17479179740A681Full,
    0x9CC65E41996D0ED8ull, 0xCEB510E27E4BF28Cull, 0x3820C3065720F670ull, 0x6A538DA5B0060A24ull,
    0x1BFA7B24D579A895ull, 0x49893587325F54C1ull, 0xBF1CE6631B34503Dull, 0xED6FA8C0FC12AC69ull,
    0x66EE67F81175CAAEull, 0x349D295BF65336FAull, 0xC208FABFDF383206ull, 0x907BB41C381ECE52ull,
    0x215B17BD15C77764ull, 0x7328591EF2E18B30ull, 0x85BD8AFADB8A8FCCull, 0xD7CEC4593CAC7398ull,
    0x5C4F0B61D1CB155Full, 0x0E3C45C236EDE90Bull, 0xF8A996261F86EDF7ull, 0xAADAD885F8A011A3ull,
    0xDB732E049DDFB312ull, 0x890060A77AF94F46ull, 0x7F95B34353924BBAull, 0x2DE6FDE0B4B4B7EEull,
    0xA66732D859D3D129ull, 0xF4147C7BBEF52D7Dull, 0x0281AF9F979E2981ull, 0x50F2E13C70B8D5D5ull,
    0x5419CE8E94BAC886ull, 0x066A802D739C34D2ull, 0xF0FF53C95AF7302Eull, 0xA28C1D6ABDD1CC7Aull,
    0x290DD25250B6AABDull, 0x7B7E9CF1B79056E9ull, 0x8DEB4F159EFB5215ull, 0xDF9801B679DDAE41ull,
    0xAE31F7371CA20CF0ull, 0xFC42B994FB84F0A4ull, 0x0AD76A70D2EFF458ull, 0x58A424D335C9080Cull,
    0xD325EBEBD8AE6ECBull, 0x8156A5483F88929Full, 0x77C376AC16E39663ull, 0x25B0380FF1C56A37ull,
    0x94909BAEDC1CD301ull, 0xC6E3D50D3B3A2F55ull, 0x307606E912512BA9ull, 0x6205484AF577D7FDull,
    0xE98487721810B13Aull, 0xBBF7C9D1FF364D6Eull, 0x4D621A35D65D4992ull, 0x1F115496317BB5C6ull,
    0x6EB8A21754041777ull, 0x3CCBECB4B322EB23ull, 0xCA5E3F509A49EFDFull, 0x982D71F37D6F138Bull,
    0x13ACBECB9008754Cull, 0x41DFF068772E8918ull, 0xB74A238C5E458DE4ull, 0xE5396D2FB96371B0ull,
};
static const uint64_t Crc64NvmeTable11[256] = {
    0x0000000000000000ull, 0x668AB3BBC976D29Dull, 0xCD15677792EDA53Aull, 0xAB9FD4CC5B9B77A7ull,
    0xAEF3E8BC7D4CD91Full, 0xC8795B07B43A0B82ull, 0x63E68FCBEFA17C25ull, 0x056C3C7026D7AEB8ull,
    0x693EF72BA20E2155ull, 0x0FB444906B78F3C8ull, 0xA42B905C30E3846Full, 0xC2A123E7F99556F2ull,
    0xC7CD1F97DF42F84Aull, 0xA147AC2C16342AD7ull, 0x0AD878E04DAF5D70ull, 0x6C52CB5B84D98FEDull,
    0xD27DEE57441C42AAull, 0xB4F75DEC8D6A9037ull, 0x1F688920D6F1E790ull, 0x79E23A9B1F87350Dull,
    0x7C8E06EB39509BB5ull, 0x1A04B550F0264928ull, 0xB19B619CABBD3E8Full, 0xD711D22762CBEC12ull,
    0xBB43197CE61263FFull, 0xDDC9AAC72F64B162ull, 0x76567E0B74FFC6C5ull, 0x10DCCDB0BD891458ull,
    0x15B0F1C09B5EBAE0ull, 0x733A427B5228687Dull, 0xD8A596B709B31FDAull, 0xBE2F250CC0C5CD47ull,
    0x9022FAFDD0AF163Full, 0xF6A8494619D9C4A2ull, 0x5D379D8A4242B305ull, 0x3BBD2E318B346198ull,
    0x3ED11241ADE3CF20ull, 0x585BA1FA64951DBDull, 0xF3C475363F0E6A1Aull, 0x954EC68DF678B887ull,
    0xF91C0DD672A1376Aull, 0x9F96BE6DBBD7E5F7ull, 0x34096AA1E04C9250ull, 0x5283D91A293A40CDull,
    0x57EFE56A0FEDEE75ull, 0x316556D1C69B3CE8ull, 0x9AFA821D9D004B4Full, 0xFC7031A6547699D2ull,
    0x425F14AA94B35495ull, 0x24D5A7115DC58608ull, 0x8F4A73DD065EF1AFull, 0xE9C0C066CF282332ull,
    0xECACFC16E9FF8D8Aull, 0x8A264FAD20895F17ull, 0x21B99B617B1228B0ull, 0x473328DAB264FA2Dull,
    0x2B61E38136BD75C0ull, 0x4DEB503AFFCBA75Dull, 0xE67484F6A450D0FAull, 0x80FE374D6D260267ull,
    0x85920B3D4BF1ACDFull, 0xE318B88682877E42ull, 0x48876C4AD91C09E5ull, 0x2E0DDFF1106ADB78ull,
    0x149CD3A8F9C9BF15ull, 0x7216601330BF6D88ull, 0xD989B4DF6B241A2Full, 0xBF030764A252C8B2ull,
    0xBA6F3B148485660Aull, 0xDCE588AF4DF3B497ull, 0x777A5C631668C330ull, 0x11F0EFD8DF1E11ADull,
    0x7DA224835BC79E40ull, 0x1B28973892B14CDDull, 0xB0B743F4C92A3B7Aull, 0xD63DF04F005CE9E7ull,
    0xD351CC3F268B475Full, 0xB5DB7F84EFFD95C2ull, 0x1E44AB48B466E265ull, 0x78CE18F37D1030F8ull,
    0xC6E13DFFBDD5FDBFull, 0xA06B8E4474A32F22ull, 0x0BF45A882F385885ull, 0x6D7EE933E64E8A18ull,
    0x6812D543C09924A0ull, 0x0E9866F809EFF63Dull, 0xA507B2345274819Aull, 0xC38D018F9B025307ull,
    0xAFDFCAD41FDBDCEAull, 0xC955796FD6AD0E77ull, 0x62CAADA38D3679D0ull, 0x04401E184440AB4Dull,
    0x012C2268629705F5ull, 0x67A691D3ABE1D768ull, 0xCC39451FF07AA0CFull, 0xAAB3F6A4390C7252ull,
    0x84BE29552966A92Aull, 0xE2349AEEE0107BB7ull, 0x49AB4E22BB8B0C10ull, 0x2F21FD9972FDDE8Dull,
    0x2A4DC1E9542A7035ull, 0x4CC772529D5CA2A8ull, 0xE758A69EC6C7D50Full, 0x81D215250FB10792ull,
    0xED80DE7E8B68887Full, 0x8B0A6DC5421E5AE2ull, 0x2095B90919852D45ull, 0x461F0AB2D0F3FFD8ull,
    0x437336C2F6245160ull, 0x25F985793F5283FDull, 0x8E6651B564C9F45Aull, 0xE8ECE20EADBF26C7ull,
    0x56C3C7026D7AEB80ull, 0x304974B9A40C391Dull, 0x9BD6A075FF974EBAull, 0xFD5C13CE36E19C27ull,
    0xF8302FBE1036329Full, 0x9EBA9C05D940E002ull, 0x352548C982DB97A5ull, 0x53AFFB724BAD4538ull,
    0x3FFD3029CF74CAD5ull, 0x5977839206021848ull, 0xF2E8575E5D996FEFull, 0x9462E4E594EFBD72ull,
    0x910ED895B23813CAull, 0xF7846B2E7B4EC157ull, 0x5C1BBFE220D5B6F0ull, 0x3A910C59E9A3646Dull,
    0x2939A751F3937E2Aull, 0x4FB314EA3AE5ACB7ull, 0xE42CC026617EDB10ull, 0x82A6739DA808098Dull,
    0x87CA4FED8EDFA735ull, 0xE140FC5647A975A8ull, 0x4ADF289A1C32020Full, 0x2C559B21D544D092ull,
    0x4007507A519D5F7Full, 0x268DE3C198EB8DE2ull, 0x8D12370DC370FA45ull, 0xEB9884B60A0628D8ull,
    0xEEF4B8C62CD18660ull, 0x887E0B7DE5A754FDull, 0x23E1DFB1BE3C235Aull, 0x456B6C0A774AF1C7ull,
    0xFB444906B78F3C80ull, 0x9DCEFABD7EF9EE1Dull, 0x36512E71256299BAull, 0x50DB9DCAEC144B27ull,
    0x55B7A1BACAC3E59Full, 0x333D120103B53702ull, 0x98A2C6CD582E40A5ull, 0xFE28757691589238ull,
    0x927ABE2D15811DD5ull, 0xF4F00D96DCF7CF48ull, 0x5F6FD95A876CB8EFull, 0x39E56AE14E1A6A72ull,
    0x3C89569168CDC4CAull, 0x5A03E52AA1BB1657ull, 0xF19C31E6FA2061F0ull, 0x9716825D3356B36Dull,
    0xB91B5DAC233C6815ull, 0xDF91EE17EA4ABA88ull, 0x740E3ADBB1D1CD2Full, 0x1284896078A71FB2ull,
    0x17E8B5105E70B10Aull, 0x716206AB97066397ull, 0xDAFDD267CC9D1430ull, 0xBC7761DC05EBC6ADull,
    0xD025AA8781324940ull, 0xB6AF193C48449BDDull, 0x1D30CDF013DFEC7Aull, 0x7BBA7E4BDAA93EE7ull,
    0x7ED6423BFC7E905Full, 0x185CF180350842C2ull, 0xB3C3254C6E933565ull, 0xD54996F7A7E5E7F8ull,
    0x6B66B3FB67202ABFull, 0x0DEC0040AE56F822ull, 0xA673D48CF5CD8F85ull, 0xC0F967373CBB5D18ull,
    0xC5955B471A6CF3A0ull, 0xA31FE8FCD31A213Dull, 0x08803C308881569Aull, 0x6E0A8F8B41F78407ull,
    0x025844D0C52E0BEAull, 0x64D2F76B0C58D977ull, 0xCF4D23A757C3AED0ull, 0xA9C7901C9EB57C4Dull,
    0xACABAC6CB862D2F5ull, 0xCA211FD771140068ull, 0x61BECB1B2A8F77CFull, 0x073478A0E3F9A552ull,
    0x3DA574F90A5AC13Full, 0x5B2FC742C32C13A2ull, 0xF0B0138E98B76405ull, 0x963AA03551C1B698ull,
    0x93569C4577161820ull, 0xF5DC2FFEBE60CABDull, 0x5E43FB32E5FBBD1Aull, 0x38C948892C8D6F87ull,
    0x549B83D2A854E06Aull, 0x32113069612232F7ull, 0x998EE4A53AB94550ull, 0xFF04571EF3CF97CDull,
    0xFA686B6ED5183975ull, 0x9CE2D8D51C6EEBE8ull, 0x377D0C1947F59C4Full, 0x51F7BFA28E834ED2ull,
    0xEFD89AAE4E468395ull, 0x8952291587305108ull, 0x22CDFDD9DCAB26AFull, 0x44474E6215DDF432ull,
    0x412B7212330A5A8Aull, 0x27A1C1A9FA7C8817ull, 0x8C3E1565A1E7FFB0ull, 0xEAB4A6DE68912D2Dull,
    0x86E66D85EC48A2C0ull, 0xE06CDE3E253E705Dull, 0x4BF30AF27EA507FAull, 0x2D79B949B7D3D567ull,
    0x2815853991047BDFull, 0x4E9F36825872A942ull, 0xE500E24E03E9DEE5ull, 0x838A51F5CA9F0C78ull,
    0xAD878E04DAF5D700ull, 0xCB0D3DBF1383059Dull, 0x6092E9734818723Aull, 0x06185AC8816EA0A7ull,
    0x037466B8A7B90E1Full, 0x65FED5036ECFDC82ull, 0xCE6101CF3554AB25ull, 0xA8EBB274FC2279B8ull,
    0xC4B9792F78FBF655ull, 0xA233CA94B18D24C8ull, 0x09AC1E58EA16536Full, 0x6F26ADE3236081F2ull,
    0x6A4A919305B72F4Aull, 0x0CC02228CCC1FDD7ull, 0xA75FF6E4975A8A70ull, 0xC1D5455F5E2C58EDull,
    0x7FFA60539EE995AAull, 0x1970D3E8579F4737ull, 0xB2EF07240C043090ull, 0xD465B49FC572E20Dull,
    0xD10988EFE3A54CB5ull, 0xB7833B542AD39E28ull, 0x1C1CEF987148E98Full, 0x7A965C23B83E3B12ull,
    0x16C497783CE7B4FFull, 0x704E24C3F5916662ull, 0xDBD1F00FAE0A11C5ull, 0xBD5B43B4677CC358ull,
    0xB8377FC441AB6DE0ull, 0xDEBDCC7F88DDBF7Dull, 0x752218B3D346C8DAull, 0x13A8AB081A301A47ull,
};
static const uint64_t Crc64NvmeTable12[256] = {
    0x0000000000000000ull, 0xF2FA1FAE5F5C1165ull, 0xD12D190FE62FB1A1ull, 0x23D706A1B973A0C4ull,
    0x9683144C94C8F029ull, 0x64790BE2CB94E14Cull, 0x47AE0D4372E74188ull, 0xB55412ED2DBB50EDull,
    0x19DF0ECA71067339ull, 0xEB2511642E5A625Cull, 0xC8F217C59729C298ull, 0x3A08086BC875D3FDull,
    0x8F5C1A86E5CE8310ull, 0x7DA60528BA929275ull, 0x5E71038903E132B1ull, 0xAC8B1C275CBD23D4ull,
    0x33BE1D94E20CE672ull, 0xC144023ABD50F717ull, 0xE293049B042357D3ull, 0x10691B355B7F46B6ull,
    0xA53D09D876C4165Bull, 0x57C716762998073Eull, 0x741010D790EBA7FAull, 0x86EA0F79CFB7B69Full,
    0x2A61135E930A954Bull, 0xD89B0CF0CC56842Eull, 0xFB4C0A51752524EAull, 0x09B615FF2A79358Full,
    0xBCE2071207C26562ull, 0x4E1818BC589E7407ull, 0x6DCF1E1DE1EDD4C3ull, 0x9F3501B3BEB1C5A6ull,
    0x677C3B29C419CCE4ull, 0x958624879B45DD81ull, 0xB651222622367D45ull, 0x44AB3D887D6A6C20ull,
    0xF1FF2F6550D13CCDull, 0x030530CB0F8D2DA8ull, 0x20D2366AB6FE8D6Cull, 0xD22829C4E9A29C09ull,
    0x7EA335E3B51FBFDDull, 0x8C592A4DEA43AEB8ull, 0xAF8E2CEC53300E7Cull, 0x5D7433420C6C1F19ull,
    0xE82021AF21D74FF4ull, 0x1ADA3E017E8B5E91ull, 0x390D38A0C7F8FE55ull, 0xCBF7270E98A4EF30ull,
    0x54C226BD26152A96ull, 0xA638391379493BF3ull, 0x85EF3FB2C03A9B37ull, 0x7715201C9F668A52ull,
    0xC24132F1B2DDDABFull, 0x30BB2D5FED81CBDAull, 0x136C2BFE54F26B1Eull, 0xE19634500BAE7A7Bull,
    0x4D1D2877571359AFull, 0xBFE737D9084F48CAull, 0x9C303178B13CE80Eull, 0x6ECA2ED6EE60F96Bull,
    0xDB9E3C3BC3DBA986ull, 0x296423959C87B8E3ull, 0x0AB3253425F41827ull, 0xF8493A9A7AA80942ull,
    0xCEF87653883399C8ull, 0x3C0269FDD76F88ADull, 0x1FD56F5C6E1C2869ull, 0xED2F70F23140390Cull,
    0x587B621F1CFB69E1ull, 0xAA817DB143A77884ull, 0x89567B10FAD4D840ull, 0x7BAC64BEA588C925ull,
    0xD7277899F935EAF1ull, 0x25DD6737A669FB94ull, 0x060A61961F1A5B50ull, 0xF4F07E3840464A35ull,
    0x41A46CD56DFD1AD8ull, 0xB35E737B32A10BBDull, 0x908975DA8BD2AB79ull, 0x62736A74D48EBA1Cull,
    0xFD466BC76A3F7FBAull, 0x0FBC746935636EDFull, 0x2C6B72C88C10CE1Bull, 0xDE916D66D34CDF7Eull,
    0x6BC57F8BFEF78F93ull, 0x993F6025A1AB9EF6ull, 0xBAE8668418D83E32ull, 0x4812792A47842F57ull,
    0xE499650D1B390C83ull, 0x16637AA344651DE6ull, 0x35B47C02FD16BD22ull, 0xC74E63ACA24AAC47ull,
    0x721A71418FF1FCAAull, 0x80E06EEFD0ADEDCFull, 0xA337684E69DE4D0Bull, 0x51CD77E036825C6Eull,
    0xA9844D7A4C2A552Cull, 0x5B7E52D413764449ull, 0x78A95475AA05E48Dull, 0x8A534BDBF559F5E8ull,
    0x3F075936D8E2A505ull, 0xCDFD469887BEB460ull, 0xEE2A40393ECD14A4ull, 0x1CD05F97619105C1ull,
    0xB05B43B03D2C2615ull, 0x42A15C1E62703770ull, 0x61765ABFDB0397B4ull, 0x938C4511845F86D1ull,
    0x26D857FCA9E4D63Cull, 0xD4224852F6B8C759ull, 0xF7F54EF34FCB679Dull, 0x050F515D109776F8ull,
    0x9A3A50EEAE26B35Eull, 0x68C04F40F17AA23Bull, 0x4B1749E1480902FFull, 0xB9ED564F1755139Aull,
    0x0CB944A23AEE4377ull, 0xFE435B0C65B25212ull, 0xDD945DADDCC1F2D6ull, 0x2F6E4203839DE3B3ull,
    0x83E55E24DF20C067ull, 0x711F418A807CD102ull, 0x52C8472B390F71C6ull, 0xA0325885665360A3ull,
    0x15664A684BE8304Eull, 0xE79C55C614B4212Bull, 0xC44B5367ADC781EFull, 0x36B14CC9F29B908Aull,
    0xA929CAF448F0A0FBull, 0x5BD3D55A17ACB19Eull, 0x7804D3FBAEDF115Aull, 0x8AFECC55F183003Full,
    0x3FAADEB8DC3850D2ull, 0xCD50C116836441B7ull, 0xEE87C7B73A17E173ull, 0x1C7DD819654BF016ull,
    0xB0F6C43E39F6D3C2ull, 0x420CDB9066AAC2A7ull, 0x61DBDD31DFD96263ull, 0x9321C29F80857306ull,
    0x2675D072AD3E23EBull, 0xD48FCFDCF262328Eull, 0xF758C97D4B11924Aull, 0x05A2D6D3144D832Full,
    0x9A97D760AAFC4689ull, 0x686DC8CEF5A057ECull, 0x4BBACE6F4CD3F728ull, 0xB940D1C1138FE64Dull,
    0x0C14C32C3E34B6A0ull, 0xFEEEDC826168A7C5ull, 0xDD39DA23D81B0701ull, 0x2FC3C58D87471664ull,
    0x8348D9AADBFA35B0ull, 0x71B2C60484A624D5ull, 0x5265C0A53DD58411ull, 0xA09FDF0B62899574ull,
    0x15CBCDE64F32C599ull, 0xE731D248106ED4FCull, 0xC4E6D4E9A91D7438ull, 0x361CCB47F641655Dull,
    0xCE55F1DD8CE96C1Full, 0x3CAFEE73D3B57D7Aull, 0x1F78E8D26AC6DDBEull, 0xED82F77C359ACCDBull,
    0x58D6E59118219C36ull, 0xAA2CFA3F477D8D53ull, 0x89FBFC9EFE0E2D97ull, 0x7B01E330A1523CF2ull,
    0xD78AFF17FDEF1F26ull, 0x2570E0B9A2B30E43ull, 0x06A7E6181BC0AE87ull, 0xF45DF9B6449CBFE2ull,
    0x4109EB5B6927EF0Full, 0xB3F3F4F5367BFE6Aull, 0x9024F2548F085EAEull, 0x62DEEDFAD0544FCBull,
    0xFDEBEC496EE58A6Dull, 0x0F11F3E731B99B08ull, 0x2CC6F54688CA3BCCull, 0xDE3CEAE8D7962AA9ull,
    0x6B68F805FA2D7A44ull, 0x9992E7ABA5716B21ull, 0xBA45E10A1C02CBE5ull, 0x48BFFEA4435EDA80ull,
    0xE434E2831FE3F954ull, 0x16CEFD2D40BFE831ull, 0x3519FB8CF9CC48F5ull, 0xC7E3E422A6905990ull,
    0x72B7F6CF8B2B097Dull, 0x804DE961D4771818ull, 0xA39AEFC06D04B8DCull, 0x5160F06E3258A9B9ull,
    0x67D1BCA7C0C33933ull, 0x952BA3099F9F2856ull, 0xB6FCA5A826EC8892ull, 0x4406BA0679B099F7ull,
    0xF152A8EB540BC91Aull, 0x03A8B7450B57D87Full, 0x207FB1E4B22478BBull, 0xD285AE4AED7869DEull,
    0x7E0EB26DB1C54A0Aull, 0x8CF4ADC3EE995B6Full, 0xAF23AB6257EAFBABull, 0x5DD9B4CC08B6EACEull,
    0xE88DA621250DBA23ull, 0x1A77B98F7A51AB46ull, 0x39A0BF2EC3220B82ull, 0xCB5AA0809C7E1AE7ull,
    0x546FA13322CFDF41ull, 0xA695BE9D7D93CE24ull, 0x8542B83CC4E06EE0ull, 0x77B8A7929BBC7F85ull,
    0xC2ECB57FB6072F68ull, 0x3016AAD1E95B3E0Dull, 0x13C1AC7050289EC9ull, 0xE13BB3DE0F748FACull,
    0x4DB0AFF953C9AC78ull, 0xBF4AB0570C95BD1Dull, 0x9C9DB6F6B5E61DD9ull, 0x6E67A958EABA0CBCull,
    0xDB33BBB5C7015C51ull, 0x29C9A41B985D4D34ull, 0x0A1EA2BA212EEDF0ull, 0xF8E4BD147E72FC95ull,
    0x00AD878E04DAF5D7ull, 0xF25798205B86E4B2ull, 0xD1809E81E2F54476ull, 0x237A812FBDA95513ull,
    0x962E93C2901205FEull, 0x64D48C6CCF4E149Bull, 0x47038ACD763DB45Full, 0xB5F995632961A53Aull,
    0x1972894475DC86EEull, 0xEB8896EA2A80978Bull, 0xC85F904B93F3374Full, 0x3AA58FE5CCAF262Aull,
    0x8FF19D08E11476C7ull, 0x7D0B82A6BE4867A2ull, 0x5EDC8407073BC766ull, 0xAC269BA95867D603ull,
    0x33139A1AE6D613A5ull, 0xC1E985B4B98A02C0ull, 0xE23E831500F9A204ull, 0x10C49CBB5FA5B361ull,
    0xA5908E56721EE38Cull, 0x576A91F82D42F2E9ull, 0x74BD97599431522Dull, 0x864788F7CB6D4348ull,
    0x2ACC94D097D0609Cull, 0xD8368B7EC88C71F9ull, 0xFBE18DDF71FFD13Dull, 0x091B92712EA3C058ull,
    0xBC4F809C031890B5ull, 0x4EB59F325C4481D0ull, 0x6D629993E5372114ull, 0x9F98863DBA6B3071ull,
};
static const uint64_t Crc64NvmeTable13[256] = {
    0x0000000000000000ull, 0x9065CB6E6D39918Aull, 0x1412B08F82E4B07Full, 0x84777BE1EFDD21F5ull,
    0x2825611F05C960FEull, 0xB840AA7168F0F174ull, 0x3C37D190872DD081ull, 0xAC521AFEEA14410Bull,
    0x504AC23E0B92C1FCull, 0xC02F095066AB5076ull, 0x445872B189767183ull, 0xD43DB9DFE44FE009ull,
    0x786FA3210E5BA102ull, 0xE80A684F63623088ull, 0x6C7D13AE8CBF117Dull, 0xFC18D8C0E18680F7ull,
    0xA095847C172583F8ull, 0x30F04F127A1C1272ull, 0xB48734F395C13387ull, 0x24E2FF9DF8F8A20Dull,
    0x88B0E56312ECE306ull, 0x18D52E0D7FD5728Cull, 0x9CA255EC90085379ull, 0x0CC79E82FD31C2F3ull,
    0xF0DF46421CB74204ull, 0x60BA8D2C718ED38Eull, 0xE4CDF6CD9E53F27Bull, 0x74A83DA3F36A63F1ull,
    0xD8FA275D197E22FAull, 0x489FEC337447B370ull, 0xCCE897D29B9A9285ull, 0x5C8D5CBCF6A3030Full,
    0x75F22EAB76DC949Bull, 0xE597E5C51BE50511ull, 0x61E09E24F43824E4ull, 0xF185554A9901B56Eull,
    0x5DD74FB47315F465ull, 0xCDB284DA1E2C65EFull, 0x49C5FF3BF1F1441Aull, 0xD9A034559CC8D590ull,
    0x25B8EC957D4E5567ull, 0xB5DD27FB1077C4EDull, 0x31AA5C1AFFAAE518ull, 0xA1CF977492937492ull,
    0x0D9D8D8A78873599ull, 0x9DF846E415BEA413ull, 0x198F3D05FA6385E6ull, 0x89EAF66B975A146Cull,
    0xD567AAD761F91763ull, 0x450261B90CC086E9ull, 0xC1751A58E31DA71Cull, 0x5110D1368E243696ull,
    0xFD42CBC86430779Dull, 0x6D2700A60909E617ull, 0xE9507B47E6D4C7E2ull, 0x7935B0298BED5668ull,
    0x852D68E96A6BD69Full, 0x1548A38707524715ull, 0x913FD866E88F66E0ull, 0x015A130885B6F76Aull,
    0xAD0809F66FA2B661ull, 0x3D6DC298029B27EBull, 0xB91AB979ED46061Eull, 0x297F7217807F9794ull,
    0xEBE45D56EDB92936ull, 0x7B8196388080B8BCull, 0xFFF6EDD96F5D9949ull, 0x6F9326B7026408C3ull,
    0xC3C13C49E87049C8ull, 0x53A4F7278549D842ull, 0xD7D38CC66A94F9B7ull, 0x47B647A807AD683Dull,
    0xBBAE9F68E62BE8CAull, 0x2BCB54068B127940ull, 0xAFBC2FE764CF58B5ull, 0x3FD9E48909F6C93Full,
    0x938BFE77E3E28834ull, 0x03EE35198EDB19BEull, 0x87994EF86106384Bull, 0x17FC85960C3FA9C1ull,
    0x4B71D92AFA9CAACEull, 0xDB14124497A53B44ull, 0x5F6369A578781AB1ull, 0xCF06A2CB15418B3Bull,
    0x6354B835FF55CA30ull, 0xF331735B926C5BBAull, 0x774608BA7DB17A4Full, 0xE723C3D41088EBC5ull,
    0x1B3B1B14F10E6B32ull, 0x8B5ED07A9C37FAB8ull, 0x0F29AB9B73EADB4Dull, 0x9F4C60F51ED34AC7ull,
    0x331E7A0BF4C70BCCull, 0xA37BB16599FE9A46ull, 0x270CCA847623BBB3ull, 0xB76901EA1B1A2A39ull,
    0x9E1673FD9B65BDADull, 0x0E73B893F65C2C27ull, 0x8A04C37219810DD2ull, 0x1A61081C74B89C58ull,
    0xB63312E29EACDD53ull, 0x2656D98CF3954CD9ull, 0xA221A26D1C486D2Cull, 0x324469037171FCA6ull,
    0xCE5CB1C390F77C51ull, 0x5E397AADFDCEEDDBull, 0xDA4E014C1213CC2Eull, 0x4A2BCA227F2A5DA4ull,
    0xE679D0DC953E1CAFull, 0x761C1BB2F8078D25ull, 0xF26B605317DAACD0ull, 0x620EAB3D7AE33D5Aull,
    0x3E83F7818C403E55ull, 0xAEE63CEFE179AFDFull, 0x2A91470E0EA48E2Aull, 0xBAF48C60639D1FA0ull,
    0x16A6969E89895EABull, 0x86C35DF0E4B0CF21ull, 0x02B426110B6DEED4ull, 0x92D1ED7F66547F5Eull,
    0x6EC935BF87D2FFA9ull, 0xFEACFED1EAEB6E23ull, 0x7ADB853005364FD6ull, 0xEABE4E5E680FDE5Cull,
    0x46EC54A0821B9F57ull, 0xD6899FCEEF220EDDull, 0x52FEE42F00FF2F28ull, 0xC29B2F416DC6BEA2ull,
    0xE3119CFE83E5C107ull, 0x73745790EEDC508Dull, 0xF7032C7101017178ull, 0x6766E71F6C38E0F2ull,
    0xCB34FDE1862CA1F9ull, 0x5B51368FEB153073ull, 0xDF264D6E04C81186ull, 0x4F43860069F1800Cull,
    0xB35B5EC0887700FBull, 0x233E95AEE54E9171ull, 0xA749EE4F0A93B084ull, 0x372C252167AA210Eull,
    0x9B7E3FDF8DBE6005ull, 0x0B1BF4B1E087F18Full, 0x8F6C8F500F5AD07Aull, 0x1F09443E626341F0ull,
    0x4384188294C042FFull, 0xD3E1D3ECF9F9D375ull, 0x5796A80D1624F280ull, 0xC7F363637B1D630Aull,
    0x6BA1799D91092201ull, 0xFBC4B2F3FC30B38Bull, 0x7FB3C91213ED927Eull, 0xEFD6027C7ED403F4ull,
    0x13CEDABC9F528303ull, 0x83AB11D2F26B1289ull, 0x07DC6A331DB6337Cull, 0x97B9A15D708FA2F6ull,
    0x3BEBBBA39A9BE3FDull, 0xAB8E70CDF7A27277ull, 0x2FF90B2C187F5382ull, 0xBF9CC0427546C208ull,
    0x96E3B255F539559Cull, 0x0686793B9800C416ull, 0x82F102DA77DDE5E3ull, 0x1294C9B41AE47469ull,
    0xBEC6D34AF0F03562ull, 0x2EA318249DC9A4E8ull, 0xAAD463C57214851Dull, 0x3AB1A8AB1F2D1497ull,
    0xC6A9706BFEAB9460ull, 0x56CCBB05939205EAull, 0xD2BBC0E47C4F241Full, 0x42DE0B8A1176B595ull,
    0xEE8C1174FB62F49Eull, 0x7EE9DA1A965B6514ull, 0xFA9EA1FB798644E1ull, 0x6AFB6A9514BFD56Bull,
    0x36763629E21CD664ull, 0xA613FD478F2547EEull, 0x226486A660F8661Bull, 0xB2014DC80DC1F791ull,
    0x1E535736E7D5B69Aull, 0x8E369C588AEC2710ull, 0x0A41E7B9653106E5ull, 0x9A242CD70808976Full,
    0x663CF417E98E1798ull, 0xF6593F7984B78612ull, 0x722E44986B6AA7E7ull, 0xE24B8FF60653366Dull,
    0x4E199508EC477766ull, 0xDE7C5E66817EE6ECull, 0x5A0B25876EA3C719ull, 0xCA6EEEE9039A5693ull,
    0x08F5C1A86E5CE831ull, 0x98900AC6036579BBull, 0x1CE77127ECB8584Eull, 0x8C82BA498181C9C4ull,
    0x20D0A0B76B9588CFull, 0xB0B56BD906AC1945ull, 0x34C21038E97138B0ull, 0xA4A7DB568448A93Aull,
    0x58BF039665CE29CDull, 0xC8DAC8F808F7B847ull, 0x4CADB319E72A99B2ull, 0xDCC878778A130838ull,
    0x709A628960074933ull, 0xE0FFA9E70D3ED8B9ull, 0x6488D206E2E3F94Cull, 0xF4ED19688FDA68C6ull,
    0xA86045D479796BC9ull, 0x38058EBA1440FA43ull, 0xBC72F55BFB9DDBB6ull, 0x2C173E3596A44A3Cull,
    0x804524CB7CB00B37ull, 0x1020EFA511899ABDull, 0x94579444FE54BB48ull, 0x04325F2A936D2AC2ull,
    0xF82A87EA72EBAA35ull, 0x684F4C841FD23BBFull, 0xEC383765F00F1A4Aull, 0x7C5DFC0B9D368BC0ull,
    0xD00FE6F57722CACBull, 0x406A2D9B1A1B5B41ull, 0xC41D567AF5C67AB4ull, 0x54789D1498FFEB3Eull,
    0x7D07EF0318807CAAull, 0xED62246D75B9ED20ull, 0x69155F8C9A64CCD5ull, 0xF97094E2F75D5D5Full,
    0x55228E1C1D491C54ull, 0xC547457270708DDEull, 0x41303E939FADAC2Bull, 0xD155F5FDF2943DA1ull,
    0x2D4D2D3D1312BD56ull, 0xBD28E6537E2B2CDCull, 0x395F9DB291F60D29ull, 0xA93A56DCFCCF9CA3ull,
    0x05684C2216DBDDA8ull, 0x950D874C7BE24C22ull, 0x117AFCAD943F6DD7ull, 0x811F37C3F906FC5Dull,
    0xDD926B7F0FA5FF52ull, 0x4DF7A011629C6ED8ull, 0xC980DBF08D414F2Dull, 0x59E5109EE078DEA7ull,
    0xF5B70A600A6C9FACull, 0x65D2C10E67550E26ull, 0xE1A5BAEF88882FD3ull, 0x71C07181E5B1BE59ull,
    0x8DD8A94104373EAEull, 0x1DBD622F690EAF24ull, 0x99CA19CE86D38ED1ull, 0x09AFD2A0EBEA1F5Bull,
    0xA5FDC85E01FE5E50ull, 0x359803306CC7CFDAull, 0xB1EF78D1831AEE2Full, 0x218AB3BFEE237FA5ull,
};
static const uint64_t Crc64NvmeTable14[256] = {
    0x0000000000000000ull, 0xC23DFBC6CA591CA3ull, 0xB0A2D1DECC25AA2Dull, 0x729F2A18067CB68Eull,
    0x559C85EEC0DCC731ull, 0x97A17E280A85DB92ull, 0xE53E54300CF96D1Cull, 0x2703AFF6C6A071BFull,
    0xAB390BDD81B98E62ull, 0x6904F01B4BE092C1ull, 0x1B9BDA034D9C244Full, 0xD9A621C587C538ECull,
    0xFEA58E3341654953ull, 0x3C9875F58B3C55F0ull, 0x4E075FED8D40E37Eull, 0x8C3AA42B4719FFDDull,
    0x62AB31E85BE48FAFull, 0xA096CA2E91BD930Cull, 0xD209E03697C12582ull, 0x10341BF05D983921ull,
    0x3737B4069B38489Eull, 0xF50A4FC05161543Dull, 0x879565D8571DE2B3ull, 0x45A89E1E9D44FE10ull,
    0xC9923A35DA5D01CDull, 0x0BAFC1F310041D6Eull, 0x7930EBEB1678ABE0ull, 0xBB0D102DDC21B743ull,
    0x9C0EBFDB1A81C6FCull, 0x5E33441DD0D8DA5Full, 0x2CAC6E05D6A46CD1ull, 0xEE9195C31CFD7072ull,
    0xC55663D0B7C91F5Eull, 0x076B98167D9003FDull, 0x75F4B20E7BECB573ull, 0xB7C949C8B1B5A9D0ull,
    0x90CAE63E7715D86Full, 0x52F71DF8BD4CC4CCull, 0x206837E0BB307242ull, 0xE255CC2671696EE1ull,
    0x6E6F680D3670913Cull, 0xAC5293CBFC298D9Full, 0xDECDB9D3FA553B11ull, 0x1CF04215300C27B2ull,
    0x3BF3EDE3F6AC560Dull, 0xF9CE16253CF54AAEull, 0x8B513C3D3A89FC20ull, 0x496CC7FBF0D0E083ull,
    0xA7FD5238EC2D90F1ull, 0x65C0A9FE26748C52ull, 0x175F83E620083ADCull, 0xD5627820EA51267Full,
    0xF261D7D62CF157C0ull, 0x305C2C10E6A84B63ull, 0x42C30608E0D4FDEDull, 0x80FEFDCE2A8DE14Eull,
    0x0CC459E56D941E93ull, 0xCEF9A223A7CD0230ull, 0xBC66883BA1B1B4BEull, 0x7E5B73FD6BE8A81Dull,
    0x5958DC0BAD48D9A2ull, 0x9B6527CD6711C501ull, 0xE9FA0DD5616D738Full, 0x2BC7F613AB346F2Cull,
    0xBE75E1F23705ADD7ull, 0x7C481A34FD5CB174ull, 0x0ED7302CFB2007FAull, 0xCCEACBEA31791B59ull,
    0xEBE9641CF7D96AE6ull, 0x29D49FDA3D807645ull, 0x5B4BB5C23BFCC0CBull, 0x99764E04F1A5DC68ull,
    0x154CEA2FB6BC23B5ull, 0xD77111E97CE53F16ull, 0xA5EE3BF17A998998ull, 0x67D3C037B0C0953Bull,
    0x40D06FC17660E484ull, 0x82ED9407BC39F827ull, 0xF072BE1FBA454EA9ull, 0x324F45D9701C520Aull,
    0xDCDED01A6CE12278ull, 0x1EE32BDCA6B83EDBull, 0x6C7C01C4A0C48855ull, 0xAE41FA026A9D94F6ull,
    0x894255F4AC3DE549ull, 0x4B7FAE326664F9EAull, 0x39E0842A60184F64ull, 0xFBDD7FECAA4153C7ull,
    0x77E7DBC7ED58AC1Aull, 0xB5DA20012701B0B9ull, 0xC7450A19217D0637ull, 0x0578F1DFEB241A94ull,
    0x227B5E292D846B2Bull, 0xE046A5EFE7DD7788ull, 0x92D98FF7E1A1C106ull, 0x50E474312BF8DDA5ull,
    0x7B23822280CCB289ull, 0xB91E79E44A95AE2Aull, 0xCB8153FC4CE918A4ull, 0x09BCA83A86B00407ull,
    0x2EBF07CC401075B8ull, 0xEC82FC0A8A49691Bull, 0x9E1DD6128C35DF95ull, 0x5C202DD4466CC336ull,
    0xD01A89FF01753CEBull, 0x12277239CB2C2048ull, 0x60B85821CD5096C6ull, 0xA285A3E707098A65ull,
    0x85860C11C1A9FBDAull, 0x47BBF7D70BF0E779ull, 0x3524DDCF0D8C51F7ull, 0xF7192609C7D54D54ull,
    0x1988B3CADB283D26ull, 0xDBB5480C11712185ull, 0xA92A6214170D970Bull, 0x6B1799D2DD548BA8ull,
    0x4C1436241BF4FA17ull, 0x8E29CDE2D1ADE6B4ull, 0xFCB6E7FAD7D1503Aull, 0x3E8B1C3C1D884C99ull,
    0xB2B1B8175A91B344ull, 0x708C43D190C8AFE7ull, 0x021369C996B41969ull, 0xC02E920F5CED05CAull,
    0xE72D3DF99A4D7475ull, 0x2510C63F501468D6ull, 0x578FEC275668DE58ull, 0x95B217E19C31C2FBull,
    0x4832E5B7369CC8C5ull, 0x8A0F1E71FCC5D466ull, 0xF8903469FAB962E8ull, 0x3AADCFAF30E07E4Bull,
    0x1DAE6059F6400FF4ull, 0xDF939B9F3C191357ull, 0xAD0CB1873A65A5D9ull, 0x6F314A41F03CB97Aull,
    0xE30BEE6AB72546A7ull, 0x213615AC7D7C5A04ull, 0x53A93FB47B00EC8Aull, 0x9194C472B159F029ull,
    0xB6976B8477F98196ull, 0x74AA9042BDA09D35ull, 0x0635BA5ABBDC2BBBull, 0xC408419C71853718ull,
    0x2A99D45F6D78476Aull, 0xE8A42F99A7215BC9ull, 0x9A3B0581A15DED47ull, 0x5806FE476B04F1E4ull,
    0x7F0551B1ADA4805Bull, 0xBD38AA7767FD9CF8ull, 0xCFA7806F61812A76ull, 0x0D9A7BA9ABD836D5ull,
    0x81A0DF82ECC1C908ull, 0x439D24442698D5ABull, 0x31020E5C20E46325ull, 0xF33FF59AEABD7F86ull,
    0xD43C5A6C2C1D0E39ull, 0x1601A1AAE644129Aull, 0x649E8BB2E038A414ull, 0xA6A370742A61B8B7ull,
    0x8D6486678155D79Bull, 0x4F597DA14B0CCB38ull, 0x3DC657B94D707DB6ull, 0xFFFBAC7F87296115ull,
    0xD8F80389418910AAull, 0x1AC5F84F8BD00C09ull, 0x685AD2578DACBA87ull, 0xAA67299147F5A624ull,
    0x265D8DBA00EC59F9ull, 0xE460767CCAB5455Aull, 0x96FF5C64CCC9F3D4ull, 0x54C2A7A20690EF77ull,
    0x73C10854C0309EC8ull, 0xB1FCF3920A69826Bull, 0xC363D98A0C1534E5ull, 0x015E224CC64C2846ull,
    0xEFCFB78FDAB15834ull, 0x2DF24C4910E84497ull, 0x5F6D66511694F219ull, 0x9D509D97DCCDEEBAull,
    0xBA5332611A6D9F05ull, 0x786EC9A7D03483A6ull, 0x0AF1E3BFD6483528ull, 0xC8CC18791C11298Bull,
    0x44F6BC525B08D656ull, 0x86CB47949151CAF5ull, 0xF4546D8C972D7C7Bull, 0x3669964A5D7460D8ull,
    0x116A39BC9BD41167ull, 0xD357C27A518D0DC4ull, 0xA1C8E86257F1BB4Aull, 0x63F513A49DA8A7E9ull,
    0xF647044501996512ull, 0x347AFF83CBC079B1ull, 0x46E5D59BCDBCCF3Full, 0x84D82E5D07E5D39Cull,
    0xA3DB81ABC145A223ull, 0x61E67A6D0B1CBE80ull, 0x137950750D60080Eull, 0xD144ABB3C73914ADull,
    0x5D7E0F988020EB70ull, 0x9F43F45E4A79F7D3ull, 0xEDDCDE464C05415Dull, 0x2FE12580865C5DFEull,
    0x08E28A7640FC2C41ull, 0xCADF71B08AA530E2ull, 0xB8405BA88CD9866Cull, 0x7A7DA06E46809ACFull,
    0x94EC35AD5A7DEABDull, 0x56D1CE6B9024F61Eull, 0x244EE47396584090ull, 0xE6731FB55C015C33ull,
    0xC170B0439AA12D8Cull, 0x034D4B8550F8312Full, 0x71D2619D568487A1ull, 0xB3EF9A5B9CDD9B02ull,
    0x3FD53E70DBC464DFull, 0xFDE8C5B6119D787Cull, 0x8F77EFAE17E1CEF2ull, 0x4D4A1468DDB8D251ull,
    0x6A49BB9E1B18A3EEull, 0xA8744058D141BF4Dull, 0xDAEB6A40D73D09C3ull, 0x18D691861D641560ull,
    0x33116795B6507A4Cull, 0xF12C9C537C0966EFull, 0x83B3B64B7A75D061ull, 0x418E4D8DB02CCCC2ull,
    0x668DE27B768CBD7Dull, 0xA4B019BDBCD5A1DEull, 0xD62F33A5BAA91750ull, 0x1412C86370F00BF3ull,
    0x98286C4837E9F42Eull, 0x5A15978EFDB0E88Dull, 0x288ABD96FBCC5E03ull, 0xEAB74650319542A0ull,
    0xCDB4E9A6F735331Full, 0x0F8912603D6C2FBCull, 0x7D1638783B109932ull, 0xBF2BC3BEF1498591ull,
    0x51BA567DEDB4F5E3ull, 0x9387ADBB27EDE940ull, 0xE11887A321915FCEull, 0x23257C65EBC8436Dull,
    0x0426D3932D6832D2ull, 0xC61B2855E7312E71ull, 0xB484024DE14D98FFull, 0x76B9F98B2B14845Cull,
    0xFA835DA06C0D7B81ull, 0x38BEA666A6546722ull, 0x4A218C7EA028D1ACull, 0x881C77B86A71CD0Full,
    0xAF1FD84EACD1BCB0ull, 0x6D2223886688A013ull, 0x1FBD099060F4169Dull, 0xDD80F256AAAD0A3Eull,
};
static const uint64_t Crc64NvmeTable15[256] = {
    0x0000000000000000ull, 0xEADC41FD2BA3D420ull, 0xE161A5A90FD03B2Bull, 0x0BBDE4542473EF0Bull,
    0xF61A6D014737E53Dull, 0x1CC62CFC6C94311Dull, 0x177BC8A848E7DE16ull, 0xFDA7895563440A36ull,
    0xD8EDFC51D6F85911ull, 0x3231BDACFD5B8D31ull, 0x398C59F8D928623Aull, 0xD3501805F28BB61Aull,
    0x2EF7915091CFBC2Cull, 0xC42BD0ADBA6C680Cull, 0xCF9634F99E1F8707ull, 0x254A7504B5BC5327ull,
    0x8502DEF0F5672149ull, 0x6FDE9F0DDEC4F569ull, 0x64637B59FAB71A62ull, 0x8EBF3AA4D114CE42ull,
    0x7318B3F1B250C474ull, 0x99C4F20C99F31054ull, 0x92791658BD80FF5Full, 0x78A557A596232B7Full,
    0x5DEF22A1239F7858ull, 0xB733635C083CAC78ull, 0xBC8E87082C4F4373ull, 0x5652C6F507EC9753ull,
    0xABF54FA064A89D65ull, 0x41290E5D4F0B4945ull, 0x4A94EA096B78A64Eull, 0xA048ABF440DB726Eull,
    0x3EDC9BB2B259D1F9ull, 0xD400DA4F99FA05D9ull, 0xDFBD3E1BBD89EAD2ull, 0x35617FE6962A3EF2ull,
    0xC8C6F6B3F56E34C4ull, 0x221AB74EDECDE0E4ull, 0x29A7531AFABE0FEFull, 0xC37B12E7D11DDBCFull,
    0xE63167E364A188E8ull, 0x0CED261E4F025CC8ull, 0x0750C24A6B71B3C3ull, 0xED8C83B740D267E3ull,
    0x102B0AE223966DD5ull, 0xFAF74B1F0835B9F5ull, 0xF14AAF4B2C4656FEull, 0x1B96EEB607E582DEull,
    0xBBDE4542473EF0B0ull, 0x510204BF6C9D2490ull, 0x5ABFE0EB48EECB9Bull, 0xB063A116634D1FBBull,
    0x4DC428430009158Dull, 0xA71869BE2BAAC1ADull, 0xACA58DEA0FD92EA6ull, 0x4679CC17247AFA86ull,
    0x6333B91391C6A9A1ull, 0x89EFF8EEBA657D81ull, 0x82521CBA9E16928Aull, 0x688E5D47B5B546AAull,
    0x9529D412D6F14C9Cull, 0x7FF595EFFD5298BCull, 0x744871BBD92177B7ull, 0x9E943046F282A397ull,
    0x7DB9376564B3A3F2ull, 0x976576984F1077D2ull, 0x9CD892CC6B6398D9ull, 0x7604D33140C04CF9ull,
    0x8BA35A64238446CFull, 0x617F1B99082792EFull, 0x6AC2FFCD2C547DE4ull, 0x801EBE3007F7A9C4ull,
    0xA554CB34B24BFAE3ull, 0x4F888AC999E82EC3ull, 0x44356E9DBD9BC1C8ull, 0xAEE92F60963815E8ull,
    0x534EA635F57C1FDEull, 0xB992E7C8DEDFCBFEull, 0xB22F039CFAAC24F5ull, 0x58F34261D10FF0D5ull,
    0xF8BBE99591D482BBull, 0x1267A868BA77569Bull, 0x19DA4C3C9E04B990ull, 0xF3060DC1B5A76DB0ull,
    0x0EA18494D6E36786ull, 0xE47DC569FD40B3A6ull, 0xEFC0213DD9335CADull, 0x051C60C0F290888Dull,
    0x205615C4472CDBAAull, 0xCA8A54396C8F0F8Aull, 0xC137B06D48FCE081ull, 0x2BEBF190635F34A1ull,
    0xD64C78C5001B3E97ull, 0x3C9039382BB8EAB7ull, 0x372DDD6C0FCB05BCull, 0xDDF19C912468D19Cull,
    0x4365ACD7D6EA720Bull, 0xA9B9ED2AFD49A62Bull, 0xA204097ED93A4920ull, 0x48D84883F2999D00ull,
    0xB57FC1D691DD9736ull, 0x5FA3802BBA7E4316ull, 0x541E647F9E0DAC1Dull, 0xBEC22582B5AE783Dull,
    0x9B88508600122B1Aull, 0x7154117B2BB1FF3Aull, 0x7AE9F52F0FC21031ull, 0x9035B4D22461C411ull,
    0x6D923D874725CE27ull, 0x874E7C7A6C861A07ull, 0x8CF3982E48F5F50Cull, 0x662FD9D36356212Cull,
    0xC6677227238D5342ull, 0x2CBB33DA082E8762ull, 0x2706D78E2C5D6869ull, 0xCDDA967307FEBC49ull,
    0x307D1F2664BAB67Full, 0xDAA15EDB4F19625Full, 0xD11CBA8F6B6A8D54ull, 0x3BC0FB7240C95974ull,
    0x1E8A8E76F5750A53ull, 0xF456CF8BDED6DE73ull, 0xFFEB2BDFFAA53178ull, 0x15376A22D106E558ull,
    0xE890E377B242EF6Eull, 0x024CA28A99E13B4Eull, 0x09F146DEBD92D445ull, 0xE32D072396310065ull,
    0xFB726ECAC96747E4ull, 0x11AE2F37E2C493C4ull, 0x1A13CB63C6B77CCFull, 0xF0CF8A9EED14A8EFull,
    0x0D6803CB8E50A2D9ull, 0xE7B44236A5F376F9ull, 0xEC09A662818099F2ull, 0x06D5E79FAA234DD2ull,
    0x239F929B1F9F1EF5ull, 0xC943D366343CCAD5ull, 0xC2FE3732104F25DEull, 0x282276CF3BECF1FEull,
    0xD585FF9A58A8FBC8ull, 0x3F59BE67730B2FE8ull, 0x34E45A335778C0E3ull, 0xDE381BCE7CDB14C3ull,
    0x7E70B03A3C0066ADull, 0x94ACF1C717A3B28Dull, 0x9F11159333D05D86ull, 0x75CD546E187389A6ull,
    0x886ADD3B7B378390ull, 0x62B69CC6509457B0ull, 0x690B789274E7B8BBull, 0x83D7396F5F446C9Bull,
    0xA69D4C6BEAF83FBCull, 0x4C410D96C15BEB9Cull, 0x47FCE9C2E5280497ull, 0xAD20A83FCE8BD0B7ull,
    0x5087216AADCFDA81ull, 0xBA5B6097866C0EA1ull, 0xB1E684C3A21FE1AAull, 0x5B3AC53E89BC358Aull,
    0xC5AEF5787B3E961Dull, 0x2F72B485509D423Dull, 0x24CF50D174EEAD36ull, 0xCE13112C5F4D7916ull,
    0x33B498793C097320ull, 0xD968D98417AAA700ull, 0xD2D53DD033D9480Bull, 0x38097C2D187A9C2Bull,
    0x1D430929ADC6CF0Cull, 0xF79F48D486651B2Cull, 0xFC22AC80A216F427ull, 0x16FEED7D89B52007ull,
    0xEB596428EAF12A31ull, 0x018525D5C152FE11ull, 0x0A38C181E521111Aull, 0xE0E4807CCE82C53Aull,
    0x40AC2B888E59B754ull, 0xAA706A75A5FA6374ull, 0xA1CD8E2181898C7Full, 0x4B11CFDCAA2A585Full,
    0xB6B64689C96E5269ull, 0x5C6A0774E2CD8649ull, 0x57D7E320C6BE6942ull, 0xBD0BA2DDED1DBD62ull,
    0x9841D7D958A1EE45ull, 0x729D962473023A65ull, 0x792072705771D56Eull, 0x93FC338D7CD2014Eull,
    0x6E5BBAD81F960B78ull, 0x8487FB253435DF58ull, 0x8F3A1F7110463053ull, 0x65E65E8C3BE5E473ull,
    0x86CB59AFADD4E416ull, 0x6C17185286773036ull, 0x67AAFC06A204DF3Dull, 0x8D76BDFB89A70B1Dull,
    0x70D134AEEAE3012Bull, 0x9A0D7553C140D50Bull, 0x91B09107E5333A00ull, 0x7B6CD0FACE90EE20ull,
    0x5E26A5FE7B2CBD07ull, 0xB4FAE403508F6927ull, 0xBF47005774FC862Cull, 0x559B41AA5F5F520Cull,
    0xA83CC8FF3C1B583Aull, 0x42E0890217B88C1Aull, 0x495D6D5633CB6311ull, 0xA3812CAB1868B731ull,
    0x03C9875F58B3C55Full, 0xE915C6A27310117Full, 0xE2A822F65763FE74ull, 0x0874630B7CC02A54ull,
    0xF5D3EA5E1F842062ull, 0x1F0FABA33427F442ull, 0x14B24FF710541B49ull, 0xFE6E0E0A3BF7CF69ull,
    0xDB247B0E8E4B9C4Eull, 0x31F83AF3A5E8486Eull, 0x3A45DEA7819BA765ull, 0xD0999F5AAA387345ull,
    0x2D3E160FC97C7973ull, 0xC7E257F2E2DFAD53ull, 0xCC5FB3A6C6AC4258ull, 0x2683F25BED0F9678ull,
    0xB817C21D1F8D35EFull, 0x52CB83E0342EE1CFull, 0x597667B4105D0EC4ull, 0xB3AA26493BFEDAE4ull,
    0x4E0DAF1C58BAD0D2ull, 0xA4D1EEE1731904F2ull, 0xAF6C0AB5576AEBF9ull, 0x45B04B487CC93FD9ull,
    0x60FA3E4CC9756CFEull, 0x8A267FB1E2D6B8DEull, 0x819B9BE5C6A557D5ull, 0x6B47DA18ED0683F5ull,
    0x96E0534D8E4289C3ull, 0x7C3C12B0A5E15DE3ull, 0x7781F6E48192B2E8ull, 0x9D5DB719AA3166C8ull,
    0x3D151CEDEAEA14A6ull, 0xD7C95D10C149C086ull, 0xDC74B944E53A2F8Dull, 0x36A8F8B9CE99FBADull,
    0xCB0F71ECADDDF19Bull, 0x21D33011867E25BBull, 0x2A6ED445A20DCAB0ull, 0xC0B295B889AE1E90ull,
    0xE5F8E0BC3C124DB7ull, 0x0F24A14117B19997ull, 0x0499451533C2769Cull, 0xEE4504E81861A2BCull,
    0x13E28DBD7B25A88Aull, 0xF93ECC4050867CAAull, 0xF283281474F593A1ull, 0x185F69E95F564781ull,
};

}
